/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.yaml.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.InputFormat;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.OutputFormat;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.output.OutputUnit;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import org.alexmond.yaml.validator.YamlValidationException;
import org.alexmond.yaml.validator.config.YamlSchemaValidatorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class YamlSchemaValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlSchemaValidator.class);
    private static final int HTTP_SUCCESS_STATUS = 200;
    private final YamlSchemaValidatorConfig config;
    private final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final ObjectMapper jsonMapper = new ObjectMapper();
    Map<String, JsonSchema> schemaCache = new HashMap();

    public Map<String, OutputUnit> validate(String filePath, String schemaPath) {
        List fileNodeList;
        try {
            fileNodeList = this.getYamlJsonNode(filePath, Files.readString(Paths.get(filePath, new String[0])));
        }
        catch (IOException | YamlValidationException e) {
            log.debug("Error reading file", e);
            return Map.of(filePath, this.genericError(e.toString()));
        }
        return switch (fileNodeList.size()) {
            case 0 -> Map.of(filePath, this.genericError("No Nodes found in YAML file"));
            case 1 -> Map.of(filePath, this.validateJsonNode(filePath, schemaPath, (JsonNode)fileNodeList.get(0)));
            default -> this.validateMultipleJsonNodes(filePath, schemaPath, fileNodeList);
        };
    }

    private Map<String, OutputUnit> validateMultipleJsonNodes(String filePath, String schemaPath, List<JsonNode> fileNodeList) {
        HashMap<String, OutputUnit> outputUnitMap = new HashMap<String, OutputUnit>();
        int fileIndex = 0;
        for (JsonNode fileNode : fileNodeList) {
            outputUnitMap.put(filePath + "-" + ++fileIndex, this.validateJsonNode(filePath, schemaPath, fileNode));
        }
        return outputUnitMap;
    }

    private OutputUnit validateJsonNode(String filePath, String schemaPath, JsonNode fileNode) {
        try {
            String schemaPathFromNode;
            if (!this.config.isSchemaOverride() && (schemaPathFromNode = this.getSchemaPathFromNode(filePath, fileNode)) != null) {
                schemaPath = schemaPathFromNode;
            }
            if (schemaPath == null) {
                return this.genericError("No schema found in YAML file or provided as parameter");
            }
            JsonSchema schema = this.getSchemaByPath(schemaPath);
            return (OutputUnit)schema.validate(fileNode.toString(), InputFormat.JSON, (OutputFormat)OutputFormat.LIST, executionConfiguration -> {
                executionConfiguration.getExecutionConfig().setAnnotationCollectionFilter(keyword -> true);
                executionConfiguration.getExecutionConfig().setFormatAssertionsEnabled(Boolean.valueOf(true));
            });
        }
        catch (IllegalArgumentException | YamlValidationException e) {
            log.debug("{}", (Object)filePath, (Object)e);
            return this.genericError(e.getMessage());
        }
        catch (Exception e) {
            log.debug("Unexpected Exception", (Throwable)e);
            return this.genericError(e.getMessage());
        }
    }

    private JsonSchema getSchemaByPath(String schemaPath) {
        if (this.schemaCache.containsKey(schemaPath)) {
            return (JsonSchema)this.schemaCache.get(schemaPath);
        }
        String schemaString = this.getSchema(schemaPath);
        JsonNode schemaNode = this.getSchemaYamlJsonNode(schemaPath, schemaString);
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)this.getSchemaVersion(schemaNode));
        JsonSchema schema = schemaFactory.getSchema(schemaNode);
        this.schemaCache.put(schemaPath, schema);
        return schema;
    }

    private OutputUnit genericError(String message) {
        OutputUnit outputUnit = new OutputUnit();
        outputUnit.setValid(false);
        outputUnit.setErrors(Map.of("error", message));
        return outputUnit;
    }

    public SpecVersion.VersionFlag getSchemaVersion(JsonNode schemaNode) {
        SpecVersion.VersionFlag defaultVersion = SpecVersion.VersionFlag.V202012;
        try {
            return SpecVersionDetector.detect((JsonNode)schemaNode);
        }
        catch (JsonSchemaException e) {
            log.warn("Error detecting schema version: {}, setting default to {}", (Object)e.getMessage(), (Object)defaultVersion);
            return defaultVersion;
        }
    }

    private JsonNode getSchemaYamlJsonNode(String filePath, String content) {
        try {
            return this.jsonMapper.readTree(content);
        }
        catch (JsonProcessingException e) {
            JsonNode jsonNode;
            log.debug("Error parsing schema as JSON, trying YAML: {}, {}", (Object)filePath, (Object)e.getMessage());
            try {
                jsonNode = this.yamlMapper.readTree(content);
            }
            catch (JsonProcessingException ex) {
                log.debug("Error parsing schema as YAML: {}, {}", (Object)filePath, (Object)ex.getMessage());
                throw new YamlValidationException((Throwable)ex, null, filePath);
            }
            return jsonNode;
        }
    }

    private List<JsonNode> getYamlJsonNode(String filePath, String content) throws YamlValidationException, IOException {
        ArrayList<JsonNode> docs = new ArrayList<JsonNode>();
        try {
            return List.of(this.jsonMapper.readTree(content));
        }
        catch (JsonProcessingException e) {
            log.debug("Error parsing file as JSON, trying YAML: {}, {}", (Object)filePath, (Object)e.getMessage());
            try (JsonParser parser = this.yamlMapper.createParser(content);){
                while (parser.nextToken() != null) {
                    JsonNode doc = (JsonNode)this.yamlMapper.readTree(parser);
                    if (doc == null || doc.isMissingNode()) continue;
                    docs.add(doc);
                }
            }
            catch (JsonProcessingException ex) {
                log.debug("Error parsing file as YAML: {}, {}", (Object)filePath, (Object)ex.getMessage());
                throw new YamlValidationException((Throwable)ex, null, filePath);
            }
            return docs;
        }
    }

    private String getSchemaPathFromNode(String yamlPath, JsonNode jsonNode) {
        JsonNode yamlSchemaNode = jsonNode.get("$schema");
        if (yamlSchemaNode == null || !StringUtils.hasLength((String)yamlSchemaNode.asText())) {
            return null;
        }
        String detectedSchemaPath = yamlSchemaNode.asText();
        log.debug("Using schema URL from YAML: {}", (Object)detectedSchemaPath);
        if (!this.isHttpUrl(detectedSchemaPath)) {
            detectedSchemaPath = new File(new File(yamlPath).getParentFile(), detectedSchemaPath).getPath();
        }
        return detectedSchemaPath;
    }

    private String getSchema(String schemaPath) {
        if (this.isHttpUrl(schemaPath)) {
            return this.fetchSchemaFromUrl(schemaPath);
        }
        return this.readSchemaFromFile(schemaPath);
    }

    private boolean isHttpUrl(String schemaPath) {
        return schemaPath.startsWith("http://") || schemaPath.startsWith("https://");
    }

    private String fetchSchemaFromUrl(String schemaPath) {
        try {
            HttpClient httpClient = this.createHttpClient();
            HttpRequest httpRequest = this.createHttpRequest(schemaPath);
            HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                String msg = "HTTP request failed with status code " + response.statusCode() + " for " + schemaPath;
                log.debug(msg);
                throw new YamlValidationException(msg, null, schemaPath);
            }
            return response.body();
        }
        catch (IOException | InterruptedException e) {
            String msg = "Error fetching schema from URL: " + schemaPath;
            log.error("{}, {}", (Object)msg, (Object)e.getMessage());
            throw new YamlValidationException((Throwable)e, null, schemaPath);
        }
    }

    private HttpClient createHttpClient() {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(this.config.getHttpTimeout());
        if (this.config.isIgnoreSslErrors()) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */}, new SecureRandom());
                builder.sslContext(sslContext).sslParameters(new SSLParameters());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                log.warn("Failed to initialize SSL context for ignoring certificate validation: {}", (Object)e.getMessage());
            }
        }
        return builder.build();
    }

    private HttpRequest createHttpRequest(String schemaPath) {
        return HttpRequest.newBuilder().uri(URI.create(schemaPath)).GET().build();
    }

    private String readSchemaFromFile(String schemaPath) {
        try {
            return Files.readString(Paths.get(schemaPath, new String[0]));
        }
        catch (IOException e) {
            String msg = "Error reading schema file";
            log.error("{}, {}", (Object)msg, (Object)e.getMessage());
            throw new YamlValidationException((Throwable)e, null, schemaPath);
        }
    }

    @Generated
    public YamlSchemaValidator(YamlSchemaValidatorConfig config) {
        this.config = config;
    }
}

