/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.yaml.validator;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.alexmond.yaml.validator.YamlSchemaValidator;
import org.alexmond.yaml.validator.YamlSchemaValidatorRunner;
import org.alexmond.yaml.validator.config.YamlSchemaValidatorConfig;
import org.alexmond.yaml.validator.output.FilesOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class YamlSchemaValidatorRunner
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YamlSchemaValidatorRunner.class);
    private final YamlSchemaValidatorConfig config;
    private final YamlSchemaValidator yamlSchemaValidator;
    private final Environment environment;

    public void run(ApplicationArguments args) {
        String reportContent;
        if (this.environment.matchesProfiles(new String[]{"test"})) {
            return;
        }
        log.warn(args.toString());
        if (args.containsOption("help")) {
            this.printHelp();
            System.exit(0);
            return;
        }
        String configError = this.validateConfig(args);
        if (configError != null) {
            System.out.println("Configuration error:" + configError);
            this.printHelp();
            System.exit(1);
            return;
        }
        LinkedHashMap allResultsl = new LinkedHashMap();
        args.getNonOptionArgs().forEach(file -> {
            try {
                Map result = this.yamlSchemaValidator.validate(file, this.config.getSchema());
                allResultsl.putAll(result);
            }
            catch (RuntimeException e) {
                log.error("Unexpected error during validation", (Throwable)e);
            }
        });
        FilesOutput filesOutput = new FilesOutput(allResultsl);
        switch (1.$SwitchMap$org$alexmond$yaml$validator$config$ReportType[this.config.getReportType().ordinal()]) {
            case 1: {
                String string = filesOutput.toJsonString();
                break;
            }
            case 2: {
                String string = filesOutput.toYamlString();
                break;
            }
            case 3: {
                String string = filesOutput.toJunitString();
                break;
            }
            default: {
                String string = reportContent = filesOutput.toColoredString(this.config.isColor());
            }
        }
        if (this.config.getReportFileName() != null) {
            try {
                Files.writeString(Path.of(this.config.getReportFileName(), new String[0]), (CharSequence)reportContent, new OpenOption[0]);
            }
            catch (Exception e) {
                log.error("Failed to write report to file: {}", (Object)this.config.getReportFileName(), (Object)e);
            }
        } else {
            System.out.println(reportContent);
        }
        if (filesOutput.isValid()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private void printHelp() {
        String helpText = "Usage: java -jar yaml-schema-validator.jar [options] <file1> <file2> ...\n\nOptions:\n  --help                     Show this help message\n  --schema=<path>            Path to the JSON schema file (required unless schema-override is false)\n  --schema-override          If set, uses --schema instead of $schema from YAML/JSON\n  --report-type=<type>       Output format: text (default), json, yaml, junit\n  --report-file-name=<name>  Write report to the given file (prints to stdout if not set)\n  --http-timeout=<dur>       HTTP timeout for fetching remote schemas (e.g., 10s, 2m). Default: 10s\n  --ignore-ssl-errors        Ignore SSL certificate validation errors when fetching schemas\n  --color                    Use ANSI colors in text output (default: enabled)\n";
        System.out.println(helpText);
        System.exit(0);
    }

    private String validateConfig(ApplicationArguments args) {
        if (args.getNonOptionArgs().isEmpty()) {
            return "At least one YAML/JSON file must be provided as a non-option argument";
        }
        if (this.config.isSchemaOverride() && this.config.getSchema() == null) {
            return "Schema path must be provided when schemaPathOverride is enabled";
        }
        return null;
    }

    @Generated
    public YamlSchemaValidatorRunner(YamlSchemaValidatorConfig config, YamlSchemaValidator yamlSchemaValidator, Environment environment) {
        this.config = config;
        this.yamlSchemaValidator = yamlSchemaValidator;
        this.environment = environment;
    }
}

