/*
 * Decompiled with CFR 0.152.
 */
package org.alexmond.yaml.validator.output;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.networknt.schema.output.OutputUnit;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.alexmond.yaml.validator.output.junit.Failure;
import org.alexmond.yaml.validator.output.junit.Testcase;
import org.alexmond.yaml.validator.output.junit.Testsuite;
import org.alexmond.yaml.validator.output.junit.Testsuites;

public class FilesOutputToJunit {
    private final Map<String, OutputUnit> files;

    public String toJunitString() {
        int totalTests = this.files.size();
        long failureCount = this.files.values().stream().filter(unit -> unit != null && !unit.isValid()).count();
        Testsuites testsuites = Testsuites.builder().name("SchemaValidationSuite").tests(totalTests).failures((int)failureCount).testsuite(this.buildTestsuite()).build();
        try {
            XmlMapper xmlMapper = new XmlMapper();
            xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
            return xmlMapper.writeValueAsString((Object)testsuites);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting to JUnit XML", e);
        }
    }

    private Testsuite buildTestsuite() {
        Testsuite testsuite = Testsuite.builder().name("SchemaValidationSuite").tests(this.files.size()).failures((int)this.files.values().stream().filter(unit -> unit != null && !unit.isValid()).count()).testcases(new ArrayList()).build();
        ArrayList<Testcase> testcases = new ArrayList<Testcase>();
        for (Map.Entry entry : this.files.entrySet()) {
            String filename = (String)entry.getKey();
            OutputUnit unit2 = (OutputUnit)entry.getValue();
            Testcase testcase = Testcase.builder().classname("files").name(filename).time(0.0).build();
            if (unit2 != null && !unit2.isValid()) {
                String fullError = this.extractFullErrorMessage(unit2);
                String message = this.extractFailureMessage(unit2, fullError);
                Failure failure = Failure.builder().message(message != null ? message : "Validation Failure").value(fullError != null ? fullError : "").build();
                testcase.setFailure(failure);
            }
            testcases.add(testcase);
        }
        testsuite.setTestcases(testcases);
        return testsuite;
    }

    private String extractFullErrorMessage(OutputUnit unit) {
        StringBuilder sb = new StringBuilder();
        if (unit.getErrors() != null && !unit.getErrors().isEmpty()) {
            unit.getErrors().forEach((key, value) -> {
                if ("error".equals(key) && value != null) {
                    sb.append(value);
                }
            });
        }
        if (unit.getDetails() != null && !unit.getDetails().isEmpty()) {
            for (OutputUnit detail : unit.getDetails()) {
                if (detail == null || detail.getErrors() == null || detail.getErrors().isEmpty()) continue;
                detail.getErrors().forEach((key, value) -> {
                    if (value != null) {
                        sb.append(value).append("\n");
                    }
                });
            }
        }
        return sb.toString().trim();
    }

    private String extractFailureMessage(OutputUnit unit, String fullError) {
        OutputUnit firstDetail;
        if (unit.getErrors() != null && unit.getErrors().containsKey("error")) {
            String errorMsg = (String)unit.getErrors().get("error");
            if (errorMsg != null) {
                if (errorMsg.startsWith("No schema")) {
                    return "No Schema Error";
                }
                if (errorMsg.contains("MarkedYAMLException") || errorMsg.contains("YAMLException")) {
                    return "YAML Parse Error";
                }
                return "Validation Error";
            }
        } else if (unit.getDetails() != null && !unit.getDetails().isEmpty() && (firstDetail = (OutputUnit)unit.getDetails().get(0)) != null && firstDetail.getInstanceLocation() != null && firstDetail.getErrors() != null) {
            return "Type Mismatch at " + firstDetail.getInstanceLocation();
        }
        return "Validation Failure";
    }

    @Generated
    public FilesOutputToJunit(Map<String, OutputUnit> files) {
        this.files = files;
    }
}

