/*
 * Decompiled with CFR 0.152.
 */
package org.alicep.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;

public class CompactMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final int NO_INDEX = -1;
    private static final int DEFAULT_CAPACITY = 10;
    private int size = 0;
    private int modCount = 0;
    private Object[] objects;
    private int head = 0;
    private long[] lookup;
    private static final long serialVersionUID = 0L;

    private static int log2ceil(int value) {
        return 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public CompactMap() {
        this(10);
    }

    public static <K, V> CompactMap<K, V> withInitialCapacity(int initialCapacity) {
        return new CompactMap<K, V>(initialCapacity);
    }

    public CompactMap(Map<? extends K, ? extends V> entries) {
        this(entries.size());
        this.putAll(entries);
    }

    private CompactMap(int initialCapacity) {
        Preconditions.checkArgument((initialCapacity >= 0 ? 1 : 0) != 0, (Object)"initialCapacity must be non-negative");
        this.objects = new Object[2 * Math.max(initialCapacity, 10)];
        this.lookup = this.newLookupArray();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public V get(Object key) {
        Object comparisonObject = key == null ? Reserved.NULL : key;
        long index = this.lookup(comparisonObject);
        if (index >= 0L) {
            Object value = this.objects[(int)index * 2 + 1];
            return (V)value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Object insertionObject = MoreObjects.firstNonNull(key, (Object)((Object)Reserved.NULL));
        long lookupIndex = this.lookup(insertionObject);
        if (lookupIndex >= 0L) {
            Object oldValue = this.objects[(int)lookupIndex * 2 + 1];
            this.objects[(int)lookupIndex * 2 + 1] = value;
            return (V)oldValue;
        }
        ++this.modCount;
        if (this.ensureFreeCell()) {
            lookupIndex = this.lookup(insertionObject);
        }
        int index = this.head++;
        this.objects[index * 2] = insertionObject;
        this.objects[index * 2 + 1] = value;
        this.addLookup((int)(-(lookupIndex + 1L)), index);
        ++this.size;
        return null;
    }

    @Override
    public V remove(Object o) {
        long index = this.lookup(o == null ? Reserved.NULL : o);
        if (index < 0L) {
            return null;
        }
        Object oldValue = this.objects[(int)index * 2 + 1];
        this.deleteObjectAtIndex((int)index);
        return (V)oldValue;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private int lookupEntryBits() {
        return CompactMap.log2ceil(this.objects.length) - 1;
    }

    private int lookupEntriesPerLong() {
        return 64 / this.lookupEntryBits();
    }

    private long[] newLookupArray() {
        int numCells;
        for (numCells = 1 << CompactMap.log2ceil(this.objects.length); this.objects.length > numCells; numCells *= 2) {
        }
        int cellsPerLong = this.lookupEntriesPerLong();
        long[] lookup = new long[1 + (numCells - 1) / cellsPerLong];
        Arrays.fill(lookup, -1L);
        return lookup;
    }

    private void addLookup(int lookupIndex, int index) {
        CompactMap.assertState(index != -1, "Invalid index", new Object[0]);
        if (this.lookupEntryBits() < 64) {
            this.addLookupNibble(lookupIndex, index);
        } else {
            this.lookup[lookupIndex] = index;
        }
    }

    private long lookupMask() {
        return (1 << this.lookupEntryBits()) - 1;
    }

    private void addLookupNibble(int lookupIndex, int index) {
        long word = this.lookup[lookupIndex / this.lookupEntriesPerLong()];
        int shift = this.lookupEntryBits() * (lookupIndex % this.lookupEntriesPerLong());
        word &= this.lookupMask() << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.lookup[lookupIndex / this.lookupEntriesPerLong()] = word |= ((long)index & this.lookupMask()) << shift;
    }

    private long lookup(Object obj) {
        int index;
        int mask = this.numLookupCells() - 1;
        int tombstoneIndex = -1;
        int lookupIndex = obj.hashCode();
        int stride = Integer.reverse(lookupIndex) * 2 + 1;
        lookupIndex &= mask;
        stride &= mask;
        while ((index = this.getLookupAt(lookupIndex)) != -1) {
            Object other = this.objects[index * 2];
            if (other == null) {
                if (tombstoneIndex == -1) {
                    tombstoneIndex = lookupIndex;
                }
            } else if (other.equals(obj)) {
                return index;
            }
            lookupIndex += stride;
            lookupIndex &= mask;
        }
        if (tombstoneIndex != -1) {
            return -tombstoneIndex - 1;
        }
        return -lookupIndex - 1;
    }

    private int numLookupCells() {
        return Integer.highestOneBit(this.lookup.length * this.lookupEntriesPerLong());
    }

    private int getLookupAt(int lookupIndex) {
        int shift;
        long word = this.lookup[lookupIndex / this.lookupEntriesPerLong()];
        int value = (int)(word >> (shift = this.lookupEntryBits() * (lookupIndex % this.lookupEntriesPerLong())) & this.lookupMask());
        return (long)value == (0xFFFFFFFFFFFFFFFFL & this.lookupMask()) ? -1 : value;
    }

    private void clearLookupArray() {
        Arrays.fill(this.lookup, -1L);
    }

    private boolean ensureFreeCell() {
        if (this.objects.length == this.head * 2) {
            if (this.size >= this.minGrowthThreshold()) {
                int newSize = (this.objects.length >> 1) + (this.objects.length >> 2);
                this.objects = Arrays.copyOf(this.objects, newSize * 2);
                this.lookup = null;
            }
            this.compact();
            return true;
        }
        return false;
    }

    private void deleteObjectAtIndex(int index) {
        CompactMap.assertState(this.objects[index * 2] != null, "Cannot delete empty cell", new Object[0]);
        CompactMap.assertState(this.size != 0, "Size is 0 but a cell is not empty", new Object[0]);
        this.objects[index * 2] = null;
        this.objects[index * 2 + 1] = null;
        --this.size;
        ++this.modCount;
    }

    private void compact() {
        if (this.lookup == null) {
            this.lookup = this.newLookupArray();
        } else {
            this.clearLookupArray();
        }
        int target = 0;
        for (int source = 0; source < this.objects.length / 2; ++source) {
            long freeLookupCell;
            Object e = this.objects[source * 2];
            if (e == null) continue;
            if (source != target) {
                this.objects[target * 2] = e;
                this.objects[target * 2 + 1] = this.objects[source * 2 + 1];
            }
            Preconditions.checkState(((freeLookupCell = -(this.lookup(e) + 1L)) >= 0L ? 1 : 0) != 0);
            this.addLookup((int)freeLookupCell, target);
            ++target;
        }
        Arrays.fill(this.objects, target * 2, this.objects.length, null);
        this.head = this.size;
    }

    private int minGrowthThreshold() {
        return this.objects.length * 3 / 8;
    }

    private static void assertState(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AssertionError((Object)String.format(message, args));
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size);
        for (int i = 0; i < this.head * 2; ++i) {
            Object o = this.objects[i * 2];
            if (o == null) continue;
            s.writeObject(o == Reserved.NULL ? null : o);
            s.writeObject(this.objects[i * 2 + 1]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.size = s.readInt();
        this.objects = new Object[Math.max(this.size, 10) * 2];
        this.lookup = this.newLookupArray();
        this.clearLookupArray();
        this.head = 0;
        while (this.head < this.size) {
            Object e;
            this.objects[this.head * 2] = e = MoreObjects.firstNonNull((Object)s.readObject(), (Object)((Object)Reserved.NULL));
            this.objects[this.head * 2 + 1] = s.readObject();
            long x = this.lookup(e);
            long freeLookupCell = -(x + 1L);
            if (freeLookupCell < 0L) {
                throw new StreamCorruptedException("Duplicate data found in serialized map");
            }
            this.addLookup((int)freeLookupCell, this.head);
            ++this.head;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new IteratorImpl();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public int size() {
            return CompactMap.this.size;
        }

        private class IteratorImpl
        implements Iterator<Map.Entry<K, V>> {
            private int expectedModCount;
            private int index;
            private int nextIndex;

            IteratorImpl() {
                this.expectedModCount = CompactMap.this.modCount;
                this.index = -1;
                this.nextIndex = 0;
                while (this.nextIndex < CompactMap.this.head && CompactMap.this.objects[this.nextIndex * 2] == null) {
                    ++this.nextIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (CompactMap.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return this.nextIndex < CompactMap.this.head;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.index = this.nextIndex;
                do {
                    ++this.nextIndex;
                } while (this.nextIndex < CompactMap.this.head && CompactMap.this.objects[this.nextIndex * 2] == null);
                Object o = CompactMap.this.objects[this.index * 2];
                if (o == null) {
                    throw new ConcurrentModificationException();
                }
                return new EntryImpl(o, this.index);
            }

            @Override
            public void remove() {
                Preconditions.checkState((this.index != -1 ? 1 : 0) != 0);
                if (CompactMap.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                CompactMap.this.deleteObjectAtIndex(this.index);
                this.index = -1;
                this.expectedModCount = CompactMap.this.modCount;
            }
        }
    }

    private class EntryImpl
    implements Map.Entry<K, V> {
        private Object keyObject;
        private int index;

        EntryImpl(Object keyObject, int index) {
            this.keyObject = keyObject;
            this.index = index;
        }

        @Override
        public K getKey() {
            Object key = this.keyObject == Reserved.NULL ? null : this.keyObject;
            return key;
        }

        @Override
        public V getValue() {
            if (CompactMap.this.objects[this.index * 2] != this.keyObject) {
                long newIndex = CompactMap.this.lookup(this.keyObject);
                Preconditions.checkState((newIndex >= 0L ? 1 : 0) != 0, (String)"Mapping for key '%s' removed", (Object[])new Object[]{this.getKey()});
                this.index = (int)newIndex;
                this.keyObject = CompactMap.this.objects[this.index * 2];
            }
            Object value = CompactMap.this.objects[this.index * 2 + 1];
            return value;
        }

        @Override
        public V setValue(V value) {
            if (CompactMap.this.objects[this.index * 2] != this.keyObject) {
                long newIndex = CompactMap.this.lookup(this.keyObject);
                Preconditions.checkState((newIndex >= 0L ? 1 : 0) != 0, (String)"Mapping for key '%s' removed", (Object[])new Object[]{this.getKey()});
                this.index = (int)newIndex;
                this.keyObject = CompactMap.this.objects[this.index * 2];
            }
            Object oldValue = CompactMap.this.objects[this.index * 2 + 1];
            ((CompactMap)CompactMap.this).objects[this.index * 2 + 1] = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return Objects.equal(this.getKey(), other.getKey()) && Objects.equal(this.getValue(), other.getValue());
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            return (this.keyObject == Reserved.NULL ? 0 : this.keyObject.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private static enum Reserved {
        NULL;

    }
}

