/*
 * Decompiled with CFR 0.152.
 */
package org.alicep.collect;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;

public class CompactSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final int NO_INDEX = -1;
    private static final int DEFAULT_CAPACITY = 10;
    private int size = 0;
    private int modCount = 0;
    private Object[] objects;
    private int head = 0;
    private long[] lookup;
    private static final long serialVersionUID = 0L;

    public CompactSet() {
        this(10);
    }

    public static <E> CompactSet<E> withInitialCapacity(int initialCapacity) {
        return new CompactSet<E>(initialCapacity);
    }

    public CompactSet(Collection<? extends E> elements) {
        this(elements.size());
        this.addAll(elements);
    }

    private CompactSet(int initialCapacity) {
        Preconditions.checkArgument((initialCapacity >= 0 ? 1 : 0) != 0, (Object)"initialCapacity must be non-negative");
        this.objects = new Object[Math.max(initialCapacity, 10)];
        this.lookup = this.newLookupArray();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    @Override
    public boolean contains(Object o) {
        Object comparisonObject = o == null ? Reserved.NULL : o;
        long index = this.lookup(comparisonObject);
        return index >= 0L;
    }

    @Override
    public boolean add(E e) {
        Object insertionObject = MoreObjects.firstNonNull(e, (Object)((Object)Reserved.NULL));
        this.ensureFreeCell();
        long lookupIndex = this.lookup(insertionObject);
        if (lookupIndex >= 0L) {
            return false;
        }
        int index = this.head++;
        this.objects[index] = insertionObject;
        this.addLookup((int)(-(lookupIndex + 1L)), index);
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        long index = this.lookup(o == null ? Reserved.NULL : o);
        if (index < 0L) {
            return false;
        }
        this.deleteObjectAtIndex((int)index);
        return true;
    }

    private static int log2ceil(int value) {
        return 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private int lookupEntryBits() {
        return CompactSet.log2ceil(this.objects.length);
    }

    private int lookupEntriesPerLong() {
        return 64 / this.lookupEntryBits();
    }

    private long[] newLookupArray() {
        int numCells;
        for (numCells = 1 << CompactSet.log2ceil(this.objects.length) + 1; this.objects.length * 2 > numCells; numCells *= 2) {
        }
        int cellsPerLong = this.lookupEntriesPerLong();
        long[] lookup = new long[1 + (numCells - 1) / cellsPerLong];
        Arrays.fill(lookup, -1L);
        return lookup;
    }

    private void addLookup(int lookupIndex, int index) {
        CompactSet.assertState(index != -1, "Invalid index", new Object[0]);
        if (this.lookupEntryBits() < 64) {
            this.addLookupNibble(lookupIndex, index);
        } else {
            this.lookup[lookupIndex] = index;
        }
    }

    private long lookupMask() {
        return (1 << this.lookupEntryBits()) - 1;
    }

    private void addLookupNibble(int lookupIndex, int index) {
        long word = this.lookup[lookupIndex / this.lookupEntriesPerLong()];
        int shift = this.lookupEntryBits() * (lookupIndex % this.lookupEntriesPerLong());
        word &= this.lookupMask() << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.lookup[lookupIndex / this.lookupEntriesPerLong()] = word |= ((long)index & this.lookupMask()) << shift;
    }

    private long lookup(Object obj) {
        int index;
        int mask = this.numLookupCells() - 1;
        int tombstoneIndex = -1;
        int lookupIndex = obj.hashCode();
        int stride = Integer.reverse(lookupIndex) * 2 + 1;
        lookupIndex &= mask;
        stride &= mask;
        while ((index = this.getLookupAt(lookupIndex)) != -1) {
            Object other = this.objects[index];
            if (other == null) {
                if (tombstoneIndex == -1) {
                    tombstoneIndex = lookupIndex;
                }
            } else if (other.equals(obj)) {
                return index;
            }
            lookupIndex += stride;
            lookupIndex &= mask;
        }
        if (tombstoneIndex != -1) {
            return -tombstoneIndex - 1;
        }
        return -lookupIndex - 1;
    }

    private int numLookupCells() {
        return Integer.highestOneBit(this.lookup.length * this.lookupEntriesPerLong());
    }

    private int getLookupAt(int lookupIndex) {
        int shift;
        long word = this.lookup[lookupIndex / this.lookupEntriesPerLong()];
        int value = (int)(word >> (shift = this.lookupEntryBits() * (lookupIndex % this.lookupEntriesPerLong())) & this.lookupMask());
        return (long)value == (0xFFFFFFFFFFFFFFFFL & this.lookupMask()) ? -1 : value;
    }

    private void clearLookupArray() {
        Arrays.fill(this.lookup, -1L);
    }

    private void ensureFreeCell() {
        if (this.objects.length == this.head) {
            if (this.size >= this.minGrowthThreshold()) {
                int newSize = this.objects.length + (this.objects.length >> 1);
                this.objects = Arrays.copyOf(this.objects, newSize);
                this.lookup = null;
            }
            this.compact();
        }
    }

    private void deleteObjectAtIndex(int index) {
        CompactSet.assertState(this.objects[index] != null, "Cannot delete empty cell", new Object[0]);
        CompactSet.assertState(this.size != 0, "Size is 0 but a cell is not empty", new Object[0]);
        this.objects[index] = null;
        --this.size;
        ++this.modCount;
    }

    private void compact() {
        if (this.lookup == null) {
            this.lookup = this.newLookupArray();
        } else {
            this.clearLookupArray();
        }
        int target = 0;
        for (int source = 0; source < this.objects.length; ++source) {
            long freeLookupCell;
            Object e = this.objects[source];
            if (e == null) continue;
            if (source != target) {
                this.objects[target] = e;
            }
            Preconditions.checkState(((freeLookupCell = -(this.lookup(e) + 1L)) >= 0L ? 1 : 0) != 0);
            this.addLookup((int)freeLookupCell, target);
            ++target;
        }
        while (target < this.objects.length) {
            this.objects[target] = null;
            ++target;
        }
        this.head = this.size;
    }

    private int minGrowthThreshold() {
        return this.objects.length * 3 / 4;
    }

    private static void assertState(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AssertionError((Object)String.format(message, args));
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size);
        for (int i = 0; i < this.head; ++i) {
            Object o = this.objects[i];
            if (o == null) continue;
            s.writeObject(o == Reserved.NULL ? null : o);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.size = s.readInt();
        this.objects = new Object[Math.max(this.size, 10)];
        this.lookup = this.newLookupArray();
        this.clearLookupArray();
        this.head = 0;
        while (this.head < this.size) {
            Object e;
            this.objects[this.head] = e = MoreObjects.firstNonNull((Object)s.readObject(), (Object)((Object)Reserved.NULL));
            long x = this.lookup(e);
            long freeLookupCell = -(x + 1L);
            if (freeLookupCell < 0L) {
                throw new StreamCorruptedException("Duplicate data found in serialized set");
            }
            this.addLookup((int)freeLookupCell, this.head);
            ++this.head;
        }
    }

    private class IteratorImpl
    implements Iterator<E> {
        private int expectedModCount;
        private int index;
        private int nextIndex;

        IteratorImpl() {
            this.expectedModCount = CompactSet.this.modCount;
            this.index = -1;
            this.nextIndex = 0;
            while (this.nextIndex < CompactSet.this.head && CompactSet.this.objects[this.nextIndex] == null) {
                ++this.nextIndex;
            }
        }

        @Override
        public boolean hasNext() {
            if (CompactSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextIndex < CompactSet.this.head;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.index = this.nextIndex;
            do {
                ++this.nextIndex;
            } while (this.nextIndex < CompactSet.this.head && CompactSet.this.objects[this.nextIndex] == null);
            Object o = CompactSet.this.objects[this.index];
            if (o == null) {
                throw new ConcurrentModificationException();
            }
            return o == Reserved.NULL ? null : o;
        }

        @Override
        public void remove() {
            Preconditions.checkState((this.index != -1 ? 1 : 0) != 0);
            if (CompactSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            CompactSet.this.deleteObjectAtIndex(this.index);
            this.index = -1;
            this.expectedModCount = CompactSet.this.modCount;
        }
    }

    private static enum Reserved {
        NULL;

    }
}

