/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alindner.tools.common.random.generator.Generator;

public class Random {
    public static <T> Stream<T> stream(int limit, int length, Predicate<? super T> method, Generator.ICharPool<T> generator) {
        return Random.build(generator).stream(length).filter(method).limit(limit);
    }

    public static <T> Stream<T> streamParallel(int count, int length, Generator.ICharPool<T> generator) {
        return Random.build(generator).stream(length, count);
    }

    public static <T> Stream<T> streamParallelUnique(int count, int length, Predicate<? super T> method, Generator.ICharPool<T> generator) {
        return Random.build(generator).stream(length).distinct().filter(method).limit(count);
    }

    public static <T> List<T> list(int count, int length, Predicate<? super T> method, Generator.ICharPool<T> generator) {
        return Random.stream(count, length, method, generator).collect(Collectors.toList());
    }

    public static String get(int length) {
        return Random.build().stream(length).findFirst().orElseThrow(RuntimeException::new);
    }

    public static BigInteger getNumber(int length) {
        return Random.build(Generator.integerNumbers()).stream(length).findFirst().orElseThrow(RuntimeException::new);
    }

    public static RandomStream<String> build() {
        return new RandomStream<String>(Generator.alphanumeric());
    }

    public static <T> RandomStream<T> build(Generator.ICharPool<T> pool) {
        return new RandomStream<T>(pool);
    }

    public static <T> RandomStream<T> build(Generator.ICharPool<T> pool, java.util.Random random) {
        return new RandomStream<T>(pool, random);
    }

    static class StringRandoms {
        StringRandoms() {
        }

        public static Stream<String> stream(int limit, Predicate<String> method) {
            return StringRandoms.stream(limit, 5, method);
        }

        public static Stream<String> stream(int limit, int length, Predicate<String> method) {
            return Random.stream(limit, length, method, Generator.alphanumeric());
        }

        public static Stream<String> streamParallel(int count) {
            return StringRandoms.streamParallel(count, 5);
        }

        public static Stream<String> streamParallel(int count, int length) {
            return Random.streamParallel(count, length, Generator.alphanumeric());
        }

        public static Stream<String> streamParallelUnique(int count) {
            return StringRandoms.streamParallelUnique(count, 5);
        }

        public static Stream<String> streamParallelUnique(int count, int length) {
            return StringRandoms.streamParallelUnique(count, length, str -> true);
        }

        public static Stream<String> streamParallelUnique(int count, int length, Predicate<String> method) {
            return Random.streamParallelUnique(count, length, method, Generator.alphanumeric());
        }

        public static List<String> list(int count, int length, Predicate<String> method) {
            return StringRandoms.stream(count, length, method).collect(Collectors.toList());
        }
    }

    static class RandomStream<T> {
        private final Generator.ICharPool<T> pool;
        private final java.util.Random random;

        public RandomStream(Generator.ICharPool<T> pool) {
            this.pool = pool;
            this.random = ThreadLocalRandom.current();
        }

        public RandomStream(Generator.ICharPool<T> pool, java.util.Random random) {
            this.pool = pool;
            this.random = random;
        }

        public Stream<T> stream() {
            return (Stream)Stream.generate(() -> this.pool.getGenerator(this.random).next(5)).unordered();
        }

        public Stream<T> stream(int length) {
            return (Stream)Stream.generate(() -> this.pool.getGenerator(this.random).next(length)).unordered();
        }

        public Stream<T> stream(int length, int limit) {
            return Stream.generate(() -> this.pool.getGenerator(this.random).next(length)).limit(limit);
        }

        public Stream<T> uniqueStream(int length, int limit) {
            return this.stream(length).distinct().limit(limit);
        }

        public Stream<T> uniqueStream(int length, int limit, Predicate<T> filter) {
            return this.stream(length).filter(filter).distinct().limit(limit);
        }

        public Stream<T> parallelStream(int length, int limit) {
            return ((Stream)this.stream(length).parallel()).limit(limit);
        }

        public Stream<T> parallelStream(int length, int limit, Predicate<T> filter) {
            return ((Stream)this.stream(length).parallel()).filter(filter).limit(limit);
        }

        public Stream<T> parallelUniqueStream(int count, int length) {
            return ((Stream)this.stream(length).parallel()).distinct().limit(count);
        }

        public Stream<T> parallelUniqueStream(int count, int length, Predicate<T> filter) {
            return ((Stream)this.stream(length).parallel()).distinct().filter(filter).limit(count);
        }
    }
}

