/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random.generator;

import java.math.BigInteger;
import java.util.Locale;
import java.util.Random;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;
import org.alindner.tools.common.random.generator.RandomNumberGenerator;
import org.alindner.tools.common.random.generator.RandomStringGenerator;

public class Generator {
    public static AlphaNumericPool alphanumeric() {
        return new AlphaNumericPool();
    }

    public static Numbers numbers() {
        return new Numbers();
    }

    public static IntegerNumbers integerNumbers() {
        return new IntegerNumbers();
    }

    public static class IntegerNumbers
    implements ICharPool<BigInteger> {
        final String digits = "0123456789";

        @Override
        public IRandomStringGenerator<BigInteger> getGenerator(Random random) {
            return new RandomNumberGenerator(this.digits, random);
        }
    }

    public static class Numbers
    implements ICharPool<String> {
        final String digits = "0123456789";

        @Override
        public IRandomStringGenerator<String> getGenerator(Random random) {
            return new RandomStringGenerator(this.digits, random);
        }
    }

    public static class AlphaNumericPool
    implements ICharPool<String> {
        final String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final String lower = this.upper.toLowerCase(Locale.ROOT);
        final String digits = "0123456789";
        final String alphanum = this.upper + this.lower + this.digits;

        @Override
        public IRandomStringGenerator<String> getGenerator(Random random) {
            return new RandomStringGenerator(this.alphanum, random);
        }
    }

    public static interface ICharPool<T> {
        public IRandomStringGenerator<T> getGenerator(Random var1);
    }
}

