/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random.generator;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;

public class RandomNumberGenerator
implements IRandomStringGenerator<BigInteger> {
    private final Random random;
    private final char[] symbols;

    public RandomNumberGenerator(String alphanum) {
        this(alphanum, new SecureRandom());
    }

    public RandomNumberGenerator(String alphanum, Random random) {
        if (alphanum.length() < 2) {
            throw new IllegalArgumentException();
        }
        this.symbols = alphanum.toCharArray();
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public BigInteger next(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        return new BigInteger(IntStream.range(0, length).mapToObj(i -> String.valueOf(this.symbols[this.random.nextInt(this.symbols.length)])).reduce(String::concat).orElse("0"));
    }
}

