/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random.generator;

import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.stream.IntStream;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;

public class RandomStringGenerator
implements IRandomStringGenerator<String> {
    private final Random random;
    private final char[] symbols;

    public RandomStringGenerator(String alphanum) {
        this(alphanum, new SecureRandom());
    }

    public RandomStringGenerator(String alphanum, Random random) {
        if (alphanum.length() < 2) {
            throw new IllegalArgumentException();
        }
        this.symbols = alphanum.toCharArray();
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public String next(int length) {
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[length];
        IntStream.range(0, buf.length).forEach(i -> {
            buf[i] = this.symbols[this.random.nextInt(this.symbols.length)];
        });
        return new String(buf);
    }
}

