/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random.generator;

import java.math.BigInteger;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;
import org.alindner.tools.common.random.generator.RandomNumberGenerator;
import org.alindner.tools.common.random.generator.RandomStringGenerator;
import org.alindner.tools.common.random.generator.RandomUnicodeStringGenerator;

public class Generator {
    public static IRandomStringGenerator<String> alphanumeric() {
        return new RandomStringGenerator(new AlphaNumericPool(), ThreadLocalRandom.current());
    }

    public static IRandomStringGenerator<String> alphanumericSigns() {
        return new RandomStringGenerator(new AlphanumericSignsPool(), ThreadLocalRandom.current());
    }

    public static IRandomStringGenerator<String> unicode() {
        return new RandomUnicodeStringGenerator(ThreadLocalRandom.current());
    }

    public static IRandomStringGenerator<String> numbers() {
        return new RandomStringGenerator(new NumbersPool(), ThreadLocalRandom.current());
    }

    public static IRandomStringGenerator<BigInteger> integerNumbers() {
        return new RandomNumberGenerator(new NumbersPool(), ThreadLocalRandom.current());
    }

    public static class NumbersPool
    implements ICharPool {
        final String digits = "0123456789";

        @Override
        public char[] getCharacters() {
            return this.digits.toCharArray();
        }
    }

    public static class AlphanumericSignsPool
    extends AlphaNumericPool {
        final String alphanum;

        public AlphanumericSignsPool() {
            this.alphanum = ((AlphaNumericPool)this).alphanum + "A-Z,a-z,0-9,!\u00a7$%&/()=?{[]}\\-_.,:;+*~#<>";
        }

        @Override
        public char[] getCharacters() {
            return this.alphanum.toCharArray();
        }
    }

    public static class AlphaNumericPool
    implements ICharPool {
        final String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        final String lower = this.upper.toLowerCase(Locale.ROOT);
        final String digits = "0123456789";
        final String alphanum = this.upper + this.lower + this.digits;

        @Override
        public char[] getCharacters() {
            return this.alphanum.toCharArray();
        }
    }

    public static interface ICharPool {
        public char[] getCharacters();
    }
}

