/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random.generator;

import java.math.BigInteger;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.alindner.tools.common.random.generator.Generator;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;

public class RandomNumberGenerator
implements IRandomStringGenerator<BigInteger> {
    private final Random random;
    private final char[] symbols;

    public RandomNumberGenerator(Generator.ICharPool alphanum) {
        this(alphanum, ThreadLocalRandom.current());
    }

    public RandomNumberGenerator(Generator.ICharPool alphanum, Random random) {
        this.symbols = alphanum.getCharacters();
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public BigInteger next(int length) {
        return new BigInteger(IntStream.range(0, length).mapToObj(i -> String.valueOf(this.symbols[this.random.nextInt(this.symbols.length)])).reduce(String::concat).orElse("0"));
    }
}

