/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random.generator;

import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.alindner.tools.common.random.generator.Generator;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;

public class RandomStringGenerator
implements IRandomStringGenerator<String> {
    private final Random random;
    private final char[] symbols;

    public RandomStringGenerator(Generator.ICharPool alphanum) {
        this(alphanum, ThreadLocalRandom.current());
    }

    public RandomStringGenerator(Generator.ICharPool alphanum, Random random) {
        this.symbols = alphanum.getCharacters();
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public String next(int length) {
        return IntStream.range(0, length).mapToObj(i -> String.valueOf(this.symbols[this.random.nextInt(this.symbols.length)])).reduce(String::concat).orElse("");
    }
}

