/*
 * Decompiled with CFR 0.152.
 */
package org.alindner.tools.common.random;

import java.math.BigInteger;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alindner.tools.common.random.generator.Generator;
import org.alindner.tools.common.random.generator.IRandomStringGenerator;

public class Random {
    public static <T> Stream<T> stream(int limit, int length, Predicate<? super T> filter, IRandomStringGenerator<T> generator) {
        return Random.build(generator).stream(length).filter(filter).limit(limit);
    }

    public static <T> Stream<T> streamParallel(int limit, int length, IRandomStringGenerator<T> generator) {
        return Random.build(generator).stream(length, limit);
    }

    public static <T> Stream<T> streamParallelUnique(int count, int length, Predicate<? super T> method, IRandomStringGenerator<T> generator) {
        return Random.build(generator).stream(length).distinct().filter(method).limit(count);
    }

    public static <T> List<T> list(int count, int length, Predicate<? super T> method, IRandomStringGenerator<T> generator) {
        return Random.stream(count, length, method, generator).collect(Collectors.toList());
    }

    public static java.lang.String get(int length) {
        return Random.build().stream(length).findFirst().orElseThrow(RuntimeException::new);
    }

    public static BigInteger getNumber(int length) {
        return Random.build(Generator.integerNumbers()).stream(length).findFirst().orElseThrow(RuntimeException::new);
    }

    public static RandomStream<java.lang.String> build() {
        return new RandomStream<java.lang.String>(Generator.alphanumeric());
    }

    public static <T> RandomStream<T> build(IRandomStringGenerator<T> generator) {
        return new RandomStream<T>(generator);
    }

    private static void checkLength(int length) throws IllegalArgumentException {
        if (length < 2) {
            throw new IllegalArgumentException();
        }
    }

    public static class String {
        public static RandomStream<java.lang.String> build() {
            return new RandomStream<java.lang.String>(Generator.alphanumeric());
        }
    }

    static class StringRandoms {
        StringRandoms() {
        }

        public static Stream<java.lang.String> stream() {
            return Random.build().stream();
        }

        public static Stream<java.lang.String> stream(int limit) {
            return StringRandoms.stream(limit, s -> true);
        }

        public static Stream<java.lang.String> stream(int limit, int length) {
            return StringRandoms.stream(limit, length, s -> true);
        }

        public static Stream<java.lang.String> stream(int limit, Predicate<java.lang.String> method) {
            return StringRandoms.stream(limit, 5, method);
        }

        public static Stream<java.lang.String> stream(int limit, int length, Predicate<java.lang.String> method) {
            return Random.stream(limit, length, method, Generator.alphanumeric());
        }

        public static Stream<java.lang.String> uniqueStream() {
            return Random.build().uniqueStream();
        }

        public static Stream<java.lang.String> uniqueStream(int limit) {
            return StringRandoms.uniqueStream(limit, s -> true);
        }

        public static Stream<java.lang.String> uniqueStream(int limit, int length) {
            return StringRandoms.uniqueStream(limit, length, s -> true);
        }

        public static Stream<java.lang.String> uniqueStream(int limit, Predicate<java.lang.String> method) {
            return StringRandoms.uniqueStream(limit, 5, method);
        }

        public static Stream<java.lang.String> uniqueStream(int limit, int length, Predicate<java.lang.String> filter) {
            return Random.build().uniqueStream(limit, length, filter);
        }

        public static Stream<java.lang.String> streamParallel(int limit) {
            return StringRandoms.streamParallel(limit, 5);
        }

        public static Stream<java.lang.String> streamParallel(int limit, int length) {
            return Random.streamParallel(limit, length, Generator.alphanumeric());
        }

        public static Stream<java.lang.String> streamParallelUnique(int limit) {
            return StringRandoms.streamParallelUnique(limit, 5);
        }

        public static Stream<java.lang.String> streamParallelUnique(int limit, int length) {
            return StringRandoms.streamParallelUnique(limit, length, str -> true);
        }

        public static Stream<java.lang.String> streamParallelUnique(int limit, int length, Predicate<java.lang.String> filter) {
            return Random.streamParallelUnique(limit, length, filter, Generator.alphanumeric());
        }

        public static List<java.lang.String> list(int limit, int length, Predicate<java.lang.String> filter) {
            return StringRandoms.stream(limit, length, filter).collect(Collectors.toList());
        }
    }

    public static class RandomStream<T> {
        private final IRandomStringGenerator<T> generator;

        public RandomStream(IRandomStringGenerator<T> generator) {
            this.generator = generator;
        }

        public Stream<T> stream() {
            return (Stream)Stream.generate(() -> this.generator.next(5)).unordered();
        }

        public Stream<T> stream(int length) {
            Random.checkLength(length);
            return (Stream)Stream.generate(() -> this.generator.next(length)).unordered();
        }

        public Stream<T> stream(int length, int limit) {
            Random.checkLength(length);
            return Stream.generate(() -> this.generator.next(length)).limit(limit);
        }

        public Stream<T> stream(int length, int limit, Predicate<T> filter) {
            Random.checkLength(length);
            return Stream.generate(() -> this.generator.next(length)).filter(filter).limit(limit);
        }

        public Stream<T> uniqueStream() {
            return this.stream().distinct();
        }

        public Stream<T> uniqueStream(int length, int limit) {
            Random.checkLength(length);
            return this.stream(length).distinct().limit(limit);
        }

        public Stream<T> uniqueStream(int length, int limit, Predicate<T> filter) {
            Random.checkLength(length);
            return this.stream(length).filter(filter).distinct().limit(limit);
        }

        public Stream<T> parallelStream(int length, int limit) {
            Random.checkLength(length);
            return ((Stream)this.stream(length).parallel()).limit(limit);
        }

        public Stream<T> parallelStream(int length, int limit, Predicate<T> filter) {
            Random.checkLength(length);
            return ((Stream)this.stream(length).parallel()).filter(filter).limit(limit);
        }

        public Stream<T> parallelUniqueStream(int length, int count) {
            Random.checkLength(length);
            return ((Stream)this.stream(length).parallel()).distinct().limit(count);
        }

        public Stream<T> parallelUniqueStream(int length, int count, Predicate<T> filter) {
            Random.checkLength(length);
            return ((Stream)this.stream(length).parallel()).distinct().filter(filter).limit(count);
        }

        public List<T> list(int length, int count, Predicate<T> filter) {
            return this.stream(length, count, filter).collect(Collectors.toList());
        }
    }
}

