/* Generated by: CongoCC Parser Generator. SNBTParserImplement.java  */
package org.allaymc.snbt;

import org.allaymc.snbt.Token.TokenType;
import org.allaymc.snbt.ast.*;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.*;
import java.util.concurrent.CancellationException;

import static org.allaymc.snbt.Token.TokenType.*;


public class SNBTParserImplement {
    static final int UNLIMITED = Integer.MAX_VALUE;
    // The last token successfully "consumed"
    Token lastConsumedToken;
    private TokenType nextTokenType;
    private Token currentLookaheadToken;
    private int remainingLookahead;
    private boolean hitFailure;
    private boolean passedPredicate;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    private int lookaheadRoutineNesting;
    private int passedPredicateThreshold = -1;
    EnumSet<TokenType> outerFollowSet;
    private boolean legacyGlitchyLookahead = false;
    private final Token DUMMY_START_TOKEN = new Token();
    private boolean cancelled;

    public void cancel() {
        cancelled = true;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    /** Generated Lexer. */
    private SNBTLexer token_source;

    public void setInputSource(String inputSource) {
        token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return token_source.getInputSource();
    }

    //=================================
    // Generated constructors
    //=================================
    public SNBTParserImplement(String inputSource, CharSequence content) {
        this(new SNBTLexer(inputSource, content));
    }

    public SNBTParserImplement(CharSequence content) {
        this("input", content);
    }

    /**
    * @param inputSource just the name of the input source (typically the filename) that
    * will be used in error messages and so on.
    * @param path The location (typically the filename) from which to get the input to parse
    */
    public SNBTParserImplement(String inputSource, Path path) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path)));
    }

    public SNBTParserImplement(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path), charset));
    }

    /**
    * @param path The location (typically the filename) from which to get the input to parse
    */
    public SNBTParserImplement(Path path) throws IOException {
        this(path.toString(), path);
    }

    /** Constructor with user supplied Lexer. */
    public SNBTParserImplement(SNBTLexer lexer) {
        token_source = lexer;
        lastConsumedToken = DUMMY_START_TOKEN;
        lastConsumedToken.setTokenSource(lexer);
    }

    /**
    * Set the starting line/column for location reporting.
    * By default, this is 1,1.
    */
    public void setStartingPos(int startingLine, int startingColumn) {
        token_source.setStartingPos(startingLine, startingColumn);
    }

    // If the next token is cached, it returns that
    // Otherwise, it goes to the token_source, i.e. the Lexer.
    private final Token nextToken(final Token tok) {
        Token result = token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result = token_source.getNextToken(result);
        }
        nextTokenType = null;
        return result;
    }

    /**
    * @return the next Token off the stream. This is the same as #getToken(1)
    */
    public final Token getNextToken() {
        return getToken(1);
    }

    /**
    * @param index how many tokens to look ahead
    * @return the specific regular (i.e. parsed) Token index ahead/behind in the stream.
    * If we are in a lookahead, it looks ahead from the currentLookaheadToken
    * Otherwise, it is the lastConsumedToken. If you pass in a negative
    * number it goes backward.
    */
    public final Token getToken(final int index) {
        Token t = currentLookaheadToken == null ? lastConsumedToken : currentLookaheadToken;
        for (int i = 0; i < index; i++) {
            t = nextToken(t);
        }
        for (int i = 0; i > index; i--) {
            t = t.getPrevious();
            if (t == null) break;
        }
        return t;
    }

    private final TokenType nextTokenType() {
        if (nextTokenType == null) {
            nextTokenType = nextToken(lastConsumedToken).getType();
        }
        return nextTokenType;
    }

    boolean activateTokenTypes(TokenType...types) {
        if (token_source.activeTokenTypes == null) return false;
        boolean result = false;
        for (TokenType tt : types) {
            result |= token_source.activeTokenTypes.add(tt);
        }
        if (result) {
            token_source.reset(getToken(0));
            nextTokenType = null;
        }
        return result;
    }

    boolean deactivateTokenTypes(TokenType...types) {
        boolean result = false;
        if (token_source.activeTokenTypes == null) {
            token_source.activeTokenTypes = EnumSet.allOf(TokenType.class);
        }
        for (TokenType tt : types) {
            result |= token_source.activeTokenTypes.remove(tt);
        }
        if (result) {
            token_source.reset(getToken(0));
            nextTokenType = null;
        }
        return result;
    }

    private static HashMap<TokenType[], EnumSet<TokenType>> enumSetCache = new HashMap<>();

    private static EnumSet<TokenType> tokenTypeSet(TokenType first, TokenType...rest) {
        TokenType[] key = new TokenType[1 + rest.length];
        key[0] = first;
        if (rest.length > 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort(key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<TokenType> result = (rest.length == 0) ? EnumSet.of(first) : EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    //=================================
    // Start of methods for BNF Productions
    //This code is generated by the ParserProductions.java.ftl template.
    //=================================
    private static final EnumSet<TokenType> Value_FIRST_SET = Value_FIRST_SET_init();

    private static EnumSet<TokenType> Value_FIRST_SET_init() {
        return tokenTypeSet(OPEN_BRACKET, OPEN_BRACE, BOOLEAN, FLOAT, DOUBLE, INTEGER, BYTE, LONG, SHORT, STRING);
    }

    // SNBT.ccc:64:1
    final public void Value() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "Value";
        // Code for ExpansionChoice specified at SNBT.ccc:65:5
        Value thisProduction = null;
        if (buildTree) {
            thisProduction = new Value();
            openNodeScope(thisProduction);
        }
        ParseException parseException2 = null;
        int callStackSize3 = parsingStack.size();
        try {
            if (nextTokenType() == BYTE) {
                // Code for Terminal specified at SNBT.ccc:65:5
                consumeToken(BYTE);
            } else if (nextTokenType() == LONG) {
                // Code for Terminal specified at SNBT.ccc:67:5
                consumeToken(LONG);
            } else if (nextTokenType() == SHORT) {
                // Code for Terminal specified at SNBT.ccc:69:5
                consumeToken(SHORT);
            } else if (nextTokenType() == INTEGER) {
                // Code for Terminal specified at SNBT.ccc:71:5
                consumeToken(INTEGER);
            } else if (nextTokenType() == FLOAT) {
                // Code for Terminal specified at SNBT.ccc:73:5
                consumeToken(FLOAT);
            } else if (nextTokenType() == DOUBLE) {
                // Code for Terminal specified at SNBT.ccc:75:5
                consumeToken(DOUBLE);
            } else if (nextTokenType() == BOOLEAN) {
                // Code for Terminal specified at SNBT.ccc:77:5
                consumeToken(BOOLEAN);
            } else if (nextTokenType() == STRING) {
                // Code for Terminal specified at SNBT.ccc:79:5
                consumeToken(STRING);
            } else if (scan$SNBT_ccc$81$5()) {
                // Code for NonTerminal specified at SNBT.ccc:81:5
                pushOntoCallStack("Value", "SNBT.ccc", 81, 5);
                try {
                    ByteArrayNBT();
                } finally {
                    popCallStack();
                }
            } else if (scan$SNBT_ccc$83$5()) {
                // Code for NonTerminal specified at SNBT.ccc:83:5
                pushOntoCallStack("Value", "SNBT.ccc", 83, 5);
                try {
                    IntArrayNBT();
                } finally {
                    popCallStack();
                }
            } else if (scan$SNBT_ccc$85$5()) {
                // Code for NonTerminal specified at SNBT.ccc:85:5
                pushOntoCallStack("Value", "SNBT.ccc", 85, 5);
                try {
                    LongArrayNBT();
                } finally {
                    popCallStack();
                }
            } else if (nextTokenType() == OPEN_BRACE) {
                // Code for NonTerminal specified at SNBT.ccc:87:5
                pushOntoCallStack("Value", "SNBT.ccc", 87, 5);
                try {
                    CompoundNBT();
                } finally {
                    popCallStack();
                }
            } else if (nextTokenType() == OPEN_BRACKET) {
                // Code for NonTerminal specified at SNBT.ccc:89:5
                pushOntoCallStack("Value", "SNBT.ccc", 89, 5);
                try {
                    ListNBT();
                } finally {
                    popCallStack();
                }
            } else {
                pushOntoCallStack("Value", "SNBT.ccc", 65, 5);
                throw new ParseException(lastConsumedToken, Value_FIRST_SET, parsingStack);
            }
        } catch (ParseException e) {
            parseException2 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize3);
            if (thisProduction != null) {
                if (parseException2 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:92:1
    final public void KeyValuePair() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "KeyValuePair";
        KeyValuePair thisProduction = null;
        if (buildTree) {
            thisProduction = new KeyValuePair();
            openNodeScope(thisProduction);
        }
        ParseException parseException110 = null;
        int callStackSize111 = parsingStack.size();
        try {
            // Code for Terminal specified at SNBT.ccc:92:16
            consumeToken(STRING);
            // Code for Terminal specified at SNBT.ccc:92:25
            consumeToken(COLON);
            // Code for ZeroOrOne specified at SNBT.ccc:92:33
            if (first_set$SNBT_ccc$92$34.contains(nextTokenType())) {
                // Code for NonTerminal specified at SNBT.ccc:92:34
                pushOntoCallStack("KeyValuePair", "SNBT.ccc", 92, 34);
                try {
                    Value();
                } finally {
                    popCallStack();
                }
            }
        } catch (ParseException e) {
            parseException110 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize111);
            if (thisProduction != null) {
                if (parseException110 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:94:1
    final public void ByteArrayNBT() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "ByteArrayNBT";
        ByteArrayNBT thisProduction = null;
        if (buildTree) {
            thisProduction = new ByteArrayNBT();
            openNodeScope(thisProduction);
        }
        ParseException parseException134 = null;
        int callStackSize135 = parsingStack.size();
        try {
            // Code for Terminal specified at SNBT.ccc:95:5
            consumeToken(OPEN_BRACKET);
            // Code for Terminal specified at SNBT.ccc:95:20
            consumeToken(B);
            // Code for Terminal specified at SNBT.ccc:95:24
            consumeToken(SEMICOLON);
            // Code for ZeroOrOne specified at SNBT.ccc:95:41
            if (nextTokenType() == BOOLEAN || nextTokenType == BYTE) {
                if (nextTokenType() == BYTE) {
                    // Code for Terminal specified at SNBT.ccc:95:44
                    consumeToken(BYTE);
                } else if (nextTokenType() == BOOLEAN) {
                    // Code for Terminal specified at SNBT.ccc:95:52
                    consumeToken(BOOLEAN);
                } else {
                    pushOntoCallStack("ByteArrayNBT", "SNBT.ccc", 95, 44);
                    throw new ParseException(lastConsumedToken, first_set$SNBT_ccc$95$44, parsingStack);
                }
                // Code for ZeroOrMore specified at SNBT.ccc:95:63
                while (true) {
                    if (!(nextTokenType() == COMMA)) break;
                    // Code for Terminal specified at SNBT.ccc:95:64
                    consumeToken(COMMA);
                    if (nextTokenType() == BYTE) {
                        // Code for Terminal specified at SNBT.ccc:95:73
                        consumeToken(BYTE);
                    } else if (nextTokenType() == BOOLEAN) {
                        // Code for Terminal specified at SNBT.ccc:95:82
                        consumeToken(BOOLEAN);
                    } else {
                        pushOntoCallStack("ByteArrayNBT", "SNBT.ccc", 95, 73);
                        throw new ParseException(lastConsumedToken, first_set$SNBT_ccc$95$73, parsingStack);
                    }
                }
                // Code for ZeroOrOne specified at SNBT.ccc:95:95
                if (nextTokenType() == COMMA) {
                    // Code for Terminal specified at SNBT.ccc:95:96
                    consumeToken(COMMA);
                }
            }
            // Code for Terminal specified at SNBT.ccc:95:108
            consumeToken(CLOSE_BRACKET);
        } catch (ParseException e) {
            parseException134 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize135);
            if (thisProduction != null) {
                if (parseException134 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:97:1
    final public void IntArrayNBT() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "IntArrayNBT";
        IntArrayNBT thisProduction = null;
        if (buildTree) {
            thisProduction = new IntArrayNBT();
            openNodeScope(thisProduction);
        }
        ParseException parseException228 = null;
        int callStackSize229 = parsingStack.size();
        try {
            // Code for Terminal specified at SNBT.ccc:98:5
            consumeToken(OPEN_BRACKET);
            // Code for Terminal specified at SNBT.ccc:98:20
            consumeToken(I);
            // Code for Terminal specified at SNBT.ccc:98:24
            consumeToken(SEMICOLON);
            // Code for ZeroOrOne specified at SNBT.ccc:98:41
            if (nextTokenType() == INTEGER) {
                // Code for Terminal specified at SNBT.ccc:98:42
                consumeToken(INTEGER);
                // Code for ZeroOrMore specified at SNBT.ccc:98:52
                while (true) {
                    if (!(nextTokenType() == COMMA)) break;
                    // Code for Terminal specified at SNBT.ccc:98:53
                    consumeToken(COMMA);
                    // Code for Terminal specified at SNBT.ccc:98:61
                    consumeToken(INTEGER);
                }
                // Code for ZeroOrOne specified at SNBT.ccc:98:73
                if (nextTokenType() == COMMA) {
                    // Code for Terminal specified at SNBT.ccc:98:74
                    consumeToken(COMMA);
                }
            }
            // Code for Terminal specified at SNBT.ccc:98:86
            consumeToken(CLOSE_BRACKET);
        } catch (ParseException e) {
            parseException228 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize229);
            if (thisProduction != null) {
                if (parseException228 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:100:1
    final public void LongArrayNBT() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "LongArrayNBT";
        LongArrayNBT thisProduction = null;
        if (buildTree) {
            thisProduction = new LongArrayNBT();
            openNodeScope(thisProduction);
        }
        ParseException parseException288 = null;
        int callStackSize289 = parsingStack.size();
        try {
            // Code for Terminal specified at SNBT.ccc:101:5
            consumeToken(OPEN_BRACKET);
            // Code for Terminal specified at SNBT.ccc:101:20
            consumeToken(L);
            // Code for Terminal specified at SNBT.ccc:101:24
            consumeToken(SEMICOLON);
            // Code for ZeroOrOne specified at SNBT.ccc:101:41
            if (nextTokenType() == LONG) {
                // Code for Terminal specified at SNBT.ccc:101:42
                consumeToken(LONG);
                // Code for ZeroOrMore specified at SNBT.ccc:101:49
                while (true) {
                    if (!(nextTokenType() == COMMA)) break;
                    // Code for Terminal specified at SNBT.ccc:101:50
                    consumeToken(COMMA);
                    // Code for Terminal specified at SNBT.ccc:101:58
                    consumeToken(LONG);
                }
                // Code for ZeroOrOne specified at SNBT.ccc:101:67
                if (nextTokenType() == COMMA) {
                    // Code for Terminal specified at SNBT.ccc:101:68
                    consumeToken(COMMA);
                }
            }
            // Code for Terminal specified at SNBT.ccc:101:80
            consumeToken(CLOSE_BRACKET);
        } catch (ParseException e) {
            parseException288 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize289);
            if (thisProduction != null) {
                if (parseException288 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:103:1
    final public void ListNBT() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "ListNBT";
        ListNBT thisProduction = null;
        if (buildTree) {
            thisProduction = new ListNBT();
            openNodeScope(thisProduction);
        }
        ParseException parseException348 = null;
        int callStackSize349 = parsingStack.size();
        try {
            // Code for Terminal specified at SNBT.ccc:104:5
            consumeToken(OPEN_BRACKET);
            // Code for ZeroOrOne specified at SNBT.ccc:104:20
            if (first_set$SNBT_ccc$104$21.contains(nextTokenType())) {
                // Code for NonTerminal specified at SNBT.ccc:104:21
                pushOntoCallStack("ListNBT", "SNBT.ccc", 104, 21);
                try {
                    Value();
                } finally {
                    popCallStack();
                }
                // Code for ZeroOrMore specified at SNBT.ccc:104:27
                while (true) {
                    if (!(nextTokenType() == COMMA)) break;
                    // Code for Terminal specified at SNBT.ccc:104:28
                    consumeToken(COMMA);
                    // Code for NonTerminal specified at SNBT.ccc:104:36
                    pushOntoCallStack("ListNBT", "SNBT.ccc", 104, 36);
                    try {
                        Value();
                    } finally {
                        popCallStack();
                    }
                }
            }
            // Code for Terminal specified at SNBT.ccc:104:46
            consumeToken(CLOSE_BRACKET);
        } catch (ParseException e) {
            parseException348 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize349);
            if (thisProduction != null) {
                if (parseException348 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:106:1
    final public void CompoundNBT() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "CompoundNBT";
        CompoundNBT thisProduction = null;
        if (buildTree) {
            thisProduction = new CompoundNBT();
            openNodeScope(thisProduction);
        }
        ParseException parseException388 = null;
        int callStackSize389 = parsingStack.size();
        try {
            // Code for Terminal specified at SNBT.ccc:106:15
            consumeToken(OPEN_BRACE);
            // Code for ZeroOrOne specified at SNBT.ccc:106:28
            if (nextTokenType() == STRING) {
                // Code for NonTerminal specified at SNBT.ccc:106:29
                pushOntoCallStack("CompoundNBT", "SNBT.ccc", 106, 29);
                try {
                    KeyValuePair();
                } finally {
                    popCallStack();
                }
                // Code for ZeroOrMore specified at SNBT.ccc:106:42
                while (true) {
                    if (!(nextTokenType() == COMMA)) break;
                    // Code for Terminal specified at SNBT.ccc:106:43
                    consumeToken(COMMA);
                    // Code for NonTerminal specified at SNBT.ccc:106:51
                    pushOntoCallStack("CompoundNBT", "SNBT.ccc", 106, 51);
                    try {
                        KeyValuePair();
                    } finally {
                        popCallStack();
                    }
                }
            }
            // Code for Terminal specified at SNBT.ccc:106:68
            consumeToken(CLOSE_BRACE);
        } catch (ParseException e) {
            parseException388 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize389);
            if (thisProduction != null) {
                if (parseException388 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    // SNBT.ccc:109:1
    final public void Root() {
        if (cancelled) throw new CancellationException();
        String prevProduction = currentlyParsedProduction;
        this.currentlyParsedProduction = "Root";
        Root thisProduction = null;
        if (buildTree) {
            thisProduction = new Root();
            openNodeScope(thisProduction);
        }
        ParseException parseException428 = null;
        int callStackSize429 = parsingStack.size();
        try {
            // Code for NonTerminal specified at SNBT.ccc:109:8
            pushOntoCallStack("Root", "SNBT.ccc", 109, 8);
            try {
                Value();
            } finally {
                popCallStack();
            }
            // Code for Terminal specified at SNBT.ccc:109:14
            consumeToken(EOF);
        } catch (ParseException e) {
            parseException428 = e;
            throw e;
        } finally {
            restoreCallStack(callStackSize429);
            if (thisProduction != null) {
                if (parseException428 == null) {
                    closeNodeScope(thisProduction, nodeArity() > 1);
                } else {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    private static final EnumSet<TokenType> first_set$SNBT_ccc$92$34 = first_set$SNBT_ccc$92$34_init();

    private static EnumSet<TokenType> first_set$SNBT_ccc$92$34_init() {
        return tokenTypeSet(OPEN_BRACKET, OPEN_BRACE, BOOLEAN, FLOAT, DOUBLE, INTEGER, BYTE, LONG, SHORT, STRING);
    }

    private static final EnumSet<TokenType> first_set$SNBT_ccc$95$44 = tokenTypeSet(BOOLEAN, BYTE);
    private static final EnumSet<TokenType> first_set$SNBT_ccc$95$73 = tokenTypeSet(BOOLEAN, BYTE);
    private static final EnumSet<TokenType> first_set$SNBT_ccc$104$21 = first_set$SNBT_ccc$104$21_init();

    private static EnumSet<TokenType> first_set$SNBT_ccc$104$21_init() {
        return tokenTypeSet(OPEN_BRACKET, OPEN_BRACE, BOOLEAN, FLOAT, DOUBLE, INTEGER, BYTE, LONG, SHORT, STRING);
    }

    private final boolean scanToken(TokenType expectedType, TokenType...additionalTypes) {
        Token peekedToken = nextToken(currentLookaheadToken);
        TokenType type = peekedToken.getType();
        if (type != expectedType) {
            boolean matched = false;
            for (TokenType tt : additionalTypes) {
                if (type == tt) {
                    matched = true;
                    break;
                }
            }
            if (!matched) return false;
        }
        --remainingLookahead;
        currentLookaheadToken = peekedToken;
        return true;
    }

    private final boolean scanToken(EnumSet<TokenType> types) {
        Token peekedToken = nextToken(currentLookaheadToken);
        TokenType type = peekedToken.getType();
        if (!types.contains(type)) return false;
        --remainingLookahead;
        currentLookaheadToken = peekedToken;
        return true;
    }

    // scanahead routine for expansion at:
    // SNBT.ccc:95:43
    // BuildScanRoutine macro
    private final boolean check$SNBT_ccc$95$43(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = remainingLookahead - 1;
        try {
            lookaheadRoutineNesting++;
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            $reachedScanCode$ = true;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ExpansionChoice specified at SNBT.ccc:95:44
            if (!scanToken(BOOLEAN, BYTE)) return false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ZeroOrMore specified at SNBT.ccc:95:63
            boolean passedPredicate455 = passedPredicate;
            try {
                while (remainingLookahead > 0 && !hitFailure) {
                    Token token456 = currentLookaheadToken;
                    passedPredicate = false;
                    if (!check$SNBT_ccc$95$64(false)) {
                        if (passedPredicate && !legacyGlitchyLookahead) return false;
                        currentLookaheadToken = token456;
                        break;
                    }
                }
            } finally {
                passedPredicate = passedPredicate455;
            }
            hitFailure = false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ZeroOrOne specified at SNBT.ccc:95:95
            Token token458 = currentLookaheadToken;
            boolean passedPredicate458 = passedPredicate;
            passedPredicate = false;
            try {
                if (!scanToken(COMMA)) {
                    if (passedPredicate && !legacyGlitchyLookahead) return false;
                    currentLookaheadToken = token458;
                    hitFailure = false;
                }
            } finally {
                passedPredicate = passedPredicate458;
            }
        } finally {
            lookaheadRoutineNesting--;
            if ($reachedScanCode$ && remainingLookahead <= passedPredicateThreshold) {
                passedPredicate = true;
            }
        }
        passedPredicate = false;
        return true;
    }

    // scanahead routine for expansion at:
    // SNBT.ccc:95:64
    // BuildScanRoutine macro
    private final boolean check$SNBT_ccc$95$64(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = remainingLookahead - 1;
        try {
            lookaheadRoutineNesting++;
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            $reachedScanCode$ = true;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:95:64
            if (!scanToken(COMMA)) return false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ExpansionChoice specified at SNBT.ccc:95:73
            if (!scanToken(BOOLEAN, BYTE)) return false;
        } finally {
            lookaheadRoutineNesting--;
            if ($reachedScanCode$ && remainingLookahead <= passedPredicateThreshold) {
                passedPredicate = true;
            }
        }
        passedPredicate = false;
        return true;
    }

    // scanahead routine for expansion at:
    // SNBT.ccc:98:42
    // BuildScanRoutine macro
    private final boolean check$SNBT_ccc$98$42(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = remainingLookahead - 1;
        try {
            lookaheadRoutineNesting++;
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            $reachedScanCode$ = true;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:98:42
            if (!scanToken(INTEGER)) return false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ZeroOrMore specified at SNBT.ccc:98:52
            boolean passedPredicate466 = passedPredicate;
            try {
                while (remainingLookahead > 0 && !hitFailure) {
                    Token token467 = currentLookaheadToken;
                    passedPredicate = false;
                    if (!check$SNBT_ccc$98$53(false)) {
                        if (passedPredicate && !legacyGlitchyLookahead) return false;
                        currentLookaheadToken = token467;
                        break;
                    }
                }
            } finally {
                passedPredicate = passedPredicate466;
            }
            hitFailure = false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ZeroOrOne specified at SNBT.ccc:98:73
            Token token469 = currentLookaheadToken;
            boolean passedPredicate469 = passedPredicate;
            passedPredicate = false;
            try {
                if (!scanToken(COMMA)) {
                    if (passedPredicate && !legacyGlitchyLookahead) return false;
                    currentLookaheadToken = token469;
                    hitFailure = false;
                }
            } finally {
                passedPredicate = passedPredicate469;
            }
        } finally {
            lookaheadRoutineNesting--;
            if ($reachedScanCode$ && remainingLookahead <= passedPredicateThreshold) {
                passedPredicate = true;
            }
        }
        passedPredicate = false;
        return true;
    }

    // scanahead routine for expansion at:
    // SNBT.ccc:98:53
    // BuildScanRoutine macro
    private final boolean check$SNBT_ccc$98$53(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = remainingLookahead - 1;
        try {
            lookaheadRoutineNesting++;
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            $reachedScanCode$ = true;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:98:53
            if (!scanToken(COMMA)) return false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:98:61
            if (!scanToken(INTEGER)) return false;
        } finally {
            lookaheadRoutineNesting--;
            if ($reachedScanCode$ && remainingLookahead <= passedPredicateThreshold) {
                passedPredicate = true;
            }
        }
        passedPredicate = false;
        return true;
    }

    // scanahead routine for expansion at:
    // SNBT.ccc:101:42
    // BuildScanRoutine macro
    private final boolean check$SNBT_ccc$101$42(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = remainingLookahead - 1;
        try {
            lookaheadRoutineNesting++;
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            $reachedScanCode$ = true;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:101:42
            if (!scanToken(LONG)) return false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ZeroOrMore specified at SNBT.ccc:101:49
            boolean passedPredicate476 = passedPredicate;
            try {
                while (remainingLookahead > 0 && !hitFailure) {
                    Token token477 = currentLookaheadToken;
                    passedPredicate = false;
                    if (!check$SNBT_ccc$101$50(false)) {
                        if (passedPredicate && !legacyGlitchyLookahead) return false;
                        currentLookaheadToken = token477;
                        break;
                    }
                }
            } finally {
                passedPredicate = passedPredicate476;
            }
            hitFailure = false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for ZeroOrOne specified at SNBT.ccc:101:67
            Token token479 = currentLookaheadToken;
            boolean passedPredicate479 = passedPredicate;
            passedPredicate = false;
            try {
                if (!scanToken(COMMA)) {
                    if (passedPredicate && !legacyGlitchyLookahead) return false;
                    currentLookaheadToken = token479;
                    hitFailure = false;
                }
            } finally {
                passedPredicate = passedPredicate479;
            }
        } finally {
            lookaheadRoutineNesting--;
            if ($reachedScanCode$ && remainingLookahead <= passedPredicateThreshold) {
                passedPredicate = true;
            }
        }
        passedPredicate = false;
        return true;
    }

    // scanahead routine for expansion at:
    // SNBT.ccc:101:50
    // BuildScanRoutine macro
    private final boolean check$SNBT_ccc$101$50(boolean scanToEnd) {
        boolean $reachedScanCode$ = false;
        int passedPredicateThreshold = remainingLookahead - 1;
        try {
            lookaheadRoutineNesting++;
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            $reachedScanCode$ = true;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:101:50
            if (!scanToken(COMMA)) return false;
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for Terminal specified at SNBT.ccc:101:58
            if (!scanToken(LONG)) return false;
        } finally {
            lookaheadRoutineNesting--;
            if ($reachedScanCode$ && remainingLookahead <= passedPredicateThreshold) {
                passedPredicate = true;
            }
        }
        passedPredicate = false;
        return true;
    }

    // BuildPredicateRoutine: expansion at SNBT.ccc:81:5
    private final boolean scan$SNBT_ccc$81$5() {
        remainingLookahead = UNLIMITED;
        currentLookaheadToken = lastConsumedToken;
        final boolean scanToEnd = false;
        try {
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for NonTerminal specified at SNBT.ccc:81:5
            // NonTerminal ByteArrayNBT at SNBT.ccc:81:5
            pushOntoLookaheadStack("Value", "SNBT.ccc", 81, 5);
            currentLookaheadProduction = "ByteArrayNBT";
            try {
                if (!check$ByteArrayNBT(false)) return false;
            } finally {
                popLookaheadStack();
            }
            return true;
        } finally {
            lookaheadRoutineNesting = 0;
            currentLookaheadToken = null;
            hitFailure = false;
        }
    }

    // BuildPredicateRoutine: expansion at SNBT.ccc:83:5
    private final boolean scan$SNBT_ccc$83$5() {
        remainingLookahead = UNLIMITED;
        currentLookaheadToken = lastConsumedToken;
        final boolean scanToEnd = false;
        try {
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for NonTerminal specified at SNBT.ccc:83:5
            // NonTerminal IntArrayNBT at SNBT.ccc:83:5
            pushOntoLookaheadStack("Value", "SNBT.ccc", 83, 5);
            currentLookaheadProduction = "IntArrayNBT";
            try {
                if (!check$IntArrayNBT(false)) return false;
            } finally {
                popLookaheadStack();
            }
            return true;
        } finally {
            lookaheadRoutineNesting = 0;
            currentLookaheadToken = null;
            hitFailure = false;
        }
    }

    // BuildPredicateRoutine: expansion at SNBT.ccc:85:5
    private final boolean scan$SNBT_ccc$85$5() {
        remainingLookahead = UNLIMITED;
        currentLookaheadToken = lastConsumedToken;
        final boolean scanToEnd = false;
        try {
            // BuildPredicateCode macro
            // End BuildPredicateCode macro
            if (hitFailure) return false;
            if (remainingLookahead <= 0) {
                return true;
            }
            // Lookahead Code for NonTerminal specified at SNBT.ccc:85:5
            // NonTerminal LongArrayNBT at SNBT.ccc:85:5
            pushOntoLookaheadStack("Value", "SNBT.ccc", 85, 5);
            currentLookaheadProduction = "LongArrayNBT";
            try {
                if (!check$LongArrayNBT(false)) return false;
            } finally {
                popLookaheadStack();
            }
            return true;
        } finally {
            lookaheadRoutineNesting = 0;
            currentLookaheadToken = null;
            hitFailure = false;
        }
    }

    // BuildProductionLookaheadMethod macro
    private final boolean check$ByteArrayNBT(boolean scanToEnd) {
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:95:5
        if (!scanToken(OPEN_BRACKET)) return false;
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:95:20
        if (!scanToken(B)) return false;
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:95:24
        if (!scanToken(SEMICOLON)) return false;
        if (!scanToEnd && lookaheadStack.size() <= 1) {
            if (lookaheadRoutineNesting == 0) {
                remainingLookahead = 0;
            } else if (lookaheadStack.size() == 1) {
                passedPredicateThreshold = remainingLookahead;
            }
        }
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for ZeroOrOne specified at SNBT.ccc:95:41
        Token token538 = currentLookaheadToken;
        boolean passedPredicate538 = passedPredicate;
        passedPredicate = false;
        try {
            if (!check$SNBT_ccc$95$43(false)) {
                if (passedPredicate && !legacyGlitchyLookahead) return false;
                currentLookaheadToken = token538;
                hitFailure = false;
            }
        } finally {
            passedPredicate = passedPredicate538;
        }
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:95:108
        if (!scanToken(CLOSE_BRACKET)) return false;
        return true;
    }

    // BuildProductionLookaheadMethod macro
    private final boolean check$IntArrayNBT(boolean scanToEnd) {
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:98:5
        if (!scanToken(OPEN_BRACKET)) return false;
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:98:20
        if (!scanToken(I)) return false;
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:98:24
        if (!scanToken(SEMICOLON)) return false;
        if (!scanToEnd && lookaheadStack.size() <= 1) {
            if (lookaheadRoutineNesting == 0) {
                remainingLookahead = 0;
            } else if (lookaheadStack.size() == 1) {
                passedPredicateThreshold = remainingLookahead;
            }
        }
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for ZeroOrOne specified at SNBT.ccc:98:41
        Token token545 = currentLookaheadToken;
        boolean passedPredicate545 = passedPredicate;
        passedPredicate = false;
        try {
            if (!check$SNBT_ccc$98$42(false)) {
                if (passedPredicate && !legacyGlitchyLookahead) return false;
                currentLookaheadToken = token545;
                hitFailure = false;
            }
        } finally {
            passedPredicate = passedPredicate545;
        }
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:98:86
        if (!scanToken(CLOSE_BRACKET)) return false;
        return true;
    }

    // BuildProductionLookaheadMethod macro
    private final boolean check$LongArrayNBT(boolean scanToEnd) {
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:101:5
        if (!scanToken(OPEN_BRACKET)) return false;
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:101:20
        if (!scanToken(L)) return false;
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:101:24
        if (!scanToken(SEMICOLON)) return false;
        if (!scanToEnd && lookaheadStack.size() <= 1) {
            if (lookaheadRoutineNesting == 0) {
                remainingLookahead = 0;
            } else if (lookaheadStack.size() == 1) {
                passedPredicateThreshold = remainingLookahead;
            }
        }
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for ZeroOrOne specified at SNBT.ccc:101:41
        Token token552 = currentLookaheadToken;
        boolean passedPredicate552 = passedPredicate;
        passedPredicate = false;
        try {
            if (!check$SNBT_ccc$101$42(false)) {
                if (passedPredicate && !legacyGlitchyLookahead) return false;
                currentLookaheadToken = token552;
                hitFailure = false;
            }
        } finally {
            passedPredicate = passedPredicate552;
        }
        if (hitFailure) return false;
        if (remainingLookahead <= 0) {
            return true;
        }
        // Lookahead Code for Terminal specified at SNBT.ccc:101:80
        if (!scanToken(CLOSE_BRACKET)) return false;
        return true;
    }

    private ArrayList<NonTerminalCall> parsingStack = new ArrayList<>();
    private ArrayList<NonTerminalCall> lookaheadStack = new ArrayList<>();

    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        parsingStack.add(new NonTerminalCall("SNBTParserImplement", token_source, fileName, methodName, line, column, null));
    }

    private final void popCallStack() {
        NonTerminalCall ntc = parsingStack.remove(parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
    }

    private final void restoreCallStack(int prevSize) {
        while (parsingStack.size() > prevSize) {
            popCallStack();
        }
    }

    private final void pushOntoLookaheadStack(String methodName, String fileName, int line, int column) {
        lookaheadStack.add(new NonTerminalCall("SNBTParserImplement", token_source, fileName, methodName, line, column, null));
    }

    private final void popLookaheadStack() {
        NonTerminalCall ntc = lookaheadStack.remove(lookaheadStack.size() - 1);
        this.currentLookaheadProduction = ntc.productionName;
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = lookaheadStack.listIterator(lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = parsingStack.listIterator(parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(TokenType expectedType) {
        Token nextToken = nextToken(lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        if (buildTree && tokensAreNodes) {
            pushNode(lastConsumedToken);
        }
        return lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(TokenType expectedType, Token nextToken) {
        throw new ParseException(nextToken, EnumSet.of(expectedType), parsingStack);
    }

    private boolean buildTree = true;
    private boolean tokensAreNodes = true;
    private boolean unparsedTokensAreNodes = false;

    public boolean isTreeBuildingEnabled() {
        return buildTree;
    }

    public void setUnparsedTokensAreNodes(boolean unparsedTokensAreNodes) {
        this.unparsedTokensAreNodes = unparsedTokensAreNodes;
    }

    public void setTokensAreNodes(boolean tokensAreNodes) {
        this.tokensAreNodes = tokensAreNodes;
    }

    NodeScope currentNodeScope = new NodeScope();

    /**
    * @return the root node of the AST. It only makes sense to call
    * this after a successful parse.
    */
    public Node rootNode() {
        return currentNodeScope.rootNode();
    }

    /**
    * push a node onto the top of the node stack
    * @param n the node to push
    */
    public void pushNode(Node n) {
        currentNodeScope.add(n);
    }

    /**
    * @return the node on the top of the stack, and remove it from the
    * stack.
    */
    public Node popNode() {
        return currentNodeScope.pop();
    }

    /**
    * @return the node currently on the top of the tree-building stack.
    */
    public Node peekNode() {
        return currentNodeScope.peek();
    }

    /**
    * Puts the node on the top of the stack. However, unlike pushNode()
    * it replaces the node that is currently on the top of the stack.
    * This is effectively equivalent to popNode() followed by pushNode(n)
    * @param n the node to poke
    */
    public void pokeNode(Node n) {
        currentNodeScope.poke(n);
    }

    /**
    * @return the number of Nodes on the tree-building stack in the current node
    * scope.
    */
    public int nodeArity() {
        return currentNodeScope.size();
    }

    private void clearNodeScope() {
        currentNodeScope.clear();
    }

    private void openNodeScope(Node n) {
        new NodeScope();
        if (n != null) {
            Token next = nextToken(lastConsumedToken);
            n.setTokenSource(lastConsumedToken.getTokenSource());
            n.setBeginOffset(next.getBeginOffset());
            n.open();
        }
    }

    /* A definite node is constructed from a specified number of
    * children.  That number of nodes are popped from the stack and
    * made the children of the definite node.  Then the definite node
    * is pushed on to the stack.
    */
    private boolean closeNodeScope(Node n, int num) {
        n.setEndOffset(lastConsumedToken.getEndOffset());
        currentNodeScope.close();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < num; i++) {
            nodes.add(popNode());
        }
        Collections.reverse(nodes);
        for (Node child : nodes) {
            // FIXME deal with the UNPARSED_TOKENS_ARE_NODES case
            n.addChild(child);
        }
        n.close();
        pushNode(n);
        return true;
    }

    /**
    * A conditional node is constructed if the condition is true.  All
    * the nodes that have been pushed since the node was opened are
    * made children of the conditional node, which is then pushed
    * on to the stack.  If the condition is false the node is not
    * constructed and they are left on the stack.
    */
    private boolean closeNodeScope(Node n, boolean condition) {
        if (n == null || !condition) {
            currentNodeScope.close();
            return false;
        } else {
            n.setEndOffset(lastConsumedToken.getEndOffset());
            int a = nodeArity();
            currentNodeScope.close();
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (a-- > 0) {
                nodes.add(popNode());
            }
            Collections.reverse(nodes);
            for (Node child : nodes) {
                if (unparsedTokensAreNodes && child instanceof Token) {
                    Token tok = (Token) child;
                    while (tok.previousCachedToken() != null && tok.previousCachedToken().isUnparsed()) {
                        tok = tok.previousCachedToken();
                    }
                    while (tok.isUnparsed()) {
                        n.addChild(tok);
                        tok = tok.nextCachedToken();
                    }
                }
                n.addChild(child);
            }
            n.close();
            pushNode(n);
        }
        return true;
    }

    public boolean getBuildTree() {
        return buildTree;
    }

    public void setBuildTree(boolean buildTree) {
        this.buildTree = buildTree;
    }


    @SuppressWarnings("serial")
    class NodeScope extends ArrayList<Node> {
        NodeScope parentScope;

        NodeScope() {
            this.parentScope = SNBTParserImplement.this.currentNodeScope;
            SNBTParserImplement.this.currentNodeScope = this;
        }

        boolean isRootScope() {
            return parentScope == null;
        }

        Node rootNode() {
            NodeScope ns = this;
            while (ns.parentScope != null) {
                ns = ns.parentScope;
            }
            return ns.isEmpty() ? null : ns.get(0);
        }

        Node peek() {
            if (isEmpty()) {
                return parentScope == null ? null : parentScope.peek();
            }
            return get(size() - 1);
        }

        Node pop() {
            return isEmpty() ? parentScope.pop() : remove(size() - 1);
        }

        void poke(Node n) {
            if (isEmpty()) {
                parentScope.poke(n);
            } else {
                set(size() - 1, n);
            }
        }

        void close() {
            parentScope.addAll(this);
            SNBTParserImplement.this.currentNodeScope = parentScope;
        }

        int nestingLevel() {
            int result = 0;
            NodeScope parent = this;
            while (parent.parentScope != null) {
                result++;
                parent = parent.parentScope;
            }
            return result;
        }

        public NodeScope clone() {
            NodeScope clone = (NodeScope) super.clone();
            if (parentScope != null) {
                clone.parentScope = parentScope.clone();
            }
            return clone;
        }

    }

}


