/*
* Generated by: CongoCC Parser Generator. Token.java
*/
package org.allaymc.snbt;

import org.allaymc.snbt.ast.Delimiter;
import org.allaymc.snbt.ast.Literal;
import org.allaymc.snbt.ast.WHITESPACE;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;


public class Token implements Node.TerminalNode {

    public enum TokenType implements NodeType {
        EOF, COLON, COMMA, OPEN_BRACKET, CLOSE_BRACKET, OPEN_BRACE, CLOSE_BRACE, SEMICOLON,
        B, I, L, WHITESPACE, FLOAT_TYPE, DOUBLE_TYPE, LONG_TYPE, BYTE_TYPE, SHORT_TYPE,
        BOOLEAN, FLOAT, DOUBLE, INTEGER, BYTE, LONG, SHORT, STRING, DUMMY, INVALID;

        public boolean isUndefined() {
            return this == DUMMY;
        }

        public boolean isInvalid() {
            return this == INVALID;
        }

        public boolean isEOF() {
            return this == EOF;
        }

    }

    private SNBTLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;
    private String image;

    public void setImage(String image) {
        this.image = image;
    }

    /**
    * It would be extremely rare that an application
    * programmer would use this method. It needs to
    * be public because it is part of the org.allaymc.snbt.Node interface.
    */
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    /**
    * It would be extremely rare that an application
    * programmer would use this method. It needs to
    * be public because it is part of the org.allaymc.snbt.Node interface.
    */
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    /**
    * @return the SNBTLexer object that handles
    * location info for the tokens.
    */
    public SNBTLexer getTokenSource() {
        return this.tokenSource;
    }

    /**
    * It should be exceedingly rare that an application
    * programmer needs to use this method.
    */
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (SNBTLexer) tokenSource;
    }

    /**
    * Return the TokenType of this Token object
    */
    @Override
    public TokenType getType() {
        return type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    /**
    * @return whether this Token represent actual input or was it inserted somehow?
    */
    public boolean isVirtual() {
        return type == TokenType.EOF;
    }

    /**
    * @return Did we skip this token in parsing?
    */
    public boolean isSkipped() {
        return false;
    }

    public int getBeginOffset() {
        return beginOffset;
    }

    public int getEndOffset() {
        return endOffset;
    }

    /**
    * @return the string image of the token.
    */
    @Override
    public String getImage() {
        return getSource();
    }

    /**
    * @return the next _cached_ regular (i.e. parsed) token
    * or null
    */
    public final Token getNext() {
        return getNextParsedToken();
    }

    /**
    * @return the previous regular (i.e. parsed) token
    * or null
    */
    public final Token getPrevious() {
        Token result = previousCachedToken();
        while (result != null && result.isUnparsed()) {
            result = result.previousCachedToken();
        }
        return result;
    }

    /**
    * @return the next regular (i.e. parsed) token
    */
    private Token getNextParsedToken() {
        Token result = nextCachedToken();
        while (result != null && result.isUnparsed()) {
            result = result.nextCachedToken();
        }
        return result;
    }

    /**
    * @return the next token of any sort (parsed or unparsed or invalid)
    */
    public Token nextCachedToken() {
        if (getType() == TokenType.EOF) return null;
        SNBTLexer tokenSource = getTokenSource();
        return tokenSource != null ? (Token) tokenSource.nextCachedToken(getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (getTokenSource() == null) return null;
        return (Token) getTokenSource().previousCachedToken(getBeginOffset());
    }

    Token getPreviousToken() {
        return previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = newToken(type, getTokenSource(), getBeginOffset(), getEndOffset());
        getTokenSource().cacheToken(result);
        return result;
    }

    public String getSource() {
        if (type == TokenType.EOF) return "";
        SNBTLexer flm = getTokenSource();
        return flm == null ? null : flm.getText(getBeginOffset(), getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, SNBTLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    public boolean isUnparsed() {
        return unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (getType() == TokenType.EOF) {
            return "EOF";
        }
        return getImage();
    }

    public String toString() {
        return getNormalizedText();
    }

    /**
    * @return An iterator of the tokens preceding this one.
    */
    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>() {
            Token currentPoint = Token.this;

            public boolean hasNext() {
                return currentPoint.previousCachedToken() != null;
            }

            public Token next() {
                Token previous = currentPoint.previousCachedToken();
                if (previous == null) throw new java.util.NoSuchElementException("No previous token!");
                return currentPoint = previous;
            }

        };
    }

    /**
    * @return a list of the unparsed tokens preceding this one in the order they appear in the input
    */
    public List<Token> precedingUnparsedTokens() {
        List<Token> result = new ArrayList<>();
        Token t = this.previousCachedToken();
        while (t != null && t.isUnparsed()) {
            result.add(t);
            t = t.previousCachedToken();
        }
        Collections.reverse(result);
        return result;
    }

    /**
    * @return An iterator of the (cached) tokens that follow this one.
    */
    public Iterator<Token> followingTokens() {
        return new Iterator<Token>() {
            Token currentPoint = Token.this;

            public boolean hasNext() {
                return currentPoint.nextCachedToken() != null;
            }

            public Token next() {
                Token next = currentPoint.nextCachedToken();
                if (next == null) throw new java.util.NoSuchElementException("No next token!");
                return currentPoint = next;
            }

        };
    }

    public void copyLocationInfo(Token from) {
        setTokenSource(from.getTokenSource());
        setBeginOffset(from.getBeginOffset());
        setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        setTokenSource(start.getTokenSource());
        if (tokenSource == null) setTokenSource(end.getTokenSource());
        setBeginOffset(start.getBeginOffset());
        setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, SNBTLexer tokenSource, int beginOffset, int endOffset) {
        switch(type) {
            case DOUBLE_TYPE : 
                return new Delimiter(TokenType.DOUBLE_TYPE, tokenSource, beginOffset, endOffset);
            case FLOAT : 
                return new Literal(TokenType.FLOAT, tokenSource, beginOffset, endOffset);
            case BYTE_TYPE : 
                return new Delimiter(TokenType.BYTE_TYPE, tokenSource, beginOffset, endOffset);
            case CLOSE_BRACKET : 
                return new Delimiter(TokenType.CLOSE_BRACKET, tokenSource, beginOffset, endOffset);
            case FLOAT_TYPE : 
                return new Delimiter(TokenType.FLOAT_TYPE, tokenSource, beginOffset, endOffset);
            case OPEN_BRACE : 
                return new Delimiter(TokenType.OPEN_BRACE, tokenSource, beginOffset, endOffset);
            case CLOSE_BRACE : 
                return new Delimiter(TokenType.CLOSE_BRACE, tokenSource, beginOffset, endOffset);
            case SEMICOLON : 
                return new Delimiter(TokenType.SEMICOLON, tokenSource, beginOffset, endOffset);
            case WHITESPACE : 
                return new WHITESPACE(TokenType.WHITESPACE, tokenSource, beginOffset, endOffset);
            case BYTE : 
                return new Literal(TokenType.BYTE, tokenSource, beginOffset, endOffset);
            case DOUBLE : 
                return new Literal(TokenType.DOUBLE, tokenSource, beginOffset, endOffset);
            case INTEGER : 
                return new Literal(TokenType.INTEGER, tokenSource, beginOffset, endOffset);
            case LONG : 
                return new Literal(TokenType.LONG, tokenSource, beginOffset, endOffset);
            case COMMA : 
                return new Delimiter(TokenType.COMMA, tokenSource, beginOffset, endOffset);
            case LONG_TYPE : 
                return new Delimiter(TokenType.LONG_TYPE, tokenSource, beginOffset, endOffset);
            case OPEN_BRACKET : 
                return new Delimiter(TokenType.OPEN_BRACKET, tokenSource, beginOffset, endOffset);
            case COLON : 
                return new Delimiter(TokenType.COLON, tokenSource, beginOffset, endOffset);
            case BOOLEAN : 
                return new Literal(TokenType.BOOLEAN, tokenSource, beginOffset, endOffset);
            case SHORT : 
                return new Literal(TokenType.SHORT, tokenSource, beginOffset, endOffset);
            case SHORT_TYPE : 
                return new Delimiter(TokenType.SHORT_TYPE, tokenSource, beginOffset, endOffset);
            case STRING : 
                return new Literal(TokenType.STRING, tokenSource, beginOffset, endOffset);
            case INVALID : 
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            default : 
                return new Token(type, tokenSource, beginOffset, endOffset);
        }
    }

    public String getLocation() {
        return getInputSource() + ":" + getBeginLine() + ":" + getBeginColumn();
    }

    public void setChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    public void addChild(Node n) {
        throw new UnsupportedOperationException();
    }

    public void addChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(int i) {
        throw new UnsupportedOperationException();
    }

    public final int indexOf(Node n) {
        return -1;
    }

    public Node getParent() {
        return parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public final int getChildCount() {
        return 0;
    }

    public final Node getChild(int i) {
        return null;
    }

    public final List<Node> children() {
        return Collections.emptyList();
    }

}


