/*
 * Decompiled with CFR 0.152.
 */
package org.allaymc.papi;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.allaymc.api.command.Command;
import org.allaymc.api.entity.interfaces.EntityPlayer;
import org.allaymc.api.plugin.Plugin;
import org.allaymc.api.registry.Registries;
import org.allaymc.api.server.Server;
import org.allaymc.papi.CharsReplacer;
import org.allaymc.papi.PAPICommand;
import org.allaymc.papi.PlaceholderProcessor;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderAPI
extends Plugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlaceholderAPI.class);
    protected static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    protected static PlaceholderAPI API;
    protected Map<String, PlaceholderProcessor> registry;

    public PlaceholderAPI() {
        API = this;
        this.registry = new HashMap<String, PlaceholderProcessor>();
        this.registerDefaultPlaceholders();
    }

    public void onLoad() {
        log.info("PlaceholderAPI loaded!");
    }

    public void onEnable() {
        Registries.COMMANDS.register((Command)new PAPICommand());
        log.info("PlaceholderAPI enabled!");
    }

    public void onDisable() {
        log.info("PlaceholderAPI disabled!");
    }

    public String setPlaceholders(EntityPlayer player, String text) {
        return CharsReplacer.apply(text, player, this.registry::get);
    }

    public boolean isRegistered(String identifier) {
        return this.registry.containsKey(identifier);
    }

    public @UnmodifiableView Set<String> getRegisteredIdentifiers() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }

    public Pattern getPlaceholderPattern() {
        return PLACEHOLDER_PATTERN;
    }

    public boolean containsPlaceholders(String text) {
        return text != null && PLACEHOLDER_PATTERN.matcher(text).find();
    }

    public boolean registerPlaceholder(Plugin plugin, String identifier, PlaceholderProcessor processor) {
        if (this.isRegistered((String)identifier)) {
            identifier = plugin.getPluginContainer().descriptor().getName() + ":" + (String)identifier;
        }
        if (this.isRegistered((String)identifier)) {
            log.warn("Plugin {} trying to register a duplicate placeholder: {}", (Object)plugin.getPluginContainer().descriptor().getName(), identifier);
            return false;
        }
        this.registry.put((String)identifier, processor);
        return true;
    }

    protected void registerDefaultPlaceholders() {
        this.registerPlaceholder(this, "x", (player, params) -> String.valueOf(Math.floor(player.getLocation().x())));
        this.registerPlaceholder(this, "y", (player, params) -> String.valueOf(Math.floor(player.getLocation().y())));
        this.registerPlaceholder(this, "z", (player, params) -> String.valueOf(Math.floor(player.getLocation().z())));
        this.registerPlaceholder(this, "player_name", (player, params) -> player.getOriginName());
        this.registerPlaceholder(this, "player_display_name", (player, params) -> player.getDisplayName());
        this.registerPlaceholder(this, "dimension", (player, params) -> player.getLocation().dimension().getDimensionInfo().toString());
        this.registerPlaceholder(this, "dimension_id", (player, params) -> String.valueOf(player.getLocation().dimension().getDimensionInfo().dimensionId()));
        this.registerPlaceholder(this, "ping", (player, params) -> String.valueOf(player.getPing()));
        this.registerPlaceholder(this, "mc_version", (player, params) -> player.getLoginData().getGameVersion());
        this.registerPlaceholder(this, "online", (player, params) -> String.valueOf(Server.getInstance().getPlayerManager().getPlayerCount()));
        this.registerPlaceholder(this, "max_online", (player, params) -> String.valueOf(Server.getInstance().getPlayerManager().getMaxPlayerCount()));
        this.registerPlaceholder(this, "address", (player, params) -> player.getSocketAddress().toString());
        this.registerPlaceholder(this, "runtime_id", (player, params) -> String.valueOf(player.getRuntimeId()));
        this.registerPlaceholder(this, "exp_level", (player, params) -> String.valueOf(player.getExperienceLevel()));
        this.registerPlaceholder(this, "exp_progress", (player, params) -> String.valueOf(player.getExperienceProgress()));
        this.registerPlaceholder(this, "game_mode", (player, params) -> player.getGameMode().toString().toLowerCase());
        this.registerPlaceholder(this, "xuid", (player, params) -> player.getLoginData().getXuid());
        this.registerPlaceholder(this, "uuid", (player, params) -> player.getLoginData().getUuid().toString());
        this.registerPlaceholder(this, "device_os", (player, params) -> player.getLoginData().getDeviceInfo().device().getName());
        this.registerPlaceholder(this, "locale", (player, params) -> player.getLoginData().getLangCode().toString());
        this.registerPlaceholder(this, "date", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)));
        this.registerPlaceholder(this, "time", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM)));
        this.registerPlaceholder(this, "datetime", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM)));
        this.registerPlaceholder(this, "year", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy")));
        this.registerPlaceholder(this, "month", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM")));
        this.registerPlaceholder(this, "day", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd")));
        this.registerPlaceholder(this, "hour", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH")));
        this.registerPlaceholder(this, "minute", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("mm")));
        this.registerPlaceholder(this, "second", (player, params) -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("ss")));
    }

    @Generated
    public static PlaceholderAPI getAPI() {
        return API;
    }
}

