/*
 * Decompiled with CFR 0.152.
 */
package org.allaymc.papi;

import java.util.function.Function;
import org.allaymc.api.entity.interfaces.EntityPlayer;
import org.allaymc.papi.PlaceholderProcessor;

public class CharsReplacer {
    private static final char HEAD = '{';
    private static final char TAIL = '}';

    public static String apply(String text, EntityPlayer player, Function<String, PlaceholderProcessor> lookup) {
        char[] chars = text.toCharArray();
        StringBuilder builder = new StringBuilder(text.length());
        StringBuilder identifier = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char l = chars[i];
            if (l != '{' || i + 1 >= chars.length) {
                builder.append(l);
                continue;
            }
            boolean identified = false;
            boolean invalid = true;
            boolean hadSpace = false;
            while (++i < chars.length) {
                char p = chars[i];
                if (p == ' ' && !identified) {
                    hadSpace = true;
                    break;
                }
                if (p == '}') {
                    invalid = false;
                    break;
                }
                if (p == '|' && !identified) {
                    identified = true;
                    continue;
                }
                if (identified) {
                    parameters.append(p);
                    continue;
                }
                identifier.append(p);
            }
            String identifierString = identifier.toString();
            String parametersString = parameters.toString();
            identifier.setLength(0);
            parameters.setLength(0);
            if (invalid) {
                builder.append('{').append(identifierString);
                if (identified) {
                    builder.append('_').append(parametersString);
                }
                if (!hadSpace) continue;
                builder.append(' ');
                continue;
            }
            PlaceholderProcessor placeholder = lookup.apply(identifierString);
            if (placeholder == null) {
                builder.append('{').append(identifierString);
                if (identified) {
                    builder.append('|');
                }
                builder.append(parametersString).append('}');
                continue;
            }
            String replacement = placeholder.process(player, parametersString);
            if (replacement == null) {
                builder.append('{').append(identifierString);
                if (identified) {
                    builder.append('|');
                }
                builder.append(parametersString).append('}');
                continue;
            }
            builder.append(replacement);
        }
        return builder.toString();
    }
}

