/*
 * Decompiled with CFR 0.152.
 */
package org.allaymc.updater.common.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.allaymc.updater.common.CompoundTagEditHelper;
import org.allaymc.updater.common.context.filter.HasKeyFilter;
import org.allaymc.updater.common.util.TagUtils;

public abstract class BaseUpdater<UPDATER extends BaseUpdater<UPDATER, BUILDER>, BUILDER extends Builder>
implements Comparable<BaseUpdater<UPDATER, BUILDER>> {
    protected final List<Predicate<CompoundTagEditHelper>> filters = new ArrayList<Predicate<CompoundTagEditHelper>>();
    protected final List<Consumer<CompoundTagEditHelper>> updaters = new ArrayList<Consumer<CompoundTagEditHelper>>();
    private final int version;

    public BaseUpdater(int version) {
        this.version = version;
    }

    public boolean update(Map<String, Object> tag) {
        CompoundTagEditHelper filterHelper = new CompoundTagEditHelper(tag);
        for (Predicate<CompoundTagEditHelper> filter : this.filters) {
            if (filter.test(filterHelper)) continue;
            return false;
        }
        CompoundTagEditHelper updaterHelper = new CompoundTagEditHelper(tag);
        this.updaters.forEach(updater -> updater.accept(updaterHelper));
        return true;
    }

    public abstract BUILDER builder();

    @Override
    public int compareTo(BaseUpdater<UPDATER, BUILDER> other) {
        return Integer.compare(this.version, other.version);
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    public abstract class Builder {
        public BUILDER match(String name, String match) {
            return this.match(name, match, false);
        }

        public BUILDER match(String name, String match, boolean regex) {
            Pattern pattern = regex ? Pattern.compile(match) : null;
            BaseUpdater.this.filters.add(helper -> {
                Map<String, Object> compoundTag = helper.getCompoundTag();
                if (compoundTag == null || !compoundTag.containsKey(name) || match.isEmpty()) {
                    return false;
                }
                String value = TagUtils.getTagValue(compoundTag.get(name));
                return regex ? pattern.matcher(value).matches() : match.equals(value);
            });
            return this.self();
        }

        public BUILDER edit(String name, Consumer<CompoundTagEditHelper> function) {
            BaseUpdater.this.filters.add(new HasKeyFilter(name));
            BaseUpdater.this.updaters.add(helper -> {
                helper.pushChild(name);
                function.accept((CompoundTagEditHelper)helper);
                helper.popChild();
            });
            return this.self();
        }

        public BUILDER renameId(String key, String oldId, String newId) {
            return ((Builder)this.match(key, oldId)).edit(key, helper -> helper.replaceWith(key, newId));
        }

        protected abstract BUILDER self();
    }
}

