/*
 * Decompiled with CFR 0.152.
 */
package org.allaymc.updater.common.context;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import lombok.Generated;
import org.allaymc.updater.common.context.BaseUpdater;
import org.allaymc.updater.common.util.TagUtils;
import org.cloudburstmc.nbt.NbtMap;

public abstract class UpdaterContext<UPDATER extends BaseUpdater<UPDATER, BUILDER>, BUILDER extends BaseUpdater.Builder> {
    private final List<UPDATER> updaters = new ArrayList<UPDATER>();
    private final IntFunction<UPDATER> updaterConstructor;
    protected int version;

    public BUILDER addUpdater() {
        return this.addUpdater(this.version);
    }

    public BUILDER addUpdater(int version) {
        BaseUpdater updater = (BaseUpdater)this.updaterConstructor.apply(version);
        this.updaters.add(updater);
        return updater.builder();
    }

    public NbtMap updateStates(NbtMap tag, int updateToVersion) {
        Map<String, Object> updated = this.updateStates0(tag, updateToVersion);
        return updated == null ? tag : (NbtMap)TagUtils.toImmutable(updated);
    }

    private Map<String, Object> updateStates0(NbtMap tag, int updateToVersion) {
        Map mutableTag = null;
        boolean updated = false;
        for (BaseUpdater updater : this.updaters) {
            if (updater.getVersion() > updateToVersion) continue;
            if (mutableTag == null) {
                mutableTag = (Map)TagUtils.toMutable(tag);
            }
            updated |= updater.update(mutableTag);
        }
        return mutableTag == null || !updated ? null : mutableTag;
    }

    private UPDATER getLatestUpdater() {
        return (UPDATER)(this.updaters.isEmpty() ? null : (BaseUpdater)this.updaters.getLast());
    }

    public int getLatestVersion() {
        UPDATER updater = this.getLatestUpdater();
        return updater == null ? 0 : ((BaseUpdater)updater).getVersion();
    }

    @Generated
    public void setVersion(int version) {
        this.version = version;
    }

    @Generated
    public UpdaterContext(IntFunction<UPDATER> updaterConstructor) {
        this.updaterConstructor = updaterConstructor;
    }
}

