/*
 * Decompiled with CFR 0.152.
 */
package org.allaymc.updater.common;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.Generated;

public class CompoundTagEditHelper {
    private final Deque<Map<String, Object>> parentTags = new ArrayDeque<Map<String, Object>>();
    private final Deque<String> tagNames = new ArrayDeque<String>();
    private Map<String, Object> rootTag;
    private Object currentTag;

    public CompoundTagEditHelper(Map<String, Object> tag) {
        this.rootTag = tag;
        this.currentTag = tag;
    }

    public Object getTag() {
        return this.currentTag;
    }

    public Map<String, Object> getCompoundTag() {
        if (this.currentTag instanceof Map) {
            return (Map)this.currentTag;
        }
        return null;
    }

    public Map<String, Object> getParent() {
        return this.parentTags.isEmpty() ? null : this.parentTags.peekLast();
    }

    public boolean canPopChild() {
        return !this.parentTags.isEmpty();
    }

    public void popChild() {
        if (!this.parentTags.isEmpty()) {
            this.currentTag = this.parentTags.pollLast();
            this.tagNames.pollLast();
        }
    }

    public void pushChild(String name) {
        Objects.requireNonNull(name, "name");
        if (!(this.currentTag instanceof Map)) {
            throw new IllegalStateException("Current tag is not a Compound type");
        }
        Map compoundTag = (Map)this.currentTag;
        if (!compoundTag.containsKey(name)) {
            throw new NoSuchElementException("Tag '" + name + "' does not exist");
        }
        this.parentTags.addLast(compoundTag);
        this.tagNames.addLast(name);
        this.currentTag = compoundTag.get(name);
    }

    public void replaceWith(String name, Object newTag) {
        if (this.parentTags.isEmpty()) {
            this.rootTag = new HashMap<String, Object>();
            this.rootTag.put(name, newTag);
            this.currentTag = this.rootTag.get(name);
            return;
        }
        Map<String, Object> parent = this.parentTags.getLast();
        if (parent != null) {
            parent.remove(this.tagNames.pollLast());
            parent.put(name, newTag);
            this.tagNames.offerLast(name);
        }
        this.currentTag = newTag;
    }

    @Generated
    public Map<String, Object> getRootTag() {
        return this.rootTag;
    }
}

