/*
 * Decompiled with CFR 0.152.
 */
package org.allaymc.updater.item;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.allaymc.updater.item.ItemStateUpdater;
import org.allaymc.updater.item.context.ItemUpdater;
import org.allaymc.updater.item.context.ItemUpdaterContext;

public class ItemStateUpdaterBase
extends ItemStateUpdater {
    public static final ItemStateUpdater INSTANCE = new ItemStateUpdaterBase();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final Map<Integer, String> LEGACY_ITEM_IDS = new HashMap<Integer, String>();

    private ItemStateUpdaterBase() {
        super(0, 0, 0);
    }

    public void registerUpdaters(ItemUpdaterContext context) {
        ((ItemUpdater.Builder)((ItemUpdater.Builder)context.addUpdater()).match("Id", "\\d+", true)).edit("Id", helper -> {
            int id = Integer.parseInt(helper.getTag().toString());
            helper.replaceWith("Name", (Object)LEGACY_ITEM_IDS.get(id));
        });
    }

    static {
        try (InputStream stream = ItemStateUpdaterBase.class.getClassLoader().getResourceAsStream("legacy_item_ids_map.json");){
            Map map = (Map)JSON_MAPPER.readValue(stream, (TypeReference)new TypeReference<Map<String, Integer>>(){});
            map.forEach((key, value) -> LEGACY_ITEM_IDS.put((Integer)value, (String)key));
        }
        catch (IOException e) {
            throw new AssertionError("Error loading legacy item ids map", e);
        }
    }
}

