/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.datastore;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.allenai.common.Logging;
import org.allenai.common.Logging$logger$;
import org.allenai.common.Resource$;
import org.allenai.datastore.Datastore$;
import org.allenai.datastore.Datastore$AlreadyExistsException$;
import org.allenai.datastore.Datastore$DoesNotExistException$;
import org.allenai.datastore.Datastore$Locator$;
import org.allenai.datastore.TempCleanup$;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r-h\u0001B\u0001\u0003\u0001%\u0011\u0011\u0002R1uCN$xN]3\u000b\u0005\r!\u0011!\u00033bi\u0006\u001cHo\u001c:f\u0015\t)a!A\u0004bY2,g.Y5\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0007G>lWn\u001c8\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005!a.Y7f+\u0005I\u0002C\u0001\u000e\u001e\u001d\tY1$\u0003\u0002\u001d\u0019\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\taB\u0002\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0015q\u0017-\\3!\u0011!\u0019\u0003A!b\u0001\n\u0003!\u0013AA:4+\u0005)\u0003C\u0001\u0014/\u001b\u00059#BA\u0012)\u0015\tI#&\u0001\u0005tKJ4\u0018nY3t\u0015\tYC&A\u0005b[\u0006TxN\\1xg*\tQ&A\u0002d_6L!aL\u0014\u0003\u001d\u0005k\u0017M_8o'N\u001aE.[3oi\"A\u0011\u0007\u0001B\u0001B\u0003%Q%A\u0002tg\u0001BQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtDcA\u001b8qA\u0011a\u0007A\u0007\u0002\u0005!)qC\ra\u00013!)1E\ra\u0001K!9!\b\u0001b\u0001\n\u0013Y\u0014\u0001\u00042bg\u0016\u001c\u0015m\u00195f\t&\u0014X#\u0001\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015\u0001\u00024jY\u0016T!!\u0011\"\u0002\u00079LwNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$\u0001\u0002)bi\"Daa\u0012\u0001!\u0002\u0013a\u0014!\u00042bg\u0016\u001c\u0015m\u00195f\t&\u0014\b\u0005C\u0004J\u0001\t\u0007I\u0011B\u001e\u0002\u0011\r\f7\r[3ESJDaa\u0013\u0001!\u0002\u0013a\u0014!C2bG\",G)\u001b:!\u0011\u001di\u0005A1A\u0005\nm\nq\u0001^3na\u0012K'\u000f\u0003\u0004P\u0001\u0001\u0006I\u0001P\u0001\ti\u0016l\u0007\u000fR5sA!)\u0011\u000b\u0001C\u00011\u0005Q!-^2lKRt\u0015-\\3\u0007\tM\u0003\u0001\t\u0016\u0002\b\u0019>\u001c\u0017\r^8s'\u0011\u0011&\"\u0016-\u0011\u0005-1\u0016BA,\r\u0005\u001d\u0001&o\u001c3vGR\u0004\"aC-\n\u0005ic!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003/S\u0005+\u0007I\u0011\u0001\r\u0002\u000b\u001d\u0014x.\u001e9\t\u0011y\u0013&\u0011#Q\u0001\ne\taa\u001a:pkB\u0004\u0003\u0002C\fS\u0005+\u0007I\u0011\u0001\r\t\u0011\u0005\u0012&\u0011#Q\u0001\neA\u0001B\u0019*\u0003\u0016\u0004%\taY\u0001\bm\u0016\u00148/[8o+\u0005!\u0007CA\u0006f\u0013\t1GBA\u0002J]RD\u0001\u0002\u001b*\u0003\u0012\u0003\u0006I\u0001Z\u0001\tm\u0016\u00148/[8oA!A!N\u0015BK\u0002\u0013\u00051.A\u0005eSJ,7\r^8ssV\tA\u000e\u0005\u0002\f[&\u0011a\u000e\u0004\u0002\b\u0005>|G.Z1o\u0011!\u0001(K!E!\u0002\u0013a\u0017A\u00033je\u0016\u001cGo\u001c:zA!)1G\u0015C\u0001eR)1/\u001e<xqB\u0011AOU\u0007\u0002\u0001!)A,\u001da\u00013!)q#\u001da\u00013!)!-\u001da\u0001I\")!.\u001da\u0001Y\"9!PUA\u0001\n\u0003Y\u0018\u0001B2paf$Ra\u001d?~}~Dq\u0001X=\u0011\u0002\u0003\u0007\u0011\u0004C\u0004\u0018sB\u0005\t\u0019A\r\t\u000f\tL\b\u0013!a\u0001I\"9!.\u001fI\u0001\u0002\u0004a\u0007\"CA\u0002%F\u0005I\u0011AA\u0003\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0002+\u0007e\tIa\u000b\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C;oG\",7m[3e\u0015\r\t)\u0002D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tiBUI\u0001\n\u0003\t)!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u0005\"+%A\u0005\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003KQ3\u0001ZA\u0005\u0011%\tICUI\u0001\n\u0003\tY#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u00055\"f\u00017\u0002\n!I\u0011\u0011\u0007*\u0002\u0002\u0013\u0005\u00131G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\")\u0001\u0003mC:<\u0017b\u0001\u0010\u0002:!A\u0011\u0011\t*\u0002\u0002\u0013\u00051-\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002FI\u000b\t\u0011\"\u0001\u0002H\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA%\u0003\u001f\u00022aCA&\u0013\r\ti\u0005\u0004\u0002\u0004\u0003:L\b\"CA)\u0003\u0007\n\t\u00111\u0001e\u0003\rAH%\r\u0005\n\u0003+\u0012\u0016\u0011!C!\u0003/\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0002b!a\u0017\u0002b\u0005%SBAA/\u0015\r\ty\u0006D\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u0003;\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003O\u0012\u0016\u0011!C\u0001\u0003S\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004Y\u0006-\u0004BCA)\u0003K\n\t\u00111\u0001\u0002J!I\u0011q\u000e*\u0002\u0002\u0013\u0005\u0013\u0011O\u0001\tQ\u0006\u001c\bnQ8eKR\tA\rC\u0005\u0002vI\u000b\t\u0011\"\u0011\u0002x\u0005AAo\\*ue&tw\r\u0006\u0002\u00026!I\u00111\u0010*\u0002\u0002\u0013\u0005\u0013QP\u0001\u0007KF,\u0018\r\\:\u0015\u00071\fy\b\u0003\u0006\u0002R\u0005e\u0014\u0011!a\u0001\u0003\u0013B1\"a!S\u0005\u0003\u0005\t\u0011\"\u0001\u00011\u0005\u0001tN]4%C2dWM\\1jI\u0011\fG/Y:u_J,G\u0005R1uCN$xN]3%I9\fW.Z,ji\"4VM]:j_:D1\"a\"S\u0005\u0003\u0005\t\u0011\"\u0001\u00011\u00051sN]4%C2dWM\\1jI\u0011\fG/Y:u_J,G\u0005R1uCN$xN]3%IM\u001c4.Z=\t\u0017\u0005-%K!A\u0001\u0002\u0013\u0005\u0001\u0001G\u0001/_J<G%\u00197mK:\f\u0017\u000e\n3bi\u0006\u001cHo\u001c:fI\u0011\u000bG/Y:u_J,G\u0005\n7pG\u0006d7)Y2iK.+\u0017\u0010C\u0006\u0002\u0010J\u0013\t\u0011!A\u0005\u0002\u0001A\u0012AM8sO\u0012\nG\u000e\\3oC&$C-\u0019;bgR|'/\u001a\u0013ECR\f7\u000f^8sK\u0012\"c\r\\1u\u0019>\u001c\u0017\r\\\"bG\",7*Z=\t\u0017\u0005M%K!A\u0001\u0002\u0013\u0005\u0001aO\u00010_J<G%\u00197mK:\f\u0017\u000e\n3bi\u0006\u001cHo\u001c:fI\u0011\u000bG/Y:u_J,G\u0005\n7pG\u0006d7)Y2iKB\u000bG\u000f\u001b\u0005\f\u0003/\u0013&\u0011!A\u0001\n\u0003\u00011(A\u0017pe\u001e$\u0013\r\u001c7f]\u0006LG\u0005Z1uCN$xN]3%\t\u0006$\u0018m\u001d;pe\u0016$C\u0005\\8dW\u001aLG.\u001a)bi\"<q!a'\u0001\u0011\u0003\ti*A\u0004M_\u000e\fGo\u001c:\u0011\u0007Q\fyJ\u0002\u0004T\u0001!\u0005\u0011\u0011U\n\u0005\u0003?S\u0001\fC\u00044\u0003?#\t!!*\u0015\u0005\u0005u\u0005\"CAU\u0003?#\t\u0001AAV\u0003\u001d1'o\\7LKf$2a]AW\u0011\u001d\ty+a*A\u0002e\t1a[3z\u0011)\t\u0019,a(\u0002\u0002\u0013\u0005\u0015QW\u0001\u0006CB\u0004H.\u001f\u000b\ng\u0006]\u0016\u0011XA^\u0003{Ca\u0001XAY\u0001\u0004I\u0002BB\f\u00022\u0002\u0007\u0011\u0004\u0003\u0004c\u0003c\u0003\r\u0001\u001a\u0005\u0007U\u0006E\u0006\u0019\u00017\t\u0015\u0005\u0005\u0017qTA\u0001\n\u0003\u000b\u0019-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u0017\u0011\u001b\t\u0006\u0017\u0005\u001d\u00171Z\u0005\u0004\u0003\u0013d!AB(qi&|g\u000eE\u0004\f\u0003\u001bL\u0012\u0004\u001a7\n\u0007\u0005=GB\u0001\u0004UkBdW\r\u000e\u0005\n\u0003'\fy,!AA\u0002M\f1\u0001\u001f\u00131\u0011)\t9.a(\u0002\u0002\u0013%\u0011\u0011\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\\B!\u0011qGAo\u0013\u0011\ty.!\u000f\u0003\r=\u0013'.Z2u\r\u0019\t\u0019\u000f\u0001\u0001\u0002f\n)Bi\\3t\u001d>$X\t_5ti\u0016C8-\u001a9uS>t7\u0003BAq\u0003O\u0004B!!;\u0002z:!\u00111^A{\u001d\u0011\ti/a=\u000e\u0005\u0005=(bAAy\u0011\u00051AH]8pizJ\u0011!D\u0005\u0004\u0003od\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003w\fiPA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u0011q\u001f\u0007\t\u0015\t\u0005\u0011\u0011\u001dB\u0001B\u0003%1/A\u0004m_\u000e\fGo\u001c:\t\u0017\t\u0015\u0011\u0011\u001dB\u0001B\u0003%!qA\u0001\u0006G\u0006,8/\u001a\t\u0005\u0003S\u0014I!\u0003\u0003\u0003\f\u0005u(!\u0003+ie><\u0018M\u00197f\u0011\u001d\u0019\u0014\u0011\u001dC\u0001\u0005\u001f!bA!\u0005\u0003\u0014\tU\u0001c\u0001;\u0002b\"9!\u0011\u0001B\u0007\u0001\u0004\u0019\bB\u0003B\u0003\u0005\u001b\u0001\n\u00111\u0001\u0003\b\u001dI!\u0011\u0004\u0001\u0002\u0002#\u0005!1D\u0001\u0016\t>,7OT8u\u000bbL7\u000f^#yG\u0016\u0004H/[8o!\r!(Q\u0004\u0004\n\u0003G\u0004\u0011\u0011!E\u0001\u0005?\u0019BA!\b\u000b1\"91G!\b\u0005\u0002\t\rBC\u0001B\u000e\u0011)\u00119C!\b\u0012\u0002\u0013\u0005!\u0011F\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-\"\u0006\u0002B\u0004\u0003\u0013A!\"a6\u0003\u001e\u0005\u0005I\u0011BAm\r\u0019\u0011\t\u0004\u0001\u0001\u00034\t1\u0012\t\u001c:fC\u0012LX\t_5tiN,\u0005pY3qi&|gn\u0005\u0003\u00030\u0005\u001d\bB\u0003B\u0001\u0005_\u0011\t\u0011)A\u0005g\"Y!Q\u0001B\u0018\u0005\u0003\u0005\u000b\u0011\u0002B\u0004\u0011\u001d\u0019$q\u0006C\u0001\u0005w!bA!\u0010\u0003@\t\u0005\u0003c\u0001;\u00030!9!\u0011\u0001B\u001d\u0001\u0004\u0019\bB\u0003B\u0003\u0005s\u0001\n\u00111\u0001\u0003\b\u001dI!Q\t\u0001\u0002\u0002#\u0005!qI\u0001\u0017\u00032\u0014X-\u00193z\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]B\u0019AO!\u0013\u0007\u0013\tE\u0002!!A\t\u0002\t-3\u0003\u0002B%\u0015aCqa\rB%\t\u0003\u0011y\u0005\u0006\u0002\u0003H!Q!q\u0005B%#\u0003%\tA!\u000b\t\u0015\u0005]'\u0011JA\u0001\n\u0013\tI\u000eC\u0004\u0003X\u0001!IA!\u0017\u0002\u0017\u001d,GoU\u001aPE*,7\r\u001e\u000b\u0005\u00057\u00129\u0007\u0005\u0003\u0003^\t\rTB\u0001B0\u0015\r\u0011\tGQ\u0001\u0003S>LAA!\u001a\u0003`\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\tyK!\u0016A\u0002eAqAa\u001b\u0001\t\u0013\u0011i'A\bxC&$hi\u001c:M_\u000e\\g-\u001b7f)\u0011\u0011yG!\u001e\u0011\u0007-\u0011\t(C\u0002\u0003t1\u0011A!\u00168ji\"9!q\u000fB5\u0001\u0004a\u0014\u0001\u00037pG.4\u0017\u000e\\3\t\u000f\tm\u0004\u0001\"\u0003\u0003~\u0005iAO]=De\u0016\fG/\u001a$jY\u0016$2\u0001\u001cB@\u0011\u0019y$\u0011\u0010a\u0001y!9!1\u0011\u0001\u0005\n\t\u0015\u0015a\u00034pe6\fGOQ=uKN$2!\u0007BD\u0011!\u0011II!!A\u0002\t-\u0015!\u00022zi\u0016\u001c\bcA\u0006\u0003\u000e&\u0019!q\u0012\u0007\u0003\t1{gn\u001a\u0005\b\u0005'\u0003A\u0011\u0002BK\u0003-\u0019w\u000e]=TiJ,\u0017-\\:\u0015\u0015\t=$q\u0013BT\u0005c\u0013)\f\u0003\u0005\u0003\u001a\nE\u0005\u0019\u0001BN\u0003\tI7\r\u0005\u0003\u0003\u001e\n\rVB\u0001BP\u0015\r\u0011\t\u000bQ\u0001\tG\"\fgN\\3mg&!!Q\u0015BP\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0011!\u0011IK!%A\u0002\t-\u0016AA8d!\u0011\u0011iJ!,\n\t\t=&q\u0014\u0002\u0014/JLG/\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\b\u0005g\u0013\t\n1\u0001\u001a\u0003!1\u0017\u000e\\3oC6,\u0007\"\u0003B\\\u0005#\u0003\n\u00111\u0001m\u0003\u0019\u0019\u0018\u000e\\3oi\"9!1\u0018\u0001\u0005\u0002\tu\u0016\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0015\u000fq\u0012yL!1\u0003D\"1AL!/A\u0002eAaa\u0006B]\u0001\u0004I\u0002B\u00022\u0003:\u0002\u0007A\rC\u0004\u0003H\u0002!\tA!3\u0002\u001b\u0011L'/Z2u_JL\b+\u0019;i)\u001da$1\u001aBg\u0005\u001fDa\u0001\u0018Bc\u0001\u0004I\u0002BB\f\u0003F\u0002\u0007\u0011\u0004\u0003\u0004c\u0005\u000b\u0004\r\u0001\u001a\u0005\b\u0005'\u0004A\u0011\u0001Bk\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0007q\u00129\u000eC\u0004\u0003\u0002\tE\u0007\u0019A:\t\u000f\tm\u0007\u0001\"\u0001\u0003^\u0006Y\u0001/\u001e2mSNDg)\u001b7f)1\u0011yGa8\u0003b\n\r(Q\u001dBt\u0011\u0019y$\u0011\u001ca\u00013!1AL!7A\u0002eAaa\u0006Bm\u0001\u0004I\u0002B\u00022\u0003Z\u0002\u0007A\rC\u0004\u0003j\ne\u0007\u0019\u00017\u0002\u0013=4XM]<sSR,\u0007b\u0002Bn\u0001\u0011\u0005!Q\u001e\u000b\r\u0005_\u0012yO!=\u0003t\nU(q\u001f\u0005\u0007\u007f\t-\b\u0019\u0001\u001f\t\rq\u0013Y\u000f1\u0001\u001a\u0011\u00199\"1\u001ea\u00013!1!Ma;A\u0002\u0011DqA!;\u0003l\u0002\u0007A\u000eC\u0004\u0003|\u0002!\tA!@\u0002!A,(\r\\5tQ\u0012K'/Z2u_JLH\u0003\u0004B8\u0005\u007f\u001c\taa\u0001\u0004\u0006\r\u001d\u0001b\u0002Bj\u0005s\u0004\r!\u0007\u0005\u00079\ne\b\u0019A\r\t\r]\u0011I\u00101\u0001\u001a\u0011\u0019\u0011'\u0011 a\u0001I\"9!\u0011\u001eB}\u0001\u0004a\u0007b\u0002B~\u0001\u0011\u000511\u0002\u000b\r\u0005_\u001aiaa\u0004\u0004\u0012\rM1Q\u0003\u0005\b\u0005'\u001cI\u00011\u0001=\u0011\u0019a6\u0011\u0002a\u00013!1qc!\u0003A\u0002eAaAYB\u0005\u0001\u0004!\u0007b\u0002Bu\u0007\u0013\u0001\r\u0001\u001c\u0005\b\u00073\u0001A\u0011AB\u000e\u0003\u001d\u0001XO\u00197jg\"$\u0002Ba\u001c\u0004\u001e\r}1\u0011\u0005\u0005\b\u0005'\u001c9\u00021\u0001=\u0011\u001d\u0011\taa\u0006A\u0002MDqA!;\u0004\u0018\u0001\u0007A\u000eC\u0004\u0004&\u0001!\taa\n\u0002\u0015\u0019LG.Z#ySN$8\u000fF\u0004m\u0007S\u0019Yc!\f\t\rq\u001b\u0019\u00031\u0001\u001a\u0011\u0019921\u0005a\u00013!1!ma\tA\u0002\u0011Dqa!\r\u0001\t\u0003\u0019\u0019$A\beSJ,7\r^8ss\u0016C\u0018n\u001d;t)\u001da7QGB\u001c\u0007sAa\u0001XB\u0018\u0001\u0004I\u0002BB\f\u00040\u0001\u0007\u0011\u0004\u0003\u0004c\u0007_\u0001\r\u0001\u001a\u0005\b\u0007{\u0001A\u0011AB \u0003\u0019)\u00070[:ugR\u0019An!\u0011\t\u000f\t\u000511\ba\u0001g\"91Q\t\u0001\u0005\n\r\u001d\u0013AD4fi\u0006cG\u000eT5ti&twm\u001d\u000b\u0005\u0007\u0013\u001aY\u0006\u0005\u0004\u0002j\u000e-3qJ\u0005\u0005\u0007\u001b\niPA\u0002TKF\u0004Ba!\u0015\u0004X5\u001111\u000b\u0006\u0004\u0007+:\u0013!B7pI\u0016d\u0017\u0002BB-\u0007'\u0012Qb\u00142kK\u000e$H*[:uS:<\u0007\u0002CB/\u0007\u0007\u0002\raa\u0018\u0002\u000fI,\u0017/^3tiB!1\u0011KB1\u0013\u0011\u0019\u0019ga\u0015\u0003%1K7\u000f^(cU\u0016\u001cGo\u001d*fcV,7\u000f\u001e\u0005\b\u0007O\u0002A\u0011AB5\u0003)a\u0017n\u001d;He>,\bo]\u000b\u0003\u0007W\u0002BAGB73%\u00191qN\u0010\u0003\u0007M+G\u000fC\u0004\u0004t\u0001!\ta!\u001e\u0002#1L7\u000f^$s_V\u00048i\u001c8uK:$8\u000f\u0006\u0003\u0004x\re\u0004\u0003\u0002\u000e\u0004nMDa\u0001XB9\u0001\u0004I\u0002bBB?\u0001\u0011\u00051qP\u0001\bM&dW-\u0016:m)!\u0019\ti!$\u0004\u0010\u000eE\u0005\u0003BBB\u0007\u0013k!a!\"\u000b\u0007\r\u001d%)A\u0002oKRLAaa#\u0004\u0006\n\u0019QK\u0015'\t\rq\u001bY\b1\u0001\u001a\u0011\u0019921\u0010a\u00013!1!ma\u001fA\u0002\u0011Dqa!&\u0001\t\u0003\u00199*\u0001\u0007eSJ,7\r^8ssV\u0013H\u000e\u0006\u0005\u0004\u0002\u000ee51TBO\u0011\u0019a61\u0013a\u00013!1qca%A\u0002eAaAYBJ\u0001\u0004!\u0007bBBQ\u0001\u0011\u000511U\u0001\u0004kJdG\u0003BBA\u0007KCqA!\u0001\u0004 \u0002\u00071\u000fC\u0004\u0004*\u0002!\taa+\u0002\u0013]L\u0007/Z\"bG\",GC\u0001B8\u0011\u001d\u0019y\u000b\u0001C\u0001\u0007W\u000bqc\u0019:fCR,')^2lKRLeMT8u\u000bbL7\u000f^:\t\u0013\rM\u0006!%A\u0005\n\u0005-\u0012!F2paf\u001cFO]3b[N$C-\u001a4bk2$H\u0005N\u0004\b\u0007o\u0013\u0001\u0012AB]\u0003%!\u0015\r^1ti>\u0014X\rE\u00027\u0007w3a!\u0001\u0002\t\u0002\ru6cAB^k!91ga/\u0005\u0002\r\u0005GCAB]\u0011%\u0019)ma/C\u0002\u0013\u0005\u0001$A\u0006eK\u001a\fW\u000f\u001c;OC6,\u0007\u0002CBe\u0007w\u0003\u000b\u0011B\r\u0002\u0019\u0011,g-Y;mi:\u000bW.\u001a\u0011\t\u0011\u0005M61\u0018C\u0001\u0007\u001b$\u0012!\u000e\u0005\t\u0003g\u001bY\f\"\u0001\u0004RR\u0019Qga5\t\r]\u0019y\r1\u0001\u001a\u0011!\t\u0019la/\u0005\u0002\r]G#B\u001b\u0004Z\u000eu\u0007bBBn\u0007+\u0004\r!G\u0001\nC\u000e\u001cWm]:LKfDqaa8\u0004V\u0002\u0007\u0011$A\btK\u000e\u0014X\r^!dG\u0016\u001c8oS3z\u0011!\t\u0019la/\u0005\u0002\r\rHcB\u001b\u0004f\u000e\u001d8\u0011\u001e\u0005\u0007/\r\u0005\b\u0019A\r\t\u000f\rm7\u0011\u001da\u00013!91q\\Bq\u0001\u0004I\u0002")
public class Datastore
implements Logging {
    private final String name;
    private final AmazonS3Client s3;
    private final Path baseCacheDir;
    private final Path org$allenai$datastore$Datastore$$cacheDir;
    private final Path tempDir;
    private volatile Datastore$Locator$ Locator$module;
    private volatile Datastore$DoesNotExistException$ DoesNotExistException$module;
    private volatile Datastore$AlreadyExistsException$ AlreadyExistsException$module;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;

    public static Datastore apply(String string, String string2, String string3) {
        return Datastore$.MODULE$.apply(string, string2, string3);
    }

    public static Datastore apply(String string, String string2) {
        return Datastore$.MODULE$.apply(string, string2);
    }

    public static Datastore apply(String string) {
        return Datastore$.MODULE$.apply(string);
    }

    public static Datastore apply() {
        return Datastore$.MODULE$.apply();
    }

    public static String defaultName() {
        return Datastore$.MODULE$.defaultName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$Locator$ Locator$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.Locator$module != null) return this.Locator$module;
            this.Locator$module = new Datastore$Locator$(this);
            return this.Locator$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$DoesNotExistException$ DoesNotExistException$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.DoesNotExistException$module != null) return this.DoesNotExistException$module;
            this.DoesNotExistException$module = new Datastore$DoesNotExistException$(this);
            return this.DoesNotExistException$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$AlreadyExistsException$ AlreadyExistsException$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.AlreadyExistsException$module != null) return this.AlreadyExistsException$module;
            this.AlreadyExistsException$module = new Datastore$AlreadyExistsException$(this);
            return this.AlreadyExistsException$module;
        }
    }

    public Logger internalLogger() {
        return this.internalLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging$logger$ logger$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.logger$module != null) return this.logger$module;
            this.logger$module = new Logging$logger$((Logging)this);
            return this.logger$module;
        }
    }

    public Logging$logger$ logger() {
        return this.logger$module == null ? this.logger$lzycompute() : this.logger$module;
    }

    public void org$allenai$common$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public String name() {
        return this.name;
    }

    public AmazonS3Client s3() {
        return this.s3;
    }

    private Path baseCacheDir() {
        return this.baseCacheDir;
    }

    public Path org$allenai$datastore$Datastore$$cacheDir() {
        return this.org$allenai$datastore$Datastore$$cacheDir;
    }

    private Path tempDir() {
        return this.tempDir;
    }

    public String bucketName() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".store.dev.allenai.org"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}));
    }

    public Datastore$Locator$ Locator() {
        return this.Locator$module == null ? this.Locator$lzycompute() : this.Locator$module;
    }

    public Datastore$DoesNotExistException$ DoesNotExistException() {
        return this.DoesNotExistException$module == null ? this.DoesNotExistException$lzycompute() : this.DoesNotExistException$module;
    }

    public Datastore$AlreadyExistsException$ AlreadyExistsException() {
        return this.AlreadyExistsException$module == null ? this.AlreadyExistsException$lzycompute() : this.AlreadyExistsException$module;
    }

    private InputStream getS3Object(String key) {
        return this.s3().getObject(this.bucketName(), key).getObjectContent();
    }

    private void waitForLockfile(Path lockfile) {
        long start = System.currentTimeMillis();
        while (Files.exists(lockfile, new LinkOption[0])) {
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for lockfile at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lockfile}));
            if (System.currentTimeMillis() - start > 60000L) {
                this.logger().warn((Function0)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            } else {
                this.logger().info((Function0)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            }
            int oneSecond = 1000;
            Thread.sleep(oneSecond);
        }
    }

    private boolean tryCreateFile(Path file) {
        boolean bl;
        try {
            Files.createFile(file, new FileAttribute[0]);
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    public String org$allenai$datastore$Datastore$$formatBytes(long bytes) {
        double orderOfMagnitude = Math.floor(Math.log(Math.max(1L, bytes)) / Math.log(1024.0));
        double bytesInUnit = (double)bytes / Math.pow(1024.0, orderOfMagnitude);
        String formattedNumber = bytesInUnit < (double)10 ? new StringOps(Predef$.MODULE$.augmentString("%.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})) : (bytesInUnit < (double)100 ? new StringOps(Predef$.MODULE$.augmentString("%.1f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})) : new StringOps(Predef$.MODULE$.augmentString("%.0f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})));
        String[] units = (String[])((Object[])new String[]{"B", "KB", "MB", "GB", "TB", "PB"});
        String unit = units[Math.min((int)orderOfMagnitude, units.length)];
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedNumber, unit}));
    }

    public void org$allenai$datastore$Datastore$$copyStreams(ReadableByteChannel ic, WritableByteChannel oc, String filename, boolean silent) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
        int loggingDelay = 1000;
        long startTime = System.currentTimeMillis();
        LongRef lastLogMessage = LongRef.create((long)startTime);
        LongRef bytesCopied = LongRef.create((long)0L);
        while (ic.read(buffer) >= 0) {
            bytesCopied.elem += (long)buffer.position();
            buffer.flip();
            oc.write(buffer);
            buffer.compact();
            bytesCopied.elem -= (long)buffer.position();
            if (!this.shouldLog$1(silent, loggingDelay, lastLogMessage)) continue;
            this.logger().info((Function0)new Serializable(this, filename, bytesCopied){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Datastore $outer;
                private final String filename$1;
                private final LongRef bytesCopied$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading ", " from the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filename$1, this.$outer.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes read."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$formatBytes(this.bytesCopied$1.elem)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filename$1 = filename$1;
                    this.bytesCopied$1 = bytesCopied$1;
                }
            });
            lastLogMessage.elem = System.currentTimeMillis();
        }
        buffer.flip();
        bytesCopied.elem += (long)buffer.remaining();
        while (buffer.hasRemaining()) {
            oc.write(buffer);
        }
        if (!silent && System.currentTimeMillis() - startTime >= (long)loggingDelay) {
            this.logger().info((Function0)new Serializable(this, filename, bytesCopied){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Datastore $outer;
                private final String filename$1;
                private final LongRef bytesCopied$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloaded ", " from the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filename$1, this.$outer.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes read."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$formatBytes(this.bytesCopied$1.elem)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filename$1 = filename$1;
                    this.bytesCopied$1 = bytesCopied$1;
                }
            });
        }
    }

    public boolean org$allenai$datastore$Datastore$$copyStreams$default$4() {
        return false;
    }

    public Path filePath(String group, String name, int version) {
        return this.path(new Locator(this, group, name, version, false));
    }

    public Path directoryPath(String group, String name, int version) {
        return this.path(new Locator(this, group, name, version, true));
    }

    /*
     * Loose catch block
     */
    public Path path(Locator locator) {
        Path path2;
        Files.createDirectories(this.org$allenai$datastore$Datastore$$cacheDir(), new FileAttribute[0]);
        Files.createDirectories(locator.org$allenai$datastore$Datastore$$lockfilePath().getParent(), new FileAttribute[0]);
        this.waitForLockfile(locator.org$allenai$datastore$Datastore$$lockfilePath());
        if (locator.directory() && Files.isDirectory(locator.org$allenai$datastore$Datastore$$localCachePath(), new LinkOption[0]) || !locator.directory() && Files.isRegularFile(locator.org$allenai$datastore$Datastore$$localCachePath(), new LinkOption[0])) {
            path2 = locator.org$allenai$datastore$Datastore$$localCachePath();
        } else {
            boolean created = this.tryCreateFile(locator.org$allenai$datastore$Datastore$$lockfilePath());
            if (created) {
                TempCleanup$.MODULE$.remember(locator.org$allenai$datastore$Datastore$$lockfilePath());
                Path tempFile = Files.createTempFile(this.tempDir(), new StringBuilder().append((Object)"ai2-datastore-").append((Object)locator.org$allenai$datastore$Datastore$$flatLocalCacheKey()).toString(), ".tmp", new FileAttribute[0]);
                TempCleanup$.MODULE$.remember(tempFile);
                Resource$.MODULE$.using2((Object)Channels.newChannel(this.getS3Object(locator.org$allenai$datastore$Datastore$$s3key())), (Object)Files.newByteChannel(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), (Function2)new Serializable(this, locator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Datastore $outer;
                    private final Locator locator$1;

                    public final void apply(ReadableByteChannel x0$1, SeekableByteChannel x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            ReadableByteChannel input = (ReadableByteChannel)tuple2._1();
                            SeekableByteChannel output = (SeekableByteChannel)tuple2._2();
                            this.$outer.org$allenai$datastore$Datastore$$copyStreams(input, output, this.locator$1.org$allenai$datastore$Datastore$$s3key(), this.$outer.org$allenai$datastore$Datastore$$copyStreams$default$4());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.locator$1 = locator$1;
                    }
                });
                if (locator.directory()) {
                    Path tempZipDir = Files.createTempDirectory(this.tempDir(), new StringBuilder().append((Object)"ai2-datastore-").append((Object)locator.org$allenai$datastore$Datastore$$flatLocalCacheKey()).toString(), new FileAttribute[0]);
                    TempCleanup$.MODULE$.remember(tempZipDir);
                    Resource$.MODULE$.using((Object)new ZipFile(tempFile.toFile()), (Function1)new Serializable(this, locator, tempZipDir){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Datastore $outer;
                        public final Locator locator$1;
                        private final Path tempZipDir$1;

                        public final void apply(ZipFile zipFile) {
                            Enumeration<? extends ZipEntry> entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                Object object;
                                ZipEntry entry = entries.nextElement();
                                String string = entry.getName();
                                String string2 = "/";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    object = BoxedUnit.UNIT;
                                    continue;
                                }
                                Path pathForEntry = this.tempZipDir$1.resolve(entry.getName());
                                if (entry.isDirectory()) {
                                    object = Files.createDirectories(pathForEntry, new FileAttribute[0]);
                                    continue;
                                }
                                Files.createDirectories(pathForEntry.getParent(), new FileAttribute[0]);
                                object = Resource$.MODULE$.using2((Object)Channels.newChannel(zipFile.getInputStream(entry)), (Object)Files.newByteChannel(pathForEntry, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$path$2 $outer;

                                    public final void apply(ReadableByteChannel x0$2, SeekableByteChannel x1$2) {
                                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                                        if (tuple2 != null) {
                                            ReadableByteChannel input = (ReadableByteChannel)tuple2._1();
                                            SeekableByteChannel output = (SeekableByteChannel)tuple2._2();
                                            this.$outer.org$allenai$datastore$Datastore$$anonfun$$$outer().org$allenai$datastore$Datastore$$copyStreams(input, output, this.$outer.locator$1.org$allenai$datastore$Datastore$$s3key(), true);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                        }

                        public /* synthetic */ Datastore org$allenai$datastore$Datastore$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.locator$1 = locator$1;
                            this.tempZipDir$1 = tempZipDir$1;
                        }
                    });
                    Files.delete(tempFile);
                    TempCleanup$.MODULE$.forget(tempFile);
                    Files.move(tempZipDir, locator.org$allenai$datastore$Datastore$$localCachePath(), new CopyOption[0]);
                    TempCleanup$.MODULE$.forget(tempZipDir);
                } else {
                    Files.createDirectories(locator.org$allenai$datastore$Datastore$$localCachePath().getParent(), new FileAttribute[0]);
                    Files.move(tempFile, locator.org$allenai$datastore$Datastore$$localCachePath(), new CopyOption[0]);
                    TempCleanup$.MODULE$.forget(tempFile);
                }
                path2 = locator.org$allenai$datastore$Datastore$$localCachePath();
            } else {
                path2 = this.path(locator);
            }
        }
        return path2;
        {
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AmazonS3Exception) {
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)throwable2;
                    String string = amazonS3Exception.getErrorCode();
                    String string2 = "NoSuchKey";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new DoesNotExistException(locator, (Throwable)amazonS3Exception);
                    }
                }
                throw throwable;
            }
        }
        finally {
            Files.delete(locator.org$allenai$datastore$Datastore$$lockfilePath());
            TempCleanup$.MODULE$.forget(locator.org$allenai$datastore$Datastore$$lockfilePath());
        }
    }

    public void publishFile(String file, String group, String name, int version, boolean overwrite) {
        this.publishFile(Paths.get(file, new String[0]), group, name, version, overwrite);
    }

    public void publishFile(Path file, String group, String name, int version, boolean overwrite) {
        this.publish(file, new Locator(this, group, name, version, false), overwrite);
    }

    public void publishDirectory(String path2, String group, String name, int version, boolean overwrite) {
        this.publishDirectory(Paths.get(path2, new String[0]), group, name, version, overwrite);
    }

    public void publishDirectory(Path path2, String group, String name, int version, boolean overwrite) {
        this.publish(path2, new Locator(this, group, name, version, true), overwrite);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(Path path2, Locator locator, boolean overwrite) {
        if (!overwrite && this.exists(locator)) {
            throw new AlreadyExistsException(locator, this.AlreadyExistsException().$lessinit$greater$default$2());
        }
        if (!locator.directory()) {
            this.s3().putObject(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key(), path2.toFile());
            return;
        }
        Path zipFile = Files.createTempFile(this.tempDir(), locator.org$allenai$datastore$Datastore$$flatLocalCacheKey(), ".ai2-datastore.upload.zip", new FileAttribute[0]);
        TempCleanup$.MODULE$.remember(zipFile);
        try {
            Resource$.MODULE$.using((Object)new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])), (Function1)new Serializable(this, path2){
                public static final long serialVersionUID = 0L;
                public final Path path$1;

                public final Path apply(ZipOutputStream zip) {
                    return Files.walkFileTree(this.path$1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, zip){
                        private final /* synthetic */ $anonfun$publish$1 $outer;
                        private final ZipOutputStream zip$1;

                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            this.zip$1.putNextEntry(new ZipEntry(((Object)this.$outer.path$1.relativize(file)).toString()));
                            Files.copy(file, this.zip$1);
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                            Path path2 = dir;
                            Path path3 = this.$outer.path$1;
                            if (path2 == null ? path3 != null : !((Object)path2).equals(path3)) {
                                this.zip$1.putNextEntry(new ZipEntry(new StringBuilder().append((Object)((Object)this.$outer.path$1.relativize(dir)).toString()).append((Object)"/").toString()));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.zip$1 = zip$1;
                        }
                    });
                }
                {
                    this.path$1 = path$1;
                }
            });
            this.s3().putObject(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key(), zipFile.toFile());
        }
        catch (Throwable throwable) {
            void var4_4;
            Files.deleteIfExists((Path)var4_4);
            TempCleanup$.MODULE$.forget((Path)var4_4);
            throw throwable;
        }
        Files.deleteIfExists(zipFile);
        TempCleanup$.MODULE$.forget(zipFile);
    }

    public boolean fileExists(String group, String name, int version) {
        return this.exists(new Locator(this, group, name, version, false));
    }

    public boolean directoryExists(String group, String name, int version) {
        return this.exists(new Locator(this, group, name, version, true));
    }

    public boolean exists(Locator locator) {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                this.s3().getObjectMetadata(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key());
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                AmazonServiceException amazonServiceException;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof AmazonServiceException) || (amazonServiceException = (AmazonServiceException)throwable3).getStatusCode() != 404) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    private Seq<ObjectListing> getAllListings(ListObjectsRequest request) {
        return this.concatenateListings$1((Seq)Seq$.MODULE$.empty(), this.s3().listObjects(request));
    }

    public Set<String> listGroups() {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName()).withPrefix("").withDelimiter("/");
        return ((TraversableOnce)((TraversableLike)this.getAllListings(listObjectsRequest).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(ObjectListing x$3) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getCommonPrefixes()).asScala();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).stripSuffix("/");
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<Locator> listGroupContents(String group) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName()).withPrefix(new StringBuilder().append((Object)group).append((Object)"/").toString()).withDelimiter("/");
        Seq objects = (Seq)this.getAllListings(listObjectsRequest).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<S3ObjectSummary> apply(ObjectListing x$5) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getObjectSummaries()).asScala();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)((TraversableLike)objects.filter((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final String group$1;

            public final boolean apply(S3ObjectSummary x$6) {
                String string = x$6.getKey();
                String string2 = new StringBuilder().append((Object)this.group$1).append((Object)"/").toString();
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.group$1 = group$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Datastore $outer;

            public final Locator apply(S3ObjectSummary os) {
                return this.$outer.Locator().fromKey(os.getKey());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public URL fileUrl(String group, String name, int version) {
        return this.url(new Locator(this, group, name, version, false));
    }

    public URL directoryUrl(String group, String name, int version) {
        return this.url(new Locator(this, group, name, version, true));
    }

    public URL url(Locator locator) {
        return new URL("http", this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key());
    }

    public void wipeCache() {
        FileUtils.deleteDirectory((File)this.org$allenai$datastore$Datastore$$cacheDir().toFile());
    }

    public void createBucketIfNotExists() {
        this.s3().createBucket(this.bucketName());
    }

    private final boolean shouldLog$1(boolean silent$1, int loggingDelay$1, LongRef lastLogMessage$1) {
        return !silent$1 && System.currentTimeMillis() - lastLogMessage$1.elem >= (long)loggingDelay$1;
    }

    private final Seq concatenateListings$1(Seq listings, ObjectListing newListing) {
        Seq concatenation;
        while (true) {
            concatenation = (Seq)listings.$colon$plus((Object)newListing, Seq$.MODULE$.canBuildFrom());
            if (!newListing.isTruncated()) break;
            newListing = this.s3().listNextBatchOfObjects(newListing);
            listings = concatenation;
        }
        return concatenation;
    }

    public Datastore(String name, AmazonS3Client s3) {
        this.name = name;
        this.s3 = s3;
        Logging.class.$init$((Logging)this);
        Path defaultCacheDir = System.getProperty("os.name").contains("Mac OS X") ? Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library").resolve("Caches").resolve("org.allenai.datastore") : Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ai2").resolve("datastore");
        String envCacheDir = System.getenv("AI2_DATASTORE_DIR");
        String propCacheDir = System.getProperty("org.allenai.datastore.dir");
        this.baseCacheDir = (Path)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{envCacheDir, propCacheDir}))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1 != null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$2) {
                return Paths.get(x$2, new String[0]);
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this, defaultCacheDir){
            public static final long serialVersionUID = 0L;
            private final Path defaultCacheDir$1;

            public final Path apply() {
                return this.defaultCacheDir$1;
            }
            {
                this.defaultCacheDir$1 = defaultCacheDir$1;
            }
        });
        this.org$allenai$datastore$Datastore$$cacheDir = this.baseCacheDir().resolve(name);
        this.tempDir = this.baseCacheDir().resolve("tmp");
        Files.createDirectories(this.tempDir(), new FileAttribute[0]);
    }

    public class Locator
    implements Product,
    Serializable {
        private final String group;
        private final String name;
        private final int version;
        private final boolean directory;
        public final /* synthetic */ Datastore $outer;

        public String group() {
            return this.group;
        }

        public String name() {
            return this.name;
        }

        public int version() {
            return this.version;
        }

        public boolean directory() {
            return this.directory;
        }

        public String org$allenai$datastore$Datastore$$nameWithVersion() {
            int lastDotIndex;
            return this.directory() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-d", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.version())})) : ((lastDotIndex = this.name().lastIndexOf(46)) < 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.version())})) : new StringBuilder().append((Object)this.name().substring(0, lastDotIndex)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.version())}))).append((Object)this.name().substring(lastDotIndex)).toString());
        }

        public String org$allenai$datastore$Datastore$$s3key() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group(), this.org$allenai$datastore$Datastore$$nameWithVersion()}));
        }

        public String org$allenai$datastore$Datastore$$localCacheKey() {
            return this.directory() ? new StringOps(Predef$.MODULE$.augmentString(this.org$allenai$datastore$Datastore$$s3key())).stripSuffix(".zip") : this.org$allenai$datastore$Datastore$$s3key();
        }

        public String org$allenai$datastore$Datastore$$flatLocalCacheKey() {
            return this.org$allenai$datastore$Datastore$$localCacheKey().replace('/', '%');
        }

        public Path org$allenai$datastore$Datastore$$localCachePath() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().org$allenai$datastore$Datastore$$cacheDir().resolve(this.org$allenai$datastore$Datastore$$localCacheKey());
        }

        public Path org$allenai$datastore$Datastore$$lockfilePath() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().org$allenai$datastore$Datastore$$cacheDir().resolve(new StringBuilder().append((Object)this.org$allenai$datastore$Datastore$$localCacheKey()).append((Object)".lock").toString());
        }

        public Locator copy(String group, String name, int version, boolean directory) {
            return new Locator(this.org$allenai$datastore$Datastore$Locator$$$outer(), group, name, version, directory);
        }

        public String copy$default$1() {
            return this.group();
        }

        public String copy$default$2() {
            return this.name();
        }

        public int copy$default$3() {
            return this.version();
        }

        public boolean copy$default$4() {
            return this.directory();
        }

        public String productPrefix() {
            return "Locator";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.directory());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.version());
                    break;
                }
                case 1: {
                    object = this.name();
                    break;
                }
                case 0: {
                    object = this.group();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Locator;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.group()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.version());
            n = Statics.mix((int)n, (int)(this.directory() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Locator)) return false;
            if (((Locator)object).org$allenai$datastore$Datastore$Locator$$$outer() != this.org$allenai$datastore$Datastore$Locator$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Locator locator = (Locator)x$1;
            String string = this.group();
            String string2 = locator.group();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = locator.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.version() != locator.version()) return false;
            if (this.directory() != locator.directory()) return false;
            if (!locator.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Datastore org$allenai$datastore$Datastore$Locator$$$outer() {
            return this.$outer;
        }

        public Locator(Datastore $outer, String group, String name, int version, boolean directory) {
            this.group = group;
            this.name = name;
            this.version = version;
            this.directory = directory;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
            Predef$.MODULE$.require(!group.contains("/"));
            Predef$.MODULE$.require(!name.contains("/"));
            Predef$.MODULE$.require(version > 0);
        }
    }

    public class DoesNotExistException
    extends Exception {
        public /* synthetic */ Datastore org$allenai$datastore$Datastore$DoesNotExistException$$$outer() {
            return Datastore.this;
        }

        public DoesNotExistException(Locator locator, Throwable cause) {
            if (Datastore.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist in the ", " datastore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locator.org$allenai$datastore$Datastore$$s3key(), Datastore.this.name()})), cause);
        }
    }

    public class AlreadyExistsException
    extends Exception {
        public /* synthetic */ Datastore org$allenai$datastore$Datastore$AlreadyExistsException$$$outer() {
            return Datastore.this;
        }

        public AlreadyExistsException(Locator locator, Throwable cause) {
            if (Datastore.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already exists in the ", " datastore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locator.org$allenai$datastore$Datastore$$s3key(), Datastore.this.name()})), cause);
        }
    }
}

