/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.datastore;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.allenai.common.Logging;
import org.allenai.common.Logging$logger$;
import org.allenai.common.Resource$;
import org.allenai.datastore.Datastore$;
import org.allenai.datastore.Datastore$AlreadyExistsException$;
import org.allenai.datastore.Datastore$DoesNotExistException$;
import org.allenai.datastore.Datastore$Locator$;
import org.allenai.datastore.TempCleanup$;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001B\u0001\u0003\u0001%\u0011\u0011\u0002R1uCN$xN]3\u000b\u0005\r!\u0011!\u00033bi\u0006\u001cHo\u001c:f\u0015\t)a!A\u0004bY2,g.Y5\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0007G>lWn\u001c8\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005!a.Y7f+\u0005I\u0002C\u0001\u000e\u001e\u001d\tY1$\u0003\u0002\u001d\u0019\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\taB\u0002\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0015q\u0017-\\3!\u0011!\u0019\u0003A!b\u0001\n\u0003!\u0013AA:4+\u0005)\u0003C\u0001\u0014/\u001b\u00059#BA\u0012)\u0015\tI#&\u0001\u0005tKJ4\u0018nY3t\u0015\tYC&A\u0005b[\u0006TxN\\1xg*\tQ&A\u0002d_6L!aL\u0014\u0003\u001d\u0005k\u0017M_8o'N\u001aE.[3oi\"A\u0011\u0007\u0001B\u0001B\u0003%Q%A\u0002tg\u0001BQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtDcA\u001b8qA\u0011a\u0007A\u0007\u0002\u0005!)qC\ra\u00013!)1E\ra\u0001K!9!\b\u0001b\u0001\n\u0013Y\u0014\u0001\u00042bg\u0016\u001c\u0015m\u00195f\t&\u0014X#\u0001\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015\u0001\u00024jY\u0016T!!\u0011\"\u0002\u00079LwNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$\u0001\u0002)bi\"Daa\u0012\u0001!\u0002\u0013a\u0014!\u00042bg\u0016\u001c\u0015m\u00195f\t&\u0014\b\u0005C\u0004J\u0001\t\u0007I\u0011B\u001e\u0002\u0011\r\f7\r[3ESJDaa\u0013\u0001!\u0002\u0013a\u0014!C2bG\",G)\u001b:!\u0011\u001di\u0005A1A\u0005\nm\nq\u0001^3na\u0012K'\u000f\u0003\u0004P\u0001\u0001\u0006I\u0001P\u0001\ti\u0016l\u0007\u000fR5sA!)\u0011\u000b\u0001C\u00011\u0005Q!-^2lKRt\u0015-\\3\u0007\tM\u0003\u0001\t\u0016\u0002\b\u0019>\u001c\u0017\r^8s'\u0011\u0011&\"\u0016-\u0011\u0005-1\u0016BA,\r\u0005\u001d\u0001&o\u001c3vGR\u0004\"aC-\n\u0005ic!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003/S\u0005+\u0007I\u0011\u0001\r\u0002\u000b\u001d\u0014x.\u001e9\t\u0011y\u0013&\u0011#Q\u0001\ne\taa\u001a:pkB\u0004\u0003\u0002C\fS\u0005+\u0007I\u0011\u0001\r\t\u0011\u0005\u0012&\u0011#Q\u0001\neA\u0001B\u0019*\u0003\u0016\u0004%\taY\u0001\bm\u0016\u00148/[8o+\u0005!\u0007CA\u0006f\u0013\t1GBA\u0002J]RD\u0001\u0002\u001b*\u0003\u0012\u0003\u0006I\u0001Z\u0001\tm\u0016\u00148/[8oA!A!N\u0015BK\u0002\u0013\u00051.A\u0005eSJ,7\r^8ssV\tA\u000e\u0005\u0002\f[&\u0011a\u000e\u0004\u0002\b\u0005>|G.Z1o\u0011!\u0001(K!E!\u0002\u0013a\u0017A\u00033je\u0016\u001cGo\u001c:zA!)1G\u0015C\u0001eR)1/\u001e<xqB\u0011AOU\u0007\u0002\u0001!)A,\u001da\u00013!)q#\u001da\u00013!)!-\u001da\u0001I\")!.\u001da\u0001Y\")!P\u0015C\u0001w\u0005!\u0001/\u0019;i\u0011\u001da(+!A\u0005\u0002u\fAaY8qsR91O`@\u0002\u0002\u0005\r\u0001b\u0002/|!\u0003\u0005\r!\u0007\u0005\b/m\u0004\n\u00111\u0001\u001a\u0011\u001d\u00117\u0010%AA\u0002\u0011DqA[>\u0011\u0002\u0003\u0007A\u000eC\u0005\u0002\bI\u000b\n\u0011\"\u0001\u0002\n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0006U\rI\u0012QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0004\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005M!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0005*\u0012\u0002\u0013\u0005\u0011\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)CUI\u0001\n\u0003\t9#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%\"f\u00013\u0002\u000e!I\u0011Q\u0006*\u0012\u0002\u0013\u0005\u0011qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tDK\u0002m\u0003\u001bA\u0011\"!\u000eS\u0003\u0003%\t%a\u000e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDQ\u0001\u0005Y\u0006tw-C\u0002\u001f\u0003{A\u0001\"!\u0012S\u0003\u0003%\taY\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003\u0013\u0012\u0016\u0011!C\u0001\u0003\u0017\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u0005M\u0003cA\u0006\u0002P%\u0019\u0011\u0011\u000b\u0007\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002V\u0005\u001d\u0013\u0011!a\u0001I\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005e#+!A\u0005B\u0005m\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0003CBA0\u0003K\ni%\u0004\u0002\u0002b)\u0019\u00111\r\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0005\u0005$\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-$+!A\u0005\u0002\u00055\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\u00071\fy\u0007\u0003\u0006\u0002V\u0005%\u0014\u0011!a\u0001\u0003\u001bB\u0011\"a\u001dS\u0003\u0003%\t%!\u001e\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u001a\u0005\n\u0003s\u0012\u0016\u0011!C!\u0003w\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003sA\u0011\"a S\u0003\u0003%\t%!!\u0002\r\u0015\fX/\u00197t)\ra\u00171\u0011\u0005\u000b\u0003+\ni(!AA\u0002\u00055\u0003bCAD%\n\u0005\t\u0011!C\u0001\u0001a\t\u0001g\u001c:hI\u0005dG.\u001a8bS\u0012\"\u0017\r^1ti>\u0014X\r\n#bi\u0006\u001cHo\u001c:fI\u0011r\u0017-\\3XSRDg+\u001a:tS>t\u0007bCAF%\n\u0005\t\u0011!C\u0001\u0001a\tae\u001c:hI\u0005dG.\u001a8bS\u0012\"\u0017\r^1ti>\u0014X\r\n#bi\u0006\u001cHo\u001c:fI\u0011\u001a8g[3z\u0011-\tyI\u0015B\u0001\u0002\u0003%\t\u0001\u0001\r\u0002]=\u0014x\rJ1mY\u0016t\u0017-\u001b\u0013eCR\f7\u000f^8sK\u0012\"\u0015\r^1ti>\u0014X\r\n\u0013m_\u000e\fGnQ1dQ\u0016\\U-\u001f\u0005\f\u0003'\u0013&\u0011!A\u0001\n\u0003\u0001\u0001$\u0001\u001ape\u001e$\u0013\r\u001c7f]\u0006LG\u0005Z1uCN$xN]3%\t\u0006$\u0018m\u001d;pe\u0016$CE\u001a7bi2{7-\u00197DC\u000eDWmS3z\u0011-\t9J\u0015B\u0001\u0002\u0003%\t\u0001A\u001e\u0002_=\u0014x\rJ1mY\u0016t\u0017-\u001b\u0013eCR\f7\u000f^8sK\u0012\"\u0015\r^1ti>\u0014X\r\n\u0013m_\u000e\fGnQ1dQ\u0016\u0004\u0016\r\u001e5\t\u0017\u0005m%K!A\u0001\u0002\u0013\u0005\u0001aO\u0001._J<G%\u00197mK:\f\u0017\u000e\n3bi\u0006\u001cHo\u001c:fI\u0011\u000bG/Y:u_J,G\u0005\n7pG.4\u0017\u000e\\3QCRDwaBAP\u0001!\u0005\u0011\u0011U\u0001\b\u0019>\u001c\u0017\r^8s!\r!\u00181\u0015\u0004\u0007'\u0002A\t!!*\u0014\t\u0005\r&\u0002\u0017\u0005\bg\u0005\rF\u0011AAU)\t\t\t\u000bC\u0005\u0002.\u0006\rF\u0011\u0001\u0001\u00020\u00069aM]8n\u0017\u0016LHcA:\u00022\"9\u00111WAV\u0001\u0004I\u0012aA6fs\"Q\u0011qWAR\u0003\u0003%\t)!/\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013M\fY,!0\u0002@\u0006\u0005\u0007B\u0002/\u00026\u0002\u0007\u0011\u0004\u0003\u0004\u0018\u0003k\u0003\r!\u0007\u0005\u0007E\u0006U\u0006\u0019\u00013\t\r)\f)\f1\u0001m\u0011)\t)-a)\u0002\u0002\u0013\u0005\u0015qY\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI-!6\u0011\u000b-\tY-a4\n\u0007\u00055GB\u0001\u0004PaRLwN\u001c\t\b\u0017\u0005E\u0017$\u00073m\u0013\r\t\u0019\u000e\u0004\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\u0005]\u00171YA\u0001\u0002\u0004\u0019\u0018a\u0001=%a!Q\u00111\\AR\u0003\u0003%I!!8\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0004B!a\u000f\u0002b&!\u00111]A\u001f\u0005\u0019y%M[3di\u001a1\u0011q\u001d\u0001\u0001\u0003S\u0014Q\u0003R8fg:{G/\u0012=jgR,\u0005pY3qi&|gn\u0005\u0003\u0002f\u0006-\b\u0003BAw\u0003{tA!a<\u0002z:!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v\"\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0007\u0005mH\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}(\u0011\u0001\u0002\n\u000bb\u001cW\r\u001d;j_:T1!a?\r\u0011)\u0011)!!:\u0003\u0002\u0003\u0006Ia]\u0001\bY>\u001c\u0017\r^8s\u0011-\u0011I!!:\u0003\u0002\u0003\u0006IAa\u0003\u0002\u000b\r\fWo]3\u0011\t\u00055(QB\u0005\u0005\u0005\u001f\u0011\tAA\u0005UQJ|w/\u00192mK\"91'!:\u0005\u0002\tMAC\u0002B\u000b\u0005/\u0011I\u0002E\u0002u\u0003KDqA!\u0002\u0003\u0012\u0001\u00071\u000f\u0003\u0006\u0003\n\tE\u0001\u0013!a\u0001\u0005\u00179\u0011B!\b\u0001\u0003\u0003E\tAa\b\u0002+\u0011{Wm\u001d(pi\u0016C\u0018n\u001d;Fq\u000e,\u0007\u000f^5p]B\u0019AO!\t\u0007\u0013\u0005\u001d\b!!A\t\u0002\t\r2\u0003\u0002B\u0011\u0015aCqa\rB\u0011\t\u0003\u00119\u0003\u0006\u0002\u0003 !Q!1\u0006B\u0011#\u0003%\tA!\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yC\u000b\u0003\u0003\f\u00055\u0001BCAn\u0005C\t\t\u0011\"\u0003\u0002^\u001a1!Q\u0007\u0001\u0001\u0005o\u0011a#\u00117sK\u0006$\u00170\u0012=jgR\u001cX\t_2faRLwN\\\n\u0005\u0005g\tY\u000f\u0003\u0006\u0003\u0006\tM\"\u0011!Q\u0001\nMD1B!\u0003\u00034\t\u0005\t\u0015!\u0003\u0003\f!91Ga\r\u0005\u0002\t}BC\u0002B!\u0005\u0007\u0012)\u0005E\u0002u\u0005gAqA!\u0002\u0003>\u0001\u00071\u000f\u0003\u0006\u0003\n\tu\u0002\u0013!a\u0001\u0005\u00179\u0011B!\u0013\u0001\u0003\u0003E\tAa\u0013\u0002-\u0005c'/Z1es\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:\u00042\u0001\u001eB'\r%\u0011)\u0004AA\u0001\u0012\u0003\u0011ye\u0005\u0003\u0003N)A\u0006bB\u001a\u0003N\u0011\u0005!1\u000b\u000b\u0003\u0005\u0017B!Ba\u000b\u0003NE\u0005I\u0011\u0001B\u0017\u0011)\tYN!\u0014\u0002\u0002\u0013%\u0011Q\u001c\u0005\b\u00057\u0002A\u0011\u0002B/\u0003-9W\r^*4\u001f\nTWm\u0019;\u0015\t\t}#1\u000e\t\u0005\u0005C\u00129'\u0004\u0002\u0003d)\u0019!Q\r\"\u0002\u0005%|\u0017\u0002\u0002B5\u0005G\u00121\"\u00138qkR\u001cFO]3b[\"9\u00111\u0017B-\u0001\u0004I\u0002b\u0002B8\u0001\u0011%!\u0011O\u0001\u0010o\u0006LGOR8s\u0019>\u001c7NZ5mKR!!1\u000fB=!\rY!QO\u0005\u0004\u0005ob!\u0001B+oSRDqAa\u001f\u0003n\u0001\u0007A(\u0001\u0005m_\u000e\\g-\u001b7f\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003\u000bQ\u0002\u001e:z\u0007J,\u0017\r^3GS2,Gc\u00017\u0003\u0004\"1qH! A\u0002qBqAa\"\u0001\t\u0013\u0011I)A\u0006g_Jl\u0017\r\u001e\"zi\u0016\u001cHcA\r\u0003\f\"A!Q\u0012BC\u0001\u0004\u0011y)A\u0003csR,7\u000fE\u0002\f\u0005#K1Aa%\r\u0005\u0011auN\\4\t\u000f\t]\u0005\u0001\"\u0003\u0003\u001a\u0006Y1m\u001c9z'R\u0014X-Y7t))\u0011\u0019Ha'\u0003,\nU&\u0011\u0018\u0005\t\u0005;\u0013)\n1\u0001\u0003 \u0006\u0011\u0011n\u0019\t\u0005\u0005C\u00139+\u0004\u0002\u0003$*\u0019!Q\u0015!\u0002\u0011\rD\u0017M\u001c8fYNLAA!+\u0003$\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\"A!Q\u0016BK\u0001\u0004\u0011y+\u0001\u0002pGB!!\u0011\u0015BY\u0013\u0011\u0011\u0019La)\u0003']\u0013\u0018\u000e^1cY\u0016\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\u000f\t]&Q\u0013a\u00013\u0005Aa-\u001b7f]\u0006lW\rC\u0005\u0003<\nU\u0005\u0013!a\u0001Y\u000611/\u001b7f]RDqAa0\u0001\t\u0003\u0011\t-\u0001\u0005gS2,\u0007+\u0019;i)\u001da$1\u0019Bc\u0005\u000fDa\u0001\u0018B_\u0001\u0004I\u0002BB\f\u0003>\u0002\u0007\u0011\u0004\u0003\u0004c\u0005{\u0003\r\u0001\u001a\u0005\b\u0005\u0017\u0004A\u0011\u0001Bg\u00035!\u0017N]3di>\u0014\u0018\u0010U1uQR9AHa4\u0003R\nM\u0007B\u0002/\u0003J\u0002\u0007\u0011\u0004\u0003\u0004\u0018\u0005\u0013\u0004\r!\u0007\u0005\u0007E\n%\u0007\u0019\u00013\t\ri\u0004A\u0011\u0001Bl)\ra$\u0011\u001c\u0005\b\u0005\u000b\u0011)\u000e1\u0001t\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005?\f1\u0002];cY&\u001c\bNR5mKRa!1\u000fBq\u0005G\u0014)Oa:\u0003j\"1qHa7A\u0002eAa\u0001\u0018Bn\u0001\u0004I\u0002BB\f\u0003\\\u0002\u0007\u0011\u0004\u0003\u0004c\u00057\u0004\r\u0001\u001a\u0005\b\u0005W\u0014Y\u000e1\u0001m\u0003%yg/\u001a:xe&$X\rC\u0004\u0003^\u0002!\tAa<\u0015\u0019\tM$\u0011\u001fBz\u0005k\u00149P!?\t\r}\u0012i\u000f1\u0001=\u0011\u0019a&Q\u001ea\u00013!1qC!<A\u0002eAaA\u0019Bw\u0001\u0004!\u0007b\u0002Bv\u0005[\u0004\r\u0001\u001c\u0005\b\u0005{\u0004A\u0011\u0001B\u0000\u0003A\u0001XO\u00197jg\"$\u0015N]3di>\u0014\u0018\u0010\u0006\u0007\u0003t\r\u000511AB\u0003\u0007\u000f\u0019I\u0001\u0003\u0004{\u0005w\u0004\r!\u0007\u0005\u00079\nm\b\u0019A\r\t\r]\u0011Y\u00101\u0001\u001a\u0011\u0019\u0011'1 a\u0001I\"9!1\u001eB~\u0001\u0004a\u0007b\u0002B\u007f\u0001\u0011\u00051Q\u0002\u000b\r\u0005g\u001aya!\u0005\u0004\u0014\rU1q\u0003\u0005\u0007u\u000e-\u0001\u0019\u0001\u001f\t\rq\u001bY\u00011\u0001\u001a\u0011\u0019921\u0002a\u00013!1!ma\u0003A\u0002\u0011DqAa;\u0004\f\u0001\u0007A\u000eC\u0004\u0004\u001c\u0001!\ta!\b\u0002\u000fA,(\r\\5tQRA!1OB\u0010\u0007C\u0019\u0019\u0003\u0003\u0004{\u00073\u0001\r\u0001\u0010\u0005\b\u0005\u000b\u0019I\u00021\u0001t\u0011\u001d\u0011Yo!\u0007A\u00021Dqaa\n\u0001\t\u0003\u0019I#\u0001\u0006gS2,W\t_5tiN$r\u0001\\B\u0016\u0007[\u0019y\u0003\u0003\u0004]\u0007K\u0001\r!\u0007\u0005\u0007/\r\u0015\u0002\u0019A\r\t\r\t\u001c)\u00031\u0001e\u0011\u001d\u0019\u0019\u0004\u0001C\u0001\u0007k\tq\u0002Z5sK\u000e$xN]=Fq&\u001cHo\u001d\u000b\bY\u000e]2\u0011HB\u001e\u0011\u0019a6\u0011\u0007a\u00013!1qc!\rA\u0002eAaAYB\u0019\u0001\u0004!\u0007bBB \u0001\u0011\u00051\u0011I\u0001\u0007KbL7\u000f^:\u0015\u00071\u001c\u0019\u0005C\u0004\u0003\u0006\ru\u0002\u0019A:\t\u000f\r\u001d\u0003\u0001\"\u0003\u0004J\u0005qq-\u001a;BY2d\u0015n\u001d;j]\u001e\u001cH\u0003BB&\u0007;\u0002b!!<\u0004N\rE\u0013\u0002BB(\u0005\u0003\u00111aU3r!\u0011\u0019\u0019f!\u0017\u000e\u0005\rU#bAB,O\u0005)Qn\u001c3fY&!11LB+\u00055y%M[3di2K7\u000f^5oO\"A1qLB#\u0001\u0004\u0019\t'A\u0004sKF,Xm\u001d;\u0011\t\rM31M\u0005\u0005\u0007K\u001a)F\u0001\nMSN$xJ\u00196fGR\u001c(+Z9vKN$\bbBB5\u0001\u0011\u000511N\u0001\u000bY&\u001cHo\u0012:pkB\u001cXCAB7!\u0011Q2qN\r\n\u0007\rEtDA\u0002TKRDqa!\u001e\u0001\t\u0003\u00199(A\tmSN$xI]8va\u000e{g\u000e^3oiN$Ba!\u001f\u0004|A!!da\u001ct\u0011\u0019a61\u000fa\u00013!91q\u0010\u0001\u0005\u0002\r\u0005\u0015a\u00024jY\u0016,&\u000f\u001c\u000b\t\u0007\u0007\u001byi!%\u0004\u0014B!1QQBF\u001b\t\u00199IC\u0002\u0004\n\n\u000b1A\\3u\u0013\u0011\u0019iia\"\u0003\u0007U\u0013F\n\u0003\u0004]\u0007{\u0002\r!\u0007\u0005\u0007/\ru\u0004\u0019A\r\t\r\t\u001ci\b1\u0001e\u0011\u001d\u00199\n\u0001C\u0001\u00073\u000bA\u0002Z5sK\u000e$xN]=Ve2$\u0002ba!\u0004\u001c\u000eu5q\u0014\u0005\u00079\u000eU\u0005\u0019A\r\t\r]\u0019)\n1\u0001\u001a\u0011\u0019\u00117Q\u0013a\u0001I\"911\u0015\u0001\u0005\u0002\r\u0015\u0016aA;sYR!11QBT\u0011\u001d\u0011)a!)A\u0002MDqaa+\u0001\t\u0003\u0019i+A\u0005xSB,7)Y2iKR\u0011!1\u000f\u0005\b\u0007c\u0003A\u0011ABW\u0003]\u0019'/Z1uK\n+8m[3u\u0013\u001atu\u000e^#ySN$8\u000fC\u0005\u00046\u0002\t\n\u0011\"\u0003\u00020\u0005)2m\u001c9z'R\u0014X-Y7tI\u0011,g-Y;mi\u0012\"taBB]\u0005!\u000511X\u0001\n\t\u0006$\u0018m\u001d;pe\u0016\u00042ANB_\r\u0019\t!\u0001#\u0001\u0004@N\u00191QX\u001b\t\u000fM\u001ai\f\"\u0001\u0004DR\u001111\u0018\u0005\n\u0007\u000f\u001ciL1A\u0005\u0002a\t1\u0002Z3gCVdGOT1nK\"A11ZB_A\u0003%\u0011$\u0001\u0007eK\u001a\fW\u000f\u001c;OC6,\u0007\u0005\u0003\u0005\u00028\u000euF\u0011ABh)\u0005)\u0004\u0002CA\\\u0007{#\taa5\u0015\u0007U\u001a)\u000e\u0003\u0004\u0018\u0007#\u0004\r!\u0007\u0005\t\u0003o\u001bi\f\"\u0001\u0004ZR)Qga7\u0004`\"91Q\\Bl\u0001\u0004I\u0012!C1dG\u0016\u001c8oS3z\u0011\u001d\u0019\toa6A\u0002e\tqb]3de\u0016$\u0018iY2fgN\\U-\u001f\u0005\t\u0003o\u001bi\f\"\u0001\u0004fR9Qga:\u0004j\u000e-\bBB\f\u0004d\u0002\u0007\u0011\u0004C\u0004\u0004^\u000e\r\b\u0019A\r\t\u000f\r\u000581\u001da\u00013!A1q^B_\t\u0003\u0019\t0\u0001\bm_\u000e\fGo\u001c:Ge>lWK\u001d7\u0015\t\rM8Q\u001f\t\u0003kIC\u0001ba>\u0004n\u0002\u00071\u0011`\u0001\u0004kJL\u0007\u0003BBC\u0007wLAa!@\u0004\b\n\u0019QKU%")
public class Datastore
implements Logging {
    private final String name;
    private final AmazonS3Client s3;
    private final Path baseCacheDir;
    private final Path org$allenai$datastore$Datastore$$cacheDir;
    private final Path tempDir;
    private volatile Datastore$Locator$ Locator$module;
    private volatile Datastore$DoesNotExistException$ DoesNotExistException$module;
    private volatile Datastore$AlreadyExistsException$ AlreadyExistsException$module;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;

    public static Locator locatorFromUrl(URI uRI) {
        return Datastore$.MODULE$.locatorFromUrl(uRI);
    }

    public static Datastore apply(String string, String string2, String string3) {
        return Datastore$.MODULE$.apply(string, string2, string3);
    }

    public static Datastore apply(String string, String string2) {
        return Datastore$.MODULE$.apply(string, string2);
    }

    public static Datastore apply(String string) {
        return Datastore$.MODULE$.apply(string);
    }

    public static Datastore apply() {
        return Datastore$.MODULE$.apply();
    }

    public static String defaultName() {
        return Datastore$.MODULE$.defaultName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$Locator$ Locator$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.Locator$module != null) return this.Locator$module;
            this.Locator$module = new Datastore$Locator$(this);
            return this.Locator$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$DoesNotExistException$ DoesNotExistException$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.DoesNotExistException$module != null) return this.DoesNotExistException$module;
            this.DoesNotExistException$module = new Datastore$DoesNotExistException$(this);
            return this.DoesNotExistException$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$AlreadyExistsException$ AlreadyExistsException$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.AlreadyExistsException$module != null) return this.AlreadyExistsException$module;
            this.AlreadyExistsException$module = new Datastore$AlreadyExistsException$(this);
            return this.AlreadyExistsException$module;
        }
    }

    public Logger internalLogger() {
        return this.internalLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging$logger$ logger$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.logger$module != null) return this.logger$module;
            this.logger$module = new Logging$logger$((Logging)this);
            return this.logger$module;
        }
    }

    public Logging$logger$ logger() {
        return this.logger$module == null ? this.logger$lzycompute() : this.logger$module;
    }

    public void org$allenai$common$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public String name() {
        return this.name;
    }

    public AmazonS3Client s3() {
        return this.s3;
    }

    private Path baseCacheDir() {
        return this.baseCacheDir;
    }

    public Path org$allenai$datastore$Datastore$$cacheDir() {
        return this.org$allenai$datastore$Datastore$$cacheDir;
    }

    private Path tempDir() {
        return this.tempDir;
    }

    public String bucketName() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".store.dev.allenai.org"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}));
    }

    public Datastore$Locator$ Locator() {
        return this.Locator$module == null ? this.Locator$lzycompute() : this.Locator$module;
    }

    public Datastore$DoesNotExistException$ DoesNotExistException() {
        return this.DoesNotExistException$module == null ? this.DoesNotExistException$lzycompute() : this.DoesNotExistException$module;
    }

    public Datastore$AlreadyExistsException$ AlreadyExistsException() {
        return this.AlreadyExistsException$module == null ? this.AlreadyExistsException$lzycompute() : this.AlreadyExistsException$module;
    }

    private InputStream getS3Object(String key) {
        return this.s3().getObject(this.bucketName(), key).getObjectContent();
    }

    private void waitForLockfile(Path lockfile) {
        long start = System.currentTimeMillis();
        while (Files.exists(lockfile, new LinkOption[0])) {
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for lockfile at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lockfile}));
            if (System.currentTimeMillis() - start > 60000L) {
                this.logger().warn((Function0)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            } else {
                this.logger().info((Function0)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            }
            int oneSecond = 1000;
            Thread.sleep(oneSecond);
        }
    }

    private boolean tryCreateFile(Path file) {
        boolean bl;
        try {
            Files.createFile(file, new FileAttribute[0]);
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    public String org$allenai$datastore$Datastore$$formatBytes(long bytes) {
        double orderOfMagnitude = Math.floor(Math.log(Math.max(1L, bytes)) / Math.log(1024.0));
        double bytesInUnit = (double)bytes / Math.pow(1024.0, orderOfMagnitude);
        String formattedNumber = bytesInUnit < (double)10 ? new StringOps(Predef$.MODULE$.augmentString("%.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})) : (bytesInUnit < (double)100 ? new StringOps(Predef$.MODULE$.augmentString("%.1f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})) : new StringOps(Predef$.MODULE$.augmentString("%.0f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})));
        String[] units = (String[])((Object[])new String[]{"B", "KB", "MB", "GB", "TB", "PB"});
        String unit = units[Math.min((int)orderOfMagnitude, units.length)];
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedNumber, unit}));
    }

    public void org$allenai$datastore$Datastore$$copyStreams(ReadableByteChannel ic, WritableByteChannel oc, String filename, boolean silent) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
        int loggingDelay = 1000;
        long startTime = System.currentTimeMillis();
        LongRef lastLogMessage = LongRef.create((long)startTime);
        LongRef bytesCopied = LongRef.create((long)0L);
        while (ic.read(buffer) >= 0) {
            bytesCopied.elem += (long)buffer.position();
            buffer.flip();
            oc.write(buffer);
            buffer.compact();
            bytesCopied.elem -= (long)buffer.position();
            if (!this.shouldLog$1(silent, loggingDelay, lastLogMessage)) continue;
            this.logger().info((Function0)new Serializable(this, filename, bytesCopied){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Datastore $outer;
                private final String filename$1;
                private final LongRef bytesCopied$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading ", " from the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filename$1, this.$outer.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes read."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$formatBytes(this.bytesCopied$1.elem)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filename$1 = filename$1;
                    this.bytesCopied$1 = bytesCopied$1;
                }
            });
            lastLogMessage.elem = System.currentTimeMillis();
        }
        buffer.flip();
        bytesCopied.elem += (long)buffer.remaining();
        while (buffer.hasRemaining()) {
            oc.write(buffer);
        }
        if (!silent && System.currentTimeMillis() - startTime >= (long)loggingDelay) {
            this.logger().info((Function0)new Serializable(this, filename, bytesCopied){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Datastore $outer;
                private final String filename$1;
                private final LongRef bytesCopied$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloaded ", " from the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filename$1, this.$outer.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes read."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$formatBytes(this.bytesCopied$1.elem)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filename$1 = filename$1;
                    this.bytesCopied$1 = bytesCopied$1;
                }
            });
        }
    }

    public boolean org$allenai$datastore$Datastore$$copyStreams$default$4() {
        return false;
    }

    public Path filePath(String group, String name, int version) {
        return this.path(new Locator(this, group, name, version, false));
    }

    public Path directoryPath(String group, String name, int version) {
        return this.path(new Locator(this, group, name, version, true));
    }

    /*
     * Loose catch block
     */
    public Path path(Locator locator) {
        Path path2;
        Files.createDirectories(this.org$allenai$datastore$Datastore$$cacheDir(), new FileAttribute[0]);
        Files.createDirectories(locator.org$allenai$datastore$Datastore$$lockfilePath().getParent(), new FileAttribute[0]);
        this.waitForLockfile(locator.org$allenai$datastore$Datastore$$lockfilePath());
        if (locator.directory() && Files.isDirectory(locator.org$allenai$datastore$Datastore$$localCachePath(), new LinkOption[0]) || !locator.directory() && Files.isRegularFile(locator.org$allenai$datastore$Datastore$$localCachePath(), new LinkOption[0])) {
            path2 = locator.org$allenai$datastore$Datastore$$localCachePath();
        } else {
            boolean created = this.tryCreateFile(locator.org$allenai$datastore$Datastore$$lockfilePath());
            if (created) {
                TempCleanup$.MODULE$.remember(locator.org$allenai$datastore$Datastore$$lockfilePath());
                Path tempFile = Files.createTempFile(this.tempDir(), new StringBuilder().append((Object)"ai2-datastore-").append((Object)locator.org$allenai$datastore$Datastore$$flatLocalCacheKey()).toString(), ".tmp", new FileAttribute[0]);
                TempCleanup$.MODULE$.remember(tempFile);
                Resource$.MODULE$.using2((Object)Channels.newChannel(this.getS3Object(locator.org$allenai$datastore$Datastore$$s3key())), (Object)Files.newByteChannel(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), (Function2)new Serializable(this, locator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Datastore $outer;
                    private final Locator locator$1;

                    public final void apply(ReadableByteChannel x0$1, SeekableByteChannel x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            ReadableByteChannel input = (ReadableByteChannel)tuple2._1();
                            SeekableByteChannel output = (SeekableByteChannel)tuple2._2();
                            this.$outer.org$allenai$datastore$Datastore$$copyStreams(input, output, this.locator$1.org$allenai$datastore$Datastore$$s3key(), this.$outer.org$allenai$datastore$Datastore$$copyStreams$default$4());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.locator$1 = locator$1;
                    }
                });
                if (locator.directory()) {
                    Path tempZipDir = Files.createTempDirectory(this.tempDir(), new StringBuilder().append((Object)"ai2-datastore-").append((Object)locator.org$allenai$datastore$Datastore$$flatLocalCacheKey()).toString(), new FileAttribute[0]);
                    TempCleanup$.MODULE$.remember(tempZipDir);
                    Resource$.MODULE$.using((Object)new ZipFile(tempFile.toFile()), (Function1)new Serializable(this, locator, tempZipDir){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Datastore $outer;
                        public final Locator locator$1;
                        private final Path tempZipDir$1;

                        public final void apply(ZipFile zipFile) {
                            Enumeration<? extends ZipEntry> entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                Object object;
                                ZipEntry entry = entries.nextElement();
                                String string = entry.getName();
                                String string2 = "/";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    object = BoxedUnit.UNIT;
                                    continue;
                                }
                                Path pathForEntry = this.tempZipDir$1.resolve(entry.getName());
                                if (entry.isDirectory()) {
                                    object = Files.createDirectories(pathForEntry, new FileAttribute[0]);
                                    continue;
                                }
                                Files.createDirectories(pathForEntry.getParent(), new FileAttribute[0]);
                                object = Resource$.MODULE$.using2((Object)Channels.newChannel(zipFile.getInputStream(entry)), (Object)Files.newByteChannel(pathForEntry, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$path$2 $outer;

                                    public final void apply(ReadableByteChannel x0$2, SeekableByteChannel x1$2) {
                                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                                        if (tuple2 != null) {
                                            ReadableByteChannel input = (ReadableByteChannel)tuple2._1();
                                            SeekableByteChannel output = (SeekableByteChannel)tuple2._2();
                                            this.$outer.org$allenai$datastore$Datastore$$anonfun$$$outer().org$allenai$datastore$Datastore$$copyStreams(input, output, this.$outer.locator$1.org$allenai$datastore$Datastore$$s3key(), true);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                        }

                        public /* synthetic */ Datastore org$allenai$datastore$Datastore$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.locator$1 = locator$1;
                            this.tempZipDir$1 = tempZipDir$1;
                        }
                    });
                    Files.delete(tempFile);
                    TempCleanup$.MODULE$.forget(tempFile);
                    Files.move(tempZipDir, locator.org$allenai$datastore$Datastore$$localCachePath(), new CopyOption[0]);
                    TempCleanup$.MODULE$.forget(tempZipDir);
                } else {
                    Files.createDirectories(locator.org$allenai$datastore$Datastore$$localCachePath().getParent(), new FileAttribute[0]);
                    Files.move(tempFile, locator.org$allenai$datastore$Datastore$$localCachePath(), new CopyOption[0]);
                    TempCleanup$.MODULE$.forget(tempFile);
                }
                path2 = locator.org$allenai$datastore$Datastore$$localCachePath();
            } else {
                path2 = this.path(locator);
            }
        }
        return path2;
        {
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AmazonS3Exception) {
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)throwable2;
                    String string = amazonS3Exception.getErrorCode();
                    String string2 = "NoSuchKey";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new DoesNotExistException(locator, (Throwable)amazonS3Exception);
                    }
                }
                throw throwable;
            }
        }
        finally {
            Files.delete(locator.org$allenai$datastore$Datastore$$lockfilePath());
            TempCleanup$.MODULE$.forget(locator.org$allenai$datastore$Datastore$$lockfilePath());
        }
    }

    public void publishFile(String file, String group, String name, int version, boolean overwrite) {
        this.publishFile(Paths.get(file, new String[0]), group, name, version, overwrite);
    }

    public void publishFile(Path file, String group, String name, int version, boolean overwrite) {
        this.publish(file, new Locator(this, group, name, version, false), overwrite);
    }

    public void publishDirectory(String path2, String group, String name, int version, boolean overwrite) {
        this.publishDirectory(Paths.get(path2, new String[0]), group, name, version, overwrite);
    }

    public void publishDirectory(Path path2, String group, String name, int version, boolean overwrite) {
        this.publish(path2, new Locator(this, group, name, version, true), overwrite);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(Path path2, Locator locator, boolean overwrite) {
        if (!overwrite && this.exists(locator)) {
            throw new AlreadyExistsException(locator, this.AlreadyExistsException().$lessinit$greater$default$2());
        }
        if (!locator.directory()) {
            this.s3().putObject(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key(), path2.toFile());
            return;
        }
        Path zipFile = Files.createTempFile(this.tempDir(), locator.org$allenai$datastore$Datastore$$flatLocalCacheKey(), ".ai2-datastore.upload.zip", new FileAttribute[0]);
        TempCleanup$.MODULE$.remember(zipFile);
        try {
            Resource$.MODULE$.using((Object)new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])), (Function1)new Serializable(this, path2){
                public static final long serialVersionUID = 0L;
                public final Path path$1;

                public final Path apply(ZipOutputStream zip) {
                    return Files.walkFileTree(this.path$1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, zip){
                        private final /* synthetic */ $anonfun$publish$1 $outer;
                        private final ZipOutputStream zip$1;

                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            this.zip$1.putNextEntry(new ZipEntry(((Object)this.$outer.path$1.relativize(file)).toString()));
                            Files.copy(file, this.zip$1);
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                            Path path2 = dir;
                            Path path3 = this.$outer.path$1;
                            if (path2 == null ? path3 != null : !((Object)path2).equals(path3)) {
                                this.zip$1.putNextEntry(new ZipEntry(new StringBuilder().append((Object)((Object)this.$outer.path$1.relativize(dir)).toString()).append((Object)"/").toString()));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.zip$1 = zip$1;
                        }
                    });
                }
                {
                    this.path$1 = path$1;
                }
            });
            this.s3().putObject(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key(), zipFile.toFile());
        }
        catch (Throwable throwable) {
            void var4_4;
            Files.deleteIfExists((Path)var4_4);
            TempCleanup$.MODULE$.forget((Path)var4_4);
            throw throwable;
        }
        Files.deleteIfExists(zipFile);
        TempCleanup$.MODULE$.forget(zipFile);
    }

    public boolean fileExists(String group, String name, int version) {
        return this.exists(new Locator(this, group, name, version, false));
    }

    public boolean directoryExists(String group, String name, int version) {
        return this.exists(new Locator(this, group, name, version, true));
    }

    public boolean exists(Locator locator) {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                this.s3().getObjectMetadata(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key());
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                AmazonServiceException amazonServiceException;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof AmazonServiceException) || (amazonServiceException = (AmazonServiceException)throwable3).getStatusCode() != 404) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    private Seq<ObjectListing> getAllListings(ListObjectsRequest request) {
        return this.concatenateListings$1((Seq)Seq$.MODULE$.empty(), this.s3().listObjects(request));
    }

    public Set<String> listGroups() {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName()).withPrefix("").withDelimiter("/");
        return ((TraversableOnce)((TraversableLike)this.getAllListings(listObjectsRequest).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(ObjectListing x$3) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getCommonPrefixes()).asScala();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).stripSuffix("/");
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public Set<Locator> listGroupContents(String group) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName()).withPrefix(new StringBuilder().append((Object)group).append((Object)"/").toString()).withDelimiter("/");
        Seq objects = (Seq)this.getAllListings(listObjectsRequest).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<S3ObjectSummary> apply(ObjectListing x$5) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getObjectSummaries()).asScala();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)((TraversableLike)objects.filter((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final String group$1;

            public final boolean apply(S3ObjectSummary x$6) {
                String string = x$6.getKey();
                String string2 = new StringBuilder().append((Object)this.group$1).append((Object)"/").toString();
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.group$1 = group$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Datastore $outer;

            public final Locator apply(S3ObjectSummary os) {
                return this.$outer.Locator().fromKey(os.getKey());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public URL fileUrl(String group, String name, int version) {
        return this.url(new Locator(this, group, name, version, false));
    }

    public URL directoryUrl(String group, String name, int version) {
        return this.url(new Locator(this, group, name, version, true));
    }

    public URL url(Locator locator) {
        return new URL("http", this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key());
    }

    public void wipeCache() {
        FileUtils.deleteDirectory((File)this.org$allenai$datastore$Datastore$$cacheDir().toFile());
    }

    public void createBucketIfNotExists() {
        this.s3().createBucket(this.bucketName());
    }

    private final boolean shouldLog$1(boolean silent$1, int loggingDelay$1, LongRef lastLogMessage$1) {
        return !silent$1 && System.currentTimeMillis() - lastLogMessage$1.elem >= (long)loggingDelay$1;
    }

    private final Seq concatenateListings$1(Seq listings, ObjectListing newListing) {
        Seq concatenation;
        while (true) {
            concatenation = (Seq)listings.$colon$plus((Object)newListing, Seq$.MODULE$.canBuildFrom());
            if (!newListing.isTruncated()) break;
            newListing = this.s3().listNextBatchOfObjects(newListing);
            listings = concatenation;
        }
        return concatenation;
    }

    public Datastore(String name, AmazonS3Client s3) {
        this.name = name;
        this.s3 = s3;
        Logging.class.$init$((Logging)this);
        Path defaultCacheDir = System.getProperty("os.name").contains("Mac OS X") ? Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library").resolve("Caches").resolve("org.allenai.datastore") : Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ai2").resolve("datastore");
        String envCacheDir = System.getenv("AI2_DATASTORE_DIR");
        String propCacheDir = System.getProperty("org.allenai.datastore.dir");
        this.baseCacheDir = (Path)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{envCacheDir, propCacheDir}))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1 != null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$2) {
                return Paths.get(x$2, new String[0]);
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this, defaultCacheDir){
            public static final long serialVersionUID = 0L;
            private final Path defaultCacheDir$1;

            public final Path apply() {
                return this.defaultCacheDir$1;
            }
            {
                this.defaultCacheDir$1 = defaultCacheDir$1;
            }
        });
        this.org$allenai$datastore$Datastore$$cacheDir = this.baseCacheDir().resolve(name);
        this.tempDir = this.baseCacheDir().resolve("tmp");
        Files.createDirectories(this.tempDir(), new FileAttribute[0]);
    }

    public class Locator
    implements Product,
    Serializable {
        private final String group;
        private final String name;
        private final int version;
        private final boolean directory;
        public final /* synthetic */ Datastore $outer;

        public String group() {
            return this.group;
        }

        public String name() {
            return this.name;
        }

        public int version() {
            return this.version;
        }

        public boolean directory() {
            return this.directory;
        }

        public String org$allenai$datastore$Datastore$$nameWithVersion() {
            int lastDotIndex;
            return this.directory() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-d", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.version())})) : ((lastDotIndex = this.name().lastIndexOf(46)) < 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.version())})) : new StringBuilder().append((Object)this.name().substring(0, lastDotIndex)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.version())}))).append((Object)this.name().substring(lastDotIndex)).toString());
        }

        public String org$allenai$datastore$Datastore$$s3key() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group(), this.org$allenai$datastore$Datastore$$nameWithVersion()}));
        }

        public String org$allenai$datastore$Datastore$$localCacheKey() {
            return this.directory() ? new StringOps(Predef$.MODULE$.augmentString(this.org$allenai$datastore$Datastore$$s3key())).stripSuffix(".zip") : this.org$allenai$datastore$Datastore$$s3key();
        }

        public String org$allenai$datastore$Datastore$$flatLocalCacheKey() {
            return this.org$allenai$datastore$Datastore$$localCacheKey().replace('/', '%');
        }

        public Path org$allenai$datastore$Datastore$$localCachePath() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().org$allenai$datastore$Datastore$$cacheDir().resolve(this.org$allenai$datastore$Datastore$$localCacheKey());
        }

        public Path org$allenai$datastore$Datastore$$lockfilePath() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().org$allenai$datastore$Datastore$$cacheDir().resolve(new StringBuilder().append((Object)this.org$allenai$datastore$Datastore$$localCacheKey()).append((Object)".lock").toString());
        }

        public Path path() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().path(this);
        }

        public Locator copy(String group, String name, int version, boolean directory) {
            return new Locator(this.org$allenai$datastore$Datastore$Locator$$$outer(), group, name, version, directory);
        }

        public String copy$default$1() {
            return this.group();
        }

        public String copy$default$2() {
            return this.name();
        }

        public int copy$default$3() {
            return this.version();
        }

        public boolean copy$default$4() {
            return this.directory();
        }

        public String productPrefix() {
            return "Locator";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.directory());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.version());
                    break;
                }
                case 1: {
                    object = this.name();
                    break;
                }
                case 0: {
                    object = this.group();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Locator;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.group()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.version());
            n = Statics.mix((int)n, (int)(this.directory() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Locator)) return false;
            if (((Locator)object).org$allenai$datastore$Datastore$Locator$$$outer() != this.org$allenai$datastore$Datastore$Locator$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Locator locator = (Locator)x$1;
            String string = this.group();
            String string2 = locator.group();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = locator.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.version() != locator.version()) return false;
            if (this.directory() != locator.directory()) return false;
            if (!locator.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Datastore org$allenai$datastore$Datastore$Locator$$$outer() {
            return this.$outer;
        }

        public Locator(Datastore $outer, String group, String name, int version, boolean directory) {
            this.group = group;
            this.name = name;
            this.version = version;
            this.directory = directory;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
            Predef$.MODULE$.require(!group.contains("/"));
            Predef$.MODULE$.require(!name.contains("/"));
            Predef$.MODULE$.require(version > 0);
        }
    }

    public class DoesNotExistException
    extends Exception {
        public /* synthetic */ Datastore org$allenai$datastore$Datastore$DoesNotExistException$$$outer() {
            return Datastore.this;
        }

        public DoesNotExistException(Locator locator, Throwable cause) {
            if (Datastore.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist in the ", " datastore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locator.org$allenai$datastore$Datastore$$s3key(), Datastore.this.name()})), cause);
        }
    }

    public class AlreadyExistsException
    extends Exception {
        public /* synthetic */ Datastore org$allenai$datastore$Datastore$AlreadyExistsException$$$outer() {
            return Datastore.this;
        }

        public AlreadyExistsException(Locator locator, Throwable cause) {
            if (Datastore.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already exists in the ", " datastore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locator.org$allenai$datastore$Datastore$$s3key(), Datastore.this.name()})), cause);
        }
    }
}

