/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.datastore;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import java.net.URI;
import org.allenai.datastore.Datastore;
import org.allenai.datastore.Datastore$Int$4$;
import org.allenai.datastore.DefaultS3$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.VolatileObjectRef;
import scala.util.matching.Regex;

public final class Datastore$
extends Datastore {
    public static final Datastore$ MODULE$;
    private final String defaultName;

    static {
        new Datastore$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$Int$4$ Int$2$lzycompute(VolatileObjectRef x$1) {
        Datastore$ datastore$ = this;
        synchronized (datastore$) {
            if (x$1.elem != null) return (Datastore$Int$4$)x$1.elem;
            x$1.elem = new Datastore$Int$4$();
            return (Datastore$Int$4$)x$1.elem;
        }
    }

    @Override
    public String defaultName() {
        return this.defaultName;
    }

    @Override
    public Datastore apply() {
        return this.apply(this.defaultName());
    }

    @Override
    public Datastore apply(String name) {
        return new Datastore(name, DefaultS3$.MODULE$);
    }

    @Override
    public Datastore apply(String accessKey, String secretAccessKey) {
        return this.apply(this.defaultName(), accessKey, secretAccessKey);
    }

    @Override
    public Datastore apply(String name, String accessKey, String secretAccessKey) {
        return new Datastore(name, new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey, secretAccessKey)));
    }

    @Override
    public Datastore.Locator locatorFromUrl(URI uri) {
        block2: {
            block6: {
                Datastore.Locator locator;
                block4: {
                    Option option;
                    String string;
                    Regex directory;
                    VolatileObjectRef Int$module;
                    block5: {
                        Option option2;
                        Regex fileWithoutExtension;
                        block3: {
                            String string2 = uri.getScheme();
                            String string3 = "datastore";
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            Int$module = VolatileObjectRef.zero();
                            Regex fileWithExtension = new StringOps(Predef$.MODULE$.augmentString("([^/]+)/(.+)-v(\\d+)\\.(.*)")).r();
                            fileWithoutExtension = new StringOps(Predef$.MODULE$.augmentString("([^/]+)/(.+)-v(\\d+)")).r();
                            directory = new StringOps(Predef$.MODULE$.augmentString("([^/]+)/(.+)-d(\\d+)")).r();
                            string = new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).stripPrefix("/");
                            Option option3 = fileWithExtension.unapplySeq((CharSequence)string);
                            if (option3.isEmpty() || option3.get() == null || ((LinearSeqOptimized)option3.get()).lengthCompare(4) != 0) break block3;
                            String group = (String)((LinearSeqOptimized)option3.get()).apply(0);
                            String name = (String)((LinearSeqOptimized)option3.get()).apply(1);
                            String string4 = (String)((LinearSeqOptimized)option3.get()).apply(2);
                            String ext = (String)((LinearSeqOptimized)option3.get()).apply(3);
                            Option<Object> option4 = this.Int$2(Int$module).unapply(string4);
                            if (option4.isEmpty()) break block3;
                            int version = BoxesRunTime.unboxToInt((Object)option4.get());
                            locator = this.datastore$1(uri).Locator().apply(group, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, ext})), version, false);
                            break block4;
                        }
                        if ((option2 = fileWithoutExtension.unapplySeq((CharSequence)string)).isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(3) != 0) break block5;
                        String group = (String)((LinearSeqOptimized)option2.get()).apply(0);
                        String name = (String)((LinearSeqOptimized)option2.get()).apply(1);
                        String string5 = (String)((LinearSeqOptimized)option2.get()).apply(2);
                        Option<Object> option5 = this.Int$2(Int$module).unapply(string5);
                        if (option5.isEmpty()) break block5;
                        int version = BoxesRunTime.unboxToInt((Object)option5.get());
                        locator = this.datastore$1(uri).Locator().apply(group, name, version, false);
                        break block4;
                    }
                    if ((option = directory.unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block6;
                    String group = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String name = (String)((LinearSeqOptimized)option.get()).apply(1);
                    String string6 = (String)((LinearSeqOptimized)option.get()).apply(2);
                    Option<Object> option6 = this.Int$2(Int$module).unapply(string6);
                    if (option6.isEmpty()) break block6;
                    int version = BoxesRunTime.unboxToInt((Object)option6.get());
                    locator = this.datastore$1(uri).Locator().apply(group, name, version, true);
                }
                return locator;
            }
            throw this.error$1(uri);
        }
        throw this.error$1(uri);
    }

    private final Nothing$ error$1(URI uri$1) {
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " cannot be parsed as a datastore URI"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri$1})));
    }

    private final Datastore$Int$4$ Int$2(VolatileObjectRef Int$module$2) {
        return Int$module$2.elem == null ? this.Int$2$lzycompute(Int$module$2) : (Datastore$Int$4$)Int$module$2.elem;
    }

    private final Datastore datastore$1(URI uri$1) {
        return this.apply(uri$1.getAuthority());
    }

    private Datastore$() {
        super("public", DefaultS3$.MODULE$);
        MODULE$ = this;
        this.defaultName = this.name();
    }
}

