/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.datastore;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.allenai.common.Logging;
import org.allenai.common.Logging$logger$;
import org.allenai.common.Resource$;
import org.allenai.datastore.Datastore$;
import org.allenai.datastore.Datastore$AlreadyExistsException$;
import org.allenai.datastore.Datastore$DoesNotExistException$;
import org.allenai.datastore.Datastore$Locator$;
import org.allenai.datastore.TempCleanup$;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011}a\u0001B\u0001\u0003\u0001%\u0011\u0011\u0002R1uCN$xN]3\u000b\u0005\r!\u0011!\u00033bi\u0006\u001cHo\u001c:f\u0015\t)a!A\u0004bY2,g.Y5\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0006\u0011!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0007G>lWn\u001c8\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005!a.Y7f+\u0005I\u0002C\u0001\u000e\u001e\u001d\tY1$\u0003\u0002\u001d\u0019\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\taB\u0002\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0015q\u0017-\\3!\u0011!\u0019\u0003A!b\u0001\n\u0003!\u0013AA:4+\u0005)\u0003C\u0001\u0014/\u001b\u00059#BA\u0012)\u0015\tI#&\u0001\u0005tKJ4\u0018nY3t\u0015\tYC&A\u0005b[\u0006TxN\\1xg*\tQ&A\u0002d_6L!aL\u0014\u0003\u001d\u0005k\u0017M_8o'N\u001aE.[3oi\"A\u0011\u0007\u0001B\u0001B\u0003%Q%A\u0002tg\u0001BQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtDcA\u001b8qA\u0011a\u0007A\u0007\u0002\u0005!)qC\ra\u00013!)1E\ra\u0001K!9!\b\u0001b\u0001\n\u0013Y\u0014\u0001\u00042bg\u0016\u001c\u0015m\u00195f\t&\u0014X#\u0001\u001f\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015\u0001\u00024jY\u0016T!!\u0011\"\u0002\u00079LwNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$\u0001\u0002)bi\"Daa\u0012\u0001!\u0002\u0013a\u0014!\u00042bg\u0016\u001c\u0015m\u00195f\t&\u0014\b\u0005C\u0004J\u0001\t\u0007I\u0011B\u001e\u0002\u0011\r\f7\r[3ESJDaa\u0013\u0001!\u0002\u0013a\u0014!C2bG\",G)\u001b:!\u0011\u001di\u0005A1A\u0005\nm\nq\u0001^3na\u0012K'\u000f\u0003\u0004P\u0001\u0001\u0006I\u0001P\u0001\ti\u0016l\u0007\u000fR5sA!)\u0011\u000b\u0001C\u00011\u0005Q!-^2lKRt\u0015-\\3\u0007\tM\u0003\u0001\t\u0016\u0002\b\u0019>\u001c\u0017\r^8s'\u0011\u0011&\"\u0016-\u0011\u0005-1\u0016BA,\r\u0005\u001d\u0001&o\u001c3vGR\u0004\"aC-\n\u0005ic!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003/S\u0005+\u0007I\u0011\u0001\r\u0002\u000b\u001d\u0014x.\u001e9\t\u0011y\u0013&\u0011#Q\u0001\ne\taa\u001a:pkB\u0004\u0003\u0002C\fS\u0005+\u0007I\u0011\u0001\r\t\u0011\u0005\u0012&\u0011#Q\u0001\neA\u0001B\u0019*\u0003\u0016\u0004%\taY\u0001\bm\u0016\u00148/[8o+\u0005!\u0007CA\u0006f\u0013\t1GBA\u0002J]RD\u0001\u0002\u001b*\u0003\u0012\u0003\u0006I\u0001Z\u0001\tm\u0016\u00148/[8oA!A!N\u0015BK\u0002\u0013\u00051.A\u0005eSJ,7\r^8ssV\tA\u000e\u0005\u0002\f[&\u0011a\u000e\u0004\u0002\b\u0005>|G.Z1o\u0011!\u0001(K!E!\u0002\u0013a\u0017A\u00033je\u0016\u001cGo\u001c:zA!)1G\u0015C\u0001eR)1/\u001e<xqB\u0011AOU\u0007\u0002\u0001!)A,\u001da\u00013!)q#\u001da\u00013!)!-\u001da\u0001I\")!.\u001da\u0001Y\")!P\u0015C\u0001w\u0005!\u0001/\u0019;i\u0011\u001da(+!A\u0005\u0002u\fAaY8qsR91O`@\u0002\u0002\u0005\r\u0001b\u0002/|!\u0003\u0005\r!\u0007\u0005\b/m\u0004\n\u00111\u0001\u001a\u0011\u001d\u00117\u0010%AA\u0002\u0011DqA[>\u0011\u0002\u0003\u0007A\u000eC\u0005\u0002\bI\u000b\n\u0011\"\u0001\u0002\n\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0006U\rI\u0012QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0004\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005M!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u0005*\u0012\u0002\u0013\u0005\u0011\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)CUI\u0001\n\u0003\t9#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%\"f\u00013\u0002\u000e!I\u0011Q\u0006*\u0012\u0002\u0013\u0005\u0011qF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tDK\u0002m\u0003\u001bA\u0011\"!\u000eS\u0003\u0003%\t%a\u000e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tyDQ\u0001\u0005Y\u0006tw-C\u0002\u001f\u0003{A\u0001\"!\u0012S\u0003\u0003%\taY\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003\u0013\u0012\u0016\u0011!C\u0001\u0003\u0017\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u0005M\u0003cA\u0006\u0002P%\u0019\u0011\u0011\u000b\u0007\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002V\u0005\u001d\u0013\u0011!a\u0001I\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005e#+!A\u0005B\u0005m\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0003CBA0\u0003K\ni%\u0004\u0002\u0002b)\u0019\u00111\r\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002h\u0005\u0005$\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-$+!A\u0005\u0002\u00055\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\u00071\fy\u0007\u0003\u0006\u0002V\u0005%\u0014\u0011!a\u0001\u0003\u001bB\u0011\"a\u001dS\u0003\u0003%\t%!\u001e\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u001a\u0005\n\u0003s\u0012\u0016\u0011!C!\u0003w\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003sA\u0011\"a S\u0003\u0003%\t%!!\u0002\r\u0015\fX/\u00197t)\ra\u00171\u0011\u0005\u000b\u0003+\ni(!AA\u0002\u00055\u0003bCAD%\n\u0005\t\u0011!C\u0001\u0001a\t\u0001g\u001c:hI\u0005dG.\u001a8bS\u0012\"\u0017\r^1ti>\u0014X\r\n#bi\u0006\u001cHo\u001c:fI\u0011r\u0017-\\3XSRDg+\u001a:tS>t\u0007bCAF%\n\u0005\t\u0011!C\u0001\u0001a\tae\u001c:hI\u0005dG.\u001a8bS\u0012\"\u0017\r^1ti>\u0014X\r\n#bi\u0006\u001cHo\u001c:fI\u0011\u001a8g[3z\u0011-\tyI\u0015B\u0001\u0002\u0003%\t\u0001\u0001\r\u0002]=\u0014x\rJ1mY\u0016t\u0017-\u001b\u0013eCR\f7\u000f^8sK\u0012\"\u0015\r^1ti>\u0014X\r\n\u0013m_\u000e\fGnQ1dQ\u0016\\U-\u001f\u0005\f\u0003'\u0013&\u0011!A\u0001\n\u0003\u0001\u0001$\u0001\u001ape\u001e$\u0013\r\u001c7f]\u0006LG\u0005Z1uCN$xN]3%\t\u0006$\u0018m\u001d;pe\u0016$CE\u001a7bi2{7-\u00197DC\u000eDWmS3z\u0011-\t9J\u0015B\u0001\u0002\u0003%\t\u0001A\u001e\u0002_=\u0014x\rJ1mY\u0016t\u0017-\u001b\u0013eCR\f7\u000f^8sK\u0012\"\u0015\r^1ti>\u0014X\r\n\u0013m_\u000e\fGnQ1dQ\u0016\u0004\u0016\r\u001e5\t\u0017\u0005m%K!A\u0001\u0002\u0013\u0005\u0001aO\u0001._J<G%\u00197mK:\f\u0017\u000e\n3bi\u0006\u001cHo\u001c:fI\u0011\u000bG/Y:u_J,G\u0005\n7pG.4\u0017\u000e\\3QCRDwaBAP\u0001!\u0005\u0011\u0011U\u0001\b\u0019>\u001c\u0017\r^8s!\r!\u00181\u0015\u0004\u0007'\u0002A\t!!*\u0014\t\u0005\r&\u0002\u0017\u0005\bg\u0005\rF\u0011AAU)\t\t\t\u000b\u0003\u0006\u0002.\u0006\r&\u0019!C\u0002\u0003_\u000bq\u0002Z3gCVdGo\u0014:eKJLgnZ\u000b\u0003\u0003c\u0013b!a-\u0002<\u0006\u0005gaBA[\u0003o\u0003\u0011\u0011\u0017\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\n\u0003s\u000b\u0019\u000b)A\u0005\u0003c\u000b\u0001\u0003Z3gCVdGo\u0014:eKJLgn\u001a\u0011\u0011\t\u0005m\u0012QX\u0005\u0005\u0003\u007f\u000biD\u0001\u0004PE*,7\r\u001e\t\u0006\u0003\u0007\f\u0019n\u001d\b\u0005\u0003\u000b\fyM\u0004\u0003\u0002H\u00065WBAAe\u0015\r\tY\rC\u0001\u0007yI|w\u000e\u001e \n\u00035I1!!5\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!!6\u0002X\nAqJ\u001d3fe&twMC\u0002\u0002R2A\u0011\"a7\u0002$\u0012\u0005\u0001!!8\u0002\u000f\u0019\u0014x.\\&fsR\u00191/a8\t\u000f\u0005\u0005\u0018\u0011\u001ca\u00013\u0005\u00191.Z=\t\u0015\u0005\u0015\u00181UA\u0001\n\u0003\u000b9/A\u0003baBd\u0017\u0010F\u0005t\u0003S\fY/!<\u0002p\"1A,a9A\u0002eAaaFAr\u0001\u0004I\u0002B\u00022\u0002d\u0002\u0007A\r\u0003\u0004k\u0003G\u0004\r\u0001\u001c\u0005\u000b\u0003g\f\u0019+!A\u0005\u0002\u0006U\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u0014\u0019\u0001E\u0003\f\u0003s\fi0C\u0002\u0002|2\u0011aa\u00149uS>t\u0007cB\u0006\u0002\u0000fIB\r\\\u0005\u0004\u0005\u0003a!A\u0002+va2,G\u0007C\u0005\u0003\u0006\u0005E\u0018\u0011!a\u0001g\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t%\u00111UA\u0001\n\u0013\u0011Y!A\u0006sK\u0006$'+Z:pYZ,GCAA^\r\u0019\u0011y\u0001\u0001\u0001\u0003\u0012\t)Bi\\3t\u001d>$X\t_5ti\u0016C8-\u001a9uS>t7\u0003\u0002B\u0007\u0005'\u0001B!a1\u0003\u0016%!!qCAl\u0005%)\u0005pY3qi&|g\u000e\u0003\u0006\u0003\u001c\t5!\u0011!Q\u0001\nM\fq\u0001\\8dCR|'\u000fC\u0006\u0003 \t5!\u0011!Q\u0001\n\t\u0005\u0012!B2bkN,\u0007\u0003BAb\u0005GIAA!\n\u0002X\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\bg\t5A\u0011\u0001B\u0015)\u0019\u0011YC!\f\u00030A\u0019AO!\u0004\t\u000f\tm!q\u0005a\u0001g\"Q!q\u0004B\u0014!\u0003\u0005\rA!\t\b\u0013\tM\u0002!!A\t\u0002\tU\u0012!\u0006#pKNtu\u000e^#ySN$X\t_2faRLwN\u001c\t\u0004i\n]b!\u0003B\b\u0001\u0005\u0005\t\u0012\u0001B\u001d'\u0011\u00119D\u0003-\t\u000fM\u00129\u0004\"\u0001\u0003>Q\u0011!Q\u0007\u0005\u000b\u0005\u0003\u00129$%A\u0005\u0002\t\r\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003F)\"!\u0011EA\u0007\u0011)\u0011IAa\u000e\u0002\u0002\u0013%!1\u0002\u0004\u0007\u0005\u0017\u0002\u0001A!\u0014\u0003-\u0005c'/Z1es\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:\u001cBA!\u0013\u0003\u0014!Q!1\u0004B%\u0005\u0003\u0005\u000b\u0011B:\t\u0017\t}!\u0011\nB\u0001B\u0003%!\u0011\u0005\u0005\bg\t%C\u0011\u0001B+)\u0019\u00119F!\u0017\u0003\\A\u0019AO!\u0013\t\u000f\tm!1\u000ba\u0001g\"Q!q\u0004B*!\u0003\u0005\rA!\t\b\u0013\t}\u0003!!A\t\u0002\t\u0005\u0014AF!me\u0016\fG-_#ySN$8/\u0012=dKB$\u0018n\u001c8\u0011\u0007Q\u0014\u0019GB\u0005\u0003L\u0001\t\t\u0011#\u0001\u0003fM!!1\r\u0006Y\u0011\u001d\u0019$1\rC\u0001\u0005S\"\"A!\u0019\t\u0015\t\u0005#1MI\u0001\n\u0003\u0011\u0019\u0005\u0003\u0006\u0003\n\t\r\u0014\u0011!C\u0005\u0005\u0017AqA!\u001d\u0001\t\u0013\u0011\u0019(A\u0006hKR\u001c6g\u00142kK\u000e$H\u0003\u0002B;\u0005\u0003\u0003BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0004\u0005w\u0012\u0015AA5p\u0013\u0011\u0011yH!\u001f\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003C\u0014y\u00071\u0001\u001a\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f\u000bqb^1ji\u001a{'\u000fT8dW\u001aLG.\u001a\u000b\u0005\u0005\u0013\u0013y\tE\u0002\f\u0005\u0017K1A!$\r\u0005\u0011)f.\u001b;\t\u000f\tE%1\u0011a\u0001y\u0005AAn\\2lM&dW\rC\u0004\u0003\u0016\u0002!IAa&\u0002\u001bQ\u0014\u0018p\u0011:fCR,g)\u001b7f)\ra'\u0011\u0014\u0005\u0007\u007f\tM\u0005\u0019\u0001\u001f\t\u000f\tu\u0005\u0001\"\u0003\u0003 \u0006Yam\u001c:nCR\u0014\u0015\u0010^3t)\rI\"\u0011\u0015\u0005\t\u0005G\u0013Y\n1\u0001\u0003&\u0006)!-\u001f;fgB\u00191Ba*\n\u0007\t%FB\u0001\u0003M_:<\u0007b\u0002BW\u0001\u0011%!qV\u0001\fG>\u0004\u0018p\u0015;sK\u0006l7\u000f\u0006\u0006\u0003\n\nE&\u0011\u0019Bf\u0005\u001fD\u0001Ba-\u0003,\u0002\u0007!QW\u0001\u0003S\u000e\u0004BAa.\u0003>6\u0011!\u0011\u0018\u0006\u0004\u0005w\u0003\u0015\u0001C2iC:tW\r\\:\n\t\t}&\u0011\u0018\u0002\u0014%\u0016\fG-\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\t\u0005\u0007\u0014Y\u000b1\u0001\u0003F\u0006\u0011qn\u0019\t\u0005\u0005o\u00139-\u0003\u0003\u0003J\ne&aE,sSR\f'\r\\3CsR,7\t[1o]\u0016d\u0007b\u0002Bg\u0005W\u0003\r!G\u0001\tM&dWM\\1nK\"I!\u0011\u001bBV!\u0003\u0005\r\u0001\\\u0001\u0007g&dWM\u001c;\t\u000f\tU\u0007\u0001\"\u0001\u0003X\u0006Aa-\u001b7f!\u0006$\b\u000eF\u0004=\u00053\u0014YN!8\t\rq\u0013\u0019\u000e1\u0001\u001a\u0011\u00199\"1\u001ba\u00013!1!Ma5A\u0002\u0011DqA!9\u0001\t\u0003\u0011\u0019/A\u0007eSJ,7\r^8ssB\u000bG\u000f\u001b\u000b\by\t\u0015(q\u001dBu\u0011\u0019a&q\u001ca\u00013!1qCa8A\u0002eAaA\u0019Bp\u0001\u0004!\u0007B\u0002>\u0001\t\u0003\u0011i\u000fF\u0002=\u0005_DqAa\u0007\u0003l\u0002\u00071\u000fC\u0004\u0003t\u0002!IA!>\u0002\u001f5,H\u000e^5qCJ$X\u000b\u001d7pC\u0012$bA!#\u0003x\ne\bB\u0002>\u0003r\u0002\u0007A\bC\u0004\u0003\u001c\tE\b\u0019A:\t\u000f\tu\b\u0001\"\u0001\u0003\u0000\u0006Y\u0001/\u001e2mSNDg)\u001b7f)1\u0011Ii!\u0001\u0004\u0004\r\u00151qAB\u0005\u0011\u0019y$1 a\u00013!1ALa?A\u0002eAaa\u0006B~\u0001\u0004I\u0002B\u00022\u0003|\u0002\u0007A\rC\u0004\u0004\f\tm\b\u0019\u00017\u0002\u0013=4XM]<sSR,\u0007b\u0002B\u007f\u0001\u0011\u00051q\u0002\u000b\r\u0005\u0013\u001b\tba\u0005\u0004\u0016\r]1\u0011\u0004\u0005\u0007\u007f\r5\u0001\u0019\u0001\u001f\t\rq\u001bi\u00011\u0001\u001a\u0011\u001992Q\u0002a\u00013!1!m!\u0004A\u0002\u0011Dqaa\u0003\u0004\u000e\u0001\u0007A\u000eC\u0004\u0004\u001e\u0001!\taa\b\u0002!A,(\r\\5tQ\u0012K'/Z2u_JLH\u0003\u0004BE\u0007C\u0019\u0019c!\n\u0004(\r%\u0002B\u0002>\u0004\u001c\u0001\u0007\u0011\u0004\u0003\u0004]\u00077\u0001\r!\u0007\u0005\u0007/\rm\u0001\u0019A\r\t\r\t\u001cY\u00021\u0001e\u0011\u001d\u0019Yaa\u0007A\u00021Dqa!\b\u0001\t\u0003\u0019i\u0003\u0006\u0007\u0003\n\u000e=2\u0011GB\u001a\u0007k\u00199\u0004\u0003\u0004{\u0007W\u0001\r\u0001\u0010\u0005\u00079\u000e-\u0002\u0019A\r\t\r]\u0019Y\u00031\u0001\u001a\u0011\u0019\u001171\u0006a\u0001I\"911BB\u0016\u0001\u0004a\u0007bBB\u001e\u0001\u0011\u00051QH\u0001\baV\u0014G.[:i)!\u0011Iia\u0010\u0004B\r\r\u0003B\u0002>\u0004:\u0001\u0007A\bC\u0004\u0003\u001c\re\u0002\u0019A:\t\u000f\r-1\u0011\ba\u0001Y\"91q\t\u0001\u0005\u0002\r%\u0013A\u00034jY\u0016,\u00050[:ugR9Ana\u0013\u0004N\r=\u0003B\u0002/\u0004F\u0001\u0007\u0011\u0004\u0003\u0004\u0018\u0007\u000b\u0002\r!\u0007\u0005\u0007E\u000e\u0015\u0003\u0019\u00013\t\u000f\rM\u0003\u0001\"\u0001\u0004V\u0005yA-\u001b:fGR|'/_#ySN$8\u000fF\u0004m\u0007/\u001aIfa\u0017\t\rq\u001b\t\u00061\u0001\u001a\u0011\u001992\u0011\u000ba\u00013!1!m!\u0015A\u0002\u0011Dqaa\u0018\u0001\t\u0003\u0019\t'\u0001\u0004fq&\u001cHo\u001d\u000b\u0004Y\u000e\r\u0004b\u0002B\u000e\u0007;\u0002\ra\u001d\u0005\b\u0007O\u0002A\u0011BB5\u000399W\r^!mY2K7\u000f^5oON$Baa\u001b\u0004~A1\u00111YB7\u0007cJAaa\u001c\u0002X\n\u00191+Z9\u0011\t\rM4\u0011P\u0007\u0003\u0007kR1aa\u001e(\u0003\u0015iw\u000eZ3m\u0013\u0011\u0019Yh!\u001e\u0003\u001b=\u0013'.Z2u\u0019&\u001cH/\u001b8h\u0011!\u0019yh!\u001aA\u0002\r\u0005\u0015a\u0002:fcV,7\u000f\u001e\t\u0005\u0007g\u001a\u0019)\u0003\u0003\u0004\u0006\u000eU$A\u0005'jgR|%M[3diN\u0014V-];fgRDqa!#\u0001\t\u0003\u0019Y)\u0001\u0006mSN$xI]8vaN,\"a!$\u0011\u000b\u0005}3qR\r\n\t\rE\u0015\u0011\r\u0002\n'>\u0014H/\u001a3TKRDqa!&\u0001\t\u0003\u00199*A\tmSN$xI]8va\u000e{g\u000e^3oiN$Ba!'\u0004\u001cB)\u0011qLBHg\"1Ala%A\u0002eAqaa(\u0001\t\u0003\u0019\t+A\u0004gS2,WK\u001d7\u0015\u0011\r\r6qVBY\u0007g\u0003Ba!*\u0004,6\u00111q\u0015\u0006\u0004\u0007S\u0013\u0015a\u00018fi&!1QVBT\u0005\r)&\u000b\u0014\u0005\u00079\u000eu\u0005\u0019A\r\t\r]\u0019i\n1\u0001\u001a\u0011\u0019\u00117Q\u0014a\u0001I\"91q\u0017\u0001\u0005\u0002\re\u0016\u0001\u00043je\u0016\u001cGo\u001c:z+JdG\u0003CBR\u0007w\u001bila0\t\rq\u001b)\f1\u0001\u001a\u0011\u001992Q\u0017a\u00013!1!m!.A\u0002\u0011Dqaa1\u0001\t\u0003\u0019)-A\u0002ve2$Baa)\u0004H\"9!1DBa\u0001\u0004\u0019\bbBBf\u0001\u0011\u00051QZ\u0001\no&\u0004XmQ1dQ\u0016$\"A!#\t\u000f\rE\u0007\u0001\"\u0001\u0004N\u000692M]3bi\u0016\u0014UoY6fi&3gj\u001c;Fq&\u001cHo\u001d\u0005\n\u0007+\u0004\u0011\u0013!C\u0005\u0003_\tQcY8qsN#(/Z1ng\u0012\"WMZ1vYR$CgB\u0004\u0004Z\nA\taa7\u0002\u0013\u0011\u000bG/Y:u_J,\u0007c\u0001\u001c\u0004^\u001a1\u0011A\u0001E\u0001\u0007?\u001c2a!86\u0011\u001d\u00194Q\u001cC\u0001\u0007G$\"aa7\t\u0013\r\u001d8Q\u001cb\u0001\n\u0003A\u0012a\u00033fM\u0006,H\u000e\u001e(b[\u0016D\u0001ba;\u0004^\u0002\u0006I!G\u0001\rI\u00164\u0017-\u001e7u\u001d\u0006lW\r\t\u0005\t\u0003K\u001ci\u000e\"\u0001\u0004pR\tQ\u0007\u0003\u0005\u0002f\u000euG\u0011ABz)\r)4Q\u001f\u0005\u0007/\rE\b\u0019A\r\t\u0011\u0005\u00158Q\u001cC\u0001\u0007s$R!NB~\u0007\u007fDqa!@\u0004x\u0002\u0007\u0011$A\u0005bG\u000e,7o]&fs\"9A\u0011AB|\u0001\u0004I\u0012aD:fGJ,G/Q2dKN\u001c8*Z=\t\u0011\u0005\u00158Q\u001cC\u0001\t\u000b!r!\u000eC\u0004\t\u0013!Y\u0001\u0003\u0004\u0018\t\u0007\u0001\r!\u0007\u0005\b\u0007{$\u0019\u00011\u0001\u001a\u0011\u001d!\t\u0001b\u0001A\u0002eA\u0001\u0002b\u0004\u0004^\u0012\u0005A\u0011C\u0001\u000fY>\u001c\u0017\r^8s\rJ|W.\u0016:m)\u0011!\u0019\u0002\"\u0006\u0011\u0005U\u0012\u0006\u0002\u0003C\f\t\u001b\u0001\r\u0001\"\u0007\u0002\u0007U\u0014\u0018\u000e\u0005\u0003\u0004&\u0012m\u0011\u0002\u0002C\u000f\u0007O\u00131!\u0016*J\u0001")
public class Datastore
implements Logging {
    private final String name;
    private final AmazonS3Client s3;
    private final Path baseCacheDir;
    private final Path org$allenai$datastore$Datastore$$cacheDir;
    private final Path tempDir;
    private volatile Datastore$Locator$ Locator$module;
    private volatile Datastore$DoesNotExistException$ DoesNotExistException$module;
    private volatile Datastore$AlreadyExistsException$ AlreadyExistsException$module;
    private final Logger internalLogger;
    private volatile Logging$logger$ logger$module;

    public static Locator locatorFromUrl(URI uRI) {
        return Datastore$.MODULE$.locatorFromUrl(uRI);
    }

    public static Datastore apply(String string, String string2, String string3) {
        return Datastore$.MODULE$.apply(string, string2, string3);
    }

    public static Datastore apply(String string, String string2) {
        return Datastore$.MODULE$.apply(string, string2);
    }

    public static Datastore apply(String string) {
        return Datastore$.MODULE$.apply(string);
    }

    public static Datastore apply() {
        return Datastore$.MODULE$.apply();
    }

    public static String defaultName() {
        return Datastore$.MODULE$.defaultName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$Locator$ Locator$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.Locator$module != null) return this.Locator$module;
            this.Locator$module = new Datastore$Locator$(this);
            return this.Locator$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$DoesNotExistException$ DoesNotExistException$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.DoesNotExistException$module != null) return this.DoesNotExistException$module;
            this.DoesNotExistException$module = new Datastore$DoesNotExistException$(this);
            return this.DoesNotExistException$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Datastore$AlreadyExistsException$ AlreadyExistsException$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.AlreadyExistsException$module != null) return this.AlreadyExistsException$module;
            this.AlreadyExistsException$module = new Datastore$AlreadyExistsException$(this);
            return this.AlreadyExistsException$module;
        }
    }

    public Logger internalLogger() {
        return this.internalLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging$logger$ logger$lzycompute() {
        Datastore datastore = this;
        synchronized (datastore) {
            if (this.logger$module != null) return this.logger$module;
            this.logger$module = new Logging$logger$((Logging)this);
            return this.logger$module;
        }
    }

    public Logging$logger$ logger() {
        return this.logger$module == null ? this.logger$lzycompute() : this.logger$module;
    }

    public void org$allenai$common$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public String name() {
        return this.name;
    }

    public AmazonS3Client s3() {
        return this.s3;
    }

    private Path baseCacheDir() {
        return this.baseCacheDir;
    }

    public Path org$allenai$datastore$Datastore$$cacheDir() {
        return this.org$allenai$datastore$Datastore$$cacheDir;
    }

    private Path tempDir() {
        return this.tempDir;
    }

    public String bucketName() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".store.dev.allenai.org"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()}));
    }

    public Datastore$Locator$ Locator() {
        return this.Locator$module == null ? this.Locator$lzycompute() : this.Locator$module;
    }

    public Datastore$DoesNotExistException$ DoesNotExistException() {
        return this.DoesNotExistException$module == null ? this.DoesNotExistException$lzycompute() : this.DoesNotExistException$module;
    }

    public Datastore$AlreadyExistsException$ AlreadyExistsException() {
        return this.AlreadyExistsException$module == null ? this.AlreadyExistsException$lzycompute() : this.AlreadyExistsException$module;
    }

    private InputStream getS3Object(String key) {
        return this.s3().getObject(this.bucketName(), key).getObjectContent();
    }

    private void waitForLockfile(Path lockfile) {
        long start = System.currentTimeMillis();
        while (Files.exists(lockfile, new LinkOption[0])) {
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for lockfile at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lockfile}));
            if (System.currentTimeMillis() - start > 60000L) {
                this.logger().warn((Function0)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            } else {
                this.logger().info((Function0)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            }
            int oneSecond = 1000;
            Thread.sleep(oneSecond);
        }
    }

    private boolean tryCreateFile(Path file) {
        boolean bl;
        try {
            Files.createFile(file, new FileAttribute[0]);
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    public String org$allenai$datastore$Datastore$$formatBytes(long bytes) {
        double orderOfMagnitude = Math.floor(Math.log(Math.max(1L, bytes)) / Math.log(1024.0));
        double bytesInUnit = (double)bytes / Math.pow(1024.0, orderOfMagnitude);
        String formattedNumber = bytesInUnit < (double)10 ? new StringOps(Predef$.MODULE$.augmentString("%.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})) : (bytesInUnit < (double)100 ? new StringOps(Predef$.MODULE$.augmentString("%.1f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})) : new StringOps(Predef$.MODULE$.augmentString("%.0f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)bytesInUnit)})));
        String[] units = (String[])((Object[])new String[]{"B", "KB", "MB", "GB", "TB", "PB"});
        String unit = units[Math.min((int)orderOfMagnitude, units.length)];
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedNumber, unit}));
    }

    public void org$allenai$datastore$Datastore$$copyStreams(ReadableByteChannel ic, WritableByteChannel oc, String filename, boolean silent) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
        int loggingDelay = 1000;
        long startTime = System.currentTimeMillis();
        LongRef lastLogMessage = LongRef.create((long)startTime);
        LongRef bytesCopied = LongRef.create((long)0L);
        while (ic.read(buffer) >= 0) {
            bytesCopied.elem += (long)buffer.position();
            buffer.flip();
            oc.write(buffer);
            buffer.compact();
            bytesCopied.elem -= (long)buffer.position();
            if (!this.shouldLog$1(silent, loggingDelay, lastLogMessage)) continue;
            this.logger().info((Function0)new Serializable(this, filename, bytesCopied){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Datastore $outer;
                private final String filename$1;
                private final LongRef bytesCopied$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading ", " from the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filename$1, this.$outer.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes read."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$formatBytes(this.bytesCopied$1.elem)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filename$1 = filename$1;
                    this.bytesCopied$1 = bytesCopied$1;
                }
            });
            lastLogMessage.elem = System.currentTimeMillis();
        }
        buffer.flip();
        bytesCopied.elem += (long)buffer.remaining();
        while (buffer.hasRemaining()) {
            oc.write(buffer);
        }
        if (!silent && System.currentTimeMillis() - startTime >= (long)loggingDelay) {
            this.logger().info((Function0)new Serializable(this, filename, bytesCopied){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Datastore $outer;
                private final String filename$1;
                private final LongRef bytesCopied$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloaded ", " from the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filename$1, this.$outer.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes read."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$formatBytes(this.bytesCopied$1.elem)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filename$1 = filename$1;
                    this.bytesCopied$1 = bytesCopied$1;
                }
            });
        }
    }

    public boolean org$allenai$datastore$Datastore$$copyStreams$default$4() {
        return false;
    }

    public Path filePath(String group, String name, int version) {
        return this.path(new Locator(this, group, name, version, false));
    }

    public Path directoryPath(String group, String name, int version) {
        return this.path(new Locator(this, group, name, version, true));
    }

    /*
     * Loose catch block
     */
    public Path path(Locator locator) {
        Path path2;
        Files.createDirectories(this.org$allenai$datastore$Datastore$$cacheDir(), new FileAttribute[0]);
        Files.createDirectories(locator.org$allenai$datastore$Datastore$$lockfilePath().getParent(), new FileAttribute[0]);
        this.waitForLockfile(locator.org$allenai$datastore$Datastore$$lockfilePath());
        if (locator.directory() && Files.isDirectory(locator.org$allenai$datastore$Datastore$$localCachePath(), new LinkOption[0]) || !locator.directory() && Files.isRegularFile(locator.org$allenai$datastore$Datastore$$localCachePath(), new LinkOption[0])) {
            path2 = locator.org$allenai$datastore$Datastore$$localCachePath();
        } else {
            boolean created = this.tryCreateFile(locator.org$allenai$datastore$Datastore$$lockfilePath());
            if (created) {
                TempCleanup$.MODULE$.remember(locator.org$allenai$datastore$Datastore$$lockfilePath());
                Path tempFile = Files.createTempFile(this.tempDir(), new StringBuilder().append((Object)"ai2-datastore-").append((Object)locator.org$allenai$datastore$Datastore$$flatLocalCacheKey()).toString(), ".tmp", new FileAttribute[0]);
                TempCleanup$.MODULE$.remember(tempFile);
                Resource$.MODULE$.using2((Object)Channels.newChannel(this.getS3Object(locator.org$allenai$datastore$Datastore$$s3key())), (Object)Files.newByteChannel(tempFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), (Function2)new Serializable(this, locator){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Datastore $outer;
                    private final Locator locator$1;

                    public final void apply(ReadableByteChannel x0$1, SeekableByteChannel x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            ReadableByteChannel input = (ReadableByteChannel)tuple2._1();
                            SeekableByteChannel output = (SeekableByteChannel)tuple2._2();
                            this.$outer.org$allenai$datastore$Datastore$$copyStreams(input, output, this.locator$1.org$allenai$datastore$Datastore$$s3key(), this.$outer.org$allenai$datastore$Datastore$$copyStreams$default$4());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.locator$1 = locator$1;
                    }
                });
                if (locator.directory()) {
                    Path tempZipDir = Files.createTempDirectory(this.tempDir(), new StringBuilder().append((Object)"ai2-datastore-").append((Object)locator.org$allenai$datastore$Datastore$$flatLocalCacheKey()).toString(), new FileAttribute[0]);
                    TempCleanup$.MODULE$.remember(tempZipDir);
                    Resource$.MODULE$.using((Object)new ZipFile(tempFile.toFile()), (Function1)new Serializable(this, locator, tempZipDir){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Datastore $outer;
                        public final Locator locator$1;
                        private final Path tempZipDir$1;

                        public final void apply(ZipFile zipFile) {
                            Enumeration<? extends ZipEntry> entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                Object object;
                                ZipEntry entry = entries.nextElement();
                                String string = entry.getName();
                                String string2 = "/";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    object = BoxedUnit.UNIT;
                                    continue;
                                }
                                Path pathForEntry = this.tempZipDir$1.resolve(entry.getName());
                                if (entry.isDirectory()) {
                                    object = Files.createDirectories(pathForEntry, new FileAttribute[0]);
                                    continue;
                                }
                                Files.createDirectories(pathForEntry.getParent(), new FileAttribute[0]);
                                object = Resource$.MODULE$.using2((Object)Channels.newChannel(zipFile.getInputStream(entry)), (Object)Files.newByteChannel(pathForEntry, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$path$2 $outer;

                                    public final void apply(ReadableByteChannel x0$2, SeekableByteChannel x1$2) {
                                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                                        if (tuple2 != null) {
                                            ReadableByteChannel input = (ReadableByteChannel)tuple2._1();
                                            SeekableByteChannel output = (SeekableByteChannel)tuple2._2();
                                            this.$outer.org$allenai$datastore$Datastore$$anonfun$$$outer().org$allenai$datastore$Datastore$$copyStreams(input, output, this.$outer.locator$1.org$allenai$datastore$Datastore$$s3key(), true);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError((Object)tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                        }

                        public /* synthetic */ Datastore org$allenai$datastore$Datastore$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.locator$1 = locator$1;
                            this.tempZipDir$1 = tempZipDir$1;
                        }
                    });
                    Files.delete(tempFile);
                    TempCleanup$.MODULE$.forget(tempFile);
                    Files.move(tempZipDir, locator.org$allenai$datastore$Datastore$$localCachePath(), new CopyOption[0]);
                    TempCleanup$.MODULE$.forget(tempZipDir);
                } else {
                    Files.createDirectories(locator.org$allenai$datastore$Datastore$$localCachePath().getParent(), new FileAttribute[0]);
                    Files.move(tempFile, locator.org$allenai$datastore$Datastore$$localCachePath(), new CopyOption[0]);
                    TempCleanup$.MODULE$.forget(tempFile);
                }
                path2 = locator.org$allenai$datastore$Datastore$$localCachePath();
            } else {
                path2 = this.path(locator);
            }
        }
        return path2;
        {
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AmazonS3Exception) {
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)throwable2;
                    String string = amazonS3Exception.getErrorCode();
                    String string2 = "NoSuchKey";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw new DoesNotExistException(locator, (Throwable)amazonS3Exception);
                    }
                }
                throw throwable;
            }
        }
        finally {
            Files.delete(locator.org$allenai$datastore$Datastore$$lockfilePath());
            TempCleanup$.MODULE$.forget(locator.org$allenai$datastore$Datastore$$lockfilePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void multipartUpload(Path path2, Locator locator) {
        TransferManager tm = new TransferManager((AmazonS3)this.s3());
        try {
            PutObjectRequest request = new PutObjectRequest(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key(), path2.toFile());
            request.setGeneralProgressListener(new ProgressListener(this, path2){
                private long lastLogMessage;
                private final /* synthetic */ Datastore $outer;
                public final Path path$1;

                private long lastLogMessage() {
                    return this.lastLogMessage;
                }

                private void lastLogMessage_$eq(long x$1) {
                    this.lastLogMessage = x$1;
                }

                public void progressChanged(ProgressEvent progressEvent) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastLogMessage() >= 1000L) {
                        this.$outer.logger().info((Function0)new Serializable(this, progressEvent){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$3 $outer;
                            private final ProgressEvent progressEvent$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploading ", " to the ", " datastore. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.path$1, this.$outer.org$allenai$datastore$Datastore$$anon$$$outer().name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " bytes written."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$allenai$datastore$Datastore$$anon$$$outer().org$allenai$datastore$Datastore$$formatBytes(this.progressEvent$1.getBytesTransferred())}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.progressEvent$1 = progressEvent$1;
                            }
                        });
                        this.lastLogMessage_$eq(now);
                    }
                }

                public /* synthetic */ Datastore org$allenai$datastore$Datastore$$anon$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.path$1 = path$1;
                    this.lastLogMessage = System.currentTimeMillis();
                }
            });
            tm.upload(request).waitForCompletion();
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.shutdownNow(false);
            throw throwable;
        }
        tm.shutdownNow(false);
    }

    public void publishFile(String file, String group, String name, int version, boolean overwrite) {
        this.publishFile(Paths.get(file, new String[0]), group, name, version, overwrite);
    }

    public void publishFile(Path file, String group, String name, int version, boolean overwrite) {
        this.publish(file, new Locator(this, group, name, version, false), overwrite);
    }

    public void publishDirectory(String path2, String group, String name, int version, boolean overwrite) {
        this.publishDirectory(Paths.get(path2, new String[0]), group, name, version, overwrite);
    }

    public void publishDirectory(Path path2, String group, String name, int version, boolean overwrite) {
        this.publish(path2, new Locator(this, group, name, version, true), overwrite);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(Path path2, Locator locator, boolean overwrite) {
        if (!overwrite && this.exists(locator)) {
            throw new AlreadyExistsException(locator, this.AlreadyExistsException().$lessinit$greater$default$2());
        }
        if (!locator.directory()) {
            this.multipartUpload(path2, locator);
            return;
        }
        Path zipFile = Files.createTempFile(this.tempDir(), locator.org$allenai$datastore$Datastore$$flatLocalCacheKey(), ".ai2-datastore.upload.zip", new FileAttribute[0]);
        TempCleanup$.MODULE$.remember(zipFile);
        try {
            Resource$.MODULE$.using((Object)new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])), (Function1)new Serializable(this, path2){
                public static final long serialVersionUID = 0L;
                public final Path path$2;

                public final Path apply(ZipOutputStream zip) {
                    return Files.walkFileTree(this.path$2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, zip){
                        private final /* synthetic */ $anonfun$publish$1 $outer;
                        private final ZipOutputStream zip$1;

                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            this.zip$1.putNextEntry(new ZipEntry(((Object)this.$outer.path$2.relativize(file)).toString()));
                            Files.copy(file, this.zip$1);
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                            Path path2 = dir;
                            Path path3 = this.$outer.path$2;
                            if (path2 == null ? path3 != null : !((Object)path2).equals(path3)) {
                                this.zip$1.putNextEntry(new ZipEntry(new StringBuilder().append((Object)((Object)this.$outer.path$2.relativize(dir)).toString()).append((Object)"/").toString()));
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.zip$1 = zip$1;
                        }
                    });
                }
                {
                    this.path$2 = path$2;
                }
            });
            this.multipartUpload(zipFile, locator);
        }
        catch (Throwable throwable) {
            void var4_4;
            Files.deleteIfExists((Path)var4_4);
            TempCleanup$.MODULE$.forget((Path)var4_4);
            throw throwable;
        }
        Files.deleteIfExists(zipFile);
        TempCleanup$.MODULE$.forget(zipFile);
    }

    public boolean fileExists(String group, String name, int version) {
        return this.exists(new Locator(this, group, name, version, false));
    }

    public boolean directoryExists(String group, String name, int version) {
        return this.exists(new Locator(this, group, name, version, true));
    }

    public boolean exists(Locator locator) {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                this.s3().getObjectMetadata(this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key());
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                AmazonServiceException amazonServiceException;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof AmazonServiceException) || (amazonServiceException = (AmazonServiceException)throwable3).getStatusCode() != 404) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    private Seq<ObjectListing> getAllListings(ListObjectsRequest request) {
        return this.concatenateListings$1((Seq)Seq$.MODULE$.empty(), this.s3().listObjects(request));
    }

    public SortedSet<String> listGroups() {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName()).withPrefix("").withDelimiter("/");
        return (SortedSet)((TraversableLike)((TraversableLike)this.getAllListings(listObjectsRequest).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(ObjectListing x$3) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getCommonPrefixes()).asScala();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).stripSuffix("/");
            }
        }, Seq$.MODULE$.canBuildFrom())).to(SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$));
    }

    public SortedSet<Locator> listGroupContents(String group) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(this.bucketName()).withPrefix(new StringBuilder().append((Object)group).append((Object)"/").toString()).withDelimiter("/");
        Seq objects = (Seq)this.getAllListings(listObjectsRequest).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<S3ObjectSummary> apply(ObjectListing x$5) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getObjectSummaries()).asScala();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (SortedSet)((TraversableLike)((TraversableLike)objects.filter((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final String group$1;

            public final boolean apply(S3ObjectSummary x$6) {
                String string = x$6.getKey();
                String string2 = new StringBuilder().append((Object)this.group$1).append((Object)"/").toString();
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.group$1 = group$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Datastore $outer;

            public final Locator apply(S3ObjectSummary os) {
                return this.$outer.Locator().fromKey(os.getKey());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).to(SortedSet$.MODULE$.newCanBuildFrom(this.Locator().defaultOrdering()));
    }

    public URL fileUrl(String group, String name, int version) {
        return this.url(new Locator(this, group, name, version, false));
    }

    public URL directoryUrl(String group, String name, int version) {
        return this.url(new Locator(this, group, name, version, true));
    }

    public URL url(Locator locator) {
        return new URL("http", this.bucketName(), locator.org$allenai$datastore$Datastore$$s3key());
    }

    public void wipeCache() {
        FileUtils.deleteDirectory((File)this.org$allenai$datastore$Datastore$$cacheDir().toFile());
    }

    public void createBucketIfNotExists() {
        this.s3().createBucket(this.bucketName());
    }

    private final boolean shouldLog$1(boolean silent$1, int loggingDelay$1, LongRef lastLogMessage$1) {
        return !silent$1 && System.currentTimeMillis() - lastLogMessage$1.elem >= (long)loggingDelay$1;
    }

    private final Seq concatenateListings$1(Seq listings, ObjectListing newListing) {
        Seq concatenation;
        while (true) {
            concatenation = (Seq)listings.$colon$plus((Object)newListing, Seq$.MODULE$.canBuildFrom());
            if (!newListing.isTruncated()) break;
            newListing = this.s3().listNextBatchOfObjects(newListing);
            listings = concatenation;
        }
        return concatenation;
    }

    public Datastore(String name, AmazonS3Client s3) {
        this.name = name;
        this.s3 = s3;
        Logging.class.$init$((Logging)this);
        Path defaultCacheDir = System.getProperty("os.name").contains("Mac OS X") ? Paths.get(System.getProperty("user.home"), new String[0]).resolve("Library").resolve("Caches").resolve("org.allenai.datastore") : Paths.get(System.getProperty("user.home"), new String[0]).resolve(".ai2").resolve("datastore");
        String envCacheDir = System.getenv("AI2_DATASTORE_DIR");
        String propCacheDir = System.getProperty("org.allenai.datastore.dir");
        this.baseCacheDir = (Path)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{envCacheDir, propCacheDir}))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1 != null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$2) {
                return Paths.get(x$2, new String[0]);
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this, defaultCacheDir){
            public static final long serialVersionUID = 0L;
            private final Path defaultCacheDir$1;

            public final Path apply() {
                return this.defaultCacheDir$1;
            }
            {
                this.defaultCacheDir$1 = defaultCacheDir$1;
            }
        });
        this.org$allenai$datastore$Datastore$$cacheDir = this.baseCacheDir().resolve(name);
        this.tempDir = this.baseCacheDir().resolve("tmp");
        Files.createDirectories(this.tempDir(), new FileAttribute[0]);
    }

    public class Locator
    implements Product,
    Serializable {
        private final String group;
        private final String name;
        private final int version;
        private final boolean directory;
        public final /* synthetic */ Datastore $outer;

        public String group() {
            return this.group;
        }

        public String name() {
            return this.name;
        }

        public int version() {
            return this.version;
        }

        public boolean directory() {
            return this.directory;
        }

        public String org$allenai$datastore$Datastore$$nameWithVersion() {
            int lastDotIndex;
            return this.directory() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-d", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.version())})) : ((lastDotIndex = this.name().lastIndexOf(46)) < 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToInteger((int)this.version())})) : new StringBuilder().append((Object)this.name().substring(0, lastDotIndex)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.version())}))).append((Object)this.name().substring(lastDotIndex)).toString());
        }

        public String org$allenai$datastore$Datastore$$s3key() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group(), this.org$allenai$datastore$Datastore$$nameWithVersion()}));
        }

        public String org$allenai$datastore$Datastore$$localCacheKey() {
            return this.directory() ? new StringOps(Predef$.MODULE$.augmentString(this.org$allenai$datastore$Datastore$$s3key())).stripSuffix(".zip") : this.org$allenai$datastore$Datastore$$s3key();
        }

        public String org$allenai$datastore$Datastore$$flatLocalCacheKey() {
            return this.org$allenai$datastore$Datastore$$localCacheKey().replace('/', '%');
        }

        public Path org$allenai$datastore$Datastore$$localCachePath() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().org$allenai$datastore$Datastore$$cacheDir().resolve(this.org$allenai$datastore$Datastore$$localCacheKey());
        }

        public Path org$allenai$datastore$Datastore$$lockfilePath() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().org$allenai$datastore$Datastore$$cacheDir().resolve(new StringBuilder().append((Object)this.org$allenai$datastore$Datastore$$localCacheKey()).append((Object)".lock").toString());
        }

        public Path path() {
            return this.org$allenai$datastore$Datastore$Locator$$$outer().path(this);
        }

        public Locator copy(String group, String name, int version, boolean directory) {
            return new Locator(this.org$allenai$datastore$Datastore$Locator$$$outer(), group, name, version, directory);
        }

        public String copy$default$1() {
            return this.group();
        }

        public String copy$default$2() {
            return this.name();
        }

        public int copy$default$3() {
            return this.version();
        }

        public boolean copy$default$4() {
            return this.directory();
        }

        public String productPrefix() {
            return "Locator";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.directory());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.version());
                    break;
                }
                case 1: {
                    object = this.name();
                    break;
                }
                case 0: {
                    object = this.group();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Locator;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.group()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.version());
            n = Statics.mix((int)n, (int)(this.directory() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Locator)) return false;
            if (((Locator)object).org$allenai$datastore$Datastore$Locator$$$outer() != this.org$allenai$datastore$Datastore$Locator$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Locator locator = (Locator)x$1;
            String string = this.group();
            String string2 = locator.group();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = locator.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.version() != locator.version()) return false;
            if (this.directory() != locator.directory()) return false;
            if (!locator.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Datastore org$allenai$datastore$Datastore$Locator$$$outer() {
            return this.$outer;
        }

        public Locator(Datastore $outer, String group, String name, int version, boolean directory) {
            this.group = group;
            this.name = name;
            this.version = version;
            this.directory = directory;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
            Predef$.MODULE$.require(!group.contains("/"));
            Predef$.MODULE$.require(!name.contains("/"));
            Predef$.MODULE$.require(version > 0);
        }
    }

    public class DoesNotExistException
    extends Exception {
        public /* synthetic */ Datastore org$allenai$datastore$Datastore$DoesNotExistException$$$outer() {
            return Datastore.this;
        }

        public DoesNotExistException(Locator locator, Throwable cause) {
            if (Datastore.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist in the ", " datastore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locator.org$allenai$datastore$Datastore$$s3key(), Datastore.this.name()})), cause);
        }
    }

    public class AlreadyExistsException
    extends Exception {
        public /* synthetic */ Datastore org$allenai$datastore$Datastore$AlreadyExistsException$$$outer() {
            return Datastore.this;
        }

        public AlreadyExistsException(Locator locator, Throwable cause) {
            if (Datastore.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already exists in the ", " datastore"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locator.org$allenai$datastore$Datastore$$s3key(), Datastore.this.name()})), cause);
        }
    }
}

