/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import org.allenai.common.Logging;
import org.allenai.common.Logging$loggerConfig$;
import org.allenai.datastore.Datastore$;
import org.allenai.datastore.Datastores;
import org.allenai.datastore.PrivateDatastore$;
import org.allenai.scienceparse.BibTraining;
import org.allenai.scienceparse.BibTraining$Config$;
import org.allenai.scienceparse.Parser;
import org.slf4j.Logger;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scopt.OptionParser;
import scopt.Read$;

public final class BibTraining$
implements App,
Datastores,
Logging {
    public static final BibTraining$ MODULE$;
    private final OptionParser<BibTraining.Config> parser;
    private final Logger internalLogger;
    private final String datastoreGroup;
    private final PrivateDatastore$ privateDatastore;
    private final Datastore$ publicDatastore;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile Logging.logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new BibTraining$();
    }

    public Logger internalLogger() {
        return this.internalLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging.logger$ logger$lzycompute() {
        BibTraining$ bibTraining$ = this;
        synchronized (bibTraining$) {
            if (this.logger$module != null) return this.logger$module;
            this.logger$module = new Logging.logger$((Logging)this);
            return this.logger$module;
        }
    }

    public Logging.logger$ logger() {
        return this.logger$module == null ? this.logger$lzycompute() : this.logger$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging$loggerConfig$ loggerConfig$lzycompute() {
        BibTraining$ bibTraining$ = this;
        synchronized (bibTraining$) {
            if (this.loggerConfig$module != null) return this.loggerConfig$module;
            this.loggerConfig$module = new Logging$loggerConfig$((Logging)this);
            return this.loggerConfig$module;
        }
    }

    public Logging$loggerConfig$ loggerConfig() {
        return this.loggerConfig$module == null ? this.loggerConfig$lzycompute() : this.loggerConfig$module;
    }

    public void org$allenai$common$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public String datastoreGroup() {
        return this.datastoreGroup;
    }

    public PrivateDatastore$ privateDatastore() {
        return this.privateDatastore;
    }

    public Datastore$ publicDatastore() {
        return this.publicDatastore;
    }

    public void org$allenai$datastore$Datastores$_setter_$datastoreGroup_$eq(String x$1) {
        this.datastoreGroup = x$1;
    }

    public void org$allenai$datastore$Datastores$_setter_$privateDatastore_$eq(PrivateDatastore$ x$1) {
        this.privateDatastore = x$1;
    }

    public void org$allenai$datastore$Datastores$_setter_$publicDatastore_$eq(Datastore$ x$1) {
        this.publicDatastore = x$1;
    }

    public Path privateFile(String name, int version) {
        return Datastores.class.privateFile((Datastores)this, (String)name, (int)version);
    }

    public Path publicFile(String name, int version) {
        return Datastores.class.publicFile((Datastores)this, (String)name, (int)version);
    }

    public InputStream privateStream(String name, int version) {
        return Datastores.class.privateStream((Datastores)this, (String)name, (int)version);
    }

    public InputStream publicStream(String name, int version) {
        return Datastores.class.publicStream((Datastores)this, (String)name, (int)version);
    }

    public Path privateDirectory(String name, int version) {
        return Datastores.class.privateDirectory((Datastores)this, (String)name, (int)version);
    }

    public Path publicDirectory(String name, int version) {
        return Datastores.class.publicDirectory((Datastores)this, (String)name, (int)version);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.class.delayedInit((App)this, body2);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public OptionParser<BibTraining.Config> parser() {
        return this.parser;
    }

    public final void delayedEndpoint$org$allenai$scienceparse$BibTraining$1() {
        this.parser = new OptionParser<BibTraining.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Options that are not specified default to the settings that were used to make the production model."}));
                this.opt('o', "output", Read$.MODULE$.fileRead()).required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(File o, BibTraining.Config c) {
                        return c.copy(o, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8());
                    }
                }).text("The output file");
                this.opt('t', "groundTruth", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(File t, BibTraining.Config c) {
                        Some x$1 = new Some((Object)t);
                        File x$2 = c.copy$default$1();
                        int x$3 = c.copy$default$3();
                        int x$4 = c.copy$default$4();
                        Option<File> x$5 = c.copy$default$5();
                        Option<File> x$6 = c.copy$default$6();
                        double x$7 = c.copy$default$7();
                        int x$8 = c.copy$default$8();
                        return c.copy(x$2, (Option<File>)x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                    }
                }).text("The ground truth directory");
                this.opt("maxIterations", Read$.MODULE$.intRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(int i, BibTraining.Config c) {
                        int x$9 = i;
                        File x$10 = c.copy$default$1();
                        Option<File> x$11 = c.copy$default$2();
                        int x$12 = c.copy$default$4();
                        Option<File> x$13 = c.copy$default$5();
                        Option<File> x$14 = c.copy$default$6();
                        double x$15 = c.copy$default$7();
                        int x$16 = c.copy$default$8();
                        return c.copy(x$10, x$11, x$9, x$12, x$13, x$14, x$15, x$16);
                    }
                }).text("Maximum number of iterations during training");
                this.opt("backgroundSampleDocs", Read$.MODULE$.intRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(int d, BibTraining.Config c) {
                        int x$17 = d;
                        File x$18 = c.copy$default$1();
                        Option<File> x$19 = c.copy$default$2();
                        int x$20 = c.copy$default$3();
                        Option<File> x$21 = c.copy$default$5();
                        Option<File> x$22 = c.copy$default$6();
                        double x$23 = c.copy$default$7();
                        int x$24 = c.copy$default$8();
                        return c.copy(x$18, x$19, x$20, x$17, x$21, x$22, x$23, x$24);
                    }
                }).text("The number of documents to use to build the background language model");
                this.opt("backgroundDirectory", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(File d, BibTraining.Config c) {
                        Some x$25 = new Some((Object)d);
                        File x$26 = c.copy$default$1();
                        Option<File> x$27 = c.copy$default$2();
                        int x$28 = c.copy$default$3();
                        int x$29 = c.copy$default$4();
                        Option<File> x$30 = c.copy$default$6();
                        double x$31 = c.copy$default$7();
                        int x$32 = c.copy$default$8();
                        return c.copy(x$26, x$27, x$28, x$29, (Option<File>)x$25, x$30, x$31, x$32);
                    }
                }).text("The directory in which the background documents are found");
                this.opt('g', "gazetteerFile", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(File f, BibTraining.Config c) {
                        Some x$33 = new Some((Object)f);
                        File x$34 = c.copy$default$1();
                        Option<File> x$35 = c.copy$default$2();
                        int x$36 = c.copy$default$3();
                        int x$37 = c.copy$default$4();
                        Option<File> x$38 = c.copy$default$5();
                        double x$39 = c.copy$default$7();
                        int x$40 = c.copy$default$8();
                        return c.copy(x$34, x$35, x$36, x$37, x$38, (Option<File>)x$33, x$39, x$40);
                    }
                }).text("The gazetteer file");
                this.opt("trainFraction", Read$.MODULE$.doubleRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(double f, BibTraining.Config c) {
                        double x$41 = f;
                        File x$42 = c.copy$default$1();
                        Option<File> x$43 = c.copy$default$2();
                        int x$44 = c.copy$default$3();
                        int x$45 = c.copy$default$4();
                        Option<File> x$46 = c.copy$default$5();
                        Option<File> x$47 = c.copy$default$6();
                        int x$48 = c.copy$default$8();
                        return c.copy(x$42, x$43, x$44, x$45, x$46, x$47, x$41, x$48);
                    }
                }).text("The fraction of the ground truth to use for training");
                this.opt("minExpectedFeatureCount", Read$.MODULE$.intRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BibTraining.Config apply(int n, BibTraining.Config c) {
                        int x$49 = n;
                        File x$50 = c.copy$default$1();
                        Option<File> x$51 = c.copy$default$2();
                        int x$52 = c.copy$default$3();
                        int x$53 = c.copy$default$4();
                        Option<File> x$54 = c.copy$default$5();
                        Option<File> x$55 = c.copy$default$6();
                        double x$56 = c.copy$default$7();
                        return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$49);
                    }
                }).text("The minimum number of times we should see a feature before accepting it.");
                this.help("help").text("Prints help text");
            }
        };
        this.parser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.args()), (Object)new BibTraining.Config(BibTraining$Config$.MODULE$.apply$default$1(), BibTraining$Config$.MODULE$.apply$default$2(), BibTraining$Config$.MODULE$.apply$default$3(), BibTraining$Config$.MODULE$.apply$default$4(), BibTraining$Config$.MODULE$.apply$default$5(), BibTraining$Config$.MODULE$.apply$default$6(), BibTraining$Config$.MODULE$.apply$default$7(), BibTraining$Config$.MODULE$.apply$default$8())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(BibTraining.Config config) {
                File groundTruthDirectory = (File)config.groundTruth().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply() {
                        return BibTraining$.MODULE$.publicDirectory("productionBibGroundTruth", 2).toFile();
                    }
                });
                Parser.ParseOpts opts = new Parser.ParseOpts();
                opts.modelFile = config.output().toString();
                opts.iterations = config.maxIterations();
                opts.threads = Runtime.getRuntime().availableProcessors() * 2;
                opts.backgroundSamples = config.backgroundSampleDocs();
                File backgroundDirectory = (File)config.backgroundDirectory().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply() {
                        return BibTraining$.MODULE$.publicDirectory("productionBackgroundDocs", 1).toFile();
                    }
                });
                opts.backgroundDirectory = backgroundDirectory.toString();
                File gazetteerFile = (File)config.gazetteerFile().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final File apply() {
                        return Parser.getDefaultGazetteer().toFile();
                    }
                });
                opts.gazetteerFile = gazetteerFile.toString();
                opts.trainFraction = config.trainFraction();
                opts.minExpectedFeatureCount = config.minExpectedFeatureCount();
                Parser.trainBibliographyCRF(groundTruthDirectory, opts);
                BibTraining$.MODULE$.logger().info((Function0)new Serializable(this, opts){
                    public static final long serialVersionUID = 0L;
                    private final Parser.ParseOpts opts$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New model at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.opts$1.modelFile}));
                    }
                    {
                        this.opts$1 = opts$1;
                    }
                });
            }
        });
    }

    private BibTraining$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        Datastores.class.$init$((Datastores)this);
        Logging.class.$init$((Logging)this);
        this.delayedInit((Function0<BoxedUnit>)new BibTraining.delayedInit.body(this));
    }
}

