/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.allenai.scienceparse.Parser;
import org.allenai.scienceparse.ParserGroundTruth;

public class CheckReferences
implements Serializable {
    private LongHashSet paperHashCodes = new LongHashSet();

    public CheckReferences(String string) throws IOException {
        this.addPapers(new ParserGroundTruth((String)string).papers);
    }

    public CheckReferences(InputStream inputStream) throws IOException {
        this.addPapers(new ParserGroundTruth((InputStream)inputStream).papers);
    }

    public int getHashSize() {
        return this.paperHashCodes.size();
    }

    public void addPaper(String string, List<String> list, int n, String string2) {
        this.paperHashCodes.add(this.getHashCode(string, list, n, string2));
    }

    public boolean hasPaper(String string, List<String> list, int n, String string2) {
        return this.paperHashCodes.contains(this.getHashCode(string, list, n, string2));
    }

    public long getHashCode(String string, List<String> list, int n, String string2) {
        string = Parser.processTitle(string);
        list = Parser.lastNames(list);
        if (string == null) {
            string = "";
        }
        if (list == null) {
            list = new ArrayList<String>();
        }
        long l = (long)list.hashCode() * Integer.MAX_VALUE + (long)string.hashCode() + (long)Integer.hashCode(n);
        return l;
    }

    public void addPapers(List<ParserGroundTruth.Paper> list) {
        for (ParserGroundTruth.Paper paper : list) {
            this.addPaper(paper.title, Arrays.asList(paper.authors), paper.year, paper.venue);
        }
    }
}

