/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.IOException;
import java.io.InputStream;
import org.allenai.scienceparse.PaperSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackPaperSource
extends PaperSource {
    private static final Logger logger = LoggerFactory.getLogger(FallbackPaperSource.class);
    private final PaperSource[] sources;

    public FallbackPaperSource(PaperSource ... paperSourceArray) {
        this.sources = paperSourceArray;
    }

    @Override
    public InputStream getPdf(String string) throws IOException {
        for (int i = 0; i < this.sources.length - 1; ++i) {
            PaperSource paperSource = this.sources[i];
            try {
                return paperSource.getPdf(string);
            }
            catch (Exception exception) {
                logger.info("Getting paper {} from source {} failed, {} more sources to try", new Object[]{string, i, this.sources.length - i - 1});
                continue;
            }
        }
        PaperSource paperSource = this.sources[this.sources.length - 1];
        return paperSource.getPdf(string);
    }
}

