/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Calendar;
import org.allenai.scienceparse.BibRecord;
import org.allenai.scienceparse.CitationRecord;
import org.allenai.scienceparse.ExtractedMetadata;
import org.allenai.scienceparse.GrobidParser;
import org.allenai.scienceparse.Parser;
import org.allenai.scienceparse.Section;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class GrobidParser$ {
    public static final GrobidParser$ MODULE$;

    static {
        new GrobidParser$();
    }

    public String addDot(String x) {
        return x.length() == 1 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x})) : x;
    }

    public String author(Element e) {
        List first = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.JsoupElementsImplicits(e).findText("persName>forename[type=first]")}));
        List mids = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)e.select("persName>forename[type=middle]")).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Element x$1) {
                return x$1.text();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        List last = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.JsoupElementsImplicits(e).findText("persName>surname")}));
        return ((TraversableOnce)((List)((TraversableLike)((List)first.$plus$plus((GenTraversableOnce)mids, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)last, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return !x$2.isEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String a) {
                return GrobidParser$.MODULE$.addDot(new GrobidParser.StringImplicits2(GrobidParser$.MODULE$.StringImplicits2(a)).trimNonAlphabetic());
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" ");
    }

    public String extractTitle(Element doc) {
        return new GrobidParser.StringImplicits2(this.StringImplicits2(this.JsoupElementsImplicits(doc).findText("teiHeader>fileDesc>titleStmt>title"))).titleCase();
    }

    public String toTitle(String s) {
        Option option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = new StringOps(Predef$.MODULE$.augmentString(new GrobidParser.StringImplicits2(this.StringImplicits2(s)).trimChars(",."))).find((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char c) {
                            return Character.isAlphabetic(c);
                        }
                    });
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = "";
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                string = s;
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    public int extractYear(String str) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    option = new StringOps(Predef$.MODULE$.augmentString("\\d{4}")).r().findFirstIn((CharSequence)str);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String y = (String)some.x();
                    n = new StringOps(Predef$.MODULE$.augmentString(y)).toInt();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = 0;
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    public Buffer<BibRecord> extractBibEntriesWithId(Element doc) {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)doc.select("listBibl>biblStruct")).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BibRecord apply(Element bib) {
                String string = GrobidParser$.MODULE$.toTitle(GrobidParser$.MODULE$.JsoupElementsImplicits(bib).findText("analytic>title[type=main]"));
                String string2 = "".equals(string) ? GrobidParser$.MODULE$.JsoupElementsImplicits(bib).findText("monogr>title") : string;
                String title = string2;
                List list = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)bib.select("analytic>author")).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Element e) {
                        return GrobidParser$.MODULE$.author(e);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toList();
                Some some = List$.MODULE$.unapplySeq((Seq)list);
                List list2 = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(0) == 0 ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)bib.select("monogr>author")).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Element e) {
                        return GrobidParser$.MODULE$.author(e);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toList() : list;
                List authors = list2;
                String venue = GrobidParser$.MODULE$.JsoupElementsImplicits(bib).findText("monogr>title");
                int yr = GrobidParser$.MODULE$.extractYear(GrobidParser$.MODULE$.JsoupElementsImplicits(bib).findAttributeValue("monogr>imprint>date[type=published]", "when"));
                return new BibRecord(title, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava(), venue, null, null, yr);
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public Option<String> ifNonEmpty(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty() ? new Some((Object)s) : None$.MODULE$;
    }

    public Tuple4<Element, String, Object, GrobidParser.Section> org$allenai$scienceparse$GrobidParser$$extractSectionInfo(Element div) {
        Option option;
        block6: {
            Tuple3 tuple3;
            Option head;
            String bodyPlusHeaderText;
            block5: {
                block4: {
                    bodyPlusHeaderText = div.text();
                    head = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)div.select("head")).asScala()).headOption();
                    option = head;
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    Element h = (Element)some.x();
                    String hText = h.text();
                    tuple3 = new Tuple3(this.ifNonEmpty(h.attr("n")), (Object)new Some((Object)hText), (Object)BoxesRunTime.boxToInteger((int)(new StringOps(Predef$.MODULE$.augmentString(hText)).size() + new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(bodyPlusHeaderText)).drop(new StringOps(Predef$.MODULE$.augmentString(hText)).size()))).takeWhile((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char x$3) {
                            return x$3 <= ' ';
                        }
                    }))).size())));
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                tuple3 = new Tuple3((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0));
            }
            Tuple3 tuple32 = tuple3;
            if (tuple32 != null) {
                Tuple3 tuple33;
                Option id = (Option)tuple32._1();
                Option headerText = (Option)tuple32._2();
                int bodyTextOffset = BoxesRunTime.unboxToInt((Object)tuple32._3());
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)id, (Object)headerText, (Object)BoxesRunTime.boxToInteger((int)bodyTextOffset));
                Option id2 = (Option)tuple34._1();
                Option headerText2 = (Option)tuple34._2();
                int bodyTextOffset2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
                Option x$14 = id2;
                String x$15 = (String)new StringOps(Predef$.MODULE$.augmentString(bodyPlusHeaderText)).drop(bodyTextOffset2);
                Option x$16 = head.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Element x$5) {
                        return x$5.text();
                    }
                });
                GrobidParser.Section section = new GrobidParser.Section((Option<String>)x$14, (Option<String>)x$16, x$15);
                return new Tuple4((Object)div, (Object)bodyPlusHeaderText, (Object)BoxesRunTime.boxToInteger((int)bodyTextOffset2), (Object)section);
            }
            throw new MatchError((Object)tuple32);
        }
        throw new MatchError((Object)option);
    }

    public List<CitationRecord> extractReferenceMentions(Element doc, Iterable<Tuple4<Element, String, Object, GrobidParser.Section>> sectionInfo) {
        Buffer bibMentions = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)doc.select("ref[type=bibr")).asScala()).flatMap((Function1)new Serializable(sectionInfo){
            public static final long serialVersionUID = 0L;
            private final Iterable sectionInfo$1;

            public final Iterable<CitationRecord> apply(Element ref) {
                return Option$.MODULE$.option2Iterable(((IterableLike)this.sectionInfo$1.zipWithIndex(Iterable$.MODULE$.canBuildFrom())).find((Function1)new Serializable(this, ref){
                    public static final long serialVersionUID = 0L;
                    private final Element ref$1;

                    public final boolean apply(Tuple2<Tuple4<Element, String, Object, GrobidParser.Section>, Object> x0$1) {
                        Tuple4 tuple4;
                        Tuple2<Tuple4<Element, String, Object, GrobidParser.Section>, Object> tuple2 = x0$1;
                        if (tuple2 != null && (tuple4 = (Tuple4)tuple2._1()) != null) {
                            Element div = (Element)tuple4._1();
                            boolean bl = this.ref$1.parents().contains((Object)div);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.ref$1 = ref$1;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Tuple4<Element, String, Object, GrobidParser.Section>, Object> check$ifrefutable$1) {
                        Tuple4 tuple4;
                        Tuple2<Tuple4<Element, String, Object, GrobidParser.Section>, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null && (tuple4 = (Tuple4)tuple2._1()) != null;
                        return bl;
                    }
                }).map((Function1)new Serializable(this, ref){
                    public static final long serialVersionUID = 0L;
                    private final Element ref$1;

                    public final CitationRecord apply(Tuple2<Tuple4<Element, String, Object, GrobidParser.Section>, Object> x$7) {
                        Tuple4 tuple4;
                        Tuple2<Tuple4<Element, String, Object, GrobidParser.Section>, Object> tuple2 = x$7;
                        if (tuple2 != null && (tuple4 = (Tuple4)tuple2._1()) != null) {
                            Element div = (Element)tuple4._1();
                            String fullText = (String)tuple4._2();
                            int offset = BoxesRunTime.unboxToInt((Object)tuple4._3());
                            String id = (String)new StringOps(Predef$.MODULE$.augmentString(this.ref$1.attr("target"))).dropWhile((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(char x$6) {
                                    return x$6 == '#';
                                }
                            });
                            int begin = GrobidParser$.MODULE$.JsoupElementsImplicits(this.ref$1).textOffset(div) - offset;
                            int end = begin + this.ref$1.text().length();
                            CitationRecord citationRecord = Parser.extractContext(0, fullText, begin, end);
                            return citationRecord;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.ref$1 = ref$1;
                    }
                }));
            }
            {
                this.sectionInfo$1 = sectionInfo$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return bibMentions.toList();
    }

    public ExtractedMetadata parseGrobidXml(Path grobidExtraction) {
        Document doc = Jsoup.parse((File)grobidExtraction.toFile(), (String)"UTF-8");
        return this.parseGrobidXml(doc);
    }

    public ExtractedMetadata parseGrobidXml(InputStream is, String baseUrl) {
        Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)baseUrl, (org.jsoup.parser.Parser)org.jsoup.parser.Parser.xmlParser());
        return this.parseGrobidXml(doc);
    }

    private ExtractedMetadata parseGrobidXml(Document doc) {
        int year = this.extractYear(this.JsoupElementsImplicits((Element)doc).findAttributeValue("teiHeader>fileDesc>sourceDesc>biblStruct>monogr>imprint>date[type=published]", "when"));
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        Buffer sectionInfo = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)doc.select("text>body>div")).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Element, String, Object, GrobidParser.Section> apply(Element div) {
                return GrobidParser$.MODULE$.org$allenai$scienceparse$GrobidParser$$extractSectionInfo(div);
            }
        }, Buffer$.MODULE$.canBuildFrom());
        ExtractedMetadata em = new ExtractedMetadata(this.extractTitle((Element)doc), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)doc.select("teiHeader>fileDesc>sourceDesc>biblStruct>analytic>author")).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Element e) {
                return GrobidParser$.MODULE$.author(e);
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava(), calendar.getTime());
        em.year = year;
        em.references = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.extractBibEntriesWithId((Element)doc)).asJava();
        em.referenceMentions = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.extractReferenceMentions((Element)doc, (Iterable<Tuple4<Element, String, Object, GrobidParser.Section>>)sectionInfo)).asJava();
        em.abstractText = (String)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)doc.select("teiHeader>profileDesc>abstract")).asScala()).headOption().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Element x$8) {
                return x$8.text();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        em.sections = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)sectionInfo.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Section apply(Tuple4<Element, String, Object, GrobidParser.Section> x0$2) {
                Tuple4<Element, String, Object, GrobidParser.Section> tuple4 = x0$2;
                if (tuple4 != null) {
                    GrobidParser.Section grobidSection = (GrobidParser.Section)tuple4._4();
                    Section section = new Section(((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{grobidSection.id(), grobidSection.header()})).flatten((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Iterable<String> apply(Option<String> xo) {
                            return Option$.MODULE$.option2Iterable(xo);
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$9) {
                            return x$9.trim();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(" "), grobidSection.text());
                    return section;
                }
                throw new MatchError(tuple4);
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
        return em;
    }

    public GrobidParser.JsoupElementsImplicits JsoupElementsImplicits(Element e) {
        return new GrobidParser.JsoupElementsImplicits(e);
    }

    public String StringImplicits2(String str) {
        return str;
    }

    private GrobidParser$() {
        MODULE$ = this;
    }
}

