/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.allenai.common.Logging;
import org.allenai.common.Logging$loggerConfig$;
import org.allenai.common.Resource$;
import org.allenai.scienceparse.ExtractedMetadata;
import org.allenai.scienceparse.LabeledData;
import org.allenai.scienceparse.LabeledData$;
import org.allenai.scienceparse.LabeledPaper;
import org.allenai.scienceparse.LabeledPapersFromPMC$;
import org.allenai.scienceparse.Parser;
import org.allenai.scienceparse.Utilities$;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.ParSeq$;
import scala.math.Ordering;
import scala.util.control.NonFatal$;

public final class LabeledPapersFromScienceParse$
implements Logging {
    public static final LabeledPapersFromScienceParse$ MODULE$;
    private final Logger internalLogger;
    private volatile Logging.logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new LabeledPapersFromScienceParse$();
    }

    public Logger internalLogger() {
        return this.internalLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging.logger$ logger$lzycompute() {
        LabeledPapersFromScienceParse$ labeledPapersFromScienceParse$ = this;
        synchronized (labeledPapersFromScienceParse$) {
            if (this.logger$module != null) return this.logger$module;
            this.logger$module = new Logging.logger$((Logging)this);
            return this.logger$module;
        }
    }

    public Logging.logger$ logger() {
        return this.logger$module == null ? this.logger$lzycompute() : this.logger$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging$loggerConfig$ loggerConfig$lzycompute() {
        LabeledPapersFromScienceParse$ labeledPapersFromScienceParse$ = this;
        synchronized (labeledPapersFromScienceParse$) {
            if (this.loggerConfig$module != null) return this.loggerConfig$module;
            this.loggerConfig$module = new Logging$loggerConfig$((Logging)this);
            return this.loggerConfig$module;
        }
    }

    public Logging$loggerConfig$ loggerConfig() {
        return this.loggerConfig$module == null ? this.loggerConfig$lzycompute() : this.loggerConfig$module;
    }

    public void org$allenai$common$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public LabeledPaper get(Function0<InputStream> input, Parser parser) {
        LabeledData labeledData;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        byte[] bytes2 = (byte[])Resource$.MODULE$.using((Object)new DigestInputStream((InputStream)input.apply(), digest), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(InputStream x$1) {
                return IOUtils.toByteArray((InputStream)x$1);
            }
        });
        String id = Utilities$.MODULE$.toHex(digest.digest());
        String labeledPaperId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SP:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id}));
        try {
            ExtractedMetadata output = (ExtractedMetadata)Resource$.MODULE$.using((Object)new ByteArrayInputStream(bytes2), (Function1)new Serializable(parser){
                public static final long serialVersionUID = 0L;
                private final Parser parser$1;

                public final ExtractedMetadata apply(InputStream is) {
                    return this.parser$1.doParse(is);
                }
                {
                    this.parser$1 = parser$1;
                }
            });
            labeledData = LabeledData$.MODULE$.fromExtractedMetadata(labeledPaperId, output);
        }
        catch (Throwable throwable) {
            LabeledData labeledData2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logger().warn((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while science-parsing"})).s((Seq)Nil$.MODULE$);
                }
            }, e);
            labeledData = labeledData2 = LabeledData$.MODULE$.empty();
        }
        LabeledData ld = labeledData;
        return new LabeledPaper(input, ld, (Option<String>)new Some((Object)id));
    }

    public Parser get$default$2() {
        return Parser.getInstance();
    }

    public void main(String[] args) {
        Seq fromPMC = (Seq)LabeledPapersFromPMC$.MODULE$.get().take(100).toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(LabeledPaper x$51) {
                return x$51.paperId();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        ParSeq fromSp = (ParSeq)((ParIterableLike)fromPMC.par()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPaper apply(LabeledPaper labeledPaper) {
                return LabeledPapersFromScienceParse$.MODULE$.get((Function0<InputStream>)new Serializable(this, labeledPaper){
                    public static final long serialVersionUID = 0L;
                    private final LabeledPaper labeledPaper$1;

                    public final InputStream apply() {
                        return this.labeledPaper$1.inputStream();
                    }
                    {
                        this.labeledPaper$1 = labeledPaper$1;
                    }
                }, LabeledPapersFromScienceParse$.MODULE$.get$default$2());
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
        LabeledData$.MODULE$.dump((Iterator<LabeledData>)fromSp.iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledData apply(LabeledPaper x$52) {
                return x$52.labels();
            }
        }));
    }

    private LabeledPapersFromScienceParse$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

