/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.IOException;
import java.io.InputStream;
import org.allenai.scienceparse.PaperSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryPaperSource
extends PaperSource {
    private static final Logger log = LoggerFactory.getLogger(RetryPaperSource.class);
    private final PaperSource inner;
    private final int tries;

    public RetryPaperSource(PaperSource paperSource) {
        this(paperSource, 3);
    }

    public RetryPaperSource(PaperSource paperSource, int n) {
        this.inner = paperSource;
        this.tries = n;
    }

    private void wait(int n) {
        long l = System.currentTimeMillis() + (long)(1000 * n);
        while (System.currentTimeMillis() < l) {
            try {
                Thread.sleep(Math.max(l - System.currentTimeMillis() + 1L, 1L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public InputStream getPdf(String string) throws IOException {
        int n = this.tries;
        int n2 = 1;
        int n3 = 1;
        while (true) {
            --n;
            try {
                return this.inner.getPdf(string);
            }
            catch (IOException iOException) {
                log.warn("{} while downloading paper {}, {} tries left", new Object[]{iOException.getClass().getSimpleName(), string, n});
                if (n <= 0) {
                    throw iOException;
                }
                this.wait(n3);
                int n4 = n3;
                n3 += n2;
                n2 = n4;
                continue;
            }
            break;
        }
    }
}

