/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.S3Object;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.allenai.scienceparse.PaperSource;

public class ScholarBucketPaperSource
extends PaperSource {
    private static ScholarBucketPaperSource instance = new ScholarBucketPaperSource();
    private static final String bucket = "ai2-s2-pdfs";
    private static final String privateBucket = "ai2-s2-pdfs-private";
    private static final String[] buckets = new String[]{"ai2-s2-pdfs", "ai2-s2-pdfs-private"};
    private final AmazonS3 s3 = new AmazonS3Client();

    protected ScholarBucketPaperSource() {
    }

    public static ScholarBucketPaperSource getInstance() {
        return instance;
    }

    private S3Object getS3Object(String string) {
        String string2 = string.substring(0, 4) + "/" + string.substring(4) + ".pdf";
        for (int i = 0; i < buckets.length; ++i) {
            try {
                return this.s3.getObject(buckets[i], string2);
            }
            catch (AmazonS3Exception amazonS3Exception) {
                if (i < buckets.length - 1 && amazonS3Exception.getStatusCode() == 404) continue;
                AmazonS3Exception amazonS3Exception2 = new AmazonS3Exception(String.format("Error for key s3://%s/%s", bucket, string2), (Exception)((Object)amazonS3Exception));
                amazonS3Exception2.setExtendedRequestId(amazonS3Exception.getExtendedRequestId());
                amazonS3Exception2.setErrorCode(amazonS3Exception.getErrorCode());
                amazonS3Exception2.setErrorType(amazonS3Exception.getErrorType());
                amazonS3Exception2.setRequestId(amazonS3Exception.getRequestId());
                amazonS3Exception2.setServiceName(amazonS3Exception.getServiceName());
                amazonS3Exception2.setStatusCode(amazonS3Exception.getStatusCode());
                throw amazonS3Exception2;
            }
        }
        throw new IllegalStateException("We should never get here.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getPdf(String string) throws IOException {
        S3Object s3Object = this.getS3Object(string);
        Path path = Files.createTempFile(string + ".", ".paper.pdf", new FileAttribute[0]);
        try {
            Files.copy((InputStream)s3Object.getObjectContent(), path, StandardCopyOption.REPLACE_EXISTING);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            return bufferedInputStream;
        }
        finally {
            Files.deleteIfExists(path);
        }
    }
}

