/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pdfapi;

import java.beans.ConstructorProperties;
import java.util.concurrent.ConcurrentHashMap;

public class PDFFontMetrics {
    private static final ConcurrentHashMap<String, PDFFontMetrics> canonical = new ConcurrentHashMap();
    public static String UNKNWON_FONT_FAMILY = "*UNKNOWN*";
    public final String name;
    public final float ptSize;
    public final float spaceWidth;

    public static PDFFontMetrics of(String string, float f, float f2) {
        PDFFontMetrics pDFFontMetrics = new PDFFontMetrics(string, f, f2);
        PDFFontMetrics pDFFontMetrics2 = canonical.putIfAbsent(string, pDFFontMetrics);
        return pDFFontMetrics2 != null ? pDFFontMetrics2 : pDFFontMetrics;
    }

    public String stringRepresentation() {
        return String.format("%s-%f", this.name, Float.valueOf(this.ptSize));
    }

    @ConstructorProperties(value={"name", "ptSize", "spaceWidth"})
    public PDFFontMetrics(String string, float f, float f2) {
        this.name = string;
        this.ptSize = f;
        this.spaceWidth = f2;
    }

    public String getName() {
        return this.name;
    }

    public float getPtSize() {
        return this.ptSize;
    }

    public float getSpaceWidth() {
        return this.spaceWidth;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDFFontMetrics)) {
            return false;
        }
        PDFFontMetrics pDFFontMetrics = (PDFFontMetrics)object;
        if (!pDFFontMetrics.canEqual(this)) {
            return false;
        }
        String string = this.getName();
        String string2 = pDFFontMetrics.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if (Float.compare(this.getPtSize(), pDFFontMetrics.getPtSize()) != 0) {
            return false;
        }
        return Float.compare(this.getSpaceWidth(), pDFFontMetrics.getSpaceWidth()) == 0;
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDFFontMetrics;
    }

    public int hashCode() {
        int n = 1;
        String string = this.getName();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        n = n * 59 + Float.floatToIntBits(this.getPtSize());
        n = n * 59 + Float.floatToIntBits(this.getSpaceWidth());
        return n;
    }

    public String toString() {
        return "PDFFontMetrics(name=" + this.getName() + ", ptSize=" + this.getPtSize() + ", spaceWidth=" + this.getSpaceWidth() + ")";
    }
}

