/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pipeline;

import java.io.InputStream;
import org.allenai.scienceparse.pipeline.Normalizers$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;

public final class Bucketizers$ {
    public static final Bucketizers$ MODULE$;
    private final InputStream highFreqTitleNgramStream;
    private final InputStream highFreqNameNgramStream;
    private Map<String, Object> highFreqTitleNgrams;
    private Map<String, Object> highFreqNameNgrams;
    private final int defaultTitleCutoffThreshold;
    private final int defaultNameCutoffThreshold;
    private final String concatChar;
    private final int defaultTitleNgramLength;
    private final int defaultNameNgramLength;
    private final boolean defaultAllowTruncated;
    private final int defaultUpto;
    private volatile byte bitmap$0;

    static {
        new Bucketizers$();
    }

    private Map highFreqTitleNgrams$lzycompute() {
        Bucketizers$ bucketizers$ = this;
        synchronized (bucketizers$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.highFreqTitleNgrams = this.loadHighFreqs(this.highFreqTitleNgramStream());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.highFreqTitleNgrams;
        }
    }

    private Map highFreqNameNgrams$lzycompute() {
        Bucketizers$ bucketizers$ = this;
        synchronized (bucketizers$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.highFreqNameNgrams = this.loadHighFreqs(this.highFreqTitleNgramStream());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.highFreqNameNgrams;
        }
    }

    public InputStream highFreqTitleNgramStream() {
        return this.highFreqTitleNgramStream;
    }

    public InputStream highFreqNameNgramStream() {
        return this.highFreqNameNgramStream;
    }

    public Map<String, Object> loadHighFreqs(InputStream is) {
        return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String l) {
                String[] stringArray = l.split("\t");
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    Tuple2 tuple2;
                    String t = (String)((SeqLike)option.get()).apply(0);
                    String f = (String)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)t, (Object)f);
                    String t2 = (String)tuple22._1();
                    String f2 = (String)tuple22._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(f2)).toInt()));
                }
                throw new MatchError((Object)stringArray);
            }
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Object> highFreqTitleNgrams() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.highFreqTitleNgrams$lzycompute() : this.highFreqTitleNgrams;
    }

    public Map<String, Object> highFreqNameNgrams() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.highFreqNameNgrams$lzycompute() : this.highFreqNameNgrams;
    }

    public int defaultTitleCutoffThreshold() {
        return this.defaultTitleCutoffThreshold;
    }

    public int defaultNameCutoffThreshold() {
        return this.defaultNameCutoffThreshold;
    }

    public String concatChar() {
        return this.concatChar;
    }

    public String toBucket(Iterable<String> words) {
        return words.mkString(this.concatChar());
    }

    public String toBucket(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])s.split(" ")).mkString(this.concatChar());
    }

    public int defaultTitleNgramLength() {
        return this.defaultTitleNgramLength;
    }

    public int defaultNameNgramLength() {
        return this.defaultNameNgramLength;
    }

    public boolean defaultAllowTruncated() {
        return this.defaultAllowTruncated;
    }

    public int defaultUpto() {
        return this.defaultUpto;
    }

    public boolean cutoffFilter(String b, Option<Object> cutoffOption, Map<String, Object> highFreqs) {
        return cutoffOption.isEmpty() || !highFreqs.contains((Object)b) || BoxesRunTime.unboxToInt((Object)highFreqs.apply((Object)b)) < BoxesRunTime.unboxToInt((Object)cutoffOption.get());
    }

    public String[] words(String text, int maxCount) {
        String[] words = (String[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(Normalizers$.MODULE$.alphaNumericNormalize(text))).split(' ')).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
            }
        });
        return (String[])Predef$.MODULE$.refArrayOps((Object[])words).take(maxCount);
    }

    public int words$default$2() {
        return 40;
    }

    public Iterator<String> ngrams(String text, int n, Option<Object> cutoffOption, boolean allowTruncated, Map<String, Object> highFreqs, int upto) {
        return this.ngramAux(this.words(text, this.words$default$2()), n, cutoffOption, allowTruncated, highFreqs, upto);
    }

    public boolean ngrams$default$4() {
        return this.defaultAllowTruncated();
    }

    public Map<String, Object> ngrams$default$5() {
        return this.highFreqTitleNgrams();
    }

    public int ngrams$default$6() {
        return this.defaultUpto();
    }

    public Iterator<String> tailNgrams(String text, int n, Option<Object> cutoffOption, boolean allowTruncated, Map<String, Object> highFreqs, int upto) {
        return this.ngramAux((String[])Predef$.MODULE$.refArrayOps((Object[])this.words(text, this.words$default$2())).reverse(), n, cutoffOption, allowTruncated, highFreqs, upto);
    }

    public boolean tailNgrams$default$4() {
        return this.defaultAllowTruncated();
    }

    public Map<String, Object> tailNgrams$default$5() {
        return this.highFreqTitleNgrams();
    }

    public int tailNgrams$default$6() {
        return this.defaultUpto();
    }

    public Iterator<String> ngramAux(String[] chunks, int n, Option<Object> cutoffOption, boolean allowTruncated, Map<String, Object> highFreqs, int upto) {
        return Predef$.MODULE$.refArrayOps((Object[])chunks).sliding(n).filter((Function1)new Serializable(n, allowTruncated){
            public static final long serialVersionUID = 0L;
            private final int n$1;
            private final boolean allowTruncated$1;

            public final boolean apply(String[] x) {
                return this.allowTruncated$1 && Predef$.MODULE$.refArrayOps((Object[])x).nonEmpty() || x.length == this.n$1;
            }
            {
                this.n$1 = n$1;
                this.allowTruncated$1 = allowTruncated$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String[] x) {
                return Bucketizers$.MODULE$.toBucket((Iterable<String>)Predef$.MODULE$.refArrayOps((Object[])x).toIterable());
            }
        }).filter((Function1)new Serializable(cutoffOption, highFreqs){
            public static final long serialVersionUID = 0L;
            private final Option cutoffOption$1;
            private final Map highFreqs$1;

            public final boolean apply(String x$3) {
                return Bucketizers$.MODULE$.cutoffFilter(x$3, (Option<Object>)this.cutoffOption$1, (Map<String, Object>)this.highFreqs$1);
            }
            {
                this.cutoffOption$1 = cutoffOption$1;
                this.highFreqs$1 = highFreqs$1;
            }
        }).take(upto);
    }

    public Iterator<String> titleNgrams(String title, int upto, boolean allowTruncated) {
        String x$4 = title;
        int x$5 = this.defaultTitleNgramLength();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)this.defaultTitleCutoffThreshold()));
        int x$7 = upto;
        boolean x$8 = allowTruncated;
        Map<String, Object> x$9 = this.ngrams$default$5();
        return this.ngrams(x$4, x$5, (Option<Object>)x$6, x$8, x$9, x$7);
    }

    public boolean titleNgrams$default$3() {
        return this.defaultAllowTruncated();
    }

    public Iterator<String> titleTailNgrams(String title, int upto, boolean allowTruncated) {
        String x$10 = title;
        int x$11 = this.defaultTitleNgramLength();
        Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)this.defaultTitleCutoffThreshold()));
        int x$13 = upto;
        boolean x$14 = allowTruncated;
        Map<String, Object> x$15 = this.tailNgrams$default$5();
        return this.tailNgrams(x$10, x$11, (Option<Object>)x$12, x$14, x$15, x$13);
    }

    public int titleTailNgrams$default$2() {
        return 1;
    }

    public boolean titleTailNgrams$default$3() {
        return this.defaultAllowTruncated();
    }

    public Iterator<String> nameNgrams(String name) {
        String x$16 = name;
        int x$17 = this.defaultNameNgramLength();
        boolean x$18 = false;
        Some x$19 = new Some((Object)BoxesRunTime.boxToInteger((int)this.defaultNameCutoffThreshold()));
        Map<String, Object> x$20 = this.highFreqNameNgrams();
        int x$21 = 3;
        return this.ngrams(x$16, x$17, (Option<Object>)x$19, x$18, x$20, x$21);
    }

    public List<String> simple3TitlePrefix(String text) {
        return this.ngrams(text, 3, (Option<Object>)None$.MODULE$, true, this.highFreqTitleNgrams(), 1).toList();
    }

    private Bucketizers$() {
        MODULE$ = this;
        this.highFreqTitleNgramStream = this.getClass().getResourceAsStream("/org/allenai/scienceparse/pipeline/highfreq.tsv");
        this.highFreqNameNgramStream = this.getClass().getResourceAsStream("/org/allenai/scienceparse/pipeline/highfreqNames.tsv");
        this.defaultTitleCutoffThreshold = 1000000;
        this.defaultNameCutoffThreshold = 100000;
        this.concatChar = "_";
        this.defaultTitleNgramLength = 3;
        this.defaultNameNgramLength = 2;
        this.defaultAllowTruncated = true;
        this.defaultUpto = 1;
    }
}

