/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pipeline;

import java.text.Normalizer;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Normalizers$ {
    public static final Normalizers$ MODULE$;

    static {
        new Normalizers$();
    }

    public String removeDiacritics(String s) {
        return new StringOps(Predef$.MODULE$.augmentString("\\p{InCombiningDiacriticalMarks}+")).r().replaceAllIn((CharSequence)Normalizer.normalize(s, Normalizer.Form.NFD), "");
    }

    public String removePunctuation(String s) {
        return s.replaceAll("\\p{P}", " ");
    }

    public String removeNonAphanumeric(String s) {
        return s.replaceAll("[^A-Za-z0-9]", " ");
    }

    public String implodeSpaces(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(" +")).r().replaceAllIn((CharSequence)s.trim(), " ");
    }

    public String removeSpaces(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(" +")).r().replaceAllIn((CharSequence)s, "");
    }

    public String normalize(String s) {
        return this.implodeSpaces(this.removePunctuation(this.removeDiacritics(s.toLowerCase())));
    }

    public String alphaNumericNormalize(String s) {
        return this.implodeSpaces(this.removeNonAphanumeric(this.removeDiacritics(s.toLowerCase())));
    }

    public String alphaNumericNormalizeNoSpaces(String s) {
        return this.removeSpaces(this.removeNonAphanumeric(this.removeDiacritics(s.toLowerCase())));
    }

    public String strictNormalize(String s) {
        return s.toLowerCase().replaceAll("[^a-z]", "");
    }

    public String soundexWord(String word) {
        String s = this.strictNormalize(word);
        if (s.isEmpty()) {
            return "";
        }
        return new StringBuilder().append(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head())).append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)s.substring(1).replaceAll("[hw]", "").replaceAll("[bfpv]", "1").replaceAll("[cgjkqsxz]", "2").replaceAll("[dt]", "3").replaceAll("l", "4").replaceAll("[mn]", "5").replaceAll("r", "6").replaceAll("(\\d)+", "$1").replaceAll("[aeiouy]", "")).append((Object)"000").toString())).take(3))).toString();
    }

    public String soundex(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])s.split(" ")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String word) {
                return Normalizers$.MODULE$.soundexWord(word);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" ");
    }

    public String truncateWords(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])s.split(" ")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return (String)new StringOps(Predef$.MODULE$.augmentString(Normalizers$.MODULE$.strictNormalize(x$1))).take(3);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" ");
    }

    private Normalizers$() {
        MODULE$ = this;
    }
}

