/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pipeline;

import org.allenai.scienceparse.pipeline.TitleAuthors;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class SimilarityMeasures$ {
    public static final SimilarityMeasures$ MODULE$;

    static {
        new SimilarityMeasures$();
    }

    public <T> double jaccardSim(Set<T> s1, Set<T> s2) {
        return (double)((TraversableOnce)s1.intersect(s2)).size() / (double)s1.union(s2).size();
    }

    public <T> double containmentJaccardSim(Set<T> s1, Set<T> s2) {
        return (double)((TraversableOnce)s1.intersect(s2)).size() / (double)package$.MODULE$.min(s1.size(), s2.size());
    }

    public Option<Object> identical(String left, String right) {
        String string = left;
        String string2 = right;
        return !(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)BoxesRunTime.boxToDouble((double)1.0)) : None$.MODULE$;
    }

    public Option<Object> prePostfix(String left, String right, Function1<Object, Object> transform) {
        return left.length() > right.length() && (left.startsWith(right) || left.endsWith(right)) ? new Some((Object)BoxesRunTime.boxToDouble((double)transform.apply$mcDI$sp(right.split(" ").length))) : None$.MODULE$;
    }

    public Function1<Object, Object> prePostfix$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x) {
                return this.apply$mcDI$sp(x);
            }

            public double apply$mcDI$sp(int x) {
                return (double)x / ((double)x + 0.5);
            }
        };
    }

    public <T> Option<T> pickFromOptions(Seq<Option<T>> members) {
        return (Option)members.toSeq().find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<T> x$1) {
                return x$1.isDefined();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
    }

    public Option<Object> twoWayPrePostfix(String left, String right, Function1<Object, Object> transform) {
        return this.pickFromOptions((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.prePostfix(left, right, transform), this.prePostfix(right, left, transform)}));
    }

    public Function1<Object, Object> twoWayPrePostfix$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x) {
                return this.apply$mcDI$sp(x);
            }

            public double apply$mcDI$sp(int x) {
                return (double)x / ((double)x + 0.5);
            }
        };
    }

    public Option<Object> characterNgramSimilarity(String left, String right, int ngramLength, double s, int l) {
        Some some;
        String string = left;
        String string2 = right;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            some = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
        } else {
            Set ngramsLeft = new StringOps(Predef$.MODULE$.augmentString(left)).sliding(ngramLength).toSet();
            Set ngramsRight = new StringOps(Predef$.MODULE$.augmentString(right)).sliding(ngramLength).toSet();
            int minSize = package$.MODULE$.min(ngramsLeft.size(), ngramsRight.size());
            double directSim = this.jaccardSim(ngramsLeft, ngramsRight);
            double containmentSim = this.containmentJaccardSim(ngramsLeft, ngramsRight);
            double containmentWeight = package$.MODULE$.min(package$.MODULE$.pow(s, (double)(minSize - l)), 100000.0);
            some = new Some((Object)BoxesRunTime.boxToDouble((double)((directSim + containmentWeight * containmentSim) / (1.0 + containmentWeight))));
        }
        return some;
    }

    public int characterNgramSimilarity$default$3() {
        return 3;
    }

    public double characterNgramSimilarity$default$4() {
        return 1.2;
    }

    public int characterNgramSimilarity$default$5() {
        return 10;
    }

    public Option<Object> titleNgramSimilarity(TitleAuthors left, TitleAuthors right, double s, int l) {
        Some some;
        TitleAuthors titleAuthors = left;
        TitleAuthors titleAuthors2 = right;
        if (!(titleAuthors != null ? !((Object)titleAuthors).equals(titleAuthors2) : titleAuthors2 != null)) {
            some = new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
        } else {
            Set<String> ngramsLeft = left.normalizedTitleNgrams();
            Set<String> ngramsRight = right.normalizedTitleNgrams();
            int minSize = package$.MODULE$.min(ngramsLeft.size(), ngramsRight.size());
            double directSim = this.jaccardSim(ngramsLeft, ngramsRight);
            double containmentSim = this.containmentJaccardSim(ngramsLeft, ngramsRight);
            double containmentWeight = package$.MODULE$.min(package$.MODULE$.pow(s, (double)(minSize - l)), 100000.0);
            some = new Some((Object)BoxesRunTime.boxToDouble((double)((directSim + containmentWeight * containmentSim) / (1.0 + containmentWeight))));
        }
        return some;
    }

    public double titleNgramSimilarity$default$3() {
        return 1.2;
    }

    public int titleNgramSimilarity$default$4() {
        return 10;
    }

    private SimilarityMeasures$() {
        MODULE$ = this;
    }
}

