/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.allenai.common.Logging;
import org.allenai.common.Logging$loggerConfig$;
import org.allenai.common.Resource$;
import org.allenai.datastore.Datastore$;
import org.allenai.datastore.Datastores;
import org.allenai.datastore.PrivateDatastore$;
import org.allenai.scienceparse.BibRecord;
import org.allenai.scienceparse.CitationRecord;
import org.allenai.scienceparse.Evaluation;
import org.allenai.scienceparse.Evaluation$;
import org.allenai.scienceparse.Evaluation$$anonfun$63$;
import org.allenai.scienceparse.Evaluation$$anonfun$67$;
import org.allenai.scienceparse.Evaluation$$anonfun$allGoldData$1$;
import org.allenai.scienceparse.Evaluation$Config$4$;
import org.allenai.scienceparse.Evaluation$EvaluationStats$;
import org.allenai.scienceparse.Evaluation$ItemWithOriginal$;
import org.allenai.scienceparse.ExtractedMetadata;
import org.allenai.scienceparse.GrobidParser$;
import org.allenai.scienceparse.Parser;
import org.allenai.scienceparse.StringUtils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenMap;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterable;
import scala.collection.parallel.ParIterable$;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.immutable.ParMap;
import scala.collection.parallel.immutable.ParSet$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scopt.OptionParser;
import scopt.Read$;

public final class Evaluation$
implements Datastores,
Logging {
    public static final Evaluation$ MODULE$;
    private final Set<String> org$allenai$scienceparse$Evaluation$$suffixes;
    private final Seq<Evaluation.Metric> metrics;
    private Seq<Tuple3<Evaluation.Metric, String, List<String>>> allGoldData;
    private Set<String> goldDocIds;
    private final Logger internalLogger;
    private final String datastoreGroup;
    private final PrivateDatastore$ privateDatastore;
    private final Datastore$ publicDatastore;
    private volatile byte bitmap$0;
    private volatile Logging.logger$ logger$module;
    private volatile Logging$loggerConfig$ loggerConfig$module;

    static {
        new Evaluation$();
    }

    private Seq allGoldData$lzycompute() {
        Evaluation$ evaluation$ = this;
        synchronized (evaluation$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.allGoldData = (Seq)this.metrics().flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final List<Tuple3<Evaluation.Metric, String, List<String>>> apply(Evaluation.Metric metric) {
                        return (List)Resource$.MODULE$.using((Object)Source$.MODULE$.fromInputStream(Evaluation$.MODULE$.getClass().getResourceAsStream(metric.goldFile()), Codec$.MODULE$.UTF8()), (Function1)new Serializable(this, metric){
                            public static final long serialVersionUID = 0L;
                            public final Evaluation.Metric metric$3;

                            public final List<Tuple3<Evaluation.Metric, String, List<String>>> apply(BufferedSource source) {
                                return source.getLines().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$allGoldData$1$$anonfun$apply$5 $outer;

                                    public final Tuple3<Evaluation.Metric, String, List<String>> apply(String line) {
                                        String[] fields = (String[])Predef$.MODULE$.refArrayOps((Object[])line.trim().split("\t")).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String x$14) {
                                                return x$14.trim();
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                        return new Tuple3((Object)this.$outer.metric$3, Predef$.MODULE$.refArrayOps((Object[])fields).head(), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields).tail()).toList());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }).toList();
                            }
                            {
                                this.metric$3 = metric$3;
                            }
                        });
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.allGoldData;
        }
    }

    private Set goldDocIds$lzycompute() {
        Evaluation$ evaluation$ = this;
        synchronized (evaluation$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.goldDocIds = ((TraversableOnce)this.allGoldData().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple3<Evaluation.Metric, String, List<String>> x$15) {
                        return (String)x$15._2();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.goldDocIds;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Evaluation$Config$4$ org$allenai$scienceparse$Evaluation$$Config$2$lzycompute(VolatileObjectRef x$1) {
        Evaluation$ evaluation$ = this;
        synchronized (evaluation$) {
            if (x$1.elem != null) return (Evaluation$Config$4$)((Object)x$1.elem);
            x$1.elem = new Evaluation$Config$4$(x$1);
            return (Evaluation$Config$4$)((Object)x$1.elem);
        }
    }

    public Logger internalLogger() {
        return this.internalLogger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging.logger$ logger$lzycompute() {
        Evaluation$ evaluation$ = this;
        synchronized (evaluation$) {
            if (this.logger$module != null) return this.logger$module;
            this.logger$module = new Logging.logger$((Logging)this);
            return this.logger$module;
        }
    }

    public Logging.logger$ logger() {
        return this.logger$module == null ? this.logger$lzycompute() : this.logger$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Logging$loggerConfig$ loggerConfig$lzycompute() {
        Evaluation$ evaluation$ = this;
        synchronized (evaluation$) {
            if (this.loggerConfig$module != null) return this.loggerConfig$module;
            this.loggerConfig$module = new Logging$loggerConfig$((Logging)this);
            return this.loggerConfig$module;
        }
    }

    public Logging$loggerConfig$ loggerConfig() {
        return this.loggerConfig$module == null ? this.loggerConfig$lzycompute() : this.loggerConfig$module;
    }

    public void org$allenai$common$Logging$_setter_$internalLogger_$eq(Logger x$1) {
        this.internalLogger = x$1;
    }

    public String datastoreGroup() {
        return this.datastoreGroup;
    }

    public PrivateDatastore$ privateDatastore() {
        return this.privateDatastore;
    }

    public Datastore$ publicDatastore() {
        return this.publicDatastore;
    }

    public void org$allenai$datastore$Datastores$_setter_$datastoreGroup_$eq(String x$1) {
        this.datastoreGroup = x$1;
    }

    public void org$allenai$datastore$Datastores$_setter_$privateDatastore_$eq(PrivateDatastore$ x$1) {
        this.privateDatastore = x$1;
    }

    public void org$allenai$datastore$Datastores$_setter_$publicDatastore_$eq(Datastore$ x$1) {
        this.publicDatastore = x$1;
    }

    public Path privateFile(String name, int version) {
        return Datastores.class.privateFile((Datastores)this, (String)name, (int)version);
    }

    public Path publicFile(String name, int version) {
        return Datastores.class.publicFile((Datastores)this, (String)name, (int)version);
    }

    public InputStream privateStream(String name, int version) {
        return Datastores.class.privateStream((Datastores)this, (String)name, (int)version);
    }

    public InputStream publicStream(String name, int version) {
        return Datastores.class.publicStream((Datastores)this, (String)name, (int)version);
    }

    public Path privateDirectory(String name, int version) {
        return Datastores.class.privateDirectory((Datastores)this, (String)name, (int)version);
    }

    public Path publicDirectory(String name, int version) {
        return Datastores.class.publicDirectory((Datastores)this, (String)name, (int)version);
    }

    public <T> Evaluation.BufferToItemToCompareList<T> org$allenai$scienceparse$Evaluation$$BufferToItemToCompareList(Buffer<T> x) {
        return new Evaluation.BufferToItemToCompareList<T>(x);
    }

    public <T> Evaluation.ListToItemToCompareList<T> org$allenai$scienceparse$Evaluation$$ListToItemToCompareList(List<T> x) {
        return new Evaluation.ListToItemToCompareList<T>(x);
    }

    public <T> Evaluation.UtilListToItemToCompareList<T> org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(java.util.List<T> x) {
        return new Evaluation.UtilListToItemToCompareList<T>(x);
    }

    public <T> void org$allenai$scienceparse$Evaluation$$logEvaluationErrors(Logger logger, Evaluation.Metric metric, String paperId2, String errorType, Set<Evaluation.ItemWithOriginal<T>> items) {
        items.foreach((Function1)new Serializable(logger, metric, paperId2, errorType){
            public static final long serialVersionUID = 0L;
            private final Logger logger$1;
            private final Evaluation.Metric metric$2;
            private final String paperId$2;
            private final String errorType$1;

            public final void apply(Evaluation.ItemWithOriginal<T> item) {
                this.logger$1.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", "\\t", "\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metric$2.name(), this.errorType$1, this.paperId$2, item.item(), item.original()})));
            }
            {
                this.logger$1 = logger$1;
                this.metric$2 = metric$2;
                this.paperId$2 = paperId$2;
                this.errorType$1 = errorType$1;
            }
        });
    }

    public BibRecord org$allenai$scienceparse$Evaluation$$normalizeBR(BibRecord bibRecord) {
        return new BibRecord((String)this.nullMap$1(bibRecord.title, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        }), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(bibRecord.author).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava(), (String)this.nullMap$1(bibRecord.venue, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        }), bibRecord.citeRegEx, bibRecord.shortCiteRegEx, bibRecord.year);
    }

    public BibRecord org$allenai$scienceparse$Evaluation$$normalizeBRstripVenues(BibRecord bibRecord) {
        BibRecord normalized = this.org$allenai$scienceparse$Evaluation$$normalizeBR(bibRecord);
        return new BibRecord(normalized.title, normalized.author, null, normalized.citeRegEx, normalized.shortCiteRegEx, normalized.year);
    }

    public String org$allenai$scienceparse$Evaluation$$strictNormalize(String s) {
        return s.toLowerCase().replaceAll("[^a-z0-9]", "");
    }

    public String org$allenai$scienceparse$Evaluation$$mentionNormalize(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])s.split("\\|")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$strictNormalize(s);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("|");
    }

    public <T> Tuple2<Object, Object> org$allenai$scienceparse$Evaluation$$calculatePR(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<T>> goldData, Set<Evaluation.ItemWithOriginal<T>> extractedData, Option<Logger> logger) {
        Tuple2.mcDD.sp sp2;
        if (goldData.isEmpty()) {
            sp2 = new Tuple2.mcDD.sp(extractedData.isEmpty() ? 1.0 : 0.0, 1.0);
        } else if (extractedData.isEmpty()) {
            sp2 = new Tuple2.mcDD.sp(0.0, 0.0);
        } else {
            logger.foreach((Function1)new Serializable(metric, paperId2, goldData, extractedData){
                public static final long serialVersionUID = 0L;
                private final Evaluation.Metric metric$1;
                private final String paperId$1;
                private final Set goldData$1;
                private final Set extractedData$1;

                public final void apply(Logger l) {
                    Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$logEvaluationErrors(l, this.metric$1, this.paperId$1, "recall", (Set)this.goldData$1.diff((GenSet)this.extractedData$1));
                    Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$logEvaluationErrors(l, this.metric$1, this.paperId$1, "precision", (Set)this.extractedData$1.diff((GenSet)this.goldData$1));
                }
                {
                    this.metric$1 = metric$1;
                    this.paperId$1 = paperId$1;
                    this.goldData$1 = goldData$1;
                    this.extractedData$1 = extractedData$1;
                }
            });
            double precision = (double)extractedData.count((Function1)new Serializable(goldData){
                public static final long serialVersionUID = 0L;
                private final Set goldData$1;

                public final boolean apply(Evaluation.ItemWithOriginal<T> elem) {
                    return this.goldData$1.contains(elem);
                }
                {
                    this.goldData$1 = goldData$1;
                }
            }) / (double)extractedData.size();
            double recall = (double)goldData.count((Function1)new Serializable(extractedData){
                public static final long serialVersionUID = 0L;
                private final Set extractedData$1;

                public final boolean apply(Evaluation.ItemWithOriginal<T> elem) {
                    return this.extractedData$1.contains(elem);
                }
                {
                    this.extractedData$1 = extractedData$1;
                }
            }) / (double)goldData.size();
            sp2 = new Tuple2.mcDD.sp(precision, recall);
        }
        return sp2;
    }

    private <T> Option<Logger> calculatePR$default$5() {
        return None$.MODULE$;
    }

    public Tuple2<Object, Object> org$allenai$scienceparse$Evaluation$$bibCounter(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<BibRecord>> goldData, Set<Evaluation.ItemWithOriginal<BibRecord>> extractedData, Option<Logger> logger) {
        return new Tuple2.mcDD.sp(1.0, (double)extractedData.size() / (double)goldData.size());
    }

    private Option<Logger> bibCounter$default$5() {
        return None$.MODULE$;
    }

    public Set<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$multiSet(List<Evaluation.ItemWithOriginal<String>> refs) {
        return ((TraversableOnce)refs.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Evaluation.ItemWithOriginal<String> apply(Evaluation.ItemWithOriginal<String> x) {
                return (Evaluation.ItemWithOriginal)Predef$.MODULE$.identity(x);
            }
        }).values().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<Evaluation.ItemWithOriginal<String>> x$2) {
                return (List)((List)x$2.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Evaluation.ItemWithOriginal<String> apply(Tuple2<Evaluation.ItemWithOriginal<String>, Object> x0$1) {
                        Tuple2<Evaluation.ItemWithOriginal<String>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Evaluation.ItemWithOriginal ref = (Evaluation.ItemWithOriginal)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            Evaluation.ItemWithOriginal<String> itemWithOriginal = ref.map(new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final int i$1;

                                public final String apply(String x$3) {
                                    return new StringBuilder().append((Object)x$3).append((Object)((Object)BoxesRunTime.boxToInteger((int)this.i$1)).toString()).toString();
                                }
                                {
                                    this.i$1 = i$1;
                                }
                            });
                            return itemWithOriginal;
                        }
                        throw new MatchError(tuple2);
                    }
                }, List$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Function5<Evaluation.Metric, String, ExtractedMetadata, List<String>, Option<Logger>, Tuple2<Object, Object>> stringEvaluator(Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>> extract, Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> extractGold, Function1<String, String> normalizer, Set<String> disallow, Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> prCalculator) {
        return new Serializable(extract, extractGold, normalizer, disallow, prCalculator){
            public static final long serialVersionUID = 0L;
            private final Function1 extract$1;
            private final Function1 extractGold$1;
            public final Function1 normalizer$1;
            public final Set disallow$1;
            private final Function5 prCalculator$1;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, ExtractedMetadata metadata, List<String> gold, Option<Logger> logger) {
                return (Tuple2)this.prCalculator$1.apply((Object)metric, (Object)paperId2, (Object)this.clean$1((List)this.extractGold$1.apply(gold)), (Object)this.clean$1((List)this.extract$1.apply((Object)metadata)), logger);
            }

            private final Set clean$1(List x) {
                List normalizedItems = (List)x.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stringEvaluator.1 $outer;

                    public final Evaluation.ItemWithOriginal<String> apply(Evaluation.ItemWithOriginal<String> x$4) {
                        return x$4.map((Function1<String, String>)this.$outer.normalizer$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
                List filteredItems = (List)normalizedItems.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.stringEvaluator.1 $outer;

                    public final boolean apply(Evaluation.ItemWithOriginal<String> i) {
                        return this.$outer.disallow$1.contains((Object)i.item());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$multiSet((List<Evaluation.ItemWithOriginal<String>>)filteredItems);
            }
            {
                this.extract$1 = extract$1;
                this.extractGold$1 = extractGold$1;
                this.normalizer$1 = normalizer$1;
                this.disallow$1 = disallow$1;
                this.prCalculator$1 = prCalculator$1;
            }
        };
    }

    private Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> stringEvaluator$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> items) {
                return Evaluation$ItemWithOriginal$.MODULE$.toList(items);
            }
        };
    }

    private Function1<String, String> stringEvaluator$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    private Set<String> stringEvaluator$default$4() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
    }

    private Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> stringEvaluator$default$5() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<String>> goldData, Set<Evaluation.ItemWithOriginal<String>> extractedData, Option<Logger> logger) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$calculatePR(metric, paperId2, goldData, extractedData, logger);
            }
        };
    }

    private <T> Function5<Evaluation.Metric, String, ExtractedMetadata, List<String>, Option<Logger>, Tuple2<Object, Object>> genericEvaluator(Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<T>>> extract, Function1<List<String>, List<Evaluation.ItemWithOriginal<T>>> extractGold, Function1<T, T> normalizer, Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<T>>, Set<Evaluation.ItemWithOriginal<T>>, Option<Logger>, Tuple2<Object, Object>> prCalculator) {
        return new Serializable(extract, extractGold, normalizer, prCalculator){
            public static final long serialVersionUID = 0L;
            private final Function1 extract$2;
            private final Function1 extractGold$2;
            public final Function1 normalizer$2;
            private final Function5 prCalculator$2;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, ExtractedMetadata metadata, List<String> gold, Option<Logger> logger) {
                return (Tuple2)this.prCalculator$2.apply((Object)metric, (Object)paperId2, (Object)((TraversableOnce)((List)this.extractGold$2.apply(gold)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.genericEvaluator.1 $outer;

                    public final Evaluation.ItemWithOriginal<T> apply(Evaluation.ItemWithOriginal<T> x$5) {
                        return x$5.map(this.$outer.normalizer$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom())).toSet(), (Object)((TraversableOnce)((List)this.extract$2.apply((Object)metadata)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.genericEvaluator.1 $outer;

                    public final Evaluation.ItemWithOriginal<T> apply(Evaluation.ItemWithOriginal<T> x$6) {
                        return x$6.map(this.$outer.normalizer$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom())).toSet(), logger);
            }
            {
                this.extract$2 = extract$2;
                this.extractGold$2 = extractGold$2;
                this.normalizer$2 = normalizer$2;
                this.prCalculator$2 = prCalculator$2;
            }
        };
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$fullNameExtractor(ExtractedMetadata metadata) {
        return this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.authors).toItems();
    }

    public Set<String> org$allenai$scienceparse$Evaluation$$suffixes() {
        return this.org$allenai$scienceparse$Evaluation$$suffixes;
    }

    public String org$allenai$scienceparse$Evaluation$$getLastName(String name) {
        return (String)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])name.split("\\s+")).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String elem) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$suffixes().contains((Object)elem);
            }
        })).last();
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$lastNameExtractor(ExtractedMetadata metadata) {
        return this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.authors).mapItems(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$getLastName(name);
            }
        });
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$lastNameGoldExtractor(List<String> names) {
        return (List)names.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Evaluation.ItemWithOriginal<String> apply(String fullName) {
                return new Evaluation.ItemWithOriginal<String>(Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$getLastName(fullName), fullName);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$titleExtractor(ExtractedMetadata metadata) {
        return this.org$allenai$scienceparse$Evaluation$$ListToItemToCompareList(((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata.title}))).$minus(null).toList()).toItems();
    }

    private String firstNLastWord(String x) {
        String[] words = x.split("\\s+");
        return new StringBuilder().append((Object)((String)Predef$.MODULE$.refArrayOps((Object[])words).head())).append((Object)" ").append(Predef$.MODULE$.refArrayOps((Object[])words).last()).toString();
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$abstractExtractor(ExtractedMetadata metadata) {
        return metadata.abstractText == null ? Nil$.MODULE$ : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Evaluation.ItemWithOriginal[]{new Evaluation.ItemWithOriginal<String>(this.firstNLastWord(metadata.abstractText), metadata.abstractText)}));
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$goldAbstractExtractor(List<String> abs) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Evaluation.ItemWithOriginal[]{new Evaluation.ItemWithOriginal<String>(this.firstNLastWord((String)abs.head()), (String)abs.head())}));
    }

    public List<Evaluation.ItemWithOriginal<BibRecord>> org$allenai$scienceparse$Evaluation$$bibExtractor(ExtractedMetadata metadata) {
        return this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.references).toItems();
    }

    public List<Evaluation.ItemWithOriginal<BibRecord>> org$allenai$scienceparse$Evaluation$$goldBibExtractor(List<String> refs) {
        return (List)refs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Evaluation.ItemWithOriginal<BibRecord> apply(String ref) {
                String[] stringArray = ref.split("\\|", -1);
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
                    Tuple4 tuple4;
                    String title = (String)((SeqLike)option.get()).apply(0);
                    String year = (String)((SeqLike)option.get()).apply(1);
                    String venue = (String)((SeqLike)option.get()).apply(2);
                    String authors = (String)((SeqLike)option.get()).apply(3);
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)title, (Object)year, (Object)venue, (Object)authors);
                    String title2 = (String)tuple42._1();
                    String year2 = (String)tuple42._2();
                    String venue2 = (String)tuple42._3();
                    String authors2 = (String)tuple42._4();
                    return new Evaluation.ItemWithOriginal<BibRecord>(new BibRecord(title2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])authors2.split(":")).toList()).asJava(), venue2, null, null, new StringOps(Predef$.MODULE$.augmentString(year2)).toInt()), ref);
                }
                throw new MatchError((Object)stringArray);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$bibAuthorsExtractor(ExtractedMetadata metadata) {
        return this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.references).flatMapItems(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(BibRecord x$8) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(x$8.author).toList();
            }
        });
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$goldBibAuthorsExtractor(List<String> bibAuthors) {
        return this.org$allenai$scienceparse$Evaluation$$ListToItemToCompareList((List)bibAuthors.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(String x$9) {
                return Predef$.MODULE$.refArrayOps((Object[])x$9.split(":")).toList();
            }
        }, List$.MODULE$.canBuildFrom())).toItems();
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$bibTitlesExtractor(ExtractedMetadata metadata) {
        return (List)this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.references).mapItems(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BibRecord x$10) {
                return x$10.title;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Evaluation.ItemWithOriginal<String> x$11) {
                return x$11 != null;
            }
        });
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$bibVenuesExtractor(ExtractedMetadata metadata) {
        return (List)this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.references).mapItems(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BibRecord x$12) {
                return x$12.venue;
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Evaluation.ItemWithOriginal<String> x$13) {
                return x$13 != null;
            }
        });
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$bibYearsExtractor(ExtractedMetadata metadata) {
        return this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.references).flatMapItems(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(BibRecord r) {
                int year = r.year;
                return year == 0 ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)((Object)BoxesRunTime.boxToInteger((int)year)).toString()));
            }
        });
    }

    public List<Evaluation.ItemWithOriginal<String>> org$allenai$scienceparse$Evaluation$$bibMentionsExtractor(ExtractedMetadata metadata) {
        return (List)this.org$allenai$scienceparse$Evaluation$$UtilListToItemToCompareList(metadata.referenceMentions).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Evaluation.ItemWithOriginal<String> apply(CitationRecord r) {
                String context = r.context;
                String mention = context.substring(r.startOffset, r.endOffset);
                return new Evaluation.ItemWithOriginal<String>(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "|", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context, mention.replaceAll("[()]", "")})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "|", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context, mention})));
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Seq<Evaluation.Metric> metrics() {
        return this.metrics;
    }

    public Seq<Tuple3<Evaluation.Metric, String, List<String>>> allGoldData() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.allGoldData$lzycompute() : this.allGoldData;
    }

    public Set<String> goldDocIds() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.goldDocIds$lzycompute() : this.goldDocIds;
    }

    public void main(String[] args) {
        VolatileObjectRef Config$module = VolatileObjectRef.zero();
        public class Org_allenai_scienceparse_Evaluation$Config$3
        implements Product,
        Serializable {
            private final Option<File> modelFile;
            private final Option<File> gazetteerFile;
            private final Option<File> bibModelFile;

            public Option<File> modelFile() {
                return this.modelFile;
            }

            public Option<File> gazetteerFile() {
                return this.gazetteerFile;
            }

            public Option<File> bibModelFile() {
                return this.bibModelFile;
            }

            public Org_allenai_scienceparse_Evaluation$Config$3 copy(Option<File> modelFile, Option<File> gazetteerFile, Option<File> bibModelFile) {
                return new Org_allenai_scienceparse_Evaluation$Config$3(modelFile, gazetteerFile, bibModelFile);
            }

            public Option<File> copy$default$1() {
                return this.modelFile();
            }

            public Option<File> copy$default$2() {
                return this.gazetteerFile();
            }

            public Option<File> copy$default$3() {
                return this.bibModelFile();
            }

            public String productPrefix() {
                return "Config";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Option<File> option;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        option = this.bibModelFile();
                        break;
                    }
                    case 1: {
                        option = this.gazetteerFile();
                        break;
                    }
                    case 0: {
                        option = this.modelFile();
                    }
                }
                return option;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Org_allenai_scienceparse_Evaluation$Config$3;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Org_allenai_scienceparse_Evaluation$Config$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Org_allenai_scienceparse_Evaluation$Config$3 var4_4 = (Org_allenai_scienceparse_Evaluation$Config$3)x$1;
                Option<File> option = this.modelFile();
                Option<File> option2 = var4_4.modelFile();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
                Option<File> option3 = this.gazetteerFile();
                Option<File> option4 = var4_4.gazetteerFile();
                if (option3 == null) {
                    if (option4 != null) {
                        return false;
                    }
                } else if (!option3.equals(option4)) return false;
                Option<File> option5 = this.bibModelFile();
                Option<File> option6 = var4_4.bibModelFile();
                if (option5 == null) {
                    if (option6 != null) {
                        return false;
                    }
                } else if (!option5.equals(option6)) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public Org_allenai_scienceparse_Evaluation$Config$3(Option<File> modelFile, Option<File> gazetteerFile, Option<File> bibModelFile) {
                this.modelFile = modelFile;
                this.gazetteerFile = gazetteerFile;
                this.bibModelFile = bibModelFile;
                Product.class.$init$((Product)this);
            }
        }
        OptionParser<Org_allenai_scienceparse_Evaluation$Config$3> parser = new OptionParser<Org_allenai_scienceparse_Evaluation$Config$3>(){
            {
                this.opt('m', "model", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Org_allenai_scienceparse_Evaluation$Config$3 apply(File m, Org_allenai_scienceparse_Evaluation$Config$3 c) {
                        return c.copy((Option<File>)new Some((Object)m), c.copy$default$2(), c.copy$default$3());
                    }
                }).text("Specifies the model file to evaluate. Defaults to the production model");
                this.opt('g', "gazetteer", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Org_allenai_scienceparse_Evaluation$Config$3 apply(File g, Org_allenai_scienceparse_Evaluation$Config$3 c) {
                        Some x$59 = new Some((Object)g);
                        Option<File> x$60 = c.copy$default$1();
                        Option<File> x$61 = c.copy$default$3();
                        return c.copy(x$60, (Option<File>)x$59, x$61);
                    }
                }).text("Specifies the gazetteer file. Defaults to the production one. Take care not to use a gazetteer that you also used to train the model.");
                this.opt('b', "bibModel", Read$.MODULE$.fileRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Org_allenai_scienceparse_Evaluation$Config$3 apply(File b, Org_allenai_scienceparse_Evaluation$Config$3 c) {
                        Some x$62 = new Some((Object)b);
                        Option<File> x$63 = c.copy$default$1();
                        Option<File> x$64 = c.copy$default$2();
                        return c.copy(x$63, x$64, (Option<File>)x$62);
                    }
                }).text("Specified the bibliography model file to evaluate. Defaults to the production model");
                this.help("help").text("Prints help text");
            }
        };
        parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)this.org$allenai$scienceparse$Evaluation$$Config$2(Config$module).apply(this.org$allenai$scienceparse$Evaluation$$Config$2(Config$module).apply$default$1(), this.org$allenai$scienceparse$Evaluation$$Config$2(Config$module).apply$default$2(), this.org$allenai$scienceparse$Evaluation$$Config$2(Config$module).apply$default$3())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Org_allenai_scienceparse_Evaluation$Config$3 config) {
                Path modelFile = (Path)config.modelFile().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(File x$16) {
                        return x$16.toPath();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply() {
                        return Parser.getDefaultProductionModel();
                    }
                });
                Path gazetteerFile = (Path)config.gazetteerFile().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(File x$17) {
                        return x$17.toPath();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply() {
                        return Parser.getDefaultGazetteer();
                    }
                });
                Path bibModelFile = (Path)config.bibModelFile().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(File x$18) {
                        return x$18.toPath();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply() {
                        return Parser.getDefaultBibModel();
                    }
                });
                Parser parser = new Parser(modelFile, gazetteerFile, bibModelFile);
                Evaluation.EvaluationResult results = Evaluation$.MODULE$.evaluate(parser);
                Evaluation$.MODULE$.printResults(results);
            }
        });
    }

    public Evaluation.EvaluationResult evaluate(Parser parser) {
        Seq allGoldData2 = (Seq)this.metrics().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple3<Evaluation.Metric, String, List<String>>> apply(Evaluation.Metric metric) {
                return (List)Resource$.MODULE$.using((Object)Source$.MODULE$.fromInputStream(Evaluation$.MODULE$.getClass().getResourceAsStream(metric.goldFile()), Codec$.MODULE$.UTF8()), (Function1)new Serializable(this, metric){
                    public static final long serialVersionUID = 0L;
                    public final Evaluation.Metric metric$4;

                    public final List<Tuple3<Evaluation.Metric, String, List<String>>> apply(BufferedSource source) {
                        return source.getLines().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$63$$anonfun$apply$7 $outer;

                            public final Tuple3<Evaluation.Metric, String, List<String>> apply(String line) {
                                String[] fields = (String[])Predef$.MODULE$.refArrayOps((Object[])line.trim().split("\t")).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String x$19) {
                                        return x$19.trim();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                return new Tuple3((Object)this.$outer.metric$4, Predef$.MODULE$.refArrayOps((Object[])fields).head(), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fields).tail()).toList());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).toList();
                    }
                    {
                        this.metric$4 = metric$4;
                    }
                });
            }
        }, Seq$.MODULE$.canBuildFrom());
        Path grobidExtractionsDirectory = this.publicDirectory("GrobidExtractions", 1);
        ParMap grobidExtractions = ((ParIterableLike)((ParIterableLike)this.goldDocIds().par()).map((Function1)new Serializable(grobidExtractionsDirectory){
            public static final long serialVersionUID = 0L;
            private final Path grobidExtractionsDirectory$1;

            public final Tuple2<String, Success<ExtractedMetadata>> apply(String docid) {
                Path grobidExtraction = this.grobidExtractionsDirectory$1.resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".xml"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{docid})));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)docid), (Object)new Success((Object)GrobidParser$.MODULE$.parseGrobidXml(grobidExtraction)));
            }
            {
                this.grobidExtractionsDirectory$1 = grobidExtractionsDirectory$1;
            }
        }, (CanBuildFrom)ParSet$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Path pdfDirectory = this.publicDirectory("PapersTestSet", 3);
        int documentCount = this.goldDocIds().size();
        this.logger().info((Function0)new Serializable(documentCount){
            public static final long serialVersionUID = 0L;
            private final int documentCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running on ", " documents"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.documentCount$1)}));
            }
            {
                this.documentCount$1 = documentCount$1;
            }
        });
        AtomicInteger totalDocumentsDone = new AtomicInteger();
        long startTime = System.currentTimeMillis();
        ParMap result = ((ParIterableLike)((ParIterableLike)this.goldDocIds().par()).map((Function1)new Serializable(parser, pdfDirectory, documentCount, totalDocumentsDone, startTime){
            public static final long serialVersionUID = 0L;
            public final Parser parser$1;
            private final Path pdfDirectory$1;
            private final int documentCount$1;
            private final AtomicInteger totalDocumentsDone$1;
            private final long startTime$1;

            /*
             * WARNING - void declaration
             */
            public final Tuple2<String, Try<ExtractedMetadata>> apply(String docid) {
                void var3_3;
                Path pdf = this.pdfDirectory$1.resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".pdf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{docid})));
                Evaluation$.MODULE$.logger().debug((Function0)new Serializable(this, pdf){
                    public static final long serialVersionUID = 0L;
                    private final Path pdf$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pdf$1}));
                    }
                    {
                        this.pdf$1 = pdf$1;
                    }
                });
                Tuple2 result = (Tuple2)Resource$.MODULE$.using((Object)Files.newInputStream(pdf, new OpenOption[0]), (Function1)new Serializable(this, docid){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.67 $outer;
                    private final String docid$1;

                    public final Tuple2<String, Try<ExtractedMetadata>> apply(InputStream is) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.docid$1), (Object)Try$.MODULE$.apply((Function0)new Serializable(this, is){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$67$$anonfun$68 $outer;
                            private final InputStream is$1;

                            public final ExtractedMetadata apply() {
                                return this.$outer.org$allenai$scienceparse$Evaluation$$anonfun$$anonfun$$$outer().parser$1.doParse(this.is$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.is$1 = is$1;
                            }
                        }));
                    }

                    public /* synthetic */ anonfun.67 org$allenai$scienceparse$Evaluation$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.docid$1 = docid$1;
                    }
                });
                int documentsDone = this.totalDocumentsDone$1.incrementAndGet();
                if (documentsDone % 50 == 0) {
                    long timeSpent = System.currentTimeMillis() - this.startTime$1;
                    double speed = 1000.0 * (double)documentsDone / (double)timeSpent;
                    double completion = 100.0 * (double)documentsDone / (double)this.documentCount$1;
                    Evaluation$.MODULE$.logger().info((Function0)new Serializable(this, documentsDone, speed, completion){
                        public static final long serialVersionUID = 0L;
                        private final int documentsDone$1;
                        private final double speed$1;
                        private final double completion$1;

                        public final String apply() {
                            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)this.documentsDone$1);
                            double arg$macro$2 = this.completion$1;
                            double arg$macro$3 = this.speed$1;
                            return new StringOps("Finished %s documents (%.0f%%, %.2f dps) ...").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToDouble((double)arg$macro$2), BoxesRunTime.boxToDouble((double)arg$macro$3)}));
                        }
                        {
                            this.documentsDone$1 = documentsDone$1;
                            this.speed$1 = speed$1;
                            this.completion$1 = completion$1;
                        }
                    });
                }
                return var3_3;
            }
            {
                this.parser$1 = parser$1;
                this.pdfDirectory$1 = pdfDirectory$1;
                this.documentCount$1 = documentCount$1;
                this.totalDocumentsDone$1 = totalDocumentsDone$1;
                this.startTime$1 = startTime$1;
            }
        }, (CanBuildFrom)ParSet$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        long finishTime = System.currentTimeMillis();
        double dps = 1000.0 * (double)documentCount / (double)(finishTime - startTime);
        this.logger().info((Function0)new Serializable(documentCount, dps){
            public static final long serialVersionUID = 0L;
            private final int documentCount$1;
            private final double dps$1;

            public final String apply() {
                Integer arg$macro$4 = BoxesRunTime.boxToInteger((int)this.documentCount$1);
                double arg$macro$5 = this.dps$1;
                return new StringOps("Finished %s documents at %.2f documents per second").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4, BoxesRunTime.boxToDouble((double)arg$macro$5)}));
            }
            {
                this.documentCount$1 = documentCount$1;
                this.dps$1 = dps$1;
            }
        });
        ParIterable failures = (ParIterable)result.values().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Try<ExtractedMetadata>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Failure) {
                    Failure failure = (Failure)A1;
                    Throwable e = failure.exception();
                    object = e;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Try<ExtractedMetadata> x1) {
                Try<ExtractedMetadata> try_ = x1;
                boolean bl = try_ instanceof Failure;
                return bl;
            }
        }, (CanBuildFrom)ParIterable$.MODULE$.canBuildFrom());
        double errorRate = 100.0 * (double)failures.size() / (double)documentCount;
        this.logger().info((Function0)new Serializable(failures, errorRate){
            public static final long serialVersionUID = 0L;
            private final ParIterable failures$1;
            private final double errorRate$1;

            public final String apply() {
                Integer arg$macro$6 = BoxesRunTime.boxToInteger((int)this.failures$1.size());
                double arg$macro$7 = this.errorRate$1;
                return new StringOps("Failed %s times (%.2f%%)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$6, BoxesRunTime.boxToDouble((double)arg$macro$7)}));
            }
            {
                this.failures$1 = failures$1;
                this.errorRate$1 = errorRate$1;
            }
        });
        if (failures.nonEmpty()) {
            this.logger().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Top errors:";
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])failures.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Throwable x$20) {
                    return x$20.getClass().getName();
                }
            }).mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(ParIterable<Throwable> x$21) {
                    return x$21.size();
                }
            }).toArray(ClassTag$.MODULE$.apply(Tuple2.class))).sortBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, Object> x$22) {
                    return -x$22._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).take(10)).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String error = (String)tuple2._1();
                        int count = tuple2._2$mcI$sp();
                        Evaluation$.MODULE$.logger().info((Function0)new Serializable(this, error, count){
                            public static final long serialVersionUID = 0L;
                            private final String error$1;
                            private final int count$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.count$1), this.error$1}));
                            }
                            {
                                this.error$1 = error$1;
                                this.count$1 = count$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
        ParMap scienceParseExtractions = result;
        Logger evaluationErrorLogger = LoggerFactory.getLogger((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".evaluationErrors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getCanonicalName()})));
        return new Evaluation.EvaluationResult((Map<Evaluation.Metric, Evaluation.EvaluationStats>)this.getPR$1((GenMap)scienceParseExtractions, (Option)new Some((Object)evaluationErrorLogger), allGoldData2), (Map<Evaluation.Metric, Evaluation.EvaluationStats>)this.getPR$1((GenMap)grobidExtractions, this.getPR$default$2$1(), allGoldData2));
    }

    public void printResults(Evaluation.EvaluationResult results) {
        ArrayBuffer output = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        String arg$macro$8 = "EVALUATION RESULTS";
        String arg$macro$9 = "PRECISION";
        String arg$macro$10 = "RECALL";
        String arg$macro$11 = "SAMPLE";
        output.$plus$eq((Object)new StringOps("%-30s%28s%28s%10s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$8, arg$macro$9, arg$macro$10, arg$macro$11})));
        String arg$macro$12 = "";
        String arg$macro$13 = "SP";
        String arg$macro$14 = "Grobid";
        String arg$macro$15 = "diff";
        String arg$macro$16 = "SP";
        String arg$macro$17 = "Grobid";
        String arg$macro$18 = "diff";
        String arg$macro$19 = "SIZE";
        output.$plus$eq((Object)new StringOps("%-30s%10s | %6s | %6s%10s | %6s | %6s%10s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$12, arg$macro$13, arg$macro$14, arg$macro$15, arg$macro$16, arg$macro$17, arg$macro$18, arg$macro$19})));
        output.$plus$eq((Object)"-----------------------------------------+--------+------------------+--------+-----------------");
        ((List)results.scienceParse().keySet().$plus$plus((GenTraversableOnce)results.grobid().keySet()).toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Evaluation.Metric x$26) {
                return x$26.name();
            }
        }, (Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(results, output){
            public static final long serialVersionUID = 0L;
            private final Evaluation.EvaluationResult results$1;
            private final ArrayBuffer output$1;

            public final ArrayBuffer<String> apply(Evaluation.Metric metric) {
                Evaluation.EvaluationStats evaluationStats = (Evaluation.EvaluationStats)this.results$1.scienceParse().getOrElse((Object)metric, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Evaluation.EvaluationStats apply() {
                        return Evaluation$EvaluationStats$.MODULE$.empty();
                    }
                });
                if (evaluationStats != null) {
                    Tuple3 tuple3;
                    double spP = evaluationStats.precision();
                    double spR = evaluationStats.recall();
                    int spSize = evaluationStats.evaluationSetSize();
                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)spP), (Object)BoxesRunTime.boxToDouble((double)spR), (Object)BoxesRunTime.boxToInteger((int)spSize));
                    double spP2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                    double spR2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                    int spSize2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                    Evaluation.EvaluationStats evaluationStats2 = (Evaluation.EvaluationStats)this.results$1.grobid().getOrElse((Object)metric, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Evaluation.EvaluationStats apply() {
                            return Evaluation$EvaluationStats$.MODULE$.empty();
                        }
                    });
                    if (evaluationStats2 != null) {
                        Tuple3 tuple33;
                        double grobidP = evaluationStats2.precision();
                        double grobidR = evaluationStats2.recall();
                        int grobidSize = evaluationStats2.evaluationSetSize();
                        Tuple3 tuple34 = tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)grobidP), (Object)BoxesRunTime.boxToDouble((double)grobidR), (Object)BoxesRunTime.boxToInteger((int)grobidSize));
                        double grobidP2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                        double grobidR2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                        int grobidSize2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
                        Predef$.MODULE$.assert(spSize2 == 0 || grobidSize2 == 0 || spSize2 == grobidSize2);
                        int size = BoxesRunTime.unboxToInt((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{spSize2, grobidSize2}))).max((Ordering)Ordering.Int$.MODULE$));
                        double pDiff = spP2 - grobidP2;
                        double rDiff = spR2 - grobidR2;
                        String arg$macro$20 = metric.name();
                        double arg$macro$21 = spP2;
                        double arg$macro$22 = grobidP2;
                        double arg$macro$23 = pDiff;
                        double arg$macro$24 = spR2;
                        double arg$macro$25 = grobidR2;
                        double arg$macro$26 = rDiff;
                        int arg$macro$27 = size;
                        return this.output$1.$plus$eq((Object)new StringOps("%-30s%10.3f | %6.3f | %+5.3f%10.3f | %6.3f | %+5.3f%10d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$20, BoxesRunTime.boxToDouble((double)arg$macro$21), BoxesRunTime.boxToDouble((double)arg$macro$22), BoxesRunTime.boxToDouble((double)arg$macro$23), BoxesRunTime.boxToDouble((double)arg$macro$24), BoxesRunTime.boxToDouble((double)arg$macro$25), BoxesRunTime.boxToDouble((double)arg$macro$26), BoxesRunTime.boxToInteger((int)arg$macro$27)})));
                    }
                    throw new MatchError((Object)evaluationStats2);
                }
                throw new MatchError((Object)evaluationStats);
            }
            {
                this.results$1 = results$1;
                this.output$1 = output$1;
            }
        });
        Predef$.MODULE$.println((Object)((TraversableOnce)output.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String line) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\u001b[1m", "\u001b[34m", line, "\u001b[0m"}));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString("\n"));
    }

    private final Object nullMap$1(Object itemOrNull, Function1 f) {
        return Option$.MODULE$.apply(itemOrNull).map(f).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Out apply() {
                return null;
            }
        });
    }

    public final Evaluation$Config$4$ org$allenai$scienceparse$Evaluation$$Config$2(VolatileObjectRef Config$module$1) {
        return Config$module$1.elem == null ? this.org$allenai$scienceparse$Evaluation$$Config$2$lzycompute(Config$module$1) : (Evaluation$Config$4$)((Object)Config$module$1.elem);
    }

    private final Map getPR$1(GenMap extractions, Option logger, Seq allGoldData$1) {
        Seq prResults = (Seq)allGoldData$1.map((Function1)new Serializable(extractions, logger){
            public static final long serialVersionUID = 0L;
            private final GenMap extractions$1;
            private final Option logger$2;

            public final Tuple2<Evaluation.Metric, Tuple2<Object, Object>> apply(Tuple3<Evaluation.Metric, String, List<String>> x0$3) {
                Tuple3<Evaluation.Metric, String, List<String>> tuple3;
                block2: {
                    Try try_;
                    block5: {
                        Tuple2 tuple2;
                        block4: {
                            List goldData;
                            String docId;
                            Evaluation.Metric metric;
                            block3: {
                                tuple3 = x0$3;
                                if (tuple3 == null) break block2;
                                metric = (Evaluation.Metric)tuple3._1();
                                docId = (String)tuple3._2();
                                goldData = (List)tuple3._3();
                                try_ = (Try)this.extractions$1.apply((Object)docId);
                                if (!(try_ instanceof Failure)) break block3;
                                tuple2 = new Tuple2((Object)metric, (Object)new Tuple2.mcDD.sp(0.0, 0.0));
                                break block4;
                            }
                            if (!(try_ instanceof Success)) break block5;
                            Success success = (Success)try_;
                            ExtractedMetadata extractedMetadata = (ExtractedMetadata)success.value();
                            tuple2 = new Tuple2((Object)metric, metric.evaluator().apply((Object)metric, (Object)docId, (Object)extractedMetadata, (Object)goldData, (Object)this.logger$2));
                        }
                        Tuple2 tuple22 = tuple2;
                        return tuple22;
                    }
                    throw new MatchError((Object)try_);
                }
                throw new MatchError(tuple3);
            }
            {
                this.extractions$1 = extractions$1;
                this.logger$2 = logger$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return prResults.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Evaluation.Metric apply(Tuple2<Evaluation.Metric, Tuple2<Object, Object>> x$23) {
                return (Evaluation.Metric)x$23._1();
            }
        }).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Evaluation.EvaluationStats apply(Seq<Tuple2<Evaluation.Metric, Tuple2<Object, Object>>> prs) {
                Tuple2 tuple2 = ((GenericTraversableTemplate)prs.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Evaluation.Metric, Tuple2<Object, Object>> x$24) {
                        return (Tuple2)x$24._2();
                    }
                }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Seq ps = (Seq)tuple2._1();
                    Seq rs = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)ps, (Object)rs);
                    Seq ps2 = (Seq)tuple23._1();
                    Seq rs2 = (Seq)tuple23._2();
                    return new Evaluation.EvaluationStats(BoxesRunTime.unboxToDouble((Object)ps2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)ps2.size(), BoxesRunTime.unboxToDouble((Object)rs2.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rs2.size(), ps2.size());
                }
                throw new MatchError((Object)tuple2);
            }
        });
    }

    private final Option getPR$default$2$1() {
        return None$.MODULE$;
    }

    private Evaluation$() {
        MODULE$ = this;
        Datastores.class.$init$((Datastores)this);
        Logging.class.$init$((Logging)this);
        this.org$allenai$scienceparse$Evaluation$$suffixes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Jr."}));
        Evaluation.Metric[] metricArray = new Evaluation.Metric[21];
        metricArray[0] = new Evaluation.Metric("authorFullName", "/golddata/dblp/authorFullName.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$fullNameExtractor(metadata);
            }
        }, this.stringEvaluator$default$2(), this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        Serializable x$29 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$fullNameExtractor(metadata);
            }
        };
        Serializable x$30 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        };
        Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> x$31 = this.stringEvaluator$default$2();
        Set<String> x$32 = this.stringEvaluator$default$4();
        Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> x$33 = this.stringEvaluator$default$5();
        metricArray[1] = new Evaluation.Metric("authorFullNameNormalized", "/golddata/dblp/authorFullName.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)x$29, x$31, (Function1<String, String>)x$30, x$32, x$33));
        metricArray[2] = new Evaluation.Metric("authorLastName", "/golddata/dblp/authorFullName.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$lastNameExtractor(metadata);
            }
        }, (Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> names) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$lastNameGoldExtractor(names);
            }
        }, this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        metricArray[3] = new Evaluation.Metric("authorLastNameNormalized", "/golddata/dblp/authorFullName.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$lastNameExtractor(metadata);
            }
        }, (Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> names) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$lastNameGoldExtractor(names);
            }
        }, (Function1<String, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        }, this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        metricArray[4] = new Evaluation.Metric("title", "/golddata/dblp/title.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$titleExtractor(metadata);
            }
        }, this.stringEvaluator$default$2(), this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        Serializable x$34 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$titleExtractor(metadata);
            }
        };
        Serializable x$35 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        };
        Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> x$36 = this.stringEvaluator$default$2();
        Set<String> x$37 = this.stringEvaluator$default$4();
        Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> x$38 = this.stringEvaluator$default$5();
        metricArray[5] = new Evaluation.Metric("titleNormalized", "/golddata/dblp/title.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)x$34, x$36, (Function1<String, String>)x$35, x$37, x$38));
        metricArray[6] = new Evaluation.Metric("abstract", "/golddata/isaac/abstracts.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$abstractExtractor(metadata);
            }
        }, (Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> abs) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldAbstractExtractor(abs);
            }
        }, this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        metricArray[7] = new Evaluation.Metric("abstractNormalized", "/golddata/isaac/abstracts.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$abstractExtractor(metadata);
            }
        }, (Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> abs) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldAbstractExtractor(abs);
            }
        }, (Function1<String, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        }, this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        metricArray[8] = new Evaluation.Metric("bibAll", "/golddata/isaac/bibliographies.tsv", this.genericEvaluator((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibExtractor(metadata);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(List<String> refs) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldBibExtractor(refs);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BibRecord apply(BibRecord x) {
                return (BibRecord)Predef$.MODULE$.identity((Object)x);
            }
        }, (Function5)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<BibRecord>> goldData, Set<Evaluation.ItemWithOriginal<BibRecord>> extractedData, Option<Logger> logger) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$calculatePR(metric, paperId2, goldData, extractedData, logger);
            }
        }));
        metricArray[9] = new Evaluation.Metric("bibAllNormalized", "/golddata/isaac/bibliographies.tsv", this.genericEvaluator((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibExtractor(metadata);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(List<String> refs) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldBibExtractor(refs);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BibRecord apply(BibRecord bibRecord) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$normalizeBR(bibRecord);
            }
        }, (Function5)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<BibRecord>> goldData, Set<Evaluation.ItemWithOriginal<BibRecord>> extractedData, Option<Logger> logger) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$calculatePR(metric, paperId2, goldData, extractedData, logger);
            }
        }));
        metricArray[10] = new Evaluation.Metric("bibAllButVenuesNormalized", "/golddata/isaac/bibliographies.tsv", this.genericEvaluator((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibExtractor(metadata);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(List<String> refs) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldBibExtractor(refs);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BibRecord apply(BibRecord bibRecord) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$normalizeBRstripVenues(bibRecord);
            }
        }, (Function5)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<BibRecord>> goldData, Set<Evaluation.ItemWithOriginal<BibRecord>> extractedData, Option<Logger> logger) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$calculatePR(metric, paperId2, goldData, extractedData, logger);
            }
        }));
        metricArray[11] = new Evaluation.Metric("bibCounts", "/golddata/isaac/bibliographies.tsv", this.genericEvaluator((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibExtractor(metadata);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<BibRecord>> apply(List<String> refs) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldBibExtractor(refs);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BibRecord apply(BibRecord x) {
                return (BibRecord)Predef$.MODULE$.identity((Object)x);
            }
        }, (Function5)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Evaluation.Metric metric, String paperId2, Set<Evaluation.ItemWithOriginal<BibRecord>> goldData, Set<Evaluation.ItemWithOriginal<BibRecord>> extractedData, Option<Logger> logger) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibCounter(metric, paperId2, goldData, extractedData, logger);
            }
        }));
        metricArray[12] = new Evaluation.Metric("bibAuthors", "/golddata/isaac/bib-authors.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibAuthorsExtractor(metadata);
            }
        }, (Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> bibAuthors) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldBibAuthorsExtractor(bibAuthors);
            }
        }, this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        metricArray[13] = new Evaluation.Metric("bibAuthorsNormalized", "/golddata/isaac/bib-authors.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibAuthorsExtractor(metadata);
            }
        }, (Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(List<String> bibAuthors) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$goldBibAuthorsExtractor(bibAuthors);
            }
        }, (Function1<String, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        }, this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        metricArray[14] = new Evaluation.Metric("bibTitles", "/golddata/isaac/bib-titles.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibTitlesExtractor(metadata);
            }
        }, this.stringEvaluator$default$2(), this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        Serializable x$39 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibTitlesExtractor(metadata);
            }
        };
        Serializable x$40 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        };
        Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> x$41 = this.stringEvaluator$default$2();
        Set<String> x$42 = this.stringEvaluator$default$4();
        Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> x$43 = this.stringEvaluator$default$5();
        metricArray[15] = new Evaluation.Metric("bibTitlesNormalized", "/golddata/isaac/bib-titles.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)x$39, x$41, (Function1<String, String>)x$40, x$42, x$43));
        metricArray[16] = new Evaluation.Metric("bibVenues", "/golddata/isaac/bib-venues.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibVenuesExtractor(metadata);
            }
        }, this.stringEvaluator$default$2(), this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        Serializable x$44 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibVenuesExtractor(metadata);
            }
        };
        Serializable x$45 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return StringUtils$.MODULE$.normalize(s);
            }
        };
        Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> x$46 = this.stringEvaluator$default$2();
        Set<String> x$47 = this.stringEvaluator$default$4();
        Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> x$48 = this.stringEvaluator$default$5();
        metricArray[17] = new Evaluation.Metric("bibVenuesNormalized", "/golddata/isaac/bib-venues.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)x$44, x$46, (Function1<String, String>)x$45, x$47, x$48));
        Serializable x$49 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibYearsExtractor(metadata);
            }
        };
        Set x$50 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0"}));
        Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> x$51 = this.stringEvaluator$default$2();
        Function1<String, String> x$52 = this.stringEvaluator$default$3();
        Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> x$53 = this.stringEvaluator$default$5();
        metricArray[18] = new Evaluation.Metric("bibYears", "/golddata/isaac/bib-years.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)x$49, x$51, x$52, (Set<String>)x$50, x$53));
        metricArray[19] = new Evaluation.Metric("bibMentions", "/golddata/isaac/mentions.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibMentionsExtractor(metadata);
            }
        }, this.stringEvaluator$default$2(), this.stringEvaluator$default$3(), this.stringEvaluator$default$4(), this.stringEvaluator$default$5()));
        Serializable x$54 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Evaluation.ItemWithOriginal<String>> apply(ExtractedMetadata metadata) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$bibMentionsExtractor(metadata);
            }
        };
        Serializable x$55 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return Evaluation$.MODULE$.org$allenai$scienceparse$Evaluation$$mentionNormalize(s);
            }
        };
        Function1<List<String>, List<Evaluation.ItemWithOriginal<String>>> x$56 = this.stringEvaluator$default$2();
        Set<String> x$57 = this.stringEvaluator$default$4();
        Function5<Evaluation.Metric, String, Set<Evaluation.ItemWithOriginal<String>>, Set<Evaluation.ItemWithOriginal<String>>, Option<Logger>, Tuple2<Object, Object>> x$58 = this.stringEvaluator$default$5();
        metricArray[20] = new Evaluation.Metric("bibMentionsNormalized", "/golddata/isaac/mentions.tsv", this.stringEvaluator((Function1<ExtractedMetadata, List<Evaluation.ItemWithOriginal<String>>>)x$54, x$56, (Function1<String, String>)x$55, x$57, x$58));
        this.metrics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])metricArray));
    }
}

