/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.tuple.Tuples;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.allenai.ml.linalg.DenseVector;
import org.allenai.ml.linalg.Vector;
import org.allenai.ml.sequences.StateSpace;
import org.allenai.ml.sequences.crf.CRFFeatureEncoder;
import org.allenai.ml.sequences.crf.CRFModel;
import org.allenai.ml.sequences.crf.CRFPredicateExtractor;
import org.allenai.ml.sequences.crf.CRFWeightsEncoder;
import org.allenai.ml.util.IOUtils;
import org.allenai.ml.util.Indexer;
import org.allenai.scienceparse.BibRecord;
import org.allenai.scienceparse.CRFBibRecordParser;
import org.allenai.scienceparse.CheckReferences;
import org.allenai.scienceparse.CitationRecord;
import org.allenai.scienceparse.GazetteerFeatures;
import org.allenai.scienceparse.Parser;
import org.allenai.scienceparse.ParserLMFeatures;
import org.allenai.scienceparse.ReferencesPredicateExtractor;
import org.allenai.scienceparse.RegexWithTimeout;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractReferences {
    private static final Logger log = LoggerFactory.getLogger(ExtractReferences.class);
    public static final String authUnit = "\\p{Lu}[\\p{L}'`\\-]+";
    public static final String authOneName = "\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?";
    public static final String authLastCommaInitial = "\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?, (?:\\p{Lu}\\.-? ?)+";
    public static final String authConnect = "(?:; |, |, and |; and | and )";
    public static final String authInitialsLast = "(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?";
    public static final String authInitialsLastList = "(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*";
    public static final String authPlain = "\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:\\p{Lu}\\. )?\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?";
    public static final String authPlainList = "\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:\\p{Lu}\\. )?\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:, and|,) (?:\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:\\p{Lu}\\. )?\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?))*";
    public static final String authGeneral = "\\p{Lu}[\\p{L}\\.'`\\- ]+";
    public static final String authGeneralList = "\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*";
    private ArrayList<BibStractor> extractors = null;
    public static Pattern pBracket = Pattern.compile("\\[([0-9]+)\\](.*)");
    public static Pattern pDot = Pattern.compile("([0-9]+)\\.(.*)");
    CheckReferences cr;
    final CRFBibRecordParser bibCRFRecordParser;
    public static final String DATA_VERSION = "0.3-BIB";
    private static final Pattern yearPattern = Pattern.compile("[1-2][0-9][0-9][0-9]");
    private static final Pattern firstNamesPattern = Pattern.compile("\\p{javaUpperCase}{1,3}|(\\p{javaUpperCase}\\.){1,3}|(\\p{javaUpperCase}\\s+){0,2}(\\p{javaUpperCase})|(\\p{javaUpperCase}\\.\\s+){0,2}(\\p{javaUpperCase}\\.)");

    public ExtractReferences(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public ExtractReferences(String string, String string2) throws IOException {
        this(new FileInputStream(string), new DataInputStream(new FileInputStream(string2)));
    }

    public ExtractReferences(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public ExtractReferences(InputStream inputStream, DataInputStream dataInputStream) throws IOException {
        this(inputStream, dataInputStream, null);
    }

    public ExtractReferences(InputStream inputStream, DataInputStream dataInputStream, InputStream inputStream2) throws IOException {
        CRFModel<String, String, String> cRFModel;
        if (inputStream2 != null) {
            try {
                cRFModel = new CRFModel<String, String, String>(inputStream2);
                Throwable throwable = null;
                try {
                    this.cr = (CheckReferences)cRFModel.readObject();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cRFModel != null) {
                        if (throwable != null) {
                            try {
                                cRFModel.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cRFModel.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                log.warn("Could not load gazetteer from cache. Loading it slowly instead.", (Throwable)exception);
            }
        }
        if (this.cr == null) {
            this.cr = new CheckReferences(inputStream);
        }
        this.extractors = new ArrayList();
        if (dataInputStream != null) {
            cRFModel = ExtractReferences.loadModel(dataInputStream);
            this.bibCRFRecordParser = new CRFBibRecordParser(cRFModel);
            this.extractors.addAll(Arrays.asList(new BracketNumber(new Class[]{BracketNumberInitialsQuotedBibRecordParser.class, CRFBibRecordParser.class}), new NamedYear(new Class[]{NamedYearBibRecordParser.class, CRFBibRecordParser.class}), new NamedYear(new Class[]{NamedYearInParensBibRecordParser.class, CRFBibRecordParser.class}), new NumberDot(new Class[]{NumberDotYearParensBibRecordParser.class, CRFBibRecordParser.class}), new NumberDot(new Class[]{NumberDotAuthorNoTitleBibRecordParser.class, CRFBibRecordParser.class}), new NumberDot(new Class[]{NumberDotYearNoParensBibRecordParser.class, CRFBibRecordParser.class}), new BracketNumber(new Class[]{BracketNumberInitialsYearParensCOMMAS.class, CRFBibRecordParser.class}), new BracketNumber(new Class[]{BracketNumberBibRecordParser.class, CRFBibRecordParser.class}), new BracketName(new Class[]{BracketNameBibRecordParser.class, CRFBibRecordParser.class})));
            this.extractors.addAll(Arrays.asList(new BracketNumber(new Class[]{CRFBibRecordParser.class}), new NumberDot(new Class[]{CRFBibRecordParser.class}), new NumberDotNaturalLineBreaks(new Class[]{CRFBibRecordParser.class}), new NamedYear(new Class[]{CRFBibRecordParser.class}), new BracketName(new Class[]{CRFBibRecordParser.class})));
        } else {
            this.bibCRFRecordParser = null;
            this.extractors.addAll(Arrays.asList(new BracketNumber(new Class[]{BracketNumberInitialsQuotedBibRecordParser.class}), new NamedYear(new Class[]{NamedYearBibRecordParser.class}), new NamedYear(new Class[]{NamedYearInParensBibRecordParser.class}), new NumberDot(new Class[]{NumberDotYearParensBibRecordParser.class}), new NumberDot(new Class[]{NumberDotAuthorNoTitleBibRecordParser.class}), new NumberDot(new Class[]{NumberDotYearNoParensBibRecordParser.class}), new BracketNumber(new Class[]{BracketNumberInitialsYearParensCOMMAS.class}), new BracketNumber(new Class[]{BracketNumberBibRecordParser.class}), new BracketName(new Class[]{BracketNameBibRecordParser.class})));
        }
    }

    public static ExtractReferences createAndWriteGazCache(InputStream inputStream, DataInputStream dataInputStream, OutputStream outputStream) throws IOException {
        ExtractReferences extractReferences = new ExtractReferences(inputStream, dataInputStream);
        FSTObjectOutput fSTObjectOutput = new FSTObjectOutput(outputStream);
        fSTObjectOutput.writeObject((Object)extractReferences.cr);
        return extractReferences;
    }

    public static CRFModel<String, String, String> loadModel(DataInputStream dataInputStream) throws IOException {
        IOUtils.ensureVersionMatch((DataInputStream)dataInputStream, (String)DATA_VERSION);
        StateSpace stateSpace = StateSpace.load((DataInputStream)dataInputStream);
        Indexer indexer = Indexer.load((DataInputStream)dataInputStream);
        Indexer indexer2 = Indexer.load((DataInputStream)dataInputStream);
        DenseVector denseVector = DenseVector.of((double[])IOUtils.loadDoubles((DataInputStream)dataInputStream));
        ParserLMFeatures parserLMFeatures = null;
        GazetteerFeatures gazetteerFeatures = null;
        try (Object object = new FSTObjectInput((InputStream)dataInputStream);){
            try {
                parserLMFeatures = (ParserLMFeatures)object.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                gazetteerFeatures = (GazetteerFeatures)object.readObject();
            }
            catch (Exception exception) {
                log.info("Failed to load kermit gazetteer with this error:", (Throwable)exception);
            }
            if (gazetteerFeatures != null) {
                log.info("kermit gazetteer successfully loaded.");
            } else {
                log.info("could not load kermit gazetter");
            }
        }
        object = new ReferencesPredicateExtractor(parserLMFeatures);
        ((ReferencesPredicateExtractor)object).setGf(gazetteerFeatures);
        var8_8 = new CRFFeatureEncoder((CRFPredicateExtractor)object, stateSpace, indexer, indexer2);
        CRFWeightsEncoder cRFWeightsEncoder = new CRFWeightsEncoder(stateSpace, indexer.size(), indexer2.size());
        return new CRFModel((CRFFeatureEncoder)var8_8, cRFWeightsEncoder, (Vector)denseVector);
    }

    public static Pattern authStrToPat(String string) {
        if (string == null || string.length() == 0) {
            string = "";
        }
        return Pattern.compile(string, 2);
    }

    private static String cleanAuthString(String string) {
        return string.replaceAll("\\p{P}", ".");
    }

    public static int extractRefYear(String string) {
        Matcher matcher = RegexWithTimeout.matcher(yearPattern, string);
        int n = 0;
        while (matcher.find()) {
            try {
                n = Integer.parseInt(matcher.group().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 1800 || n >= BibRecord.MAXYEAR) continue;
            return n;
        }
        return n;
    }

    public static List<String> authorStringToList(String string2) {
        String[] stringArray;
        block10: {
            int n;
            int n2;
            int n3;
            block9: {
                string2 = string2.trim();
                string2 = string2.replaceAll("[\\p{Punct}&&[^.]]*$", "");
                string2 = string2.replaceAll("^\\p{Punct}*", "");
                string2 = string2.replaceAll("[\\s\\p{Punct}]*[eE][tT]\\s+[aA][lL].?$", "");
                String string3 = (string2 = string2.replaceAll("[\\s\\p{Punct}]*[eE][tT][cC].?$", "")).contains(";") ? ";" : ",";
                string2 = string2.replaceAll("\\b[aA][nN][dD]\\b|&", string3);
                stringArray = string2.split(string3);
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    stringArray[n3] = stringArray[n3].trim().replaceAll("^\\p{Punct}\\s+", "");
                }
                if (string3.equals(",")) {
                    for (n3 = 1; n3 < stringArray.length; ++n3) {
                        if (!firstNamesPattern.matcher(stringArray[n3]).matches()) continue;
                        stringArray[n3 - 1] = stringArray[n3] + " " + stringArray[n3 - 1];
                        stringArray[n3] = "";
                        ++n3;
                    }
                }
                n3 = 0;
                n2 = 0;
                n = 0;
                for (String string4 : stringArray) {
                    if (string4.isEmpty()) continue;
                    if (string4.contains(",")) {
                        ++n3;
                        continue;
                    }
                    String[] stringArray2 = string4.split("\\s+");
                    if (firstNamesPattern.matcher(stringArray2[stringArray2.length - 1]).matches()) {
                        ++n2;
                        continue;
                    }
                    ++n;
                }
                if (n3 <= n2 || n3 <= n) break block9;
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray3 = stringArray[i].split("\\s*,\\s*");
                    if (stringArray3.length != 2) continue;
                    stringArray[i] = stringArray3[1] + " " + stringArray3[0];
                }
                break block10;
            }
            if (n2 <= n3 || n2 <= n) break block10;
            StringBuilder stringBuilder = new StringBuilder(128);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray4 = stringArray[i].split("\\s+");
                stringBuilder.append(stringArray4[stringArray4.length - 1]);
                stringBuilder.append(' ');
                for (int j = 0; j < stringArray4.length - 1; ++j) {
                    stringBuilder.append(stringArray4[j]);
                    stringBuilder.append(' ');
                }
                stringArray[i] = stringBuilder.toString().trim();
                stringBuilder.setLength(0);
            }
        }
        return Arrays.asList(stringArray).stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    private static <T> List<T> removeNulls(List<T> list) {
        return list.stream().filter(object -> object != null).collect(Collectors.toList());
    }

    private static String getAuthorLastName(String string) {
        int n = string.lastIndexOf(" ");
        return string.substring(n + 1);
    }

    private static int refStart(List<String> list) {
        for (int i = list.size() / 3; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.endsWith("References") || string.endsWith("Citations") || string.endsWith("Bibliography") || string.endsWith("Bibliographie") || string.endsWith("REFERENCES") || string.endsWith("CITATIONS") || string.endsWith("BIBLIOGRAPHY") || string.endsWith("BIBLIOGRAPHIE")) {
                return i;
            }
            if (!string.contains("References<lb>") && !string.contains("Citations<lb>") && !string.contains("Bibliography<lb>") && !string.contains("Bibliographie<lb>") && !string.contains("REFERENCES<lb>") && !string.contains("CITATIONS<lb>") && !string.contains("BIBLIOGRAPHY<lb>") && !string.contains("BIBLIOGRAPHIE<lb>")) continue;
            return i - 1;
        }
        return -1;
    }

    public static int getIdxOf(List<BibRecord> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).citeRegEx.matcher(string).matches()) continue;
            return i;
        }
        return -1;
    }

    public static Pair<Integer, Integer> shortCiteSearch(int n, int n2, String string, List<BibRecord> list) {
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        for (BibRecord bibRecord : list) {
            Matcher matcher = RegexWithTimeout.matcher(bibRecord.shortCiteRegEx, string);
            if (matcher.find()) {
                if (matcher.start() > n) continue;
                n3 = matcher.start();
                n4 = n5;
                break;
            }
            ++n5;
        }
        return Tuples.pair((Object)n3, (Object)n4);
    }

    public static List<CitationRecord> findCitations(List<String> list, List<BibRecord> list2, BibStractor bibStractor) {
        ArrayList<CitationRecord> arrayList = new ArrayList<CitationRecord>();
        Pattern pattern = Pattern.compile(bibStractor.getCiteRegex());
        Pattern pattern2 = Pattern.compile("([0-9]+)\\p{Pd}([0-9]+)");
        int n = ExtractReferences.refStart(list);
        if (n < 0) {
            n = list.size();
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = list.get(i).replaceAll("-<lb>", "").replaceAll("<lb>", " ");
            list.set(i, string);
            Matcher matcher = RegexWithTimeout.matcher(pattern, string);
            while (matcher.find()) {
                object = matcher.group(1).split(bibStractor.getCiteDelimiter());
                for (String string2 : object) {
                    int n2;
                    Matcher matcher2 = RegexWithTimeout.matcher(pattern2, string2);
                    if (matcher2.matches()) {
                        n2 = Integer.parseInt(matcher2.group(1));
                        int n3 = Integer.parseInt(matcher2.group(2));
                        for (int j = n2; j <= n3; ++j) {
                            if (Thread.interrupted()) {
                                throw new Parser.ParsingTimeout();
                            }
                            int n4 = ExtractReferences.getIdxOf(list2, j + "");
                            if (n4 < 0) continue;
                            arrayList.add(new CitationRecord(n4, list.get(i), matcher.start(), matcher.end()));
                        }
                        continue;
                    }
                    n2 = ExtractReferences.getIdxOf(list2, string2.trim());
                    if (n2 < 0) continue;
                    arrayList.add(new CitationRecord(n2, list.get(i), matcher.start(), matcher.end()));
                }
            }
            if (bibStractor.getShortCiteRegex() == null) continue;
            object = Pattern.compile(bibStractor.getShortCiteRegex());
            Matcher matcher3 = RegexWithTimeout.matcher((Pattern)object, string);
            while (matcher3.find()) {
                Pair<Integer, Integer> pair = ExtractReferences.shortCiteSearch(matcher3.start(), Integer.parseInt(matcher3.group(1).substring(0, 4)), string, list2);
                int n5 = (Integer)pair.getOne();
                int n6 = (Integer)pair.getTwo();
                if (n5 <= 0) continue;
                arrayList.add(new CitationRecord(n6, list.get(i), n5, matcher3.end() + 1));
            }
        }
        return arrayList;
    }

    public int numFound(List<BibRecord> list) {
        int n = 0;
        for (BibRecord bibRecord : list) {
            if (!this.cr.hasPaper(bibRecord.title, bibRecord.author, bibRecord.year, bibRecord.venue)) continue;
            ++n;
        }
        return n;
    }

    public int longestIdx(List<BibRecord>[] listArray) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < listArray.length; ++i) {
            int n3 = 10000 * this.numFound(listArray[i]) + listArray[i].size();
            if (n3 <= n) continue;
            n2 = i;
            n = n3;
        }
        return n2;
    }

    public boolean refEnd(String string) {
        return string.endsWith("Appendix") || string.endsWith("APPENDIX");
    }

    private static List<BibRecord> clean(List<BibRecord> list) {
        ArrayList<BibRecord> arrayList = new ArrayList<BibRecord>(list.size());
        for (BibRecord bibRecord : list) {
            String string2 = bibRecord.title.trim().replaceAll("^\\p{P}", "").replaceAll("[\\p{P}&&[^)]]$", "");
            if (string2.isEmpty() || string2.length() >= 512 || bibRecord.venue != null && bibRecord.venue.length() >= 512 || bibRecord.author != null && !bibRecord.author.stream().allMatch(string -> string.length() < 512)) continue;
            arrayList.add(bibRecord.withTitle(string2));
        }
        return arrayList;
    }

    public Pair<List<BibRecord>, BibStractor> findReferences(List<String> list) {
        int n;
        int n2 = ExtractReferences.refStart(list) + 1;
        ArrayList[] arrayListArray = new ArrayList[this.extractors.size()];
        for (int i = 0; i < arrayListArray.length; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < list.size() && !this.refEnd(list.get(i)); ++i) {
            stringBuilder.append("<bb>");
            stringBuilder.append(list.get(i));
        }
        String string = stringBuilder.toString();
        for (n = 0; n < arrayListArray.length; ++n) {
            arrayListArray[n] = this.extractors.get(n).parse(string);
            arrayListArray[n] = ExtractReferences.clean(arrayListArray[n]);
        }
        n = this.longestIdx(arrayListArray);
        return Tuples.pair((Object)arrayListArray[n], (Object)this.extractors.get(n));
    }

    public static String getCiteAuthorFromAuthors(List<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() > 2) {
            return ExtractReferences.cleanAuthString(ExtractReferences.getAuthorLastName(list.get(0))) + " et al\\.";
        }
        if (list.size() == 1) {
            return ExtractReferences.cleanAuthString(ExtractReferences.getAuthorLastName(list.get(0)));
        }
        if (list.size() == 2) {
            return ExtractReferences.cleanAuthString(ExtractReferences.getAuthorLastName(list.get(0))) + " and " + ExtractReferences.cleanAuthString(ExtractReferences.getAuthorLastName(list.get(1)));
        }
        return null;
    }

    private class BracketName
    extends BibStractor {
        protected final String citeRegex = "\\[([^\\]]+)\\]";
        protected final String citeDelimiter = "; ?";

        BracketName(Class[] classArray) {
            super(classArray);
            this.citeRegex = "\\[([^\\]]+)\\]";
            this.citeDelimiter = "; ?";
        }

        @Override
        public String getCiteRegex() {
            return "\\[([^\\]]+)\\]";
        }

        @Override
        public String getCiteDelimiter() {
            return "; ?";
        }

        @Override
        public List<BibRecord> parse(String string) {
            if (string.startsWith("<bb>")) {
                string = string.substring(4);
            }
            String[] stringArray = string.split("<bb>");
            List<String> list = Arrays.asList(stringArray);
            ArrayList<BibRecord> arrayList = new ArrayList();
            boolean bl = true;
            block0: for (String string2 : list) {
                string2 = string2.replaceAll("-<lb>", "").replaceAll("<lb>", " ").trim();
                if (bl && string2.length() > 0) {
                    if (RegexWithTimeout.matcher(pBracket, string2).matches() || RegexWithTimeout.matcher(pDot, string2).matches()) {
                        return ExtractReferences.removeNulls(arrayList);
                    }
                    bl = false;
                }
                for (int i = 0; i < this.recParser.length; ++i) {
                    BibRecord bibRecord = this.recParser[i].parseRecord(string2);
                    if (bibRecord == null) continue;
                    arrayList.add(bibRecord);
                    continue block0;
                }
            }
            arrayList = ExtractReferences.removeNulls(arrayList);
            return arrayList;
        }
    }

    private class BracketNumber
    extends BibStractor {
        protected final String citeRegex = "\\[([0-9, \\p{Pd}]+)\\]";
        protected final String citeDelimiter = "(,| |;)+";

        BracketNumber(Class[] classArray) {
            super(classArray);
            this.citeRegex = "\\[([0-9, \\p{Pd}]+)\\]";
            this.citeDelimiter = "(,| |;)+";
        }

        @Override
        public String getCiteRegex() {
            return "\\[([0-9, \\p{Pd}]+)\\]";
        }

        @Override
        public String getCiteDelimiter() {
            return "(,| |;)+";
        }

        @Override
        public List<BibRecord> parse(String string) {
            string = string.replaceAll("<bb>", "<lb>");
            int n = 0;
            String string2 = "[" + ++n + "]";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = string.indexOf(string2);
            while (n2 >= 0) {
                string2 = "<lb>[" + ++n + "]";
                int n3 = string.indexOf(string2, n2);
                if (n3 > 0) {
                    arrayList.add(string.substring(n2, n3));
                } else {
                    arrayList.add(string.substring(n2));
                }
                n2 = n3;
            }
            ArrayList<BibRecord> arrayList2 = new ArrayList();
            boolean bl = true;
            block1: for (String string3 : arrayList) {
                string3 = string3.replaceAll("-<lb>(\\p{Ll})", "$1").replaceAll("<lb>", " ").trim();
                for (int i = 0; i < this.recParser.length; ++i) {
                    BibRecord bibRecord = this.recParser[i].parseRecord(string3);
                    if (bibRecord == null) continue;
                    arrayList2.add(bibRecord);
                    continue block1;
                }
            }
            arrayList2 = ExtractReferences.removeNulls(arrayList2);
            return arrayList2;
        }
    }

    private class NumberDot
    extends BracketNumber {
        NumberDot(Class[] classArray) {
            super(classArray);
        }

        protected List<BibRecord> parseWithGivenBreaks(String string, boolean bl) {
            string = !bl ? string.replaceAll("<bb>", "<lb>") : string.replaceAll("<lb>", " ");
            int n = 0;
            String string2 = "<bb>";
            if (!bl) {
                string2 = "<lb>";
            }
            String string3 = string2 + ++n + ". ";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = string.indexOf(string3);
            while (n2 >= 0) {
                string3 = string2 + ++n + ". ";
                int n3 = string.indexOf(string3, n2);
                if (n3 > 0) {
                    arrayList.add(string.substring(n2, n3));
                } else {
                    arrayList.add(string.substring(n2));
                }
                n2 = n3;
            }
            ArrayList<BibRecord> arrayList2 = new ArrayList();
            block1: for (String string4 : arrayList) {
                string4 = string4.replaceAll("-<lb>", "").replaceAll("<lb>", " ");
                string4 = string4.replaceAll("-<bb>", "").replaceAll("<bb>", " ");
                for (int i = 0; i < this.recParser.length; ++i) {
                    BibRecord bibRecord = this.recParser[i].parseRecord(string4);
                    if (bibRecord == null) continue;
                    arrayList2.add(bibRecord);
                    continue block1;
                }
            }
            arrayList2 = ExtractReferences.removeNulls(arrayList2);
            return arrayList2;
        }

        @Override
        public List<BibRecord> parse(String string) {
            return this.parseWithGivenBreaks(string, false);
        }
    }

    private class NumberDotNaturalLineBreaks
    extends NumberDot {
        NumberDotNaturalLineBreaks(Class[] classArray) {
            super(classArray);
        }

        @Override
        public List<BibRecord> parse(String string) {
            return this.parseWithGivenBreaks(string, true);
        }
    }

    public class NamedYear
    extends BibStractor {
        private static final String citeRegex = "(?:\\[|\\()([^\\[\\(\\]\\)]+ [1-2][0-9]{3}[a-z]?)+(?:\\]|\\))";
        private static final String shortCiteRegex = "(?:\\[|\\()([1-2][0-9]{3}[a-z]?)(?:\\]|\\))";
        private static final String citeDelimiter = "; ?";

        NamedYear(Class[] classArray) {
            super(classArray);
        }

        @Override
        public String getCiteRegex() {
            return citeRegex;
        }

        @Override
        public String getShortCiteRegex() {
            return shortCiteRegex;
        }

        @Override
        public String getCiteDelimiter() {
            return citeDelimiter;
        }

        @Override
        public List<BibRecord> parse(String string) {
            if (string.startsWith("<bb>")) {
                string = string.substring(4);
            }
            String[] stringArray = string.split("<bb>");
            List<String> list = Arrays.asList(stringArray);
            ArrayList<BibRecord> arrayList = new ArrayList();
            boolean bl = true;
            block0: for (String string2 : list) {
                string2 = string2.replaceAll("-<lb>", "").replaceAll("<lb>", " ").trim();
                if (bl && string2.length() > 0) {
                    if (RegexWithTimeout.matcher(pBracket, string2).matches() || RegexWithTimeout.matcher(pDot, string2).matches()) {
                        return ExtractReferences.removeNulls(arrayList);
                    }
                    bl = false;
                }
                for (int i = 0; i < this.recParser.length; ++i) {
                    BibRecord bibRecord = this.recParser[i].parseRecord(string2);
                    if (bibRecord == null) continue;
                    arrayList.add(bibRecord);
                    continue block0;
                }
            }
            arrayList = ExtractReferences.removeNulls(arrayList);
            return arrayList;
        }
    }

    public class DataMatchBibStractor
    extends BibStractor {
        DataMatchBibStractor(Class[] classArray) {
            if (classArray != null) {
                log.error("BibRecordParsers not supported in DataMatchBibStractor.  Ignoring.");
            }
        }

        @Override
        public List<BibRecord> parse(String string) {
            ArrayList<BibRecord> arrayList = new ArrayList<BibRecord>();
            boolean bl = true;
            return arrayList;
        }

        @Override
        public String getCiteRegex() {
            return null;
        }

        @Override
        public String getCiteDelimiter() {
            return null;
        }
    }

    private static class BracketNameBibRecordParser
    implements BibRecordParser {
        private static final String regEx1 = "\\[([^\\]]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*), ([1-2][0-9]{3})\\.";
        private static final Pattern pattern1 = Pattern.compile("\\[([^\\]]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*), ([1-2][0-9]{3})\\.");
        private static final String regEx2 = "\\[([^\\]]+)\\] (\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*),? ([1-2][0-9]{3})\\..*";
        private static final Pattern pattern2 = Pattern.compile("\\[([^\\]]+)\\] (\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*),? ([1-2][0-9]{3})\\..*");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern1, string.trim());
            Matcher matcher2 = RegexWithTimeout.matcher(pattern2, string.trim());
            if (matcher.matches()) {
                if (matcher.group(1).matches("[0-9]+")) {
                    return null;
                }
                return new BibRecord(matcher.group(3), ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(4), ExtractReferences.authStrToPat(ExtractReferences.cleanAuthString(matcher.group(1))), null, ExtractReferences.extractRefYear(matcher.group(5)));
            }
            if (matcher2.matches()) {
                if (matcher2.group(1).matches("[0-9]+")) {
                    return null;
                }
                return new BibRecord(matcher2.group(3), ExtractReferences.authorStringToList(matcher2.group(2)), matcher2.group(4), ExtractReferences.authStrToPat(ExtractReferences.cleanAuthString(matcher2.group(1))), null, ExtractReferences.extractRefYear(matcher2.group(5)));
            }
            return null;
        }
    }

    private static class BracketNumberInitialsYearParensCOMMAS
    implements BibRecordParser {
        private static final String regEx1 = "\\[([0-9]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*)\\(.*([1-2][0-9]{3}).*\\).*";
        private static final Pattern pattern1 = Pattern.compile("\\[([0-9]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*)\\(.*([1-2][0-9]{3}).*\\).*");
        private static final String regEx2 = "\\[([0-9]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*), ((?:20|19)[0-9]{2})(?:\\.|,).*";
        private static final Pattern pattern2 = Pattern.compile("\\[([0-9]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)(?:,|\\.) ([^\\.,]+)(?:,|\\.) (?:(?:I|i)n )?(.*), ((?:20|19)[0-9]{2})(?:\\.|,).*");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern1, string.trim());
            Matcher matcher2 = RegexWithTimeout.matcher(pattern2, string.trim());
            if (matcher.matches()) {
                return new BibRecord(matcher.group(3), ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(4), Pattern.compile(matcher.group(1)), null, ExtractReferences.extractRefYear(matcher.group(5)));
            }
            if (matcher2.matches()) {
                return new BibRecord(matcher2.group(3), ExtractReferences.authorStringToList(matcher2.group(2)), matcher2.group(4), Pattern.compile(matcher2.group(1)), null, ExtractReferences.extractRefYear(matcher2.group(5)));
            }
            return null;
        }
    }

    private static class NamedYearInParensBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "(\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*) +\\(([1-2][0-9]{3}[a-z]?)\\)\\. ([^\\.]+)\\. (?:(?:I|i)n )?(.*)\\.?";
        private static final Pattern pattern = Pattern.compile("(\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*) +\\(([1-2][0-9]{3}[a-z]?)\\)\\. ([^\\.]+)\\. (?:(?:I|i)n )?(.*)\\.?");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                List<String> list = ExtractReferences.authorStringToList(matcher.group(1));
                int n = Integer.parseInt(matcher.group(2).substring(0, 4));
                String string2 = ExtractReferences.getCiteAuthorFromAuthors(list);
                String string3 = string2 + ",? " + matcher.group(2);
                return new BibRecord(matcher.group(3), list, matcher.group(4), ExtractReferences.authStrToPat(string3), ExtractReferences.authStrToPat(string2), n);
            }
            return null;
        }
    }

    private static class NamedYearBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "(\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*) +([1-2][0-9]{3}[a-z]?)\\. ([^\\.]+)\\. (?:(?:I|i)n )?(.*)\\.?";
        private static final Pattern pattern = Pattern.compile("(\\p{Lu}[\\p{L}\\.'`\\- ]+(?:(?:; |, |, and |; and | and )\\p{Lu}[\\p{L}\\.'`\\- ]+)*) +([1-2][0-9]{3}[a-z]?)\\. ([^\\.]+)\\. (?:(?:I|i)n )?(.*)\\.?");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                List<String> list = ExtractReferences.authorStringToList(matcher.group(1));
                int n = Integer.parseInt(matcher.group(2).substring(0, 4));
                String string2 = ExtractReferences.getCiteAuthorFromAuthors(list);
                String string3 = string2 + ",? " + matcher.group(2);
                return new BibRecord(matcher.group(3), list, matcher.group(4), ExtractReferences.authStrToPat(string3), ExtractReferences.authStrToPat(string2), n);
            }
            return null;
        }
    }

    private static class NumberDotYearNoParensBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "([0-9]+)\\. ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*). ([^\\.]+)\\. (?:(?:I|i)n: )?(.*) ([1-2][0-9]{3}).( .*)?";
        private static final Pattern pattern = Pattern.compile("([0-9]+)\\. ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*). ([^\\.]+)\\. (?:(?:I|i)n: )?(.*) ([1-2][0-9]{3}).( .*)?");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                return new BibRecord(matcher.group(3), ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(4), Pattern.compile(matcher.group(1)), null, ExtractReferences.extractRefYear(matcher.group(5)));
            }
            return null;
        }
    }

    private static class NumberDotYearParensBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "([0-9]+)\\. ([^:]+): ([^\\.]+)\\. (?:(?:I|i)n: )?(.*) \\([^)]*([0-9]{4})\\)\\.?(?: .*)?";
        private static final Pattern pattern = Pattern.compile("([0-9]+)\\. ([^:]+): ([^\\.]+)\\. (?:(?:I|i)n: )?(.*) \\([^)]*([0-9]{4})\\)\\.?(?: .*)?");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                return new BibRecord(matcher.group(3), ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(4), Pattern.compile(matcher.group(1)), null, ExtractReferences.extractRefYear(matcher.group(5)));
            }
            return null;
        }
    }

    static class NumberDotAuthorNoTitleBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "([0-9]+)\\. +(\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?, (?:\\p{Lu}\\.-? ?)+(?:; \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?, (?:\\p{Lu}\\.-? ?)+)*) ([^0-9]*) ([1-2][0-9]{3})(?:\\.|,[0-9, ]*)(?:.*)";
        private static final Pattern pattern = Pattern.compile("([0-9]+)\\. +(\\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?, (?:\\p{Lu}\\.-? ?)+(?:; \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?, (?:\\p{Lu}\\.-? ?)+)*) ([^0-9]*) ([1-2][0-9]{3})(?:\\.|,[0-9, ]*)(?:.*)");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                return new BibRecord("", ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(3), Pattern.compile(matcher.group(1)), null, ExtractReferences.extractRefYear(matcher.group(4)));
            }
            return null;
        }
    }

    private static class BracketNumberBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "\\[([0-9]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)\\. ([^\\.]+)\\. (?:(?:I|i)n )?(.*) ([1-2][0-9]{3})\\.( .*)?";
        private static final Pattern pattern = Pattern.compile("\\[([0-9]+)\\] ((?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?(?:(?:; |, |, and |; and | and )(?:\\p{Lu}\\.?(?:-| )?)+ \\p{Lu}[\\p{L}'`\\-]+(?: \\p{Lu}[\\p{L}'`\\-]+)?)*)\\. ([^\\.]+)\\. (?:(?:I|i)n )?(.*) ([1-2][0-9]{3})\\.( .*)?");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                return new BibRecord(matcher.group(3), ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(4), Pattern.compile(matcher.group(1)), null, ExtractReferences.extractRefYear(matcher.group(5)));
            }
            return null;
        }
    }

    private static class BracketNumberInitialsQuotedBibRecordParser
    implements BibRecordParser {
        private static final String regEx = "\\[([0-9]+)\\] (.*)(?:,|\\.|:) [\\p{Pi}\"']+(.*),[\\p{Pf}\"']+ (?:(?:I|i)n )?(.*)\\.?";
        private static final Pattern pattern = Pattern.compile("\\[([0-9]+)\\] (.*)(?:,|\\.|:) [\\p{Pi}\"']+(.*),[\\p{Pf}\"']+ (?:(?:I|i)n )?(.*)\\.?");

        @Override
        public BibRecord parseRecord(String string) {
            Matcher matcher = RegexWithTimeout.matcher(pattern, string.trim());
            if (matcher.matches()) {
                return new BibRecord(matcher.group(3), ExtractReferences.authorStringToList(matcher.group(2)), matcher.group(4), Pattern.compile(matcher.group(1)), null, ExtractReferences.extractRefYear(matcher.group(4)));
            }
            return null;
        }
    }

    private static class DefaultBibRecordParser
    implements BibRecordParser {
        private DefaultBibRecordParser() {
        }

        @Override
        public BibRecord parseRecord(String string) {
            return new BibRecord(string, null, null, null, null, 0);
        }
    }

    public abstract class BibStractor {
        final BibRecordParser[] recParser;

        BibStractor(Class[] classArray) {
            BibRecordParser bibRecordParser = null;
            this.recParser = new BibRecordParser[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == CRFBibRecordParser.class) {
                    bibRecordParser = ExtractReferences.this.bibCRFRecordParser;
                } else {
                    try {
                        bibRecordParser = (BibRecordParser)classArray[i].newInstance();
                    }
                    catch (Exception exception) {
                        log.warn("Exception while creating BibStractor", (Throwable)exception);
                    }
                }
                this.recParser[i] = bibRecordParser;
            }
        }

        BibStractor() {
            this.recParser = null;
        }

        public abstract List<BibRecord> parse(String var1);

        public abstract String getCiteRegex();

        public String getShortCiteRegex() {
            return null;
        }

        public abstract String getCiteDelimiter();
    }

    public static interface BibRecordParser {
        public BibRecord parseRecord(String var1);
    }
}

