/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.tuple.Tuples;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.allenai.scienceparse.BibRecord;
import org.allenai.scienceparse.CitationRecord;
import org.allenai.scienceparse.PDFToCRFInput;
import org.allenai.scienceparse.PaperToken;
import org.allenai.scienceparse.ParserGroundTruth;
import org.allenai.scienceparse.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractedMetadata {
    private static final Logger log = LoggerFactory.getLogger(ExtractedMetadata.class);
    public static final String titleTag = "T";
    public static final String authorTag = "A";
    public static final String yearTag = "Y";
    public static final String venueTag = "V";
    private static transient Pattern emailDelimitersRegex = Pattern.compile(",|\\||;");
    public Source source;
    public String title;
    public List<String> authors;
    public List<String> emails;
    public List<Section> sections;
    public List<BibRecord> references;
    public List<CitationRecord> referenceMentions;
    public int year;
    public String abstractText;
    public String creator;

    public ExtractedMetadata(List<PaperToken> list, List<String> list2) {
        List<LabelSpan> list3 = ExtractedMetadata.getSpans(list2);
        this.authors = new ArrayList<String>();
        for (LabelSpan labelSpan : list3) {
            if (this.title == null && labelSpan.tag.equals(titleTag)) {
                this.title = PDFToCRFInput.stringAt(list, labelSpan.loc);
                continue;
            }
            if (!labelSpan.tag.equals(authorTag)) continue;
            this.authors.add(PDFToCRFInput.stringAt(list, labelSpan.loc));
        }
        this.emails = ExtractedMetadata.getEmails(list);
    }

    public ExtractedMetadata(String string, List<String> list, Date date) {
        this.title = string;
        this.authors = list;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.year = calendar.get(1);
        }
        this.emails = new ArrayList<String>();
    }

    public ExtractedMetadata(ParserGroundTruth.Paper paper) {
        this.title = paper.title;
        this.authors = Arrays.asList(paper.authors);
        this.year = paper.year;
        this.emails = new ArrayList<String>();
    }

    public static List<String> tokToMail(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string.contains("@")) {
            return null;
        }
        if ((string = string.replaceAll("\\P{Print}", "")).contains(":") && string.split(":").length > 1) {
            string = string.split(":")[1];
        }
        if ((stringArray = string.split("@")).length == 2) {
            String string2 = stringArray[1];
            String string3 = stringArray[0];
            String[] stringArray2 = new String[1];
            if (string3.startsWith("{") && string3.endsWith("}") || string3.startsWith("[") && string3.endsWith("]") || string3.contains(",") || string3.contains("|")) {
                string3 = string3.replaceAll("\\{|\\}|\\[|\\]", "");
                stringArray2 = string3.split(emailDelimitersRegex.pattern());
            } else {
                stringArray2[0] = string3;
            }
            for (String string4 : stringArray2) {
                arrayList.add(string4.trim() + "@" + string2);
            }
        } else {
            log.debug("e-mail parts not 2");
        }
        return arrayList;
    }

    public static List<String> getEmails(List<PaperToken> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PaperToken paperToken : list) {
            String string;
            if (paperToken.getPdfToken() == null || (string = paperToken.getPdfToken().token) == null || !string.contains("@")) continue;
            arrayList.addAll(ExtractedMetadata.tokToMail(string));
        }
        return arrayList;
    }

    public static List<LabelSpan> getSpans(List<String> list) {
        ArrayList<LabelSpan> arrayList = new ArrayList<LabelSpan>();
        int n = -1;
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            LabelSpan labelSpan;
            String string2;
            String string3 = list.get(i);
            if (string3.equals("O")) {
                n = -1;
                continue;
            }
            if (string3.startsWith("B_")) {
                n = i;
                string = string3.substring(2);
                continue;
            }
            if (string3.startsWith("I_")) {
                string2 = string3.substring(2);
                if (string.equals(string2)) continue;
                n = -1;
                continue;
            }
            if (string3.startsWith("E_")) {
                string2 = string3.substring(2);
                if (!string.equals(string2) || n < 0) continue;
                labelSpan = new LabelSpan(string, (Pair<Integer, Integer>)Tuples.pair((Object)n, (Object)(i + 1)));
                arrayList.add(labelSpan);
                n = -1;
                continue;
            }
            if (!string3.startsWith("W_")) continue;
            string2 = string3.substring(2);
            labelSpan = new LabelSpan(string2, (Pair<Integer, Integer>)Tuples.pair((Object)i, (Object)(i + 1)));
            arrayList.add(labelSpan);
            n = -1;
        }
        return arrayList;
    }

    public void setYearFromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.year = calendar.get(1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("T: " + this.title + "\r\n");
        this.authors.forEach(string -> stringBuffer.append("A: " + string + "\r\n"));
        this.emails.forEach(string -> stringBuffer.append("E: " + string + "\r\n"));
        return stringBuffer.toString();
    }

    public Source getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public List<BibRecord> getReferences() {
        return this.references;
    }

    public List<CitationRecord> getReferenceMentions() {
        return this.referenceMentions;
    }

    public int getYear() {
        return this.year;
    }

    public String getAbstractText() {
        return this.abstractText;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setAuthors(List<String> list) {
        this.authors = list;
    }

    public void setEmails(List<String> list) {
        this.emails = list;
    }

    public void setSections(List<Section> list) {
        this.sections = list;
    }

    public void setReferences(List<BibRecord> list) {
        this.references = list;
    }

    public void setReferenceMentions(List<CitationRecord> list) {
        this.referenceMentions = list;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public void setAbstractText(String string) {
        this.abstractText = string;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExtractedMetadata)) {
            return false;
        }
        ExtractedMetadata extractedMetadata = (ExtractedMetadata)object;
        if (!extractedMetadata.canEqual(this)) {
            return false;
        }
        Source source = this.getSource();
        Source source2 = extractedMetadata.getSource();
        if (source == null ? source2 != null : !((Object)((Object)source)).equals((Object)source2)) {
            return false;
        }
        String string = this.getTitle();
        String string2 = extractedMetadata.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List<String> list = this.getAuthors();
        List<String> list2 = extractedMetadata.getAuthors();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getEmails();
        List<String> list4 = extractedMetadata.getEmails();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        List<Section> list5 = this.getSections();
        List<Section> list6 = extractedMetadata.getSections();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        List<BibRecord> list7 = this.getReferences();
        List<BibRecord> list8 = extractedMetadata.getReferences();
        if (list7 == null ? list8 != null : !((Object)list7).equals(list8)) {
            return false;
        }
        List<CitationRecord> list9 = this.getReferenceMentions();
        List<CitationRecord> list10 = extractedMetadata.getReferenceMentions();
        if (list9 == null ? list10 != null : !((Object)list9).equals(list10)) {
            return false;
        }
        if (this.getYear() != extractedMetadata.getYear()) {
            return false;
        }
        String string3 = this.getAbstractText();
        String string4 = extractedMetadata.getAbstractText();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getCreator();
        String string6 = extractedMetadata.getCreator();
        return !(string5 == null ? string6 != null : !string5.equals(string6));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ExtractedMetadata;
    }

    public int hashCode() {
        int n = 1;
        Source source = this.getSource();
        n = n * 59 + (source == null ? 43 : ((Object)((Object)source)).hashCode());
        String string = this.getTitle();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        List<String> list = this.getAuthors();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getEmails();
        n = n * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        List<Section> list3 = this.getSections();
        n = n * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        List<BibRecord> list4 = this.getReferences();
        n = n * 59 + (list4 == null ? 43 : ((Object)list4).hashCode());
        List<CitationRecord> list5 = this.getReferenceMentions();
        n = n * 59 + (list5 == null ? 43 : ((Object)list5).hashCode());
        n = n * 59 + this.getYear();
        String string2 = this.getAbstractText();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getCreator();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        return n;
    }

    public static class LabelSpan {
        public final String tag;
        public final Pair<Integer, Integer> loc;

        @ConstructorProperties(value={"tag", "loc"})
        public LabelSpan(String string, Pair<Integer, Integer> pair) {
            this.tag = string;
            this.loc = pair;
        }
    }

    public static enum Source {
        INVALID,
        CRF,
        META;

    }
}

