/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

class MarkableFileInputStream
extends FilterInputStream {
    private FileChannel fileChannel;
    private static final long NOT_MARKED = -1L;
    private static final long MARK_FAILED = -2L;
    private long mark = -1L;

    public MarkableFileInputStream(FileInputStream fileInputStream) {
        super(fileInputStream);
        this.fileChannel = fileInputStream.getChannel();
        this.mark(0);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.mark = this.fileChannel.position();
        }
        catch (IOException iOException) {
            this.mark = -2L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1L) {
            throw new IOException("not marked");
        }
        if (this.mark == -2L) {
            throw new IOException("previous mark failed");
        }
        this.fileChannel.position(this.mark);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

