/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserGroundTruth {
    private static final Logger log = LoggerFactory.getLogger(ParserGroundTruth.class);
    public List<Paper> papers;
    public HashMap<String, Integer> lookup = new HashMap();

    private void buildLookup() {
        for (int i = 0; i < this.papers.size(); ++i) {
            this.lookup.put(this.papers.get((int)i).id.substring(4), i);
        }
    }

    public ParserGroundTruth(List<Paper> list) throws IOException {
        this.papers = list;
        this.buildLookup();
    }

    public ParserGroundTruth(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String string;
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectReader objectReader = objectMapper.reader().forType((TypeReference)new TypeReference<Paper>(){});
            this.papers = new ArrayList<Paper>();
            while ((string = bufferedReader.readLine()) != null) {
                this.papers.add((Paper)objectReader.readValue(string));
            }
        }
        log.info("Read " + this.papers.size() + " papers.");
        this.buildLookup();
        this.papers.forEach(paper -> {
            for (int i = 0; i < paper.authors.length; ++i) {
                paper.authors[i] = ParserGroundTruth.invertAroundComma(paper.authors[i]);
            }
        });
    }

    public ParserGroundTruth(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public static String invertAroundComma(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length == 2) {
            return (stringArray[1] + " " + stringArray[0]).trim();
        }
        return string;
    }

    public Paper forKey(String string) {
        if (!this.lookup.containsKey(string)) {
            log.info("key not found: " + string);
            return null;
        }
        return this.papers.get(this.lookup.get(string));
    }

    public static class Paper {
        String id;
        String url;
        String title;
        String[] authors;
        int year;
        String venue;

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTitle() {
            return this.title;
        }

        public String[] getAuthors() {
            return this.authors;
        }

        public int getYear() {
            return this.year;
        }

        public String getVenue() {
            return this.venue;
        }

        public void setId(String string) {
            this.id = string;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setAuthors(String[] stringArray) {
            this.authors = stringArray;
        }

        public void setYear(int n) {
            this.year = n;
        }

        public void setVenue(String string) {
            this.venue = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Paper)) {
                return false;
            }
            Paper paper = (Paper)object;
            if (!paper.canEqual(this)) {
                return false;
            }
            String string = this.getId();
            String string2 = paper.getId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getUrl();
            String string4 = paper.getUrl();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            String string5 = this.getTitle();
            String string6 = paper.getTitle();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getAuthors(), paper.getAuthors())) {
                return false;
            }
            if (this.getYear() != paper.getYear()) {
                return false;
            }
            String string7 = this.getVenue();
            String string8 = paper.getVenue();
            return !(string7 == null ? string8 != null : !string7.equals(string8));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Paper;
        }

        public int hashCode() {
            int n = 1;
            String string = this.getId();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getUrl();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            String string3 = this.getTitle();
            n = n * 59 + (string3 == null ? 43 : string3.hashCode());
            n = n * 59 + Arrays.deepHashCode(this.getAuthors());
            n = n * 59 + this.getYear();
            String string4 = this.getVenue();
            n = n * 59 + (string4 == null ? 43 : string4.hashCode());
            return n;
        }

        public String toString() {
            return "ParserGroundTruth.Paper(id=" + this.getId() + ", url=" + this.getUrl() + ", title=" + this.getTitle() + ", authors=" + Arrays.deepToString(this.getAuthors()) + ", year=" + this.getYear() + ", venue=" + this.getVenue() + ")";
        }
    }
}

