/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pdfapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.FileInputStream;
import java.util.Date;
import java.util.List;
import org.allenai.scienceparse.pdfapi.PDFExtractor;

public class PDFMetadata {
    public final String title;
    public final List<String> authors;
    public final List<String> keywords;
    public final Date createDate;
    public final Date lastModifiedDate;
    public final String creator;

    public static void main(String[] stringArray) {
        PDFExtractor pDFExtractor = new PDFExtractor();
        ObjectWriter objectWriter = new ObjectMapper().writer();
        if (stringArray.length <= 1) {
            objectWriter = objectWriter.withDefaultPrettyPrinter();
        }
        for (String string : stringArray) {
            String string2 = "";
            if (stringArray.length > 1) {
                string2 = string + "\t";
            }
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                try {
                    PDFMetadata pDFMetadata = pDFExtractor.extractFromInputStream(fileInputStream).getMeta();
                    String string3 = objectWriter.writeValueAsString((Object)pDFMetadata);
                    System.out.println(string2 + string3);
                }
                catch (Exception exception) {
                    System.out.println(string2 + "ERROR: " + exception);
                }
            }
        }
    }

    PDFMetadata(String string, List<String> list, List<String> list2, Date date, Date date2, String string2) {
        this.title = string;
        this.authors = list;
        this.keywords = list2;
        this.createDate = date;
        this.lastModifiedDate = date2;
        this.creator = string2;
    }

    public static PDFMetadataBuilder builder() {
        return new PDFMetadataBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDFMetadata)) {
            return false;
        }
        PDFMetadata pDFMetadata = (PDFMetadata)object;
        if (!pDFMetadata.canEqual(this)) {
            return false;
        }
        String string = this.getTitle();
        String string2 = pDFMetadata.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List<String> list = this.getAuthors();
        List<String> list2 = pDFMetadata.getAuthors();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getKeywords();
        List<String> list4 = pDFMetadata.getKeywords();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        Date date = this.getCreateDate();
        Date date2 = pDFMetadata.getCreateDate();
        if (date == null ? date2 != null : !((Object)date).equals(date2)) {
            return false;
        }
        Date date3 = this.getLastModifiedDate();
        Date date4 = pDFMetadata.getLastModifiedDate();
        if (date3 == null ? date4 != null : !((Object)date3).equals(date4)) {
            return false;
        }
        String string3 = this.getCreator();
        String string4 = pDFMetadata.getCreator();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDFMetadata;
    }

    public int hashCode() {
        int n = 1;
        String string = this.getTitle();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        List<String> list = this.getAuthors();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getKeywords();
        n = n * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        Date date = this.getCreateDate();
        n = n * 59 + (date == null ? 43 : ((Object)date).hashCode());
        Date date2 = this.getLastModifiedDate();
        n = n * 59 + (date2 == null ? 43 : ((Object)date2).hashCode());
        String string2 = this.getCreator();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        return n;
    }

    public String toString() {
        return "PDFMetadata(title=" + this.getTitle() + ", authors=" + this.getAuthors() + ", keywords=" + this.getKeywords() + ", createDate=" + this.getCreateDate() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", creator=" + this.getCreator() + ")";
    }

    public static class PDFMetadataBuilder {
        private String title;
        private List<String> authors;
        private List<String> keywords;
        private Date createDate;
        private Date lastModifiedDate;
        private String creator;

        PDFMetadataBuilder() {
        }

        public PDFMetadataBuilder title(String string) {
            this.title = string;
            return this;
        }

        public PDFMetadataBuilder authors(List<String> list) {
            this.authors = list;
            return this;
        }

        public PDFMetadataBuilder keywords(List<String> list) {
            this.keywords = list;
            return this;
        }

        public PDFMetadataBuilder createDate(Date date) {
            this.createDate = date;
            return this;
        }

        public PDFMetadataBuilder lastModifiedDate(Date date) {
            this.lastModifiedDate = date;
            return this;
        }

        public PDFMetadataBuilder creator(String string) {
            this.creator = string;
            return this;
        }

        public PDFMetadata build() {
            return new PDFMetadata(this.title, this.authors, this.keywords, this.createDate, this.lastModifiedDate, this.creator);
        }

        public String toString() {
            return "PDFMetadata.PDFMetadataBuilder(title=" + this.title + ", authors=" + this.authors + ", keywords=" + this.keywords + ", createDate=" + this.createDate + ", lastModifiedDate=" + this.lastModifiedDate + ", creator=" + this.creator + ")";
        }
    }
}

