/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pdfapi;

import java.util.List;
import org.allenai.scienceparse.pdfapi.PDFLine;

public class PDFPage {
    public final List<PDFLine> lines;
    public final int pageNumber;
    public final int pageWidth;
    public final int pageHeight;

    PDFPage(List<PDFLine> list, int n, int n2, int n3) {
        this.lines = list;
        this.pageNumber = n;
        this.pageWidth = n2;
        this.pageHeight = n3;
    }

    public static PDFPageBuilder builder() {
        return new PDFPageBuilder();
    }

    public List<PDFLine> getLines() {
        return this.lines;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDFPage)) {
            return false;
        }
        PDFPage pDFPage = (PDFPage)object;
        if (!pDFPage.canEqual(this)) {
            return false;
        }
        List<PDFLine> list = this.getLines();
        List<PDFLine> list2 = pDFPage.getLines();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        if (this.getPageNumber() != pDFPage.getPageNumber()) {
            return false;
        }
        if (this.getPageWidth() != pDFPage.getPageWidth()) {
            return false;
        }
        return this.getPageHeight() == pDFPage.getPageHeight();
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDFPage;
    }

    public int hashCode() {
        int n = 1;
        List<PDFLine> list = this.getLines();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        n = n * 59 + this.getPageNumber();
        n = n * 59 + this.getPageWidth();
        n = n * 59 + this.getPageHeight();
        return n;
    }

    public String toString() {
        return "PDFPage(lines=" + this.getLines() + ", pageNumber=" + this.getPageNumber() + ", pageWidth=" + this.getPageWidth() + ", pageHeight=" + this.getPageHeight() + ")";
    }

    public static class PDFPageBuilder {
        private List<PDFLine> lines;
        private int pageNumber;
        private int pageWidth;
        private int pageHeight;

        PDFPageBuilder() {
        }

        public PDFPageBuilder lines(List<PDFLine> list) {
            this.lines = list;
            return this;
        }

        public PDFPageBuilder pageNumber(int n) {
            this.pageNumber = n;
            return this;
        }

        public PDFPageBuilder pageWidth(int n) {
            this.pageWidth = n;
            return this;
        }

        public PDFPageBuilder pageHeight(int n) {
            this.pageHeight = n;
            return this;
        }

        public PDFPage build() {
            return new PDFPage(this.lines, this.pageNumber, this.pageWidth, this.pageHeight);
        }

        public String toString() {
            return "PDFPage.PDFPageBuilder(lines=" + this.lines + ", pageNumber=" + this.pageNumber + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight + ")";
        }
    }
}

