/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.allenai.scienceparse.StringUtils;

public class BibRecord {
    public static final int MINYEAR = 1800;
    public static final int MAXYEAR = Calendar.getInstance().get(1) + 10;
    public String title;
    public final List<String> author;
    public final String venue;
    public final Pattern citeRegEx;
    public final Pattern shortCiteRegEx;
    public final int year;

    public BibRecord(String string, List<String> list, String string2, Pattern pattern, Pattern pattern2, int n) {
        this.title = string;
        this.author = list;
        this.venue = string2;
        this.citeRegEx = pattern;
        this.shortCiteRegEx = pattern2;
        this.year = n;
    }

    private static String normalizeInitialsInAuthor(String string) {
        string = string.trim();
        string = string.replaceAll("(\\p{Lu}\\.) (\\p{Lu}\\.)", "$1$2");
        string = string.replaceAll("(\\p{Lu}\\.) (\\p{Lu}\\.)", "$1$2");
        return string;
    }

    public BibRecord withNormalizedAuthors() {
        return new BibRecord(this.title, this.author.stream().map(BibRecord::normalizeInitialsInAuthor).filter(string -> !StringUtils.normalize(string.toLowerCase()).equals("et al")).collect(Collectors.toList()), this.venue, this.citeRegEx, this.shortCiteRegEx, this.year);
    }

    public BibRecord withTitle(String string) {
        return new BibRecord(string, this.author, this.venue, this.citeRegEx, this.shortCiteRegEx, this.year);
    }

    private static String stripSuperscriptTags(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("[\u2357\u2350]", "");
    }

    public BibRecord withoutSuperscripts() {
        return new BibRecord(BibRecord.stripSuperscriptTags(this.title), this.author.stream().map(BibRecord::stripSuperscriptTags).collect(Collectors.toList()), BibRecord.stripSuperscriptTags(this.venue), this.citeRegEx, this.shortCiteRegEx, this.year);
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getAuthor() {
        return this.author;
    }

    public String getVenue() {
        return this.venue;
    }

    public Pattern getCiteRegEx() {
        return this.citeRegEx;
    }

    public Pattern getShortCiteRegEx() {
        return this.shortCiteRegEx;
    }

    public int getYear() {
        return this.year;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String toString() {
        return "BibRecord(title=" + this.getTitle() + ", author=" + this.getAuthor() + ", venue=" + this.getVenue() + ", citeRegEx=" + this.getCiteRegEx() + ", shortCiteRegEx=" + this.getShortCiteRegEx() + ", year=" + this.getYear() + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BibRecord)) {
            return false;
        }
        BibRecord bibRecord = (BibRecord)object;
        if (!bibRecord.canEqual(this)) {
            return false;
        }
        String string = this.getTitle();
        String string2 = bibRecord.getTitle();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List<String> list = this.getAuthor();
        List<String> list2 = bibRecord.getAuthor();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        String string3 = this.getVenue();
        String string4 = bibRecord.getVenue();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        return this.getYear() == bibRecord.getYear();
    }

    protected boolean canEqual(Object object) {
        return object instanceof BibRecord;
    }

    public int hashCode() {
        int n = 1;
        String string = this.getTitle();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        List<String> list = this.getAuthor();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        String string2 = this.getVenue();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        n = n * 59 + this.getYear();
        return n;
    }
}

