/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.factory.primitive.CharIntMaps;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.tuple.Tuples;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.allenai.datastore.Datastore;
import org.allenai.ml.eval.TrainCriterionEval;
import org.allenai.ml.linalg.DenseVector;
import org.allenai.ml.linalg.Vector;
import org.allenai.ml.sequences.Evaluation;
import org.allenai.ml.sequences.SequenceTagger;
import org.allenai.ml.sequences.StateSpace;
import org.allenai.ml.sequences.crf.CRFFeatureEncoder;
import org.allenai.ml.sequences.crf.CRFModel;
import org.allenai.ml.sequences.crf.CRFPredicateExtractor;
import org.allenai.ml.sequences.crf.CRFTrainer;
import org.allenai.ml.sequences.crf.CRFWeightsEncoder;
import org.allenai.ml.util.IOUtils;
import org.allenai.ml.util.Indexer;
import org.allenai.ml.util.Parallel;
import org.allenai.pdffigures2.FigureExtractor;
import org.allenai.scienceparse.BibRecord;
import org.allenai.scienceparse.CRFBibRecordParser;
import org.allenai.scienceparse.CitationRecord;
import org.allenai.scienceparse.ExtractReferences;
import org.allenai.scienceparse.ExtractedMetadata;
import org.allenai.scienceparse.GazetteerFeatures;
import org.allenai.scienceparse.LabeledData;
import org.allenai.scienceparse.LabeledPaper;
import org.allenai.scienceparse.PDFDocToPartitionedText;
import org.allenai.scienceparse.PDFPredicateExtractor;
import org.allenai.scienceparse.PDFToCRFInput;
import org.allenai.scienceparse.PaperToken;
import org.allenai.scienceparse.ParserLMFeatures;
import org.allenai.scienceparse.ReferencesPredicateExtractor;
import org.allenai.scienceparse.RegexWithTimeout;
import org.allenai.scienceparse.Section;
import org.allenai.scienceparse.pdfapi.PDFDoc;
import org.allenai.scienceparse.pdfapi.PDFExtractor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Iterable;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.ScalaStreamSupport;

public class Parser {
    public static final int MAXHEADERWORDS = 500;
    public static final String DATA_VERSION = "0.3";
    private CRFModel<String, PaperToken, String> model;
    private ExtractReferences referenceExtractor;
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private static final Logger labeledDataLogger = LoggerFactory.getLogger((String)(logger.getName() + ".labeledData"));
    private static final Datastore datastore = Datastore.apply();
    private static Parser defaultParser = null;
    private static final int MAX_AUTHOR_LENGTH = 32;
    private static final int MIN_AUTHOR_LENGTH = 2;
    private final Timer parserKillerTimer = new Timer("Science-parse killer timer", true);
    private final MutableIntSet parseNumbersInProgress = IntSets.mutable.empty();
    private final AtomicInteger nextParseNumber = new AtomicInteger();

    public static Path getDefaultProductionModel() {
        return datastore.filePath("org.allenai.scienceparse", "productionModel.dat", 9);
    }

    public static Path getDefaultGazetteer() {
        return datastore.filePath("org.allenai.scienceparse", "gazetteer.json", 5);
    }

    public static Path getDefaultGazetteerDir() {
        return datastore.directoryPath("org.allenai.scienceparse", "kermit-gazetteers", 1);
    }

    public static Path getDefaultBibModel() {
        return datastore.filePath("org.allenai.scienceparse", "productionBibModel.dat", 7);
    }

    public static synchronized Parser getInstance() throws Exception {
        if (defaultParser == null) {
            defaultParser = new Parser();
        }
        return defaultParser;
    }

    public Parser() throws Exception {
        this(Parser.getDefaultProductionModel(), Parser.getDefaultGazetteer(), Parser.getDefaultBibModel());
    }

    public Parser(String string, String string2, String string3) throws Exception {
        this(new File(string), new File(string2), new File(string3));
    }

    public Parser(Path path, Path path2, Path path3) throws Exception {
        this(path.toFile(), path2.toFile(), path3.toFile());
    }

    public Parser(final File file, File file2, File file3) throws Exception {
        final AtomicReference atomicReference = new AtomicReference();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.info("Loading model from {}", (Object)file);
                try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
                    Parser.this.model = Parser.loadModel(dataInputStream);
                    logger.info("Loaded model from {}", (Object)file);
                }
                catch (Exception exception) {
                    atomicReference.compareAndSet(null, exception);
                    logger.warn("Failed loading model from {}", (Object)file);
                }
            }
        }, "ModelLoaderThread");
        thread.start();
        logger.info("Loading gazetteer from {}", (Object)file2);
        logger.info("Loading bib model from {}", (Object)file3);
        try (FileInputStream fileInputStream = new FileInputStream(file2);
             DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file3));){
            String string = String.format("%s-%08x.gazetteerCache.bin", file2.getName(), file2.getCanonicalPath().hashCode());
            Path path = Paths.get(System.getProperty("java.io.tmpdir"), string);
            try (RandomAccessFile randomAccessFile = new RandomAccessFile(path.toFile(), "rw");
                 FileChannel fileChannel = randomAccessFile.getChannel();
                 FileLock fileLock = fileChannel.lock();){
                if (fileChannel.size() == 0L) {
                    logger.info("Creating gazetteer cache at {}", (Object)path);
                    this.referenceExtractor = ExtractReferences.createAndWriteGazCache(fileInputStream, dataInputStream, Channels.newOutputStream(fileChannel));
                } else {
                    logger.info("Reading from gazetteer cache at {}", (Object)path);
                    this.referenceExtractor = new ExtractReferences(fileInputStream, dataInputStream, Channels.newInputStream(fileChannel));
                }
            }
        }
        logger.info("Loaded gazetteer from {}", (Object)file2);
        logger.info("Loaded bib model from {}", (Object)file3);
        thread.join();
        if (atomicReference.get() != null) {
            throw (Exception)atomicReference.get();
        }
        assert (this.model != null);
    }

    public Parser(InputStream inputStream, InputStream inputStream2, InputStream inputStream3) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.model = Parser.loadModel(dataInputStream);
        this.referenceExtractor = new ExtractReferences(inputStream2, new DataInputStream(inputStream3));
    }

    public static Pair<List<BibRecord>, List<CitationRecord>> getReferences(List<String> list, List<String> list2, ExtractReferences extractReferences) {
        Pair<List<BibRecord>, ExtractReferences.BibStractor> pair = extractReferences.findReferences(list2);
        List<BibRecord> list3 = ((List)pair.getOne()).stream().map(BibRecord::withNormalizedAuthors).collect(Collectors.toList());
        ExtractReferences.BibStractor bibStractor = (ExtractReferences.BibStractor)pair.getTwo();
        List<CitationRecord> list4 = ExtractReferences.findCitations(list, list3, bibStractor);
        return Tuples.pair(list3, list4);
    }

    public static String paperToString(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            PDFDoc pDFDoc = new PDFExtractor().extractFromInputStream(fileInputStream);
            fileInputStream.close();
            List<PaperToken> list = PDFToCRFInput.getSequence(pDFDoc);
            return PDFToCRFInput.stringAt(list, (Pair<Integer, Integer>)Tuples.pair((Object)0, (Object)list.size()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static <T> Pair<List<T>, List<T>> splitData(List<T> list, double d) {
        ArrayList<T> arrayList = new ArrayList<T>();
        ArrayList<T> arrayList2 = new ArrayList<T>();
        if (d > 0.0) {
            Collections.shuffle(list, new Random(0L));
            int n = (int)((1.0 - d) * (double)list.size());
            arrayList.addAll(list.subList(0, n));
            arrayList2.addAll(list.subList(n, list.size()));
        } else {
            arrayList.addAll(list);
        }
        return Tuples.pair(arrayList, arrayList2);
    }

    public static List<Pair<PaperToken, String>> getPaperLabels(String string, InputStream inputStream, LabeledData labeledData, PDFExtractor pDFExtractor, int n, boolean bl) throws IOException {
        PDFDoc pDFDoc;
        logger.debug("{}: starting", (Object)string);
        try {
            pDFDoc = pDFExtractor.extractFromInputStream(inputStream);
        }
        catch (Exception exception) {
            logger.warn("{} failed: {}", (Object)string, (Object)exception.toString());
            return null;
        }
        if (pDFDoc == null) {
            return null;
        }
        List<PaperToken> list = PDFToCRFInput.getSequence(pDFDoc);
        if (list.size() == 0) {
            return null;
        }
        List<Pair<PaperToken, String>> list2 = PDFToCRFInput.labelMetadata(string, list = list.subList(0, Math.min(list.size(), n)), labeledData);
        if (list2 != null && bl) {
            ExtractedMetadata extractedMetadata = new ExtractedMetadata(list2.stream().map(Pair::getOne).collect(Collectors.toList()), list2.stream().map(Pair::getTwo).collect(Collectors.toList()));
            Collection collection = labeledData.javaAuthorNames().orElse(Collections.emptyList());
            if (extractedMetadata.authors.size() != collection.size()) {
                logger.debug("{}: author mismatch, discarding. Expected {}, got {}.", new Object[]{string, collection, extractedMetadata.authors});
                list2 = null;
            }
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LabelingOutput labelFromGroundTruth(Iterator<LabeledPaper> iterator, int n, int n2, int n3, boolean bl, Set<String> set) throws IOException {
        PDFExtractor pDFExtractor = new PDFExtractor();
        int n4 = Runtime.getRuntime().availableProcessors() * 2;
        int n5 = n4 * 4;
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>(n5);
        ExecutorService executorService = Executors.newFixedThreadPool(n4);
        AtomicInteger atomicInteger = new AtomicInteger();
        ConcurrentSkipListMap concurrentSkipListMap = new ConcurrentSkipListMap();
        ArrayList<List<Pair<PaperToken, String>>> arrayList = new ArrayList<List<Pair<PaperToken, String>>>(n2 > 0 ? n2 : 1024);
        MutableSet mutableSet = new UnifiedSet().asSynchronized();
        try {
            Object object;
            if (n2 > 0) {
                logger.info("Will be labeling {} papers in {} threads.", (Object)n2, (Object)n4);
            } else {
                logger.info("Will be labeling all papers in {} threads.", (Object)n4);
            }
            while (iterator.hasNext() && (n2 <= 0 || arrayList.size() < n2)) {
                Object object2;
                while (iterator.hasNext() && arrayDeque.size() < n5) {
                    Object object3;
                    object = iterator.next();
                    object2 = ((LabeledPaper)object).labels();
                    Optional<String> optional = ((LabeledData)object2).javaTitle();
                    Optional<Collection<LabeledData.Author>> optional2 = ((LabeledData)object2).javaAuthors();
                    if (set.contains(((LabeledPaper)object).paperId()) || n3 > 0 && (!((OptionalInt)(object3 = ((LabeledData)object2).javaYear())).isPresent() || ((OptionalInt)object3).getAsInt() < n3)) continue;
                    object3 = executorService.submit(() -> Parser.lambda$labelFromGroundTruth$0(concurrentSkipListMap, (LabeledPaper)object, (LabeledData)object2, pDFExtractor, n, bl, atomicInteger, mutableSet));
                    arrayDeque.add(object3);
                }
                object = (Future)arrayDeque.poll();
                try {
                    object2 = (List)object.get();
                    if (object2 == null) continue;
                    arrayList.add((List<Pair<PaperToken, String>>)object2);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn("Interrupted while processing paper", (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    logger.warn("ExecutionException while processing paper", (Throwable)executionException);
                }
            }
            while (!(arrayDeque.isEmpty() || n2 > 0 && arrayList.size() >= n2)) {
                try {
                    object = (List)((Future)arrayDeque.poll()).get();
                    if (object == null) continue;
                    arrayList.add((List<Pair<PaperToken, String>>)object);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn("Interrupted while processing paper", (Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    logger.warn("ExecutionException while processing paper", (Throwable)executionException);
                }
            }
        }
        finally {
            executorService.shutdown();
            try {
                logger.info("Done labeling papers. Waiting for threads to shut down.");
                executorService.awaitTermination(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Interrupted while waiting for the executor to shut down. We may be leaking threads.", (Throwable)interruptedException);
            }
        }
        logger.info(String.format("Tried to label %d papers, succeeded %d times (%.2f%%), all done!", atomicInteger.get(), mutableSet.size(), (double)mutableSet.size() * 100.0 / atomicInteger.doubleValue()));
        return new LabelingOutput(arrayList, (Set<String>)mutableSet.asUnmodifiable());
    }

    private static UnifiedSet<String> readSet(String string) throws IOException {
        String string2;
        UnifiedSet unifiedSet = new UnifiedSet();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            unifiedSet.add((Object)string2);
        }
        bufferedReader.close();
        return unifiedSet;
    }

    public static void trainBibliographyCRF(File file, ParseOpts parseOpts) throws IOException {
        File file2 = new File(file, "cora-citations.txt");
        File file3 = new File(file, "umass-citations.txt");
        File file4 = new File(file, "kermit-citations.txt");
        Parser.trainBibliographyCRF(file2, file3, file4, parseOpts);
    }

    public static void trainBibliographyCRF(File file, File file2, File file3, ParseOpts parseOpts) throws IOException {
        ReferencesPredicateExtractor referencesPredicateExtractor;
        Pair<List<List<Pair<String, String>>>, List<List<Pair<String, String>>>> pair;
        List<List<Pair<String, String>>> list2 = CRFBibRecordParser.labelFromCoraFile(file);
        if (file2 != null) {
            list2.addAll(CRFBibRecordParser.labelFromUMassFile(file2));
        }
        if (file3 != null) {
            list2.addAll(CRFBibRecordParser.labelFromKermitFile(file3));
        }
        GazetteerFeatures gazetteerFeatures = null;
        try {
            if (parseOpts.gazetteerDir != null) {
                gazetteerFeatures = new GazetteerFeatures(parseOpts.gazetteerDir);
            }
        }
        catch (IOException iOException) {
            logger.error("Error importing gazetteer directory, ignoring.");
        }
        ParserLMFeatures parserLMFeatures = null;
        if (parseOpts.gazetteerFile != null) {
            pair = new Pair<List<List<Pair<String, String>>>, List<List<Pair<String, String>>>>(parseOpts.gazetteerFile);
            parserLMFeatures = new ParserLMFeatures(pair.papers, (UnifiedSet<String>)new UnifiedSet(), new File(parseOpts.backgroundDirectory), parseOpts.backgroundSamples);
            referencesPredicateExtractor = new ReferencesPredicateExtractor(parserLMFeatures);
        } else {
            referencesPredicateExtractor = new ReferencesPredicateExtractor();
        }
        referencesPredicateExtractor.setGf(gazetteerFeatures);
        logger.info("CRF training for bibs with {} threads and {} labeled examples", (Object)parseOpts.threads, (Object)list2.size());
        pair = Parser.splitData(list2, 1.0 - parseOpts.trainFraction);
        List list3 = (List)pair.getOne();
        List list4 = (List)pair.getTwo();
        CRFTrainer.Opts opts = new CRFTrainer.Opts();
        opts.optimizerOpts.maxIters = parseOpts.iterations;
        opts.numThreads = parseOpts.threads;
        opts.minExpectedFeatureCount = parseOpts.minExpectedFeatureCount;
        Parallel.MROpts mROpts = Parallel.MROpts.withIdAndThreads((String)"mr-crf-bib-train-eval", (int)parseOpts.threads);
        TrainCriterionEval trainCriterionEval = list4.stream().map(list -> list.stream().map(Pair::swap).collect(Collectors.toList())).collect(Collectors.toList());
        ToDoubleFunction<CRFModel> toDoubleFunction = cRFModel -> {
            Evaluation evaluation = Evaluation.compute((SequenceTagger)cRFModel, (List)trainCriterionEval, (Parallel.MROpts)mROpts);
            return evaluation.tokenAccuracy.accuracy();
        };
        trainCriterionEval = new TrainCriterionEval(toDoubleFunction);
        trainCriterionEval.maxNumDipIters = 100;
        opts.iterCallback = trainCriterionEval;
        CRFTrainer cRFTrainer = new CRFTrainer(list3, (CRFPredicateExtractor)referencesPredicateExtractor, opts);
        cRFTrainer.train(list3);
        CRFModel cRFModel2 = (CRFModel)trainCriterionEval.bestModel;
        Vector vector = cRFModel2.weights();
        Parallel.shutdownExecutor((ExecutorService)mROpts.executorService, (long)Long.MAX_VALUE);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(parseOpts.modelFile));
        logger.info("Writing model to {}", (Object)parseOpts.modelFile);
        Parser.saveModel(dataOutputStream, cRFModel2.featureEncoder, vector, parserLMFeatures, gazetteerFeatures, "0.3-BIB");
        dataOutputStream.close();
    }

    public static void trainParser(Iterator<LabeledPaper> iterator, ParseOpts parseOpts) throws IOException {
        Parser.trainParser(iterator, parseOpts, (UnifiedSet<String>)UnifiedSet.newSet());
    }

    public static void trainParser(Iterator<LabeledPaper> iterator, ParseOpts parseOpts, String string) throws IOException {
        UnifiedSet unifiedSet = string == null ? new UnifiedSet() : Parser.readSet(string);
        Parser.trainParser(iterator, parseOpts, (UnifiedSet<String>)unifiedSet);
    }

    public static void trainParser(Iterator<LabeledPaper> iterator, ParseOpts parseOpts, UnifiedSet<String> unifiedSet) throws IOException {
        PDFPredicateExtractor pDFPredicateExtractor;
        Object object;
        Pair<List<List<Pair<PaperToken, String>>>, List<List<Pair<PaperToken, String>>>> pair;
        LabelingOutput labelingOutput = Parser.labelFromGroundTruth(iterator, parseOpts.headerMax, parseOpts.documentCount, parseOpts.minYear, parseOpts.checkAuthors, unifiedSet);
        ParserLMFeatures parserLMFeatures = null;
        if (parseOpts.gazetteerFile != null) {
            pair = new Pair<List<List<Pair<PaperToken, String>>>, List<List<Pair<PaperToken, String>>>>(parseOpts.gazetteerFile);
            object = new UnifiedSet(labelingOutput.usedPaperIds);
            object.addAll(unifiedSet);
            parserLMFeatures = new ParserLMFeatures(pair.papers, (UnifiedSet<String>)object, new File(parseOpts.backgroundDirectory), parseOpts.backgroundSamples);
            pDFPredicateExtractor = new PDFPredicateExtractor(parserLMFeatures);
        } else {
            pDFPredicateExtractor = new PDFPredicateExtractor();
        }
        logger.info("CRF training with {} threads and {} labeled examples", (Object)parseOpts.threads, (Object)labelingOutput.labeledData.size());
        pair = Parser.splitData(labelingOutput.labeledData, 1.0 - parseOpts.trainFraction);
        object = (List)pair.getOne();
        List list2 = (List)pair.getTwo();
        if (labeledDataLogger.isDebugEnabled()) {
            labeledDataLogger.info("Training data before:");
            Parser.logLabeledData((List<List<Pair<PaperToken, String>>>)object);
            labeledDataLogger.info("Test data before:");
            Parser.logLabeledData(list2);
        }
        CRFTrainer.Opts opts = new CRFTrainer.Opts();
        opts.optimizerOpts.maxIters = parseOpts.iterations;
        opts.numThreads = parseOpts.threads;
        opts.minExpectedFeatureCount = parseOpts.minExpectedFeatureCount;
        Parallel.MROpts mROpts = Parallel.MROpts.withIdAndThreads((String)"mr-crf-train-eval", (int)parseOpts.threads);
        TrainCriterionEval trainCriterionEval = list2.stream().map(list -> list.stream().map(Pair::swap).collect(Collectors.toList())).collect(Collectors.toList());
        ToDoubleFunction<CRFModel> toDoubleFunction = cRFModel -> {
            Evaluation evaluation = Evaluation.compute((SequenceTagger)cRFModel, (List)trainCriterionEval, (Parallel.MROpts)mROpts);
            logger.info("Test Label F-measures");
            evaluation.stateFMeasures.forEach((string, fMeasure) -> logger.info(String.format("-- %s: p:%.3f r:%.3f f1:%.3f", string, fMeasure.precision(), fMeasure.recall(), fMeasure.f1())));
            logger.info("");
            return evaluation.tokenAccuracy.accuracy();
        };
        trainCriterionEval = new TrainCriterionEval(toDoubleFunction);
        trainCriterionEval.maxNumDipIters = 100;
        opts.iterCallback = trainCriterionEval;
        CRFTrainer cRFTrainer = new CRFTrainer((List)object, (CRFPredicateExtractor)pDFPredicateExtractor, opts);
        cRFTrainer.train((List)object);
        CRFModel cRFModel2 = (CRFModel)trainCriterionEval.bestModel;
        Vector vector = cRFModel2.weights();
        Parallel.shutdownExecutor((ExecutorService)mROpts.executorService, (long)Long.MAX_VALUE);
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(parseOpts.modelFile));){
            logger.info("Writing model to {}", (Object)parseOpts.modelFile);
            Parser.saveModel(dataOutputStream, cRFModel2.featureEncoder, vector, parserLMFeatures);
        }
        if (labeledDataLogger.isDebugEnabled()) {
            labeledDataLogger.info("Training data after:");
            Parser.logLabeledData((List<List<Pair<PaperToken, String>>>)object);
            labeledDataLogger.info("Test data after:");
            Parser.logLabeledData(list2);
        }
    }

    private static void logLabeledData(List<List<Pair<PaperToken, String>>> list) {
        for (List<Pair<PaperToken, String>> list2 : list) {
            String string = list2.stream().map(pair -> String.format("%s/%x/%s", ((PaperToken)pair.getOne()).getPdfToken() == null ? "null" : ((PaperToken)pair.getOne()).getPdfToken().getToken(), ((PaperToken)pair.getOne()).hashCode(), pair.getTwo())).collect(Collectors.joining(" "));
            labeledDataLogger.info(string);
        }
    }

    public static <T> void saveModel(DataOutputStream dataOutputStream, CRFFeatureEncoder<String, T, String> cRFFeatureEncoder, Vector vector, ParserLMFeatures parserLMFeatures, String string) throws IOException {
        Parser.saveModel(dataOutputStream, cRFFeatureEncoder, vector, parserLMFeatures, null, string);
    }

    public static <T> void saveModel(DataOutputStream dataOutputStream, CRFFeatureEncoder<String, T, String> cRFFeatureEncoder, Vector vector, ParserLMFeatures parserLMFeatures, GazetteerFeatures gazetteerFeatures, String string) throws IOException {
        dataOutputStream.writeUTF(string);
        cRFFeatureEncoder.stateSpace.save(dataOutputStream);
        cRFFeatureEncoder.nodeFeatures.save(dataOutputStream);
        cRFFeatureEncoder.edgeFeatures.save(dataOutputStream);
        IOUtils.saveDoubles((DataOutputStream)dataOutputStream, (double[])vector.toDoubles());
        logger.debug("Saving ParserLMFeatures");
        try (FSTObjectOutput fSTObjectOutput = new FSTObjectOutput((OutputStream)dataOutputStream);){
            fSTObjectOutput.writeObject((Object)parserLMFeatures);
            if (parserLMFeatures != null) {
                parserLMFeatures.logState();
            }
            logger.debug("Saving gazetteer features");
            fSTObjectOutput.writeObject((Object)gazetteerFeatures);
        }
    }

    public static <T> void saveModel(DataOutputStream dataOutputStream, CRFFeatureEncoder<String, T, String> cRFFeatureEncoder, Vector vector, ParserLMFeatures parserLMFeatures) throws IOException {
        Parser.saveModel(dataOutputStream, cRFFeatureEncoder, vector, parserLMFeatures, DATA_VERSION);
    }

    public static ModelComponents loadModelComponents(DataInputStream dataInputStream, String string) throws IOException {
        ParserLMFeatures parserLMFeatures;
        IOUtils.ensureVersionMatch((DataInputStream)dataInputStream, (String)string);
        StateSpace stateSpace = StateSpace.load((DataInputStream)dataInputStream);
        Indexer indexer = Indexer.load((DataInputStream)dataInputStream);
        Indexer indexer2 = Indexer.load((DataInputStream)dataInputStream);
        DenseVector denseVector = DenseVector.of((double[])IOUtils.loadDoubles((DataInputStream)dataInputStream));
        logger.debug("Loading ParserLMFeatures");
        try (Object object = new FSTObjectInput((InputStream)dataInputStream);){
            try {
                parserLMFeatures = (ParserLMFeatures)object.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Model file contains unknown class.", classNotFoundException);
            }
        }
        if (parserLMFeatures != null && logger.isDebugEnabled()) {
            parserLMFeatures.logState();
        }
        object = new PDFPredicateExtractor(parserLMFeatures);
        var8_7 = new CRFFeatureEncoder((CRFPredicateExtractor)object, stateSpace, indexer, indexer2);
        CRFWeightsEncoder cRFWeightsEncoder = new CRFWeightsEncoder(stateSpace, indexer.size(), indexer2.size());
        CRFModel cRFModel = new CRFModel((CRFFeatureEncoder)var8_7, cRFWeightsEncoder, (Vector)denseVector);
        return new ModelComponents((PDFPredicateExtractor)object, (CRFFeatureEncoder<String, PaperToken, String>)var8_7, (CRFWeightsEncoder<String>)cRFWeightsEncoder, (CRFModel<String, PaperToken, String>)cRFModel);
    }

    public static ModelComponents loadModelComponents(DataInputStream dataInputStream) throws IOException {
        return Parser.loadModelComponents(dataInputStream, DATA_VERSION);
    }

    public static CRFModel<String, PaperToken, String> loadModel(DataInputStream dataInputStream) throws IOException {
        return Parser.loadModelComponents((DataInputStream)dataInputStream).model;
    }

    public static void clean(ExtractedMetadata extractedMetadata) {
        extractedMetadata.title = Parser.cleanTitle(extractedMetadata.title);
        extractedMetadata.authors = Parser.trimAuthors(extractedMetadata.authors);
    }

    public static String cleanTitle(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        string = Normalizer.normalize(string, Normalizer.Form.NFKD);
        if ((string = string.replaceAll("\\&.*?\\;", "")).endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String processTitle(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        string = string.trim().toLowerCase();
        string = Parser.cleanTitle(string);
        string = string.replaceAll("\\W", "");
        return string.replaceAll("\\s+", " ");
    }

    public static String processExtractedTitle(String string) {
        String string2 = string.replaceAll("(?<=[a-z])\\- ", "");
        if (!(string2.endsWith("?") || string2.endsWith("\"") || string2.endsWith(")"))) {
            string2 = string2.replaceFirst("\\W$", "");
        }
        return string2.trim();
    }

    public static String lastName(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length > 0) {
            return Parser.processTitle(stringArray[stringArray.length - 1]);
        }
        return "";
    }

    public static List<String> lastNames(List<String> list) {
        return list == null ? null : list.stream().map(string -> Parser.lastName(string)).collect(Collectors.toList());
    }

    public static int scoreAuthors(String[] stringArray, List<String> list) {
        List<String> list2 = Parser.lastNames(list);
        List<String> list3 = Parser.lastNames(Arrays.asList(stringArray));
        int n = 0;
        for (String string : list3) {
            if (!list2.contains(string)) continue;
            ++n;
        }
        return n;
    }

    public static String fixupAuthors(String string) {
        String string2 = string.replaceAll("([^\\p{javaLowerCase}\\p{javaUpperCase}])+$", "");
        if (string2.contains(",")) {
            string2 = string2.substring(0, string2.indexOf(","));
        }
        if (string2.endsWith("Jr")) {
            string2 = string2 + ".";
        }
        return string2;
    }

    public static List<String> trimAuthors(List<String> list) {
        return list.stream().flatMap(string -> Arrays.stream(string.split("(?!,\\s*Jr),|\\band\\b"))).map(String::trim).map(Parser::fixupAuthors).filter(string -> !string.isEmpty()).filter(string -> string.length() <= 32).filter(string -> string.length() >= 2).distinct().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtractedMetadata doParseWithTimeout(InputStream inputStream, long l) throws IOException {
        boolean bl;
        final int n = this.nextParseNumber.getAndIncrement();
        final Thread thread = Thread.currentThread();
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MutableIntSet mutableIntSet = Parser.this.parseNumbersInProgress;
                synchronized (mutableIntSet) {
                    if (Parser.this.parseNumbersInProgress.contains(n)) {
                        logger.info("Killing parsing thread {} because it's taking too long", (Object)thread.getId());
                        thread.stop();
                    }
                }
            }
        };
        TimerTask timerTask2 = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MutableIntSet mutableIntSet = Parser.this.parseNumbersInProgress;
                synchronized (mutableIntSet) {
                    if (Parser.this.parseNumbersInProgress.contains(n)) {
                        logger.info("Interrupting parsing thread {} because it's taking too long", (Object)thread.getId());
                        thread.interrupt();
                    }
                }
            }
        };
        Object object = this.parseNumbersInProgress;
        synchronized (object) {
            this.parseNumbersInProgress.add(n);
        }
        this.parserKillerTimer.schedule(timerTask2, l);
        this.parserKillerTimer.schedule(timerTask, 3L * l);
        try {
            try {
                object = this.doParse(inputStream);
            }
            catch (ThreadDeath threadDeath) {
                throw new RuntimeException("Science-parse killer got impatient", threadDeath);
            }
        }
        finally {
            MutableIntSet mutableIntSet = this.parseNumbersInProgress;
            synchronized (mutableIntSet) {
                this.parseNumbersInProgress.remove(n);
            }
            bl = Thread.interrupted();
        }
        if (bl) {
            logger.info("Overriding interruption of parsing thread {} because it finished before we could react", (Object)thread.getId());
        }
        assert (!Thread.interrupted());
        return object;
    }

    public ExtractedMetadata doParse(InputStream inputStream) throws IOException {
        return this.doParse(inputStream, 500);
    }

    public static CitationRecord extractContext(int n, String string, int n2, int n3) {
        int n4;
        int n5;
        for (n5 = n2; n5 > 0 && (string.charAt(n5) == '(' || string.charAt(n5) == '[' || string.charAt(n5) == '.' || string.charAt(n5) == '\u2350'); --n5) {
        }
        if (string.charAt(n5 = string.substring(0, n5).lastIndexOf(46) + 1) == '\u2350' && (n4 = string.indexOf(9047, n5)) > 0 && n4 < n2) {
            n5 = n4 + 1;
        }
        n4 = (n4 = string.indexOf(46, n3)) < 0 ? string.length() : ++n4;
        String string2 = string.substring(n5, n4);
        String string3 = string2.trim();
        return new CitationRecord(n, string3, n2 - (n5 += string2.indexOf(string3)), n3 - n5);
    }

    public ExtractedMetadata doParse(InputStream inputStream, int n) throws IOException {
        Object object;
        ExtractedMetadata extractedMetadata;
        List<String> list;
        PDFDoc pDFDoc;
        PDFDoc pDFDoc2;
        PDFExtractor pDFExtractor;
        PDDocument pDDocument;
        block18: {
            pDDocument = PDDocument.load((InputStream)inputStream);
            pDFExtractor = new PDFExtractor();
            pDFDoc2 = pDFExtractor.extractResultFromPDDocument((PDDocument)pDDocument).document;
            pDFDoc = pDFDoc2.withoutSuperscripts();
            List<PaperToken> list2 = PDFToCRFInput.getSequence(pDFDoc);
            list2 = list2.subList(0, Math.min(list2.size(), n));
            list2 = PDFToCRFInput.padSequence(list2);
            list = this.model.bestGuess(list2);
            list = PDFToCRFInput.padTagSequence(list);
            extractedMetadata = new ExtractedMetadata(list2, list);
            extractedMetadata.source = ExtractedMetadata.Source.CRF;
            if (pDFDoc2.meta != null) {
                if (pDFDoc2.meta.title != null) {
                    extractedMetadata.setTitle(pDFDoc2.meta.title);
                    extractedMetadata.source = ExtractedMetadata.Source.META;
                }
                if (pDFDoc2.meta.createDate != null) {
                    extractedMetadata.setYearFromDate(pDFDoc2.meta.createDate);
                }
            }
            Parser.clean(extractedMetadata);
            if (pDFDoc2.meta != null) {
                extractedMetadata.creator = pDFDoc2.meta.creator;
            }
            try {
                CitationRecord citationRecord2;
                char c;
                CitationRecord citationRecord32;
                Function<CitationRecord, Character> function2;
                list = PDFDocToPartitionedText.getRaw(pDFDoc2);
                List<String> list3 = PDFDocToPartitionedText.getRawReferences(pDFDoc2);
                object = Parser.getReferences(list, list3, this.referenceExtractor);
                extractedMetadata.references = new ArrayList<BibRecord>(((List)object.getOne()).size());
                for (Function<CitationRecord, Character> function2 : (List)object.getOne()) {
                    extractedMetadata.references.add(((BibRecord)((Object)function2)).withoutSuperscripts());
                }
                ArrayList arrayList = new ArrayList();
                for (CitationRecord citationRecord32 : (List)object.getTwo()) {
                    CitationRecord citationRecord4 = Parser.extractContext(citationRecord32.referenceID, citationRecord32.context, citationRecord32.startOffset, citationRecord32.endOffset);
                    c = citationRecord4.context.length() - (citationRecord4.endOffset - citationRecord4.startOffset);
                    if (c < 35) continue;
                    arrayList.add(citationRecord4);
                }
                function2 = citationRecord -> {
                    char c = citationRecord.context.charAt(citationRecord.startOffset);
                    if (c == '(' || c == '[' || c == '\u2350') {
                        return Character.valueOf(c);
                    }
                    return Character.valueOf('\u0000');
                };
                citationRecord32 = CharIntMaps.mutable.empty();
                int n2 = 0;
                c = '\u0000';
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    citationRecord2 = (CitationRecord)iterator.next();
                    char c2 = function2.apply(citationRecord2).charValue();
                    int n3 = citationRecord32.addToValue(c2, 1);
                    if (n3 <= n2) continue;
                    n2 = n3;
                    c = c2;
                }
                if (c == '(' && citationRecord32.getIfAbsent('[', 0) > 4) {
                    c = '[';
                }
                extractedMetadata.referenceMentions = new ArrayList<CitationRecord>(arrayList.size());
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    citationRecord2 = (CitationRecord)iterator.next();
                    if (c != '\u0000' && function2.apply(citationRecord2).charValue() != c) continue;
                    extractedMetadata.referenceMentions.add(citationRecord2.withConvertedSuperscriptTags());
                }
            }
            catch (ParsingTimeout | RegexWithTimeout.RegexTimeout runtimeException) {
                logger.warn("Timeout while extracting references. References may be incomplete or missing.");
                if (extractedMetadata.references == null) {
                    extractedMetadata.references = Collections.emptyList();
                }
                if (extractedMetadata.referenceMentions != null) break block18;
                extractedMetadata.referenceMentions = Collections.emptyList();
            }
        }
        logger.debug(extractedMetadata.references.size() + " refs for " + extractedMetadata.title);
        try {
            list = PDFDocToPartitionedText.getRaw(pDFDoc);
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i).replaceAll("-<lb>", "").replaceAll("<lb>", " ");
                list.set(i, (String)object);
            }
            extractedMetadata.abstractText = PDFDocToPartitionedText.getAbstract(list, pDFDoc).trim();
            extractedMetadata.abstractText = extractedMetadata.abstractText.replaceAll("\u2350[^\u2357]\u2357", "");
            if (extractedMetadata.abstractText.isEmpty()) {
                extractedMetadata.abstractText = null;
            }
        }
        catch (ParsingTimeout | RegexWithTimeout.RegexTimeout runtimeException) {
            logger.warn("Timeout while extracting abstract. Abstract will be missing.");
            extractedMetadata.abstractText = null;
        }
        try {
            pDFExtractor = new FigureExtractor(false, true, true, true, true);
            pDFDoc2 = pDFExtractor.getFiguresWithText(pDDocument, Option.apply(null), Option.apply(null));
            extractedMetadata.sections = ScalaStreamSupport.stream((Iterable)pDFDoc2.sections()).map(documentSection -> new Section(OptionConverters.toJava((Option)documentSection.titleText()).orElse(null), documentSection.bodyText())).filter(section -> section.getHeading() == null || !PDFDocToPartitionedText.referenceHeaders.contains(section.getHeading().trim().toLowerCase().replaceAll("\\p{Punct}*$", ""))).collect(Collectors.toList());
        }
        catch (Exception exception) {
            logger.warn("Exception {} while getting sections. Section data will be missing.", (Object)exception.getMessage());
            extractedMetadata.sections = null;
        }
        return extractedMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ List lambda$labelFromGroundTruth$0(ConcurrentMap concurrentMap, LabeledPaper labeledPaper, LabeledData labeledData, PDFExtractor pDFExtractor, int n, boolean bl, AtomicInteger atomicInteger, MutableSet mutableSet) throws Exception {
        try {
            List<Pair<PaperToken, String>> list;
            concurrentMap.put(labeledPaper.paperId(), System.currentTimeMillis());
            try (InputStream inputStream = labeledPaper.inputStream();){
                list = Parser.getPaperLabels(labeledPaper.paperId(), inputStream, labeledData, pDFExtractor, n, bl);
            }
            int n2 = atomicInteger.incrementAndGet();
            if (list != null) {
                mutableSet.add((Object)labeledPaper.paperId());
            }
            if (n2 % 100 == 0) {
                final long l = System.currentTimeMillis();
                Set set = concurrentMap.entrySet();
                Optional<Map.Entry<String, Long>> optional = set.stream().max(new Comparator<Map.Entry<String, Long>>(){

                    @Override
                    public int compare(Map.Entry<String, Long> entry, Map.Entry<String, Long> entry2) {
                        long l3;
                        long l2 = l - entry.getValue();
                        if (l2 < (l3 = l - entry2.getValue())) {
                            return -1;
                        }
                        if (l2 > l3) {
                            return 1;
                        }
                        return 0;
                    }
                });
                int n3 = mutableSet.size();
                if (optional.isPresent()) {
                    logger.info(String.format("Tried to label %d papers, succeeded %d times (%.2f%%), %d papers in flight, oldest is %s at %.2f seconds", n2, n3, (double)n3 * 100.0 / (double)n2, set.size(), optional.get().getKey(), (double)(l - optional.get().getValue()) / 1000.0));
                } else {
                    logger.info(String.format("Tried to label %d papers, succeeded %d times (%.2f%%), 0 papers in flight", n2, n3, (double)n3 * 100.0 / (double)n2));
                }
            }
            List<Pair<PaperToken, String>> list2 = list;
            return list2;
        }
        catch (IOException iOException) {
            logger.warn("IOException {} while processing paper {}", (Object)iOException.getMessage(), (Object)labeledPaper.paperId());
            List list = null;
            return list;
        }
        finally {
            concurrentMap.remove(labeledPaper.paperId());
        }
    }

    public static class ParseOpts {
        public String modelFile;
        public int iterations;
        public int threads;
        public int headerMax;
        public double trainFraction;
        public String gazetteerFile;
        public String gazetteerDir;
        public int backgroundSamples;
        public String backgroundDirectory;
        public int minYear;
        public boolean checkAuthors;
        public int documentCount = -1;
        public int minExpectedFeatureCount = 1;
    }

    public static class ParsingTimeout
    extends RuntimeException {
    }

    public static class ModelComponents {
        public final PDFPredicateExtractor predExtractor;
        public final CRFFeatureEncoder<String, PaperToken, String> featureEncoder;
        public final CRFWeightsEncoder<String> weightsEncoder;
        public final CRFModel<String, PaperToken, String> model;

        public ModelComponents(PDFPredicateExtractor pDFPredicateExtractor, CRFFeatureEncoder<String, PaperToken, String> cRFFeatureEncoder, CRFWeightsEncoder<String> cRFWeightsEncoder, CRFModel<String, PaperToken, String> cRFModel) {
            this.predExtractor = pDFPredicateExtractor;
            this.featureEncoder = cRFFeatureEncoder;
            this.weightsEncoder = cRFWeightsEncoder;
            this.model = cRFModel;
        }

        public PDFPredicateExtractor getPredExtractor() {
            return this.predExtractor;
        }

        public CRFFeatureEncoder<String, PaperToken, String> getFeatureEncoder() {
            return this.featureEncoder;
        }

        public CRFWeightsEncoder<String> getWeightsEncoder() {
            return this.weightsEncoder;
        }

        public CRFModel<String, PaperToken, String> getModel() {
            return this.model;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ModelComponents)) {
                return false;
            }
            ModelComponents modelComponents = (ModelComponents)object;
            if (!modelComponents.canEqual(this)) {
                return false;
            }
            PDFPredicateExtractor pDFPredicateExtractor = this.getPredExtractor();
            PDFPredicateExtractor pDFPredicateExtractor2 = modelComponents.getPredExtractor();
            if (pDFPredicateExtractor == null ? pDFPredicateExtractor2 != null : !pDFPredicateExtractor.equals(pDFPredicateExtractor2)) {
                return false;
            }
            CRFFeatureEncoder<String, PaperToken, String> cRFFeatureEncoder = this.getFeatureEncoder();
            CRFFeatureEncoder<String, PaperToken, String> cRFFeatureEncoder2 = modelComponents.getFeatureEncoder();
            if (cRFFeatureEncoder == null ? cRFFeatureEncoder2 != null : !cRFFeatureEncoder.equals(cRFFeatureEncoder2)) {
                return false;
            }
            CRFWeightsEncoder<String> cRFWeightsEncoder = this.getWeightsEncoder();
            CRFWeightsEncoder<String> cRFWeightsEncoder2 = modelComponents.getWeightsEncoder();
            if (cRFWeightsEncoder == null ? cRFWeightsEncoder2 != null : !cRFWeightsEncoder.equals(cRFWeightsEncoder2)) {
                return false;
            }
            CRFModel<String, PaperToken, String> cRFModel = this.getModel();
            CRFModel<String, PaperToken, String> cRFModel2 = modelComponents.getModel();
            return !(cRFModel == null ? cRFModel2 != null : !cRFModel.equals(cRFModel2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ModelComponents;
        }

        public int hashCode() {
            int n = 1;
            PDFPredicateExtractor pDFPredicateExtractor = this.getPredExtractor();
            n = n * 59 + (pDFPredicateExtractor == null ? 43 : pDFPredicateExtractor.hashCode());
            CRFFeatureEncoder<String, PaperToken, String> cRFFeatureEncoder = this.getFeatureEncoder();
            n = n * 59 + (cRFFeatureEncoder == null ? 43 : cRFFeatureEncoder.hashCode());
            CRFWeightsEncoder<String> cRFWeightsEncoder = this.getWeightsEncoder();
            n = n * 59 + (cRFWeightsEncoder == null ? 43 : cRFWeightsEncoder.hashCode());
            CRFModel<String, PaperToken, String> cRFModel = this.getModel();
            n = n * 59 + (cRFModel == null ? 43 : cRFModel.hashCode());
            return n;
        }

        public String toString() {
            return "Parser.ModelComponents(predExtractor=" + this.getPredExtractor() + ", featureEncoder=" + this.getFeatureEncoder() + ", weightsEncoder=" + this.getWeightsEncoder() + ", model=" + this.getModel() + ")";
        }
    }

    private static class LabelingOutput {
        public final List<List<Pair<PaperToken, String>>> labeledData;
        public final Set<String> usedPaperIds;

        public LabelingOutput(List<List<Pair<PaperToken, String>>> list, Set<String> set) {
            this.labeledData = list;
            this.usedPaperIds = set;
        }

        public List<List<Pair<PaperToken, String>>> getLabeledData() {
            return this.labeledData;
        }

        public Set<String> getUsedPaperIds() {
            return this.usedPaperIds;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LabelingOutput)) {
                return false;
            }
            LabelingOutput labelingOutput = (LabelingOutput)object;
            if (!labelingOutput.canEqual(this)) {
                return false;
            }
            List<List<Pair<PaperToken, String>>> list = this.getLabeledData();
            List<List<Pair<PaperToken, String>>> list2 = labelingOutput.getLabeledData();
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                return false;
            }
            Set<String> set = this.getUsedPaperIds();
            Set<String> set2 = labelingOutput.getUsedPaperIds();
            return !(set == null ? set2 != null : !((Object)set).equals(set2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof LabelingOutput;
        }

        public int hashCode() {
            int n = 1;
            List<List<Pair<PaperToken, String>>> list = this.getLabeledData();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            Set<String> set = this.getUsedPaperIds();
            n = n * 59 + (set == null ? 43 : ((Object)set).hashCode());
            return n;
        }

        public String toString() {
            return "Parser.LabelingOutput(labeledData=" + this.getLabeledData() + ", usedPaperIds=" + this.getUsedPaperIds() + ")";
        }
    }
}

