/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse;

import com.gs.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.allenai.scienceparse.Parser;
import org.allenai.scienceparse.ParserGroundTruth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserLMFeatures
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ParserLMFeatures.class);
    private static final long serialVersionUID = 1L;
    final ObjectDoubleHashMap<String> titleBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> titleFirstBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> titleLastBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> titleBagOfCharTrigrams = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> authorBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> authorFirstBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> authorLastBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> authorBagOfCharTrigrams = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> backgroundBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> venueBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> venueFirstBow = new ObjectDoubleHashMap();
    final ObjectDoubleHashMap<String> venueLastBow = new ObjectDoubleHashMap();

    public ParserLMFeatures() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParserLMFeatures(List<ParserGroundTruth.Paper> list, UnifiedSet<String> unifiedSet, File file, int n) throws IOException {
        log.info("Excluding {} paper ids from LM features", (Object)unifiedSet.size());
        for (ParserGroundTruth.Paper object2 : list) {
            if (unifiedSet.contains((Object)object2.id)) continue;
            ParserLMFeatures.fillBow(this.titleBow, object2.title, this.titleFirstBow, this.titleLastBow, this.titleBagOfCharTrigrams, false);
            ParserLMFeatures.fillBow(this.venueBow, object2.venue, this.venueFirstBow, this.venueLastBow, null, false);
            for (String d2 : object2.authors) {
                ParserLMFeatures.fillBow(this.authorBow, d2, this.authorFirstBow, this.authorLastBow, this.authorBagOfCharTrigrams, true);
            }
        }
        log.info("Getting token statistics from approximately {} background papers in {}", (Object)n, (Object)file);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        ExecutorCompletionService<String[]> executorCompletionService = new ExecutorCompletionService<String[]>(executorService);
        try {
            Object[] interruptedException = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".pdf");
                }
            });
            double d = (double)n / (double)interruptedException.length;
            double d2 = 0.0;
            int n2 = 0;
            for (Object object : interruptedException) {
                if (!((d2 += d) >= 1.0)) continue;
                d2 -= 1.0;
                executorCompletionService.submit(() -> ParserLMFeatures.lambda$new$0((File)object));
                ++n2;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n2 > n4 + n5) {
                String[] stringArray;
                try {
                    stringArray = (String[])executorCompletionService.take().get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
                if (stringArray != null) {
                    n3 += ParserLMFeatures.fillBow(this.backgroundBow, stringArray, null, null, null, false);
                    ++n4;
                    continue;
                }
                ++n5;
            }
            log.info("Gazetteer loaded with {} tokens", (Object)n3);
            log.info(String.format("Tried %d papers, succeeded on %d (%.2f%%)", n2, n4, 100.0 * (double)n4 / (double)n2));
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static int fillBow(ObjectDoubleHashMap<String> objectDoubleHashMap, String string, ObjectDoubleHashMap<String> objectDoubleHashMap2, ObjectDoubleHashMap<String> objectDoubleHashMap3, ObjectDoubleHashMap<String> objectDoubleHashMap4, boolean bl) {
        if (string == null) {
            return 0;
        }
        return ParserLMFeatures.fillBow(objectDoubleHashMap, ParserLMFeatures.tokenize(string), objectDoubleHashMap2, objectDoubleHashMap3, objectDoubleHashMap4, bl);
    }

    public static int fillBow(ObjectDoubleHashMap<String> objectDoubleHashMap, String string, boolean bl) {
        return ParserLMFeatures.fillBow(objectDoubleHashMap, string, null, null, null, bl);
    }

    public static void addTrigrams(ObjectDoubleHashMap<String> objectDoubleHashMap, String string) {
        if (string == null) {
            return;
        }
        string = "^" + string + "$";
        int n = string.length();
        for (int i = 0; i < n - 3; ++i) {
            objectDoubleHashMap.addToValue((Object)string.substring(i, i + 3), 1.0);
        }
    }

    private static int fillBow(ObjectDoubleHashMap<String> objectDoubleHashMap, String[] stringArray, ObjectDoubleHashMap<String> objectDoubleHashMap2, ObjectDoubleHashMap<String> objectDoubleHashMap3, ObjectDoubleHashMap<String> objectDoubleHashMap4, boolean bl) {
        int n = 0;
        if (stringArray.length > 0) {
            if (objectDoubleHashMap2 != null) {
                objectDoubleHashMap2.addToValue((Object)(bl ? Parser.fixupAuthors(stringArray[0]) : stringArray[0]), 1.0);
            }
            if (objectDoubleHashMap3 != null) {
                objectDoubleHashMap3.addToValue((Object)(bl ? Parser.fixupAuthors(stringArray[stringArray.length - 1]) : stringArray[stringArray.length - 1]), 1.0);
            }
        }
        for (String string : stringArray) {
            objectDoubleHashMap.addToValue((Object)(bl ? Parser.fixupAuthors(string) : string), 1.0);
            if (objectDoubleHashMap4 != null) {
                ParserLMFeatures.addTrigrams(objectDoubleHashMap4, bl ? Parser.fixupAuthors(string) : string);
            }
            ++n;
        }
        return n;
    }

    private static String[] tokenize(String string) {
        return string.split("( )");
    }

    private void logBow(String string, ObjectDoubleHashMap<String> objectDoubleHashMap) {
        log.debug("{}:  {} elements", (Object)string, (Object)objectDoubleHashMap.size());
        String[] stringArray = new String[objectDoubleHashMap.size()];
        Object[] objectArray = objectDoubleHashMap.keySet().toArray(stringArray);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            double d = objectDoubleHashMap.get(object);
            log.debug("{}: {} = {}", new Object[]{string, object, d});
        }
    }

    public void logState() {
        this.logBow("titleBow", this.titleBow);
        this.logBow("titleFirstBow", this.titleFirstBow);
        this.logBow("titleLastBow", this.titleLastBow);
        this.logBow("titleBagOfCharTrigrams", this.titleBagOfCharTrigrams);
        this.logBow("authorBow", this.authorBow);
        this.logBow("authorFirstBow", this.authorFirstBow);
        this.logBow("authorLastBow", this.authorLastBow);
        this.logBow("authorBagOfCharTrigrams", this.authorBagOfCharTrigrams);
        this.logBow("backgroundBow", this.backgroundBow);
        this.logBow("venueBow", this.venueBow);
        this.logBow("venueFirstBow", this.venueFirstBow);
        this.logBow("venueLastBow", this.venueLastBow);
    }

    private static /* synthetic */ String[] lambda$new$0(File file) throws Exception {
        String string = Parser.paperToString(file);
        if (string != null) {
            return ParserLMFeatures.tokenize(string);
        }
        return null;
    }
}

