/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pdfapi;

import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.allenai.scienceparse.pdfapi.PDFToken;

public class PDFLine {
    public final List<PDFToken> tokens;

    private DoubleStream projectCoord(int n) {
        return this.tokens.stream().mapToDouble(pDFToken -> pDFToken.bounds.get(n));
    }

    public FloatList bounds() {
        float f = (float)this.projectCoord(0).min().getAsDouble();
        float f2 = (float)this.projectCoord(1).min().getAsDouble();
        float f3 = (float)this.projectCoord(2).max().getAsDouble();
        float f4 = (float)this.projectCoord(3).max().getAsDouble();
        return FloatArrayList.newListWith((float[])new float[]{f, f2, f3, f4});
    }

    public float height() {
        FloatList floatList = this.bounds();
        return floatList.get(3) - floatList.get(1);
    }

    public String lineText() {
        return this.tokens.stream().map(PDFToken::getToken).collect(Collectors.joining(" "));
    }

    public double avgFontSize() {
        return this.tokens.stream().mapToDouble(pDFToken -> pDFToken.getFontMetrics().getPtSize()).average().orElse(0.0);
    }

    public PDFLine withoutSuperscripts() {
        ArrayList<PDFToken> arrayList = new ArrayList<PDFToken>(this.tokens.size());
        for (PDFToken pDFToken : this.tokens) {
            String string = pDFToken.token.replaceAll("\u2350[^\u2357]*\u2357", "");
            if (string.isEmpty()) continue;
            arrayList.add(pDFToken.withToken(string));
        }
        return this.withTokens(arrayList);
    }

    PDFLine(List<PDFToken> list) {
        this.tokens = list;
    }

    public static PDFLineBuilder builder() {
        return new PDFLineBuilder();
    }

    public List<PDFToken> getTokens() {
        return this.tokens;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDFLine)) {
            return false;
        }
        PDFLine pDFLine = (PDFLine)object;
        if (!pDFLine.canEqual(this)) {
            return false;
        }
        List<PDFToken> list = this.getTokens();
        List<PDFToken> list2 = pDFLine.getTokens();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PDFLine;
    }

    public int hashCode() {
        int n = 1;
        List<PDFToken> list = this.getTokens();
        n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n;
    }

    public String toString() {
        return "PDFLine(tokens=" + this.getTokens() + ")";
    }

    public PDFLine withTokens(List<PDFToken> list) {
        return this.tokens == list ? this : new PDFLine(list);
    }

    public static class PDFLineBuilder {
        private List<PDFToken> tokens;

        PDFLineBuilder() {
        }

        public PDFLineBuilder tokens(List<PDFToken> list) {
            this.tokens = list;
            return this;
        }

        public PDFLine build() {
            return new PDFLine(this.tokens);
        }

        public String toString() {
            return "PDFLine.PDFLineBuilder(tokens=" + this.tokens + ")";
        }
    }
}

