/*
 * Decompiled with CFR 0.152.
 */
package org.allenai.scienceparse.pdfapi;

import com.gs.collections.api.list.primitive.FloatList;
import org.allenai.scienceparse.pdfapi.PDFFontMetrics;

public final class PDFToken {
    public final String token;
    public final PDFFontMetrics fontMetrics;
    public final FloatList bounds;

    PDFToken(String string, PDFFontMetrics pDFFontMetrics, FloatList floatList) {
        this.token = string;
        this.fontMetrics = pDFFontMetrics;
        this.bounds = floatList;
    }

    public static PDFTokenBuilder builder() {
        return new PDFTokenBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public PDFFontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public FloatList getBounds() {
        return this.bounds;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PDFToken)) {
            return false;
        }
        PDFToken pDFToken = (PDFToken)object;
        String string = this.getToken();
        String string2 = pDFToken.getToken();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        PDFFontMetrics pDFFontMetrics = this.getFontMetrics();
        PDFFontMetrics pDFFontMetrics2 = pDFToken.getFontMetrics();
        if (pDFFontMetrics == null ? pDFFontMetrics2 != null : !((Object)pDFFontMetrics).equals(pDFFontMetrics2)) {
            return false;
        }
        FloatList floatList = this.getBounds();
        FloatList floatList2 = pDFToken.getBounds();
        return !(floatList == null ? floatList2 != null : !floatList.equals(floatList2));
    }

    public int hashCode() {
        int n = 1;
        String string = this.getToken();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        PDFFontMetrics pDFFontMetrics = this.getFontMetrics();
        n = n * 59 + (pDFFontMetrics == null ? 43 : ((Object)pDFFontMetrics).hashCode());
        FloatList floatList = this.getBounds();
        n = n * 59 + (floatList == null ? 43 : floatList.hashCode());
        return n;
    }

    public String toString() {
        return "PDFToken(token=" + this.getToken() + ", fontMetrics=" + this.getFontMetrics() + ", bounds=" + this.getBounds() + ")";
    }

    public PDFToken withToken(String string) {
        return this.token == string ? this : new PDFToken(string, this.fontMetrics, this.bounds);
    }

    public static class PDFTokenBuilder {
        private String token;
        private PDFFontMetrics fontMetrics;
        private FloatList bounds;

        PDFTokenBuilder() {
        }

        public PDFTokenBuilder token(String string) {
            this.token = string;
            return this;
        }

        public PDFTokenBuilder fontMetrics(PDFFontMetrics pDFFontMetrics) {
            this.fontMetrics = pDFFontMetrics;
            return this;
        }

        public PDFTokenBuilder bounds(FloatList floatList) {
            this.bounds = floatList;
            return this;
        }

        public PDFToken build() {
            return new PDFToken(this.token, this.fontMetrics, this.bounds);
        }

        public String toString() {
            return "PDFToken.PDFTokenBuilder(token=" + this.token + ", fontMetrics=" + this.fontMetrics + ", bounds=" + this.bounds + ")";
        }
    }
}

