/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4.OurPDFWriter;
import edu.mit.csail.sdg.alloy4graph.Curve;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class Artist {
    private static final String fontName = "Lucida Grande";
    private static final int fontSize = 12;
    private Graphics2D gr;
    private OurPDFWriter pdf;
    private static float[] dot = new float[]{1.0f, 3.0f};
    private static float[] dashed = new float[]{6.0f, 3.0f};
    private boolean fontBoldness = false;
    private static Graphics2D cachedGraphics = null;
    private static FontMetrics cachedPlainMetrics = null;
    private static FontMetrics cachedBoldMetrics = null;
    private static Font cachedPlainFont = null;
    private static Font cachedBoldFont = null;
    private static int cachedMaxAscent = -1;
    private static int cachedMaxDescent = -1;

    public Artist(Graphics2D graphics2D) {
        this.gr = graphics2D;
        this.pdf = null;
    }

    public Artist(OurPDFWriter pdfWriter) {
        this.gr = null;
        this.pdf = pdfWriter;
    }

    public void translate(int x, int y) {
        if (this.gr != null) {
            this.gr.translate(x, y);
        } else {
            this.pdf.shiftCoordinateSpace(x, y);
        }
    }

    public void drawCircle(int radius) {
        if (this.gr != null) {
            this.gr.drawArc(-radius, -radius, radius * 2, radius * 2, 0, 360);
        } else {
            this.pdf.drawCircle(radius, false);
        }
    }

    public void fillCircle(int radius) {
        if (this.gr != null) {
            this.gr.fillArc(-radius, -radius, radius * 2, radius * 2, 0, 360);
        } else {
            this.pdf.drawCircle(radius, true);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.gr != null) {
            this.gr.drawLine(x1, y1, x2, y2);
        } else {
            this.pdf.drawLine(x1, y1, x2, y2);
        }
    }

    public void setColor(Color color) {
        if (this.gr != null) {
            this.gr.setColor(color);
        } else {
            this.pdf.setColor(color);
        }
    }

    private static boolean in(double left, double x, double right) {
        return left <= x && x <= right || right <= x && x <= left;
    }

    public void drawSmoothly(Curve curve) {
        int smooth = 15;
        double cx = 0.0;
        double cy = 0.0;
        int n = curve.list.size();
        for (int i = 0; i < n; ++i) {
            CubicCurve2D.Double c = new CubicCurve2D.Double();
            CubicCurve2D.Double c2 = i + 1 < n ? curve.list.get(i + 1) : null;
            c.setCurve(curve.list.get(i));
            if (i > 0) {
                c.ctrlx1 = cx;
                c.ctrly1 = cy;
            }
            if (c2 == null) {
                this.draw(c, false);
                return;
            }
            double slope = c.x1 < c.x2 && c2.x2 < c2.x1 || c.x1 > c.x2 && c2.x2 > c2.x1 ? 0.0 : (c2.x2 - c.x1) / (c2.y2 - c.y1);
            double tmp = c.y2 - 15.0;
            double tmpx = c.x2 - 15.0 * slope;
            if (tmp > c.ctrly1 && tmp < c.y2 && Artist.in(c.x1, tmpx, c.x2)) {
                c.ctrly2 = tmp;
                c.ctrlx2 = tmpx;
            }
            double tmp2 = c2.y1 + 15.0;
            double tmp2x = c2.x1 + 15.0 * slope;
            if (tmp2 > c2.y1 && tmp2 < c2.ctrly2 && Artist.in(c2.x1, tmp2x, c2.x2)) {
                cy = tmp2;
                cx = tmp2x;
            } else {
                cy = c2.ctrly1;
                cx = c2.ctrlx1;
            }
            this.draw(c, false);
        }
    }

    public void draw(Curve curve) {
        for (CubicCurve2D.Double c : curve.list) {
            this.draw(c, false);
        }
    }

    public void draw(Shape shape, boolean fillOrNot) {
        if (this.gr == null) {
            this.pdf.drawShape(shape, fillOrNot);
        } else if (fillOrNot) {
            this.gr.fill(shape);
        } else {
            this.gr.draw(shape);
        }
    }

    public void set(DotStyle style, double scale) {
        if (this.gr != null) {
            this.gr.setStroke(switch (style) {
                case DotStyle.BOLD -> new BasicStroke(scale > 1.0 ? (float)(2.6 / scale) : 2.6f);
                case DotStyle.DOTTED -> new BasicStroke(scale > 1.0 ? (float)(1.3 / scale) : 1.3f, 1, 1, 15.0f, dot, 0.0f);
                case DotStyle.DASHED -> new BasicStroke(scale > 1.0 ? (float)(1.3 / scale) : 1.3f, 1, 1, 15.0f, dashed, 5.0f);
                default -> new BasicStroke(scale > 1.0 ? (float)(1.3 / scale) : 1.3f);
            });
            return;
        }
        switch (style) {
            case BOLD: {
                this.pdf.setBoldLine();
                return;
            }
            case DOTTED: {
                this.pdf.setDottedLine();
                return;
            }
            case DASHED: {
                this.pdf.setDashedLine();
                return;
            }
        }
        this.pdf.setNormalLine();
    }

    public void setFont(boolean fontBoldness) {
        Artist.calc();
        if (this.gr != null) {
            this.gr.setFont(fontBoldness ? cachedBoldFont : cachedPlainFont);
        } else {
            this.fontBoldness = fontBoldness;
        }
    }

    public void drawString(String text, int x, int y) {
        if (text.length() == 0) {
            return;
        }
        if (this.gr != null) {
            this.gr.drawString(text, x, y);
            return;
        }
        Artist.calc();
        Font font = this.fontBoldness ? cachedBoldFont : cachedPlainFont;
        GlyphVector gv = font.createGlyphVector(new FontRenderContext(null, false, false), text);
        this.translate(x, y);
        this.draw(gv.getOutline(), true);
        this.translate(-x, -y);
    }

    private static void calc() {
        if (cachedMaxDescent >= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(1, 1, 1);
        cachedGraphics = (Graphics2D)image.getGraphics();
        cachedPlainFont = new Font(fontName, 0, 12);
        cachedPlainMetrics = cachedGraphics.getFontMetrics(cachedPlainFont);
        cachedBoldFont = new Font(fontName, 1, 12);
        cachedBoldMetrics = cachedGraphics.getFontMetrics(cachedBoldFont);
        cachedGraphics.setFont(cachedPlainFont);
        cachedMaxAscent = cachedPlainMetrics.getMaxAscent();
        cachedMaxDescent = cachedPlainMetrics.getMaxDescent();
    }

    public static int getMaxAscent() {
        Artist.calc();
        return cachedMaxAscent;
    }

    public static int getMaxAscentAndDescent() {
        Artist.calc();
        return cachedMaxAscent + cachedMaxDescent;
    }

    public static Rectangle2D getBounds(boolean fontBoldness, String string) {
        Artist.calc();
        return (fontBoldness ? cachedBoldMetrics : cachedPlainMetrics).getStringBounds(string, cachedGraphics);
    }
}

