/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import java.awt.geom.CubicCurve2D;
import java.util.ArrayList;
import java.util.List;

final class Curve {
    public double startX;
    public double startY;
    public double endX;
    public double endY;
    public final List<CubicCurve2D.Double> list = new ArrayList<CubicCurve2D.Double>();

    public Curve(double startX, double startY) {
        this.startX = startX;
        this.endX = startX;
        this.startY = startY;
        this.endY = startY;
    }

    public Curve dup() {
        Curve ans = new Curve(this.startX, this.startY);
        ans.endX = this.endX;
        ans.endY = this.endY;
        for (CubicCurve2D.Double x : this.list) {
            CubicCurve2D.Double c = new CubicCurve2D.Double();
            c.setCurve(x);
            ans.list.add(c);
        }
        return ans;
    }

    Curve join(Curve that) {
        Curve ans = new Curve(this.startX, this.startY);
        ans.list.addAll(this.list);
        ans.list.addAll(that.list);
        ans.endX = that.endX;
        ans.endY = that.endY;
        return ans;
    }

    private static CubicCurve2D.Double makeline(double x1, double y1, double x2, double y2) {
        return new CubicCurve2D.Double(x1, y1, (x2 - x1) * 0.3 + x1, (y2 - y1) * 0.3 + y1, (x2 - x1) * 0.6 + x1, (y2 - y1) * 0.6 + y1, x2, y2);
    }

    public Curve lineTo(double ax, double ay) {
        this.list.add(Curve.makeline(this.endX, this.endY, ax, ay));
        this.endX = ax;
        this.endY = ay;
        return this;
    }

    public Curve cubicTo(double ax, double ay, double bx, double by, double cx, double cy) {
        this.list.add(new CubicCurve2D.Double(this.endX, this.endY, ax, ay, bx, by, cx, cy));
        this.endX = cx;
        this.endY = cy;
        return this;
    }

    private static boolean intersects(double x1, double y1, double x2, double y2, double x, double y3, double y4) {
        if (!(y3 < y4)) {
            double tmp = y3;
            y3 = y4;
            y4 = tmp;
        }
        if (!(x1 <= x && x <= x2 || x2 <= x && x <= x1)) {
            return false;
        }
        double m = (y2 - y1) / (x2 - x1);
        double i = (x - x1) * m + y1;
        return y3 <= i && i <= y4 || y4 <= i && i <= y3;
    }

    void bendUp(double x, double y1, double y2, double gap) {
        for (int i = 0; i < this.list.size(); ++i) {
            CubicCurve2D.Double c = this.list.get(i);
            if (!Curve.intersects(c.x1, c.y1, c.x2, c.y2, x, y1, y2)) continue;
            this.list.set(i, Curve.makeline(c.x1, c.y1, x, y1 - gap));
            this.list.add(i + 1, Curve.makeline(x, y1 - gap, c.x2, c.y2));
            return;
        }
    }

    void bendDown(double x, double y1, double y2, double gap) {
        for (int i = 0; i < this.list.size(); ++i) {
            CubicCurve2D.Double c = this.list.get(i);
            if (!Curve.intersects(c.x1, c.y1, c.x2, c.y2, x, y1, y2)) continue;
            this.list.set(i, Curve.makeline(c.x1, c.y1, x, y2 + gap));
            this.list.add(i + 1, Curve.makeline(x, y2 + gap, c.x2, c.y2));
            return;
        }
    }

    public void chopStart(double t) {
        int n = this.list.size();
        double di = StrictMath.floor(t *= (double)n);
        int i = (int)di;
        if (i < 0) {
            return;
        }
        if (i >= n) {
            this.list.clear();
        }
        while (i > 0 && !this.list.isEmpty()) {
            this.list.remove(0);
            --i;
        }
        if (this.list.isEmpty()) {
            this.startX = this.endX;
            this.startY = this.endY;
            this.list.add(new CubicCurve2D.Double(this.startX, this.startY, this.endX, this.endY, this.endX, this.endY, this.endX, this.endY));
            return;
        }
        CubicCurve2D.Double tmp = new CubicCurve2D.Double();
        Curve.divide(t - di, this.list.get(0), new CubicCurve2D.Double(), tmp);
        this.list.get(0).setCurve(tmp);
        this.startX = tmp.x1;
        this.startY = tmp.y1;
    }

    public void chopEnd(double t) {
        int n = this.list.size();
        double di = StrictMath.floor(t *= (double)n);
        int i = (int)di;
        if (i < 0) {
            this.list.clear();
        }
        if (i >= n) {
            return;
        }
        while (i + 1 < this.list.size()) {
            this.list.remove(i + 1);
        }
        if (this.list.isEmpty()) {
            this.endX = this.startX;
            this.endY = this.startY;
            this.list.add(new CubicCurve2D.Double(this.endX, this.endY, this.endX, this.endY, this.endX, this.endY, this.endX, this.endY));
            return;
        }
        CubicCurve2D.Double tmp = new CubicCurve2D.Double();
        Curve.divide(t - di, this.list.get(i), tmp, new CubicCurve2D.Double());
        this.list.get(i).setCurve(tmp);
        this.endX = tmp.x2;
        this.endY = tmp.y2;
    }

    public double getXatY(double y, double startT, double endT, double defaultValue) {
        double by;
        double a = startT;
        double b = endT;
        double ay = this.getY(a);
        if (ay > (by = this.getY(b))) {
            double tmp = ay;
            ay = by;
            by = tmp;
            a = endT;
            b = startT;
        }
        if (!(ay <= y) || !(y <= by)) {
            return defaultValue;
        }
        while (StrictMath.abs(a - b) > 0.001) {
            double t = (a + b) / 2.0;
            double ty = this.getY(t);
            if (ty == y) {
                a = t;
                break;
            }
            if (ty < y) {
                a = t;
                continue;
            }
            b = t;
        }
        return this.getX(a);
    }

    public double getX(double t) {
        int n = this.list.size();
        double di = StrictMath.floor(t *= (double)n);
        int i = (int)di;
        if (i < 0) {
            return this.startX;
        }
        if (i >= n) {
            return this.endX;
        }
        return this.getX(this.list.get(i), t - di);
    }

    public double getY(double t) {
        int n = this.list.size();
        double di = StrictMath.floor(t *= (double)n);
        int i = (int)di;
        if (i < 0) {
            return this.startY;
        }
        if (i >= n) {
            return this.endY;
        }
        return this.getY(this.list.get(i), t - di);
    }

    private double getX(CubicCurve2D.Double curve, double t) {
        double px = (curve.ctrlx1 - curve.x1) * t + curve.x1;
        double qx = (curve.ctrlx2 - curve.ctrlx1) * t + curve.ctrlx1;
        double rx = (curve.x2 - curve.ctrlx2) * t + curve.ctrlx2;
        double sx = (qx - px) * t + px;
        double tx = (rx - qx) * t + qx;
        return (tx - sx) * t + sx;
    }

    private double getY(CubicCurve2D.Double curve, double t) {
        double py = (curve.ctrly1 - curve.y1) * t + curve.y1;
        double qy = (curve.ctrly2 - curve.ctrly1) * t + curve.ctrly1;
        double ry = (curve.y2 - curve.ctrly2) * t + curve.ctrly2;
        double sy = (qy - py) * t + py;
        double ty = (ry - qy) * t + qy;
        return (ty - sy) * t + sy;
    }

    public static void divide(double t, CubicCurve2D.Double curve, CubicCurve2D.Double first, CubicCurve2D.Double second) {
        first.x1 = curve.x1;
        second.x2 = curve.x2;
        first.ctrlx1 = (1.0 - t) * curve.x1 + t * curve.ctrlx1;
        double x = (1.0 - t) * curve.ctrlx1 + t * curve.ctrlx2;
        second.ctrlx2 = (1.0 - t) * curve.ctrlx2 + t * curve.x2;
        first.ctrlx2 = (1.0 - t) * first.ctrlx1 + t * x;
        second.ctrlx1 = (1.0 - t) * x + t * second.ctrlx2;
        second.x1 = first.x2 = (1.0 - t) * first.ctrlx2 + t * second.ctrlx1;
        first.y1 = curve.y1;
        second.y2 = curve.y2;
        first.ctrly1 = (1.0 - t) * curve.y1 + t * curve.ctrly1;
        double y = (1.0 - t) * curve.ctrly1 + t * curve.ctrly2;
        second.ctrly2 = (1.0 - t) * curve.ctrly2 + t * curve.y2;
        first.ctrly2 = (1.0 - t) * first.ctrly1 + t * y;
        second.ctrly1 = (1.0 - t) * y + t * second.ctrly2;
        second.y1 = first.y2 = (1.0 - t) * first.ctrly2 + t * second.ctrly1;
    }
}

